/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.essbase.api.base.EssException;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.dataquery.IEssCubeView;
import com.essbase.api.dataquery.IEssGridView;
import com.essbase.api.dataquery.IEssOpRetrieve;
import com.essbase.api.dataquery.IEssOperation;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.datasource.IEssOlapServer;
import com.essbase.api.domain.IEssDomain;
import com.essbase.api.metadata.IEssMember;
import com.runqian.base.module.DataSetConfig;
import com.runqian.base.module.OLAPSessionFactory;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Segment;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.OLAPSession;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetFactory;
import com.runqian.report.dataset.Row;
import com.runqian.report.usermodel.Env;
import java.util.Properties;

public class OlapDataSetFactory
implements DataSetFactory {
    private Properties prop;
    private int maxSubGens = 0;

    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    public DataSet getDataSet(Env env) {
        DataSetConfig dsc = (DataSetConfig)this.prop.get("dsc");
        String strDefine = dsc.getSQL();
        Segment seg = new Segment(strDefine);
        if (seg.get("dstype").equalsIgnoreCase(OLAPSessionFactory.ESSBASE_TYPE_CUBE_RETRIEVE)) {
            return this.essBaseCubeRetrieve(strDefine, dsc.getDataSourceName(), env);
        }
        return this.essBaseDimView(strDefine, dsc.getDataSourceName(), env);
    }

    private DataSet essBaseDimView(String strDefine, String dsName, Env env) {
        DataSet ds = new DataSet();
        Segment olap = new Segment(strDefine);
        String app = olap.get("appname");
        String cube = olap.get("cubename");
        String dim = olap.get("dims");
        try {
            OLAPSession os = env.getOLAPSession(dsName);
            if (os == null) {
                os = env.getOLAPSession("activeolap");
            }
            if (os == null || os.getDBType() != 101) {
                throw new Exception("\u6ca1\u6709\u8fde\u63a5\u5230 EssBase \u6570\u636e\u6e90\uff0c\u6216\u8005\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u662fEssBase\u3002");
            }
            IEssOlapServer eos = (IEssOlapServer)os.getSession();
            IEssOlapApplication ea = eos.getApplication(app);
            IEssCube ec = ea.getCube(cube);
            int max = this.calcMaxGenOfCube(ec, dim, false, null);
            int i = 1;
            while (i < max) {
                ds.addColumn("Gen" + (i + 1));
                ++i;
            }
            this.calcMaxGenOfCube(ec, dim, true, ds);
        }
        catch (Exception x) {
            Tools.showException(x);
        }
        return ds;
    }

    /*
     * Exception decompiling
     */
    int calcMaxGenOfCube(IEssCube cube, String dimName, boolean fillDims, DataSet ds) throws EssException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 181->184)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void listSubMembers(IEssMember mbr) throws EssException {
        boolean fetchAllProps = true;
        IEssIterator mbrs = mbr.getChildMembers(fetchAllProps);
        int curGen = mbr.getGenerationNumber();
        if (this.maxSubGens < curGen) {
            this.maxSubGens = curGen;
        }
        int i = 0;
        while (i < mbrs.getCount()) {
            mbr = (IEssMember)mbrs.getAt(i);
            this.listSubMembers(mbr);
            ++i;
        }
    }

    void fillDimDataSet(int maxGen, IEssMember mbr, DataSet ds, Segment row) throws EssException {
        int i;
        boolean fetchAllProps = true;
        IEssIterator mbrs = mbr.getChildMembers(fetchAllProps);
        int curGen = mbr.getGenerationNumber();
        row.put(Integer.toString(curGen), mbr.getName());
        if (mbrs.getCount() == 0) {
            Row dimRow = ds.addRow();
            i = 2;
            while (i <= curGen) {
                dimRow.setData(i - 1, (Object)row.get(Integer.toString(i)));
                ++i;
            }
        }
        i = 0;
        while (i < mbrs.getCount()) {
            mbr = (IEssMember)mbrs.getAt(i);
            this.fillDimDataSet(maxGen, mbr, ds, row);
            ++i;
        }
    }

    private DataSet essBaseCubeRetrieve(String strDefine, String dsName, Env env) {
        DataSet ds = new DataSet();
        Segment olap = new Segment(strDefine);
        String app = olap.get("appname");
        String cube = olap.get("cubename");
        String dims = olap.get("dims");
        Section cols = new Section(dims);
        int cc = 0;
        while (cc < cols.size()) {
            ds.addColumn(cols.get(cc));
            ++cc;
        }
        ds.addColumn("value");
        try {
            OLAPSession os = env.getOLAPSession(dsName);
            if (os == null) {
                os = env.getOLAPSession("activeolap");
            }
            if (os == null || os.getDBType() != 101) {
                throw new Exception("\u6ca1\u6709\u8fde\u63a5\u5230 EssBase \u6570\u636e\u6e90\uff0c\u6216\u8005\u6570\u636e\u6e90\u7c7b\u578b\u4e0d\u662fEssBase\u3002");
            }
            IEssOlapServer eos = (IEssOlapServer)os.getSession();
            IEssDomain ed = (IEssDomain)eos.getParentBase();
            IEssCubeView cv = ed.openCubeView("cubeview", eos.getName(), app, cube, true, true, true, true);
            cv.setRepeatMemberNames(false);
            cv.setIncludeSelection(true);
            cv.updatePropertyValues();
            String syntax = OLAPSessionFactory.convert2EssbaseCmd(strDefine);
            OlapDataSetFactory.olapCubeView2DataSet(cv, syntax, ds);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ds;
    }

    private static DataSet olapCubeView2DataSet(IEssCubeView ecv, String retrieveStr, DataSet ds) throws Exception {
        IEssGridView grid = ecv.getGridView();
        IEssOpRetrieve op = ecv.createIEssOpRetrieve();
        op.setQuery(retrieveStr, IEssCubeView.EEssQueryGrammar.ESSBASE);
        ecv.performOperation((IEssOperation)op);
        int cntRows = grid.getCountRows();
        int cntCols = ds.getColumnCount();
        int i = 1;
        while (i < cntRows) {
            Row row = ds.addRow();
            int j = 0;
            while (j < cntCols) {
                if (j == cntCols - 1) {
                    row.setData(j + 1, (Object)new Double(grid.getDoubleValue(i, j)));
                } else {
                    row.setData(j + 1, (Object)grid.getStringValue(i, j));
                }
                ++j;
            }
            ++i;
        }
        return ds;
    }
}

