/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ObjectCache;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.Variable;

public class Row
implements Variable {
    protected DataSet ds;
    protected Object value;
    protected int rowNo;

    public Row(DataSet ds, int rowNo) {
        this.ds = ds;
        this.rowNo = rowNo;
    }

    public DataSet getDataSet() {
        return this.ds;
    }

    public int getRowNo() {
        return this.rowNo;
    }

    private final Object[] getRowData() {
        return this.ds.getRowData(this.rowNo);
    }

    public void setData(int col, Object data) {
        this.ds.setData(this.rowNo, col, data);
    }

    public void setDataInt(int col, int data) {
        this.ds.setData(this.rowNo, col, ObjectCache.getInteger(data));
    }

    public void setDataDouble(int col, double data) {
        this.ds.setData(this.rowNo, col, new Double(data));
    }

    public void setData(String colName, Object data) {
        this.setData(this.ds.getColumnNo(colName), data);
    }

    public void setDataInt(String colName, int data) {
        this.setData(this.ds.getColumnNo(colName), (Object)ObjectCache.getInteger(data));
    }

    public void setDataDouble(String colName, double data) {
        this.setData(this.ds.getColumnNo(colName), (Object)new Double(data));
    }

    public Object getData(int col) {
        if (col == 0) {
            return ObjectCache.getInteger(this.rowNo);
        }
        return this.getRowData()[col - 1];
    }

    public Object getData(String colName) {
        return this.getRowData()[this.ds.getColumnNo(colName)];
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue(boolean dispValue) {
        return this.value;
    }

    public boolean test(Expression exp) {
        this.ds.setCurrentRow(this);
        Object value = exp.calculate();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new ReportError("\u884c\u8fc7\u6ee4\u6761\u4ef6\u5e94\u8fd4\u56de\u5e03\u5c14\u503c");
    }

    public Object evaluate(Expression exp) {
        this.ds.setCurrentRow(this);
        return exp.calculate();
    }
}

