/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetFactory;
import com.runqian.report.dataset.Row;
import com.runqian.report.dataset.XMLDataSetFactory;
import com.runqian.report.usermodel.Env;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class TextDataSetFactory
implements DataSetFactory {
    private Properties prop;

    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    public DataSet getDataSet(Env env) {
        InputStream is;
        block20: {
            is = (InputStream)this.prop.get("stream");
            if (is == null) {
                String fileName = (String)this.prop.get("fileName");
                try {
                    is = new FileInputStream(fileName);
                }
                catch (Exception e) {
                    String mainDir = env.getMainDir();
                    if (!fileName.startsWith("/")) {
                        fileName = "/" + fileName;
                    }
                    String fName = String.valueOf(mainDir) + fileName;
                    try {
                        is = new FileInputStream(new File(fName));
                    }
                    catch (Exception ee) {
                        if (env.getServletContext() != null) {
                            try {
                                is = env.getServletContext().getResourceAsStream(fName);
                                break block20;
                            }
                            catch (Exception eee) {
                                throw new ReportError("\u6587\u4ef6" + fileName + "\u4e0d\u5b58\u5728");
                            }
                        }
                        throw new ReportError("\u6587\u4ef6" + fileName + "\u4e0d\u5b58\u5728");
                    }
                }
            }
        }
        DataSet ds = new DataSet();
        try {
            String tmp;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "GBK"));
            int[] colTypes = null;
            boolean isFirst = true;
            while ((tmp = br.readLine()) != null) {
                int i;
                int cols;
                ArgumentTokenizer at;
                if (tmp.trim().length() == 0) continue;
                String line = tmp.trim();
                if (isFirst) {
                    boolean skip = false;
                    if (tmp.toLowerCase().startsWith("colname")) {
                        skip = true;
                        tmp = tmp.substring(tmp.indexOf("=") + 1);
                    } else if (tmp.toLowerCase().startsWith("coltype")) {
                        tmp = tmp.substring(tmp.indexOf("=") + 1);
                    }
                    at = new ArgumentTokenizer(tmp, '\t');
                    cols = at.countTokens();
                    colTypes = new int[cols];
                    i = 0;
                    while (i < cols) {
                        ds.addColumn(at.nextToken().trim());
                        colTypes[i] = 1;
                        ++i;
                    }
                    isFirst = false;
                    if (skip) continue;
                }
                if (line.toLowerCase().startsWith("coltype")) {
                    line = line.substring(line.indexOf("=") + 1);
                    ArgumentTokenizer at2 = new ArgumentTokenizer(line, '\t');
                    int cols2 = at2.countTokens();
                    int i2 = 0;
                    while (i2 < cols2) {
                        colTypes[i2] = Integer.parseInt(at2.nextToken());
                        ++i2;
                    }
                    continue;
                }
                Row row = ds.addRow();
                at = new ArgumentTokenizer(line, '\t');
                cols = at.countTokens();
                i = 0;
                while (i < cols) {
                    String stmp = at.nextToken();
                    Object colValue = XMLDataSetFactory.getColValue(stmp, colTypes[i]);
                    row.setData(i + 1, colValue);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
        return ds;
    }
}

