/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dataset;

import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetFactory;
import com.runqian.report.dataset.Row;
import com.runqian.report.usermodel.Env;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XMLDataSetFactory
implements DataSetFactory {
    private Element root;
    private Properties prop;

    public void setProperties(Properties prop) {
        this.prop = prop;
    }

    public DataSet getDataSet(Env env) {
        InputStream is;
        block19: {
            is = (InputStream)this.prop.get("stream");
            if (is == null) {
                String fileName = (String)this.prop.get("fileName");
                try {
                    is = new FileInputStream(fileName);
                }
                catch (Exception e) {
                    String mainDir = env.getMainDir();
                    if (!fileName.startsWith("/")) {
                        fileName = "/" + fileName;
                    }
                    String fName = String.valueOf(mainDir) + fileName;
                    try {
                        is = new FileInputStream(new File(fName));
                    }
                    catch (Exception ee) {
                        if (env.getServletContext() != null) {
                            try {
                                is = env.getServletContext().getResourceAsStream(fName);
                                break block19;
                            }
                            catch (Exception eee) {
                                throw new ReportError("\u6587\u4ef6" + fileName + "\u4e0d\u5b58\u5728");
                            }
                        }
                        throw new ReportError("\u6587\u4ef6" + fileName + "\u4e0d\u5b58\u5728");
                    }
                }
            }
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver((EntityResolver)new MyEntityResolver());
        Document doc = null;
        try {
            doc = builder.build(is);
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
        this.root = doc.getRootElement();
        DataSet ds = new DataSet();
        List list = this.root.getChildren();
        int[] colTypes = null;
        int i = 0;
        while (i < list.size()) {
            block21: {
                Element a;
                int j;
                List l;
                Element el;
                block20: {
                    el = (Element)list.get(i);
                    l = el.getChildren();
                    if (i != 0) break block20;
                    colTypes = new int[l.size()];
                    j = 0;
                    while (j < l.size()) {
                        a = (Element)l.get(j);
                        ds.addColumn(a.getText());
                        colTypes[j] = 1;
                        ++j;
                    }
                    if (el.getName().equalsIgnoreCase("colname")) break block21;
                }
                if (el.getName().equalsIgnoreCase("coltype")) {
                    j = 0;
                    while (j < l.size()) {
                        a = (Element)l.get(j);
                        colTypes[j] = Integer.parseInt(a.getText());
                        ++j;
                    }
                } else {
                    Row row = ds.addRow();
                    int j2 = 0;
                    while (j2 < l.size()) {
                        Element a2 = (Element)l.get(j2);
                        Object colValue = XMLDataSetFactory.getColValue(a2.getText(), colTypes[j2]);
                        row.setData(j2 + 1, colValue);
                        ++j2;
                    }
                }
            }
            ++i;
        }
        return ds;
    }

    public static Object getColValue(String value, int type) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        switch (type) {
            case -5: {
                return Long.valueOf(value);
            }
            case 4: {
                return Integer.valueOf(value);
            }
            case -6: 
            case 5: {
                return Short.valueOf(value);
            }
            case 91: {
                return Date.valueOf(value);
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return Double.valueOf(value);
            }
            case 6: {
                return Float.valueOf(value);
            }
            case 92: {
                return Time.valueOf(value);
            }
            case 93: {
                return Timestamp.valueOf(value);
            }
        }
        return value;
    }

    private static class MyEntityResolver
    implements EntityResolver {
        MyEntityResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

