/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.dbexplorer;

import com.runqian.base.tool.AppTools;
import com.runqian.base.tool.Tools;
import com.runqian.base.tool.XMLFile;
import java.awt.Font;
import java.io.File;

public class DBExplorerOption {
    private static Font m_jFont = new Font("\u5b8b\u4f53", 0, 18);
    private static int m_iRowNumber = 20;
    private static boolean m_bRowLimited = true;

    public void setNewFont(Font jFont) {
        m_jFont = jFont;
    }

    public Font getFont() {
        return m_jFont;
    }

    public void setRowLimited(boolean bRowLimited) {
        m_bRowLimited = bRowLimited;
    }

    public boolean getRowLimited() {
        return m_bRowLimited;
    }

    public void setRowNumber(int iRowNumber) {
        m_iRowNumber = iRowNumber;
    }

    public int getRowNumber() {
        return m_iRowNumber;
    }

    public static void save() throws Throwable {
        XMLFile file = new XMLFile(AppTools.CONFIG_FILE);
        String path = "RUNQIAN/DBEXPLORER";
        if (!file.isPathExists(path)) {
            file.newElement("RUNQIAN", "DBEXPLORER");
        }
        file.setAttribute(String.valueOf(path) + "/FontFamily", m_jFont.getFamily());
        file.setAttribute(String.valueOf(path) + "/FontSize", String.valueOf(m_jFont.getSize()));
        String strFontStyle = "";
        strFontStyle = m_jFont.isBold() && m_jFont.isItalic() ? "Bold Italic" : (m_jFont.isBold() ? "Bold" : (m_jFont.isItalic() ? "Italic" : "Plain"));
        file.setAttribute(String.valueOf(path) + "/FontStyle", strFontStyle);
        file.setAttribute(String.valueOf(path) + "/RowNumber", String.valueOf(m_iRowNumber));
        if (m_bRowLimited) {
            file.setAttribute(String.valueOf(path) + "/RowLimited", "1");
        } else {
            file.setAttribute(String.valueOf(path) + "/RowLimited", "0");
        }
        file.save();
    }

    public static void load() throws Throwable {
        File f = new File(AppTools.CONFIG_FILE);
        XMLFile file = !f.isFile() ? XMLFile.newConfigFile(AppTools.CONFIG_FILE) : new XMLFile(AppTools.CONFIG_FILE);
        String path = "RUNQIAN/DBEXPLORER";
        String strFontFamily = file.getAttribute(String.valueOf(path) + "/FontFamily");
        String strFontSize = file.getAttribute(String.valueOf(path) + "/FontSize");
        String strFontStyle = file.getAttribute(String.valueOf(path) + "/FontStyle");
        if (!Tools.isValidString(strFontFamily)) {
            strFontFamily = "\u5b8b\u4f53";
        }
        if (!Tools.isValidString(strFontSize)) {
            strFontSize = "20";
        }
        if (!Tools.isValidString(strFontStyle)) {
            strFontStyle = "Plain";
        }
        int iFontSize = 20;
        try {
            iFontSize = Integer.parseInt(strFontSize);
        }
        catch (Throwable e1) {
            iFontSize = 20;
        }
        m_jFont = "Bold Italic".equalsIgnoreCase(strFontStyle) ? new Font(strFontFamily, 3, iFontSize) : ("Bold".equalsIgnoreCase(strFontStyle) ? new Font(strFontFamily, 1, iFontSize) : ("Italic".equalsIgnoreCase(strFontStyle) ? new Font(strFontFamily, 2, iFontSize) : new Font(strFontFamily, 0, iFontSize)));
        String strRowNumber = file.getAttribute(String.valueOf(path) + "/RowNumber");
        if (!Tools.isValidString(strRowNumber)) {
            strRowNumber = "20";
        }
        try {
            m_iRowNumber = Integer.parseInt(strRowNumber);
        }
        catch (Throwable e1) {
            m_iRowNumber = 20;
        }
        String strRowLimited = file.getAttribute(String.valueOf(path) + "/RowLimited");
        if (!Tools.isValidString(strRowLimited)) {
            strRowLimited = "1";
        }
        m_bRowLimited = "0".equals(strRowLimited) ? false : ("1".equals(strRowLimited) ? true : true);
    }
}

