/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.report.cellset.CellRegion;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.Node;
import com.runqian.report.engine.Variable;
import com.runqian.report.engine.Variant2;
import java.util.ArrayList;
import java.util.List;

public class CSVariable
extends Node
implements Variable {
    private ExtCell source;
    private ExtCellSet cs;
    private String sourceId;
    private ExtCell leftHead;
    private ExtCell topHead;
    private boolean isSaved;

    public CSVariable(ExtCellSet cs, String sourceId) {
        this.cs = cs;
        this.sourceId = sourceId;
    }

    public CSVariable(ExtCell source, boolean isSaved) {
        this.source = source;
        this.isSaved = isSaved;
    }

    public CSVariable(ExtCell source) {
        this(source, false);
    }

    public CSVariable(ExtCell source, ExtCell leftHead, ExtCell topHead) {
        this.source = source;
        this.leftHead = leftHead;
        this.topHead = topHead;
    }

    public ExtCell getSource() {
        return this.source;
    }

    public ExtCell getLeftHead() {
        return this.leftHead;
    }

    public void setLeftHead(ExtCell head) {
        this.leftHead = head;
    }

    public ExtCell getTopHead() {
        return this.topHead;
    }

    public void setTopHead(ExtCell head) {
        this.topHead = head;
    }

    public Object calculate() {
        ExtCell current = null;
        if (this.source == null) {
            return null;
        }
        ExtCellSet cs = this.source.getCellSet();
        current = this.isSaved ? cs.getSavedCurrent() : cs.getCurrent();
        ExtCell leftSource = this.source.getCommonLeftHead(current.getSource());
        this.leftHead = current.getLeftHead(leftSource);
        ExtCell topSource = this.source.getCommonTopHead(current.getSource());
        this.topHead = current.getTopHead(topSource);
        return this;
    }

    public CellRegion getRegion() {
        ExtCell cell = this.getCell();
        return new CellRegion(cell.getRow(), cell.getCol(), cell.getEndRow(), cell.getEndCol());
    }

    private ExtCell getCell(ExtCell leftHead, ExtCell topHead) {
        block19: {
            block21: {
                block20: {
                    block18: {
                        if (leftHead.getSource() == this.source) {
                            return leftHead;
                        }
                        if (topHead.getSource() == this.source) {
                            return topHead;
                        }
                        if (!leftHead.getSource().isDirectLeftHeadOf(this.source)) break block18;
                        int subSize = leftHead.getSubSize();
                        int i = 0;
                        while (i < subSize) {
                            ExtCell sub = leftHead.getSubCell(i);
                            if (sub.getSource() == this.source) {
                                int extSize = sub.extCellSize();
                                int j = 0;
                                while (j < extSize) {
                                    ExtCell cell = sub.getExtCell(j);
                                    if (topHead.isTopHeadOf(cell)) {
                                        return cell;
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break block19;
                    }
                    if (!topHead.getSource().isDirectTopHeadOf(this.source)) break block20;
                    int subSize = topHead.getSubSize();
                    int i = 0;
                    while (i < subSize) {
                        ExtCell sub = topHead.getSubCell(i);
                        if (sub.getSource() == this.source) {
                            int extSize = sub.extCellSize();
                            int j = 0;
                            while (j < extSize) {
                                ExtCell cell = sub.getExtCell(j);
                                if (leftHead.isLeftHeadOf(cell)) {
                                    return cell;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break block19;
                }
                if (!leftHead.getSource().isLeftHeadOf(this.source) || leftHead.getSource() == this.source.getLeftHead()) break block21;
                int subSize = leftHead.getSubSize();
                int i = 0;
                while (i < subSize) {
                    ExtCell sub = leftHead.getSubCell(i);
                    if (sub.getSource().isLeftHeadOf(this.source)) {
                        int extSize = sub.extCellSize();
                        int j = 0;
                        while (j < extSize) {
                            ExtCell cell = sub.getExtCell(j);
                            if ((cell = this.getCell(cell, topHead)) != null) {
                                return cell;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break block19;
            }
            if (!topHead.getSource().isTopHeadOf(this.source) || topHead.getSource() == this.source.getTopHead()) break block19;
            int subSize = topHead.getSubSize();
            int i = 0;
            while (i < subSize) {
                ExtCell sub = topHead.getSubCell(i);
                if (sub.getSource().isTopHeadOf(this.source)) {
                    int extSize = sub.extCellSize();
                    int j = 0;
                    while (j < extSize) {
                        ExtCell cell = sub.getExtCell(j);
                        if ((cell = this.getCell(leftHead, cell)) != null) {
                            return cell;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public ExtCell getCell() {
        return this.getCell(this.leftHead, this.topHead);
    }

    public Object getValue(boolean dispValue) {
        ExtCell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        cell.testValue();
        return cell.getValue(dispValue);
    }

    public List getCells(ExtCell leftHead, ExtCell topHead, List list) {
        block15: {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                if (list == null) {
                                    list = new ArrayList<ExtCell>();
                                }
                                if (leftHead.getSource() != this.source) break block16;
                                list.add(leftHead);
                                break block15;
                            }
                            if (topHead.getSource() != this.source) break block17;
                            list.add(topHead);
                            break block15;
                        }
                        if (!leftHead.getSource().isDirectLeftHeadOf(this.source)) break block18;
                        int subSize = leftHead.getSubSize();
                        int i = 0;
                        while (i < subSize) {
                            ExtCell sub = leftHead.getSubCell(i);
                            if (sub.getSource() == this.source) {
                                int extSize = sub.extCellSize();
                                int j = 0;
                                while (j < extSize) {
                                    ExtCell cell = sub.getExtCell(j);
                                    if (topHead.isTopHeadOf(cell)) {
                                        list.add(cell);
                                    }
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        break block15;
                    }
                    if (!topHead.getSource().isDirectTopHeadOf(this.source)) break block19;
                    int subSize = topHead.getSubSize();
                    int i = 0;
                    while (i < subSize) {
                        ExtCell sub = topHead.getSubCell(i);
                        if (sub.getSource() == this.source) {
                            int extSize = sub.extCellSize();
                            int j = 0;
                            while (j < extSize) {
                                ExtCell cell = sub.getExtCell(j);
                                if (leftHead.isLeftHeadOf(cell)) {
                                    list.add(cell);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break block15;
                }
                if (!leftHead.getSource().isLeftHeadOf(this.source) || leftHead.getSource() == this.source.getLeftHead()) break block20;
                int subSize = leftHead.getSubSize();
                int i = 0;
                while (i < subSize) {
                    ExtCell sub = leftHead.getSubCell(i);
                    if (sub.getSource().isLeftHeadOf(this.source)) {
                        int extSize = sub.extCellSize();
                        int j = 0;
                        while (j < extSize) {
                            ExtCell cell = sub.getExtCell(j);
                            this.getCells(cell, topHead, list);
                            ++j;
                        }
                        break block15;
                    }
                    ++i;
                }
                break block15;
            }
            if (!topHead.getSource().isTopHeadOf(this.source) || topHead.getSource() == this.source.getTopHead()) break block15;
            int subSize = topHead.getSubSize();
            int i = 0;
            while (i < subSize) {
                ExtCell sub = topHead.getSubCell(i);
                if (sub.getSource().isTopHeadOf(this.source)) {
                    int extSize = sub.extCellSize();
                    int j = 0;
                    while (j < extSize) {
                        ExtCell cell = sub.getExtCell(j);
                        this.getCells(leftHead, cell, list);
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
        return list;
    }

    public List getCells(List list) {
        return this.getCells(this.leftHead, this.topHead, list);
    }

    protected boolean isExtended() {
        return false;
    }

    public String getExp() {
        ExtCell cell = ((CSVariable)this.calculate()).getCell();
        return Variant2.getExp(cell);
    }

    protected boolean canOptimized() {
        return false;
    }
}

