/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.ExtCellSet;

class CellSetTransfer {
    CellSetTransfer() {
    }

    public static ExtCellSet transfer(CellSet cs, ExtCellSet ecs) {
        if (ecs == null) {
            return null;
        }
        CellSetParser parser = new CellSetParser(cs);
        ecs.setRowSize(cs.getRow());
        ecs.setColSize(cs.getColumn());
        int i = 0;
        while (i < cs.getRow()) {
            int j = 0;
            while (j < cs.getColumn()) {
                if (parser.isMergedFirstCell(i, j)) {
                    int endRow = parser.getMergedEndRow(i, j);
                    int endCol = parser.getMergedEndCol(i, j);
                    int propId = 4406;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(i, endCol, propId));
                    propId = 4404;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(i, endCol, propId));
                    propId = 4405;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(i, endCol, propId));
                    propId = 4412;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(endRow, j, propId));
                    propId = 4410;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(endRow, j, propId));
                    propId = 4411;
                    cs.setPropertyValue(i, j, propId, cs.getPropertyValue(endRow, j, propId));
                }
                IntHashtable propTable = cs.getPropertyMap(i, j);
                ExtCell cell = ecs.getCell(i, j);
                if (propTable != null) {
                    if (i == 0 && j == 0) {
                        CellProperty cp = (CellProperty)propTable.get(1101);
                        if (cp != null) {
                            ecs.reportType = cp.getPropertyValue();
                        }
                        if ((cp = (CellProperty)propTable.get(1109)) != null) {
                            ecs.drillable = Boolean.TRUE.equals(cp.getPropertyValue());
                        }
                    }
                    if (cell == null) {
                        cell = ecs.newCell(i, j);
                    }
                    cell.setPropTable(propTable);
                    if (ecs.isMerged(i, j)) {
                        ecs.remove(i, j);
                    }
                }
                ++j;
            }
            ++i;
        }
        ecs.addMergedCells();
        ecs.setNewInput(cs.isNewInputVersion());
        return ecs;
    }

    public static CellSet transfer(ExtCellSet ecs, CellSet cs) {
        return CellSetTransfer.transfer(ecs, cs, false);
    }

    public static CellSet transfer(ExtCellSet ecs, CellSet cs, boolean only) {
        if (cs == null) {
            cs = new CellSet(ecs.getRowSize(), ecs.getColSize());
        }
        int i = 0;
        while (i < ecs.getRowSize()) {
            int j = 0;
            while (j < ecs.getColSize()) {
                ExtCell cell = ecs.getCell(i, j);
                IntHashtable propTable = null;
                if (cell != null) {
                    if (!ecs.isMerged(i, j)) {
                        propTable = cell.getPropTable();
                        cs.setPropertyMap(i, j, propTable);
                    } else {
                        int key = 4103;
                        cs.setPropertyMap(i, j, (IntHashtable)cs.getPropertyMap(cell.getRow(), cell.getCol()).clone());
                        if (i <= 1 || ecs.getCell(i - 1, j) == null || ecs.isMerged(i - 1, j)) {
                            key = 4407;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4409;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4408;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                        }
                        if (j <= 1 || ecs.getCell(i, j - 1) == null || ecs.isMerged(i, j - 1)) {
                            key = 4401;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4403;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4402;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                        }
                        if (i + 1 == ecs.getRowSize() || ecs.getCell(i + 1, j) == null) {
                            key = 4410;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4412;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4411;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                        }
                        if (j + 1 == ecs.getColSize() || ecs.getCell(i, j + 1) == null) {
                            key = 4404;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4406;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                            key = 4405;
                            cs.setPropertyValue(i, j, key, cell.getPropValue(key));
                        }
                    }
                }
                if (only) {
                    ecs.setCell(i, j, null);
                }
                ++j;
            }
            ++i;
        }
        return cs;
    }
}

