/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ReportError;
import com.runqian.base.util.Sentence;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.Filters;
import com.runqian.report.dataset.Group;
import com.runqian.report.engine.CSCurrent;
import com.runqian.report.engine.CSVariable;
import com.runqian.report.engine.CellNotSetValueException;
import com.runqian.report.engine.Constant;
import com.runqian.report.engine.DSVariable;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.Function;
import com.runqian.report.engine.FunctionLib;
import com.runqian.report.engine.Node;
import com.runqian.report.engine.Variant2;
import com.runqian.report.engine.function.DSMember;
import com.runqian.report.engine.operator.Add;
import com.runqian.report.engine.operator.And;
import com.runqian.report.engine.operator.Divide;
import com.runqian.report.engine.operator.Equals;
import com.runqian.report.engine.operator.Greater;
import com.runqian.report.engine.operator.In;
import com.runqian.report.engine.operator.Like;
import com.runqian.report.engine.operator.Link;
import com.runqian.report.engine.operator.Mod;
import com.runqian.report.engine.operator.Multiply;
import com.runqian.report.engine.operator.Not;
import com.runqian.report.engine.operator.NotEquals;
import com.runqian.report.engine.operator.NotGreater;
import com.runqian.report.engine.operator.NotSmaller;
import com.runqian.report.engine.operator.Or;
import com.runqian.report.engine.operator.Smaller;
import com.runqian.report.engine.operator.Subtract;
import com.runqian.report.engine.operator.To;
import com.runqian.report.usermodel.Env;

public class Expression {
    protected ExtCellSet cs;
    protected Env env;
    protected DataSet ds;
    protected String expStr;
    protected int location;
    protected Node home;
    protected Node preNode;
    protected boolean extended = false;
    private boolean filterChecked = false;
    private Filters fs = null;

    public boolean isConstantExpression() {
        return this.home instanceof Constant;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public Node getHome() {
        return this.home;
    }

    public ExtCellSet getCS() {
        return this.cs;
    }

    protected String scanId() {
        int len = this.expStr.length();
        int begin = this.location;
        while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c) || c == '+' || c == '-' || c == '*' || c == '/' || c == '%' || c == '=' || c == '&' || c == '|' || c == '!' || c == ':' || c == '>' || c == '<' || c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') break;
            ++this.location;
        }
        return this.expStr.substring(begin, this.location);
    }

    protected String scanParameter() {
        char c;
        int len = this.expStr.length();
        while (this.location < len) {
            c = this.expStr.charAt(this.location);
            if (!Character.isWhitespace(c)) break;
            ++this.location;
        }
        if (this.location == len) {
            throw new ReportError("\u51fd\u6570\u7f3a\u5c11\u53c2\u6570");
        }
        c = this.expStr.charAt(this.location);
        if (c != '(') {
            throw new ReportError("\u51fd\u6570\u7f3a\u5c11\u53c2\u6570");
        }
        int match = Sentence.scanParenthesis(this.expStr, this.location);
        if (match == -1) {
            throw new ReportError("\u51fd\u6570\u62ec\u53f7\u4e0d\u5339\u914d");
        }
        String param = this.expStr.substring(this.location + 1, match);
        this.location = match + 1;
        return param;
    }

    protected Node createNode() {
        Node node;
        String dsName;
        char c = this.expStr.charAt(this.location);
        int match = -1;
        if (c == '\"' || c == '\'') {
            match = Sentence.scanQuotation(this.expStr, this.location);
            if (match == -1) {
                throw new ReportError("\u5f15\u53f7\u4e0d\u5339\u914d");
            }
            String str = this.expStr.substring(this.location + 1, match);
            this.location = match + 1;
            return new Constant(str);
        }
        if (this.cs != null && c == '{') {
            match = Sentence.scanBrace(this.expStr, this.location);
            if (match == -1) {
                throw new ReportError("\u5927\u62ec\u53f7\u4e0d\u5339\u914d");
            }
            Function fun = FunctionLib.newFunction("select", this.cs, this.ds);
            fun.setParameter(this.expStr.substring(this.location + 1, match));
            this.location = match + 1;
            return fun;
        }
        if (this.cs != null && c == '[') {
            Function fun;
            match = Sentence.scanBracket(this.expStr, this.location);
            if (match == -1) {
                throw new ReportError("\u4e2d\u62ec\u53f7\u4e0d\u5339\u914d");
            }
            if (this.preNode == null || this.preNode.isOperator()) {
                fun = FunctionLib.newFunction("list", this.cs, this.ds);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            } else if (this.preNode instanceof CSVariable) {
                fun = FunctionLib.newFunction("move", this.cs, this.ds);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            } else {
                fun = FunctionLib.newFunction("offset", this.cs, this.ds);
                fun.setParameter(this.expStr.substring(this.location + 1, match));
            }
            this.location = match + 1;
            return fun;
        }
        String id = this.scanId();
        if (id.equalsIgnoreCase("and")) {
            return new And();
        }
        if (id.equalsIgnoreCase("or")) {
            return new Or();
        }
        if (id.equalsIgnoreCase("not")) {
            return new Not();
        }
        if (id.equalsIgnoreCase("in")) {
            return new In();
        }
        if (id.equalsIgnoreCase("to")) {
            return new To();
        }
        if (id.equalsIgnoreCase("like")) {
            return new Like();
        }
        DataSet tempDS = this.ds;
        int index = id.indexOf(46);
        if (index > 0 && !Character.isDigit(id.charAt(0)) && this.env.isDataSetName(dsName = id.substring(0, index))) {
            tempDS = this.env.getDataSet(dsName);
            Node node2 = this.createDSNode(tempDS, id = id.substring(index + 1), true);
            if (node2 != null) {
                return node2;
            }
            throw new ReportError("\u6709\u4e0d\u53ef\u8bc6\u522b\u7684\u6570\u636e\u96c6\u51fd\u6570" + id);
        }
        if (this.ds != null && (node = this.createDSNode(this.ds, id, true)) != null) {
            return node;
        }
        if (this.preNode instanceof DSMember && (node = this.createDSNode(this.ds, id, false)) != null) {
            return node;
        }
        boolean isSaved = false;
        if (id.charAt(0) == '@') {
            id = id.substring(1);
        } else if (id.charAt(0) == '$') {
            id = id.substring(1);
            isSaved = true;
        }
        if (this.cs != null && id.equalsIgnoreCase("value")) {
            return new CSCurrent(this.cs);
        }
        if (this.env.isParamName(id)) {
            return new Constant(this.env.getParam(id));
        }
        if (this.cs != null && this.cs.isSource(id)) {
            ExtCell cell = this.cs.getSource(id);
            if (cell == null) {
                return new CSVariable(this.cs, id);
            }
            return new CSVariable(this.cs.getSource(id), isSaved);
        }
        if (this.isNextBracket()) {
            if (FunctionLib.isFunName(id)) {
                Function fun = FunctionLib.newFunction(id, this.cs, this.ds);
                fun.setParameter(this.scanParameter());
                return fun;
            }
            throw new ReportError("\u672a\u77e5\u7684\u51fd\u6570" + id);
        }
        Object value = Variant2.parse(id);
        return new Constant(value);
    }

    private boolean isNextBracket() {
        int i = this.location;
        int len = this.expStr.length();
        while (i < len && Character.isWhitespace(this.expStr.charAt(i))) {
            ++i;
        }
        if (i >= len) {
            return false;
        }
        return this.expStr.charAt(i) == '(';
    }

    protected Node createDSNode(DataSet ds, String id, boolean check) {
        if (id.charAt(0) == '#') {
            int colNo = 0;
            try {
                colNo = Integer.parseInt(id.substring(1));
            }
            catch (NumberFormatException e) {
                throw new ReportError("\u6570\u636e\u96c6\u5217\u7d22\u5f15\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            if (check) {
                if (ds == null) {
                    throw new ReportError("\u6570\u636e\u96c6\u672a\u4ea7\u751f");
                }
                if (colNo > ds.getColumnCount()) {
                    throw new ReportError("\u6570\u636e\u96c6\u5217\u7d22\u5f15\u8d85\u51fa\u8303\u56f4");
                }
                return new DSVariable(ds, colNo);
            }
        }
        if (this.isNextBracket()) {
            if (FunctionLib.isDSFunName(id)) {
                Function fun = check ? FunctionLib.newDSFunction(id, this.cs, ds) : FunctionLib.newDSFunction(id, this.cs);
                fun.setParameter(this.scanParameter());
                return fun;
            }
        } else if (check) {
            if (ds == null) {
                throw new ReportError("\u6570\u636e\u96c6\u672a\u4ea7\u751f");
            }
            if (ds.isColumnName(id)) {
                return new DSVariable(ds, ds.getColumnNo(id));
            }
        } else {
            return new DSVariable(ds, id);
        }
        return null;
    }

    protected void create() {
        int len = this.expStr.length();
        Node node = null;
        int inBrackets = 0;
        block18: while (this.location < len) {
            char c = this.expStr.charAt(this.location);
            if (Character.isWhitespace(c)) {
                ++this.location;
                continue;
            }
            node = null;
            switch (c) {
                case '(': {
                    ++inBrackets;
                    ++this.location;
                    continue block18;
                }
                case ')': {
                    if (--inBrackets < 0) {
                        throw new ReportError("\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u53f3\u62ec\u53f7\u592a\u591a\uff01");
                    }
                    ++this.location;
                    continue block18;
                }
                case '+': {
                    node = new Add();
                    ++this.location;
                    break;
                }
                case '-': {
                    node = new Subtract();
                    ++this.location;
                    break;
                }
                case '*': {
                    node = new Multiply();
                    ++this.location;
                    break;
                }
                case '/': {
                    node = new Divide();
                    ++this.location;
                    break;
                }
                case '=': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        ++this.location;
                    }
                    node = new Equals();
                    break;
                }
                case '!': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotEquals();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Not();
                    break;
                }
                case '>': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotSmaller();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Greater();
                    break;
                }
                case '<': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '=') {
                        node = new NotGreater();
                        ++this.location;
                    }
                    if (node != null) break;
                    node = new Smaller();
                    break;
                }
                case '&': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '&') {
                        node = new And();
                        ++this.location;
                        break;
                    }
                    node = FunctionLib.newFunction("address", this.cs, this.ds);
                    break;
                }
                case '|': {
                    ++this.location;
                    if (this.location < len && this.expStr.charAt(this.location) == '|') {
                        node = new Or();
                        ++this.location;
                        break;
                    }
                    throw new ReportError("\u4e0d\u80fd\u8bc6\u522b\u6807\u8bc6\u7b26|");
                }
                case ':': {
                    node = new Link(this.cs);
                    ++this.location;
                    break;
                }
                case '%': {
                    node = new Mod();
                    ++this.location;
                    break;
                }
                case '.': {
                    if (this.preNode == null || this.preNode.isOperator()) {
                        node = this.createNode();
                        break;
                    }
                    node = FunctionLib.newFunction("dsmember", this.cs, this.ds);
                    ++this.location;
                    break;
                }
                case ',': {
                    throw new ReportError("\u4f4d\u7f6e" + this.location + "\u4e0d\u5e94\u8be5\u51fa\u73b0\u9017\u53f7");
                }
                default: {
                    node = this.createNode();
                }
            }
            node.setInBrackets(inBrackets);
            this.preNode = node;
            if (this.home == null) {
                this.home = node;
                continue;
            }
            Node right = this.home;
            Node parent = null;
            while (right != null && right.getPriority() < node.getPriority()) {
                parent = right;
                right = right.getRight();
            }
            node.setLeft(right);
            if (parent != null) {
                parent.setRight(node);
                continue;
            }
            this.home = node;
        }
        if (inBrackets > 0) {
            throw new ReportError("\u62ec\u53f7\u4e0d\u5339\u914d\uff0c\u5de6\u62ec\u53f7\u592a\u591a\uff01");
        }
    }

    public Expression(ExtCellSet cs, DataSet ds, String expStr) {
        this(cs, ds, cs == null ? Variant2.getEnv() : cs.getEnv(), expStr, false);
    }

    public Expression(ExtCellSet cs, String expStr) {
        this(cs, null, cs == null ? Variant2.getEnv() : cs.getEnv(), expStr, false);
    }

    public Expression(ExtCellSet cs, String expStr, boolean needCheckExtended) {
        this(cs, null, cs == null ? Variant2.getEnv() : cs.getEnv(), expStr, needCheckExtended);
    }

    public Expression(Env env, String expStr) {
        this(null, null, env, expStr, false);
    }

    public Expression(String expStr) {
        this(null, null, null, expStr, false);
    }

    public Expression(DataSet ds, Env env, String expStr) {
        this(null, ds, env, expStr, false);
    }

    public Expression(ExtCellSet cs, DataSet ds, Env env, String expStr) {
        this(cs, ds, env, expStr, false);
    }

    private Expression(ExtCellSet cs, DataSet ds, Env env, String expStr, boolean needCheckExtended) {
        if (env == null) {
            env = Variant2.getEnv();
        }
        this.cs = cs;
        this.env = env;
        this.ds = ds;
        this.expStr = expStr;
        this.location = 0;
        try {
            this.create();
            this.home = this.home.optimize();
            if (needCheckExtended) {
                this.extended = this.checkExtended();
            }
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + expStr + "\u4e2d" + re.getErrorMsg());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public Object calculate() {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.calculate();
        }
        catch (CellNotSetValueException cne) {
            throw cne;
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + re.getMessage());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public String getExp() {
        try {
            if (this.home == null) {
                return null;
            }
            return this.home.getExp();
        }
        catch (CellNotSetValueException cne) {
            throw cne;
        }
        catch (ReportError re) {
            re.setErrorMsg("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + re.getMessage());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u8868\u8fbe\u5f0f" + this.expStr + "\u4e2d" + e.getMessage(), e);
        }
    }

    public String toString() {
        return this.expStr;
    }

    public boolean checkExtended() {
        if (this.home == null) {
            return false;
        }
        return this.home.isExtended();
    }

    public void optimize() {
        if (this.home != null) {
            this.home = this.home.optimize();
        }
    }

    public Filters getFilters(Group group) {
        if (group.getDataSet() != this.ds) {
            return null;
        }
        if (!this.filterChecked) {
            this.fs = group.getFilters(this);
        }
        return this.fs;
    }
}

