/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.MacroResolver;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellProperty;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.dataset.Group;
import com.runqian.report.dataset.Row;
import com.runqian.report.engine.CellNotSetValueException;
import com.runqian.report.engine.CircularRefException;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.SubRpt;
import com.runqian.report.engine.Variable;
import com.runqian.report.engine.Variant2;
import com.runqian.report.input.UpdateProp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class ExtCell
implements Cloneable,
Variable {
    private static Object NULL_VALUE = new Object();
    private ExtCellSet cs;
    private ExtCell source;
    private int row;
    private int col;
    private int rowMerge;
    private int colMerge;
    private ExtCell leftHead;
    private ExtCell topHead;
    private Object cellValue = null;
    Engine engine = new Engine();
    private IntHashtable propSetMap;
    private ExtCell[] extCells;
    private ArrayList subCellList;
    private Group group;
    private Row dsRow;
    private int movedForCalc;

    public ExtCell(ExtCellSet cs, int row, int col) {
        if (cs == null) {
            throw new RuntimeException();
        }
        if (row < 0 || col < 0) {
            throw new RuntimeException();
        }
        this.cs = cs;
        this.row = row;
        this.col = col;
        this.rowMerge = 1;
        this.colMerge = 1;
        this.source = this;
        this.movedForCalc = 0;
        this.engine.extensible = CellPropertyDefine.CEX_DEFAULT;
        this.engine.sourceId = ExtCellSet.getId(row, col).toUpperCase();
    }

    public ExtCell(ExtCellSet cs, int row, int col, boolean isNullCell) {
        this(cs, row, col);
    }

    public Object clone() {
        try {
            ExtCell newCell = (ExtCell)super.clone();
            newCell.propSetMap = null;
            newCell.movedForCalc = 0;
            newCell.subCellList = null;
            this.dsRow = null;
            return newCell;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    public ExtCell getSource() {
        return this.source;
    }

    public String getId() {
        return ExtCellSet.getId(this.row, this.col).toUpperCase();
    }

    public String getSourceId() {
        return this.engine.sourceId;
    }

    public ExtCellSet getCellSet() {
        return this.cs;
    }

    public void setLocation(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public int getEndRow() {
        return this.row + this.rowMerge - 1;
    }

    public int getEndCol() {
        return this.col + this.colMerge - 1;
    }

    public void move(int rowInc, int colInc) {
        this.row += rowInc;
        if (this.row < 0) {
            throw new RuntimeException();
        }
        this.col += colInc;
        if (this.col < 0) {
            throw new RuntimeException();
        }
    }

    public void setMerge(int rowMerge, int colMerge) {
        if (this.row == 0 || this.col == 0) {
            return;
        }
        if (rowMerge < 1) {
            throw new RuntimeException();
        }
        if (colMerge < 1) {
            throw new RuntimeException();
        }
        this.rowMerge = rowMerge;
        this.colMerge = colMerge;
    }

    public void expand(int rowMergeInc, int colMergeInc) {
        if (this.row == 0 || this.col == 0) {
            return;
        }
        this.rowMerge += rowMergeInc;
        this.colMerge += colMergeInc;
        if (this.rowMerge < 1) {
            throw new RuntimeException();
        }
        if (this.colMerge < 1) {
            throw new RuntimeException();
        }
    }

    public void expandLeftHead(int mergeInc) {
        if (mergeInc < 0) {
            throw new RuntimeException();
        }
        ExtCell head = this.leftHead;
        ExtCell sub = this;
        while (head != null) {
            int i = 0;
            while (i < head.subCellList.size()) {
                ExtCell sub1 = (ExtCell)head.subCellList.get(i);
                if (sub1 != sub && sub1.containRow(this)) {
                    sub1.expand(mergeInc, 0);
                }
                ++i;
            }
            if (head.containRow(this)) {
                head.expand(mergeInc, 0);
            }
            sub = head;
            head = head.leftHead;
        }
    }

    public void expandTopHead(int mergeInc) {
        if (mergeInc < 0) {
            throw new RuntimeException();
        }
        ExtCell head = this.topHead;
        ExtCell sub = this;
        while (head != null) {
            int i = 0;
            while (i < head.subCellList.size()) {
                ExtCell sub1 = (ExtCell)head.subCellList.get(i);
                if (sub1 != sub && sub1.containCol(this) && this.sameRowTypeAs(sub1)) {
                    sub1.expand(0, mergeInc);
                }
                ++i;
            }
            if (head.containCol(this)) {
                head.expand(0, mergeInc);
            }
            sub = head;
            head = head.topHead;
        }
    }

    public boolean isMergeCell() {
        return this.rowMerge > 1 || this.colMerge > 1;
    }

    public int getRowMerge() {
        return this.rowMerge;
    }

    public int getColMerge() {
        return this.colMerge;
    }

    public boolean containRow(int row) {
        return this.row <= row && row < this.row + this.rowMerge;
    }

    public boolean sameRowTypeAs(ExtCell other) {
        ExtCell row0 = this.cs.getCell(this.row, 0);
        ExtCell other0 = this.cs.getCell(other.row, 0);
        Object type1 = null;
        Object type2 = null;
        if (row0 != null && row0.engine.propGetMap != null) {
            type1 = row0.engine.propGetMap.get(3103);
        }
        if (type1 == null) {
            type1 = CellPropertyDefine.CRT_NORMAL;
        }
        if (other0 != null && other0.engine.propGetMap != null) {
            type2 = other0.engine.propGetMap.get(3103);
        }
        if (type2 == null) {
            type2 = CellPropertyDefine.CRT_NORMAL;
        }
        if (CellPropertyDefine.CRT_NORMAL.equals(type1) || CellPropertyDefine.CRT_TABLE_HEADER.equals(type1)) {
            return CellPropertyDefine.CRT_NORMAL.equals(type2) || CellPropertyDefine.CRT_TABLE_HEADER.equals(type2);
        }
        return type1.equals(type2);
    }

    public boolean containCol(int col) {
        return this.col <= col && col < this.col + this.colMerge;
    }

    public boolean containRow(ExtCell sub) {
        return this.row <= sub.row && sub.row + sub.rowMerge <= this.row + this.rowMerge;
    }

    public boolean containCol(ExtCell sub) {
        return this.sameRowTypeAs(sub) && this.col <= sub.col && sub.col + sub.colMerge <= this.col + this.colMerge;
    }

    public void testValue() {
        if (this.cellValue == NULL_VALUE) {
            if (this.engine.exp != null) {
                if (this.movedForCalc > 10000) {
                    throw new CircularRefException(this);
                }
                ++this.movedForCalc;
                throw new CellNotSetValueException(this);
            }
            this.cellValue = null;
        }
        if (this.leftHead != null) {
            this.leftHead.testValue();
        }
        if (this.topHead != null) {
            this.topHead.testValue();
        }
    }

    public Object getValue(boolean dispValue) {
        Object value;
        this.testValue();
        if (dispValue && (value = this.getPropValue(4105)) != null) {
            return value;
        }
        return this.cellValue;
    }

    public void setPropValue(int key, Object value) {
        if (this.engine.propGetMap == null) {
            this.engine.propGetMap = new IntHashtable(3);
        }
        if (key == 4501) {
            this.engine.extensible = (Integer)value;
        } else if (key == 4103) {
            this.setMerge((String)value);
        } else {
            this.engine.propGetMap.put(key, value);
        }
    }

    public void setPropExp(int key, String expStr) {
        if (key == 4102) {
            this.engine.expStr = expStr;
        } else {
            if (this.engine.propEngMap == null) {
                this.engine.propEngMap = new IntHashtable(3);
            }
            ExpPair ep = new ExpPair();
            ep.expStr = expStr;
            this.engine.propEngMap.put(key, ep);
        }
    }

    public void replaceMacros(Map macros) {
        IntHashtable propEngMap;
        String text;
        Object value;
        if (macros == null || macros.isEmpty()) {
            return;
        }
        IntHashtable propGetMap = this.engine.propGetMap;
        if (propGetMap != null && (value = propGetMap.get(4102)) instanceof String) {
            String text2 = (String)value;
            propGetMap.put(4102, MacroResolver.replaceMacros(text2, macros));
        }
        if ((text = this.engine.expStr) != null) {
            this.engine.expStr = MacroResolver.replaceMacros(text, macros);
        }
        if ((propEngMap = this.engine.propEngMap) != null) {
            int i = 0;
            while (i < propEngMap.size()) {
                ExpPair e = (ExpPair)propEngMap.getValue(i);
                e.expStr = MacroResolver.replaceMacros(e.expStr, macros);
                ++i;
            }
        }
    }

    public String getMerge() {
        StringBuffer sb = new StringBuffer(20);
        sb.append(this.getRow());
        sb.append(',');
        sb.append(this.getCol());
        sb.append('-');
        sb.append(this.getRow() + this.getRowMerge() - 1);
        sb.append(',');
        sb.append(this.getCol() + this.getColMerge() - 1);
        String merge = sb.toString();
        return sb.toString();
    }

    private void setMerge(String merge) {
        if (merge.trim().length() == 0) {
            return;
        }
        ArgumentTokenizer arg = new ArgumentTokenizer(merge, '-');
        String begin = arg.nextToken();
        String end = arg.nextToken();
        arg = new ArgumentTokenizer(begin, ',');
        this.row = Integer.parseInt(arg.nextToken());
        this.col = Integer.parseInt(arg.nextToken());
        arg = new ArgumentTokenizer(end, ',');
        int endRow = Integer.parseInt(arg.nextToken());
        int endCol = Integer.parseInt(arg.nextToken());
        this.rowMerge = endRow - this.row + 1;
        this.colMerge = endCol - this.col + 1;
    }

    void setPropResult(int key, Object value) {
        if (this.propSetMap == null) {
            this.propSetMap = new IntHashtable(3);
        }
        this.propSetMap.put(key, value);
    }

    public IntHashtable getPropTable() {
        int key;
        int i;
        int size = (this.engine.propGetMap == null ? 0 : this.engine.propGetMap.size()) + (this.propSetMap == null ? 0 : this.propSetMap.size());
        IntHashtable propTable = new IntHashtable(size);
        CellProperty cp = null;
        IntHashtable propGetMap = this.engine.propGetMap;
        if (propGetMap != null) {
            i = 0;
            while (i < propGetMap.size()) {
                key = propGetMap.getKey(i);
                if (key != 4501 && key != 1102 && key != 1108 && key != 4502 && key != 4503) {
                    cp = new CellProperty();
                    cp.setPropertyValue(propGetMap.getValue(i));
                    propTable.put(key, cp);
                }
                ++i;
            }
        }
        if (this.cellValue != NULL_VALUE && this.cellValue != null) {
            int key2 = 4102;
            cp = new CellProperty();
            if (this.cellValue instanceof ExtCellSet) {
                ExtCellSet ecs = (ExtCellSet)this.cellValue;
                cp.setPropertyValue(ecs.write());
            } else {
                cp.setPropertyValue(this.cellValue);
            }
            propTable.put(key2, cp);
        }
        if (this.propSetMap != null) {
            i = 0;
            while (i < this.propSetMap.size()) {
                key = this.propSetMap.getKey(i);
                cp = new CellProperty();
                cp.setPropertyValue(this.propSetMap.getValue(i));
                propTable.put(key, cp);
                ++i;
            }
        }
        if (this.isMergeCell()) {
            cp = new CellProperty();
            cp.setPropertyValue(this.getMerge());
            propTable.put(4103, cp);
        }
        return propTable;
    }

    public void setPropTable(IntHashtable propTable) {
        int size = propTable.size();
        this.engine.propGetMap = new IntHashtable(size);
        CellProperty cp = null;
        int i = 0;
        while (i < propTable.size()) {
            int key = propTable.getKey(i);
            cp = (CellProperty)propTable.getValue(i);
            if (this.cs.isInput() && (key == 4801 || key == 4803 || key == 4807)) {
                if (this.engine.propInputMap == null) {
                    this.engine.propInputMap = new IntHashtable(5, 0.8f);
                }
                this.engine.propInputMap.put(key, cp.getPropertyValue());
            } else {
                Object value;
                String expStr = cp.getPropertyExpression();
                if (expStr != null && expStr.trim().length() > 0) {
                    this.setPropExp(key, expStr);
                }
                if ((value = cp.getPropertyValue()) != null) {
                    this.setPropValue(key, value);
                }
            }
            ++i;
        }
    }

    public Integer getExtensible() {
        return this.engine.extensible;
    }

    public void setExtensible(Integer extensible) {
        this.engine.extensible = extensible;
    }

    public Object getPropValue(int key) {
        Object value = null;
        if (this.propSetMap != null) {
            value = this.propSetMap.get(key);
        }
        if (value == null && this.engine.propGetMap != null) {
            value = this.engine.propGetMap.get(key);
        }
        return value;
    }

    public List getSubCells() {
        return this.subCellList;
    }

    public int getSubSize() {
        if (this.subCellList == null) {
            return 0;
        }
        return this.subCellList.size();
    }

    public ExtCell getSubCell(int index) {
        return (ExtCell)this.subCellList.get(index);
    }

    public void setLeftHead(ExtCell head) {
        if (head == this) {
            throw new ReportError(String.valueOf(this.engine.sourceId) + "\u5de6\u4e3b\u683c\u5faa\u73af\u5f15\u7528");
        }
        this.leftHead = head;
        if (head != null) {
            if (head.subCellList == null) {
                head.subCellList = new ArrayList(10);
            }
            head.subCellList.add(this);
        }
    }

    public void setTopHead(ExtCell head) {
        if (head == this) {
            throw new ReportError(String.valueOf(this.engine.sourceId) + "\u4e0a\u4e3b\u683c\u5faa\u73af\u5f15\u7528");
        }
        this.topHead = head;
        if (head != null) {
            if (head.subCellList == null) {
                head.subCellList = new ArrayList(10);
            }
            head.subCellList.add(this);
        }
    }

    public ExtCell getLeftHead() {
        return this.leftHead;
    }

    public ExtCell getTopHead() {
        return this.topHead;
    }

    public boolean isLeftHeadOf(ExtCell sub) {
        ExtCell head = sub;
        while (head != null) {
            if (this == head) {
                return true;
            }
            head = head.leftHead;
        }
        return false;
    }

    public boolean isTopHeadOf(ExtCell sub) {
        ExtCell head = sub;
        while (head != null) {
            if (this == head) {
                return true;
            }
            head = head.topHead;
        }
        return false;
    }

    public boolean isDirectLeftHeadOf(ExtCell sub) {
        return sub.leftHead == this && this.subCellList != null && this.subCellList.contains(sub);
    }

    public boolean isDirectTopHeadOf(ExtCell sub) {
        return sub.topHead == this && this.subCellList != null && this.subCellList.contains(sub);
    }

    public ExtCell getCommonLeftHead(ExtCell other) {
        ExtCell head = this;
        while (head != null) {
            if (head.isLeftHeadOf(other)) {
                return head;
            }
            head = head.leftHead;
        }
        return head;
    }

    public ExtCell getCommonTopHead(ExtCell other) {
        ExtCell head = this;
        while (head != null) {
            if (head.isTopHeadOf(other)) {
                return head;
            }
            head = head.topHead;
        }
        return head;
    }

    public ExtCell getLeftHead(ExtCell source) {
        ExtCell head = this;
        while (head != null) {
            if (head.source == source) break;
            head = head.leftHead;
        }
        return head;
    }

    public ExtCell getTopHead(ExtCell source) {
        ExtCell head = this;
        while (head != null) {
            if (head.source == source) break;
            head = head.topHead;
        }
        return head;
    }

    public void setExtCells(ExtCell[] cells) {
        this.extCells = cells;
    }

    public ExtCell[] getExtCells() {
        return this.extCells;
    }

    public int extCellSize() {
        return this.extCells == null ? 1 : this.extCells.length;
    }

    public ExtCell getExtCell(int index) {
        if (this.extCells == null) {
            if (index == 0) {
                return this;
            }
            return null;
        }
        if (index < 0 || index >= this.extCells.length) {
            return null;
        }
        return this.extCells[index];
    }

    public int getPosition() {
        if (this.extCells == null) {
            return 0;
        }
        int i = 0;
        while (i < this.extCells.length) {
            if (this == this.extCells[i]) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException();
    }

    public ExtCell getLeftHead(ExtCell source, int position) {
        ExtCell leftHead = this.getLeftHead(source);
        if (leftHead == null || leftHead.extCells == null) {
            return null;
        }
        if (position < 0 || position >= leftHead.extCells.length) {
            return null;
        }
        return leftHead.extCells[position];
    }

    public ExtCell getTopHead(ExtCell source, int position) {
        ExtCell topHead = this.getTopHead(source);
        if (topHead == null || topHead.extCells == null) {
            return null;
        }
        if (position < 0 || position >= topHead.extCells.length) {
            return null;
        }
        return topHead.extCells[position];
    }

    public ExtCell getSubCell(ExtCell source) {
        if (this.subCellList == null) {
            return null;
        }
        int i = 0;
        while (i < this.subCellList.size()) {
            ExtCell sub = (ExtCell)this.subCellList.get(i);
            if (sub.source == source) {
                return sub;
            }
            ++i;
        }
        return null;
    }

    public ExtCell getSubCell(ExtCell source, int position) {
        int i = 0;
        while (i < this.subCellList.size()) {
            ExtCell sub = (ExtCell)this.subCellList.get(i);
            if (sub.source == source) {
                if (sub.extCells == null) {
                    return null;
                }
                if (position < 0 || position >= sub.extCells.length) {
                    return null;
                }
                return sub.extCells[position];
            }
            ++i;
        }
        return null;
    }

    public void prepareCalculate() {
        try {
            this.movedForCalc = 0;
            boolean canExtended = false;
            if (this.engine.expStr != null) {
                if (CellPropertyDefine.CEX_DEFAULT.equals(this.getExtensible())) {
                    this.engine.exp = new Expression(this.cs, this.engine.expStr, true);
                    ExtCell cell00 = this.cs.getCell(0, 0);
                    if (this.engine.exp.isExtended()) {
                        if (this.leftHead == cell00 && this.topHead != cell00) {
                            this.setExtensible(CellPropertyDefine.CEX_HORIZONTAL);
                            canExtended = true;
                        } else if (this.leftHead != cell00 && this.topHead != cell00) {
                            this.setExtensible(CellPropertyDefine.CEX_NONE);
                        } else {
                            this.setExtensible(CellPropertyDefine.CEX_VERTICAL);
                            canExtended = true;
                        }
                    }
                } else {
                    this.engine.exp = new Expression(this.cs, this.engine.expStr);
                    canExtended = CellPropertyDefine.CEX_HORIZONTAL.equals(this.getExtensible()) || CellPropertyDefine.CEX_VERTICAL.equals(this.getExtensible());
                }
                this.cellValue = NULL_VALUE;
            } else {
                IntHashtable propGetMap = this.engine.propGetMap;
                if (propGetMap != null) {
                    this.cellValue = propGetMap.get(4102);
                    Object dataType = propGetMap.get(4101);
                    if ((dataType == null || dataType.equals(CellPropertyDefine.CDT_TEXT)) && this.cellValue instanceof String) {
                        String format;
                        this.cellValue = Variant2.parse((String)this.cellValue, false);
                        if (propGetMap.get(4105) == null && !StringUtils.isSpaceString(format = (String)propGetMap.get(4104))) {
                            propGetMap.put(4105, Variant2.format(this.cellValue, format));
                        }
                    }
                }
            }
            IntHashtable propEngMap = this.engine.propEngMap;
            if (propEngMap != null) {
                int i = 0;
                while (i < propEngMap.size()) {
                    ExpPair ep = (ExpPair)propEngMap.getValue(i);
                    ep.exp = new Expression(this.cs, ep.expStr);
                    ++i;
                }
            }
        }
        catch (ReportError re) {
            re.setCellId(this.getSourceId());
            throw re;
        }
        catch (Throwable e) {
            throw new ReportError("\u5355\u5143\u683c" + this.getSourceId() + "\u4e2d\u6709\u9519\u8bef\uff0c" + e.getMessage(), e);
        }
    }

    private void setDSCurrent() {
        this.cs.resetDSCurrent();
        if (this.group != null) {
            this.group.getDataSet().setCurrentGroup(this.group);
        }
        if (this.dsRow != null) {
            this.dsRow.getDataSet().setCurrentRow(this.dsRow);
        }
        ExtCell head = this.leftHead;
        while (head != null) {
            if (head.group != null && head.group.getDataSet().getCurrentGroup() == null) {
                head.group.getDataSet().setCurrentGroup(head.group);
            }
            if (head.dsRow != null && head.dsRow.getDataSet().getCurrentRow() == null) {
                head.dsRow.getDataSet().setCurrentRow(head.dsRow);
            }
            head = head.leftHead;
        }
        head = this.topHead;
        while (head != null) {
            if (head.group != null) {
                Group current = head.group.getDataSet().getCurrentGroup();
                current = current != null ? current.cross(head.group) : head.group;
                current.getDataSet().setCurrentGroup(current);
            }
            if (head.dsRow != null && head.dsRow.getDataSet().getCurrentRow() == null) {
                head.dsRow.getDataSet().setCurrentRow(head.dsRow);
            }
            head = head.topHead;
        }
        this.cs.setDSCurrent();
    }

    public void calculate() {
        if (this.engine == null) {
            return;
        }
        if (this.engine.exp == null || this.cellValue != NULL_VALUE) {
            return;
        }
        if (this.leftHead != null) {
            this.leftHead.testValue();
        }
        if (this.topHead != null) {
            this.topHead.testValue();
        }
        this.setDSCurrent();
        Object result = this.engine.exp.calculate();
        Integer extensible = this.getExtensible();
        if (CellPropertyDefine.CDT_SUBREPORT.equals(this.engine.propGetMap.get(4101))) {
            ExtCellSet subRpt = (ExtCellSet)result;
            if (subRpt.getSubRptType() == ExtCellSet.SRT_IMPORT) {
                new SubRpt(this.cs, this, subRpt).extendSubRpt();
            } else {
                this.cellValue = result;
            }
        } else if (CellPropertyDefine.CEX_VERTICAL.equals(extensible) || CellPropertyDefine.CEX_HORIZONTAL.equals(extensible)) {
            if (result instanceof List) {
                Object value;
                List list = (List)result;
                int len = list.size();
                if (len == 0) {
                    this.cellValue = null;
                    return;
                }
                Object[] valueList = new Object[len];
                Object[] dispList = new Object[len];
                int i = 0;
                while (i < len) {
                    value = list.get(i);
                    valueList[i] = Variant2.getValue(value);
                    dispList[i] = this.calcDispValue(value);
                    ++i;
                }
                if (CellPropertyDefine.CEX_VERTICAL.equals(extensible)) {
                    this.cs.extendRow(this, len);
                } else {
                    this.cs.extendCol(this, len);
                }
                i = 0;
                while (i < len) {
                    this.extCells[i].cellValue = valueList[i];
                    if (dispList[i] != null) {
                        this.extCells[i].setPropResult(4105, dispList[i]);
                    }
                    if ((value = list.get(i)) instanceof Row) {
                        this.extCells[i].dsRow = (Row)value;
                    } else if (value instanceof Group) {
                        Group group;
                        this.extCells[i].group = group = (Group)value;
                        if (group.getRowCount() > 0) {
                            this.extCells[i].dsRow = group.getRow(0);
                        }
                    }
                    ++i;
                }
            } else {
                this.cellValue = Variant2.getValue(result);
                this.setPropResult(4105, this.calcDispValue(result));
                this.extCells = new ExtCell[]{this};
                if (result instanceof Row) {
                    this.dsRow = (Row)result;
                } else if (result instanceof Group) {
                    this.group = (Group)result;
                    if (this.group.getRowCount() > 0) {
                        this.dsRow = this.group.getRow(0);
                    }
                }
            }
        } else {
            this.setPropResult(4105, this.calcDispValue(result));
            this.cellValue = Variant2.getValue(result);
            if (result instanceof Row) {
                this.dsRow = (Row)result;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String calcDispValue(Object result) {
        String dispValue = (String)this.engine.propGetMap.get(4105);
        if (dispValue != null) {
            return dispValue.toString();
        }
        Object type = this.engine.propGetMap.get(4101);
        if (type != null && !CellPropertyDefine.CDT_TEXT.equals(type)) {
            return null;
        }
        String format = null;
        Object oldCellValue = this.cellValue;
        Group oldGroup = this.group;
        Row oldRow = this.dsRow;
        try {
            this.cellValue = Variant2.getValue(result);
            if (result instanceof Group) {
                this.group = (Group)result;
            }
            if (result instanceof Row) {
                this.dsRow = (Row)result;
            }
            if (this.group != null) {
                this.group.getDataSet().setCurrentGroup(this.group);
            }
            if (this.dsRow != null) {
                this.dsRow.getDataSet().setCurrentRow(this.dsRow);
            }
            if (this.engine.propEngMap != null) {
                Object o;
                ExpPair e = (ExpPair)this.engine.propEngMap.get(4105);
                if (e != null) {
                    this.cellValue = Variant2.getSingleValue(e.exp.calculate());
                }
                if ((e = (ExpPair)this.engine.propEngMap.get(4104)) != null && (o = Variant2.getSingleValue(e.exp.calculate())) instanceof String) {
                    format = (String)o;
                }
            }
            if (format == null) {
                format = (String)this.engine.propGetMap.get(4104);
            }
            if (StringUtils.isSpaceString(format)) {
                if (!(this.cellValue instanceof byte[])) {
                    dispValue = Variant2.toString(this.cellValue);
                }
            } else {
                dispValue = Variant2.format(this.cellValue, format);
            }
            Object var10_12 = null;
            this.cellValue = oldCellValue;
            this.group = oldGroup;
            this.dsRow = oldRow;
            return dispValue;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.cellValue = oldCellValue;
            this.group = oldGroup;
            this.dsRow = oldRow;
            throw throwable;
        }
    }

    public void calcProperties() {
        IntHashtable propEngMap = this.engine.propEngMap;
        if (propEngMap != null) {
            if (this.dsRow != null) {
                this.dsRow.getDataSet().setCurrentRow(this.dsRow);
            }
            int i = 0;
            while (i < propEngMap.size()) {
                int key = propEngMap.getKey(i);
                if (key != 4104 && key != 4105) {
                    ExpPair e = (ExpPair)propEngMap.getValue(i);
                    Object result = Variant2.getSingleValue(e.exp.calculate());
                    this.setPropResult(key, result);
                }
                ++i;
            }
        }
    }

    private static String remove$(String s) {
        int i = 0;
        while (i < s.length()) {
            int pos = s.indexOf(36, i);
            if (pos < 0) break;
            s = String.valueOf(s.substring(0, pos)) + s.substring(pos + 1);
            i = pos;
        }
        return s;
    }

    public void calcInput() {
        IntHashtable inputMap = this.engine.propInputMap;
        if (inputMap == null) {
            return;
        }
        if (this.cs.isNewInput()) {
            int k = 0;
            while (k < inputMap.size()) {
                int key = inputMap.getKey(k);
                String prop = (String)inputMap.getValue(k);
                if (!StringUtils.isSpaceString(prop)) {
                    switch (key) {
                        case 4803: 
                        case 4807: {
                            MacroResolver mr = new MacroResolver(prop);
                            while (mr.hasNext()) {
                                String macro = mr.next();
                                Expression exp = new Expression(this.cs, macro);
                                mr.setValue(exp.getExp());
                            }
                            String sss = mr.getResolvedStr();
                            if (sss == null || sss.trim().length() == 0) {
                                sss = null;
                            }
                            this.setPropResult(key, sss);
                            break;
                        }
                        case 4801: {
                            UpdateProp up = new UpdateProp(prop);
                            int i = 0;
                            while (i < up.getUpdateCount()) {
                                Expression exp;
                                String token;
                                boolean first = true;
                                String s = up.getKeyValue(i);
                                StringTokenizer st = new StringTokenizer(s, ",");
                                StringBuffer sb = new StringBuffer(s.length());
                                while (st.hasMoreTokens()) {
                                    token = ExtCell.remove$(st.nextToken());
                                    exp = new Expression(this.cs, token);
                                    if (first) {
                                        first = false;
                                    } else {
                                        sb.append(',');
                                    }
                                    sb.append(exp.getExp());
                                }
                                up.setKeyValue(i, sb.toString());
                                s = up.getUpdateValue(i);
                                first = true;
                                st = new StringTokenizer(s, ",");
                                sb.setLength(0);
                                while (st.hasMoreTokens()) {
                                    token = ExtCell.remove$(st.nextToken());
                                    exp = new Expression(this.cs, token);
                                    if (first) {
                                        first = false;
                                    } else {
                                        sb.append(',');
                                    }
                                    sb.append(exp.getExp());
                                }
                                up.setUpdateValue(i, sb.toString());
                                ++i;
                            }
                            this.setPropResult(key, up.toString());
                        }
                    }
                }
                ++k;
            }
        } else {
            if (this != this.source) {
                return;
            }
            int i = 0;
            while (i < inputMap.size()) {
                int key = inputMap.getKey(i);
                String prop = (String)inputMap.getValue(i);
                if (!StringUtils.isSpaceString(prop)) {
                    switch (key) {
                        case 4803: 
                        case 4807: {
                            MacroResolver mr = new MacroResolver(prop);
                            while (mr.hasNext()) {
                                String macro = mr.next();
                                Expression exp = new Expression(this.cs, macro);
                                mr.setValue(exp.getExp());
                            }
                            this.setPropResult(key, mr.getResolvedStr());
                            break;
                        }
                        case 4801: {
                            this.setPropResult(key, prop);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void calcFold() {
        Integer extensible = this.engine.extensible;
        if (!CellPropertyDefine.CEX_VERTICAL.equals(extensible) && !CellPropertyDefine.CEX_HORIZONTAL.equals(extensible)) {
            return;
        }
        int begin = this.cs.getBeginRow(this);
        int end = this.cs.getEndRow(this);
        StringBuffer sb = new StringBuffer(32);
        boolean first = true;
        ExtCell ocell = this.cs.getCell(0, 0);
        int i = begin;
        while (i < end) {
            IntHashtable ih;
            boolean hide = false;
            ExtCell c = this.cs.getCell(i, 0);
            if (c != null && (ih = c.engine.propGetMap) != null) {
                hide = Boolean.TRUE.equals(ih.get(3104));
            }
            if (!hide) {
                int j = 1;
                while (j < this.cs.getColSize()) {
                    ExtCell cell = this.cs.getCell(i, j);
                    if (cell != null && cell.leftHead != null && cell.leftHead != ocell && cell != this) {
                        hide = true;
                        Integer cellExtensible = cell.getExtensible();
                        if (cell.leftHead == this && !CellPropertyDefine.CEX_VERTICAL.equals(cellExtensible) && !CellPropertyDefine.CEX_HORIZONTAL.equals(cellExtensible) || cell.leftHead != this && cell.leftHead.isLeftHeadOf(this)) {
                            hide = false;
                            break;
                        }
                    }
                    ++j;
                }
            }
            if (hide) {
                if (first) {
                    first = !first;
                } else {
                    sb.append(',');
                }
                sb.append(i);
            }
            ++i;
        }
        if (!first) {
            this.setPropResult(4704, sb.toString());
        }
    }

    public void addDependCell(ExtCell cell) {
    }

    public boolean dependOn(ExtCell cell) {
        return false;
    }

    public void clearDependCells() {
    }

    public void clearDSRef() {
        this.group = null;
        this.dsRow = null;
    }

    public void clearCellRef() {
        this.source = null;
        this.leftHead = null;
        this.topHead = null;
        this.extCells = null;
        this.subCellList = null;
    }

    static class Engine {
        public String expStr;
        public Expression exp;
        public IntHashtable propGetMap;
        public IntHashtable propEngMap;
        public IntHashtable propInputMap;
        public String sourceId;
        public Integer extensible;

        Engine() {
        }
    }

    static class ExpPair {
        public String expStr;
        public Expression exp;

        ExpPair() {
        }
    }
}

