/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.NStringMap;
import com.runqian.base.util.Queue;
import com.runqian.base.util.ReportError;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.CellNotSetValueException;
import com.runqian.report.engine.CellSetTransfer;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.Matrix;
import com.runqian.report.engine.Variant2;
import com.runqian.report.usermodel.Env;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExtCellSet
implements Cloneable {
    public static int NORMAL = 0;
    public static int GRAPH = 10;
    public static int SUBREPORT = 20;
    public static int GET_EXP = 30;
    public static int FOLD = 40;
    public static int FINISHED = 50;
    public static int SRT_NONE = 0;
    public static int SRT_IMPORT = 1;
    public static int SRT_EMBED = 2;
    private int subRptType = SRT_NONE;
    private Env env;
    protected Matrix matrix;
    protected NStringMap sourceMap;
    protected Queue cellList;
    protected ExtCell current;
    protected ExtCell savedCurrent;
    private int state = NORMAL;
    protected boolean drillable = false;
    private boolean newInput = false;
    protected Object reportType = CellPropertyDefine.CRT_GRID;
    private static final String[][] cellIds;

    static {
        String[][] ids = cellIds = new String[51][27];
        int row = 0;
        while (row < 51) {
            int col = 0;
            while (col < 27) {
                ids[row][col] = String.valueOf((char)(col - 1 + 97)) + Integer.toString(row);
                ++col;
            }
            ++row;
        }
    }

    public ExtCellSet(Env env, int initRowCap, int initColCap) {
        this.env = env;
        if (env == null) {
            env = Variant2.getEnv();
        }
        this.matrix = new Matrix(initRowCap, initColCap);
        this.sourceMap = new NStringMap();
        this.cellList = new Queue();
        this.newCell(0, 0);
    }

    public ExtCellSet(Env env) {
        this(env, 20, 10);
    }

    public Env getEnv() {
        return this.env;
    }

    public void setEnv(Env env) {
        if (env != null) {
            this.env = env;
        }
    }

    public boolean isInput() {
        return CellPropertyDefine.CRT_INPUT.equals(this.reportType);
    }

    public void setNewInput(boolean newInput) {
        this.newInput = newInput;
    }

    public boolean isNewInput() {
        return this.newInput;
    }

    public int getSubRptType() {
        return this.subRptType;
    }

    public void setSubRptType(int subRptType) {
        this.subRptType = subRptType;
    }

    public void resetDSCurrent() {
        NStringMap dsMap = this.env.getDataSetsMap();
        if (dsMap == null) {
            return;
        }
        Iterator it = dsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DataSet ds = (DataSet)entry.getValue();
            if (ds == null) continue;
            ds.setCurrentGroup(null);
            ds.setCurrentRow(null);
        }
    }

    public void setDSCurrent() {
        NStringMap dsMap = this.env.getDataSetsMap();
        if (dsMap == null) {
            return;
        }
        Iterator it = dsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DataSet ds = (DataSet)entry.getValue();
            if (ds == null || ds.getCurrentGroup() != null) continue;
            ds.setCurrentGroup(ds.getRootGroup());
        }
    }

    public int getRowHeight(int row) {
        ExtCell cell = this.getCell(row, 0);
        Number height = null;
        if (cell != null) {
            height = (Number)cell.getPropValue(3101);
        }
        if (height == null) {
            height = CellPropertyDefine.DEFAULT_ROW_HEIGHT;
        }
        return Math.round(((Number)height).floatValue());
    }

    public int getColWidth(int col) {
        ExtCell cell = this.getCell(0, col);
        Number width = null;
        if (cell != null) {
            width = (Number)cell.getPropValue(2101);
        }
        if (width == null) {
            width = CellPropertyDefine.DEFAULT_COL_WIDTH;
        }
        return Math.round(((Number)width).floatValue());
    }

    public void setCurrent(ExtCell current) {
        this.current = current;
    }

    public ExtCell getCurrent() {
        return this.current;
    }

    public void saveCurrent() {
        this.savedCurrent = this.current;
    }

    public ExtCell getSavedCurrent() {
        return this.savedCurrent;
    }

    public void resumeCurrent() {
        this.current = this.savedCurrent;
    }

    public ExtCell newCell(int row, int col, boolean isNullCell) {
        ExtCell cell = this.getCell(row, col);
        if (cell != null) {
            throw new RuntimeException();
        }
        if (this.matrix.getRowSize() <= row) {
            this.matrix.setRowSize(row + 1);
        }
        if (this.matrix.getColSize() <= col) {
            this.matrix.setColSize(col + 1);
        }
        cell = new ExtCell(this, row, col, isNullCell);
        this.matrix.set(row, col, cell);
        return cell;
    }

    public ExtCell newCell(int row, int col) {
        return this.newCell(row, col, false);
    }

    public void remove(int row, int col) {
        this.matrix.set(row, col, null);
    }

    public boolean isSource(String id) {
        return this.sourceMap.containsKey(id);
    }

    public ExtCell getSource(String cellId) {
        return (ExtCell)this.sourceMap.get(cellId);
    }

    public int getRowSize() {
        return this.matrix.getRowSize();
    }

    public int getColSize() {
        return this.matrix.getColSize();
    }

    public void setRowSize(int size) {
        this.matrix.setRowSize(size);
    }

    public void setColSize(int size) {
        this.matrix.setColSize(size);
    }

    public boolean isMerged(int row, int col) {
        ExtCell cell = this.getCell(row, col);
        if (cell == null) {
            return false;
        }
        return cell.getRow() != row || cell.getCol() != col;
    }

    public ExtCell getCell(int row, int col) {
        if (this.matrix.getRowSize() <= row || this.matrix.getColSize() <= col) {
            return null;
        }
        return (ExtCell)this.matrix.get(row, col);
    }

    private void removeMergedCells() {
        int i = 1;
        while (i < this.getRowSize()) {
            int j = 1;
            while (j < this.getColSize()) {
                if (this.isMerged(i, j)) {
                    this.matrix.set(i, j, null);
                }
                ++j;
            }
            ++i;
        }
    }

    private void addMergedCell(ExtCell cell) {
        int endRow = cell.getEndRow();
        int endCol = cell.getEndCol();
        int i = cell.getRow();
        while (i <= endRow) {
            int j = cell.getCol();
            while (j <= endCol) {
                if (i != cell.getRow() || j != cell.getCol()) {
                    this.matrix.set(i, j, cell);
                }
                ++j;
            }
            ++i;
        }
    }

    public void addMergedCells() {
        int i = 1;
        while (i < this.getRowSize()) {
            int j = 1;
            while (j < this.getColSize()) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null && !this.isMerged(i, j)) {
                    this.addMergedCell(cell);
                }
                ++j;
            }
            ++i;
        }
    }

    private ExtCell getLeftHead(ExtCell cell) {
        ExtCell head1;
        String head = (String)cell.getPropValue(4502);
        if (head != null && (head = head.trim()).length() > 0 && (head1 = this.getSource(head)) != null) {
            return head1;
        }
        int i = cell.getCol() - 1;
        while (i >= 1) {
            ExtCell head12 = this.getCell(cell.getRow(), i);
            if (head12 != null) {
                if (head12.containRow(cell) && CellPropertyDefine.CEX_VERTICAL.equals(head12.getExtensible())) {
                    if (!cell.isLeftHeadOf(head12)) {
                        return head12;
                    }
                } else {
                    ExtCell headOfHead1 = head12.getLeftHead();
                    if (headOfHead1 != null && !cell.isLeftHeadOf(headOfHead1)) {
                        return headOfHead1;
                    }
                }
            }
            --i;
        }
        return this.getCell(0, 0);
    }

    private ExtCell getTopHead(ExtCell cell) {
        ExtCell head1;
        String head = (String)cell.getPropValue(4503);
        if (head != null && (head = head.trim()).length() > 0 && (head1 = this.getSource(head)) != null) {
            return head1;
        }
        int i = cell.getRow() - 1;
        while (i >= 1) {
            ExtCell head12 = this.getCell(i, cell.getCol());
            if (head12 != null) {
                ExtCell headOfHead1;
                if (cell.sameRowTypeAs(head12) && head12.containCol(cell) && CellPropertyDefine.CEX_HORIZONTAL.equals(head12.getExtensible())) {
                    if (!cell.isTopHeadOf(head12)) {
                        return head12;
                    }
                } else if (cell.sameRowTypeAs(head12) && (headOfHead1 = head12.getTopHead()) != null && !cell.isTopHeadOf(headOfHead1)) {
                    return headOfHead1;
                }
            }
            --i;
        }
        return this.getCell(0, 0);
    }

    private void prepareCalculate() {
        ExtCell cell;
        int j;
        this.cellList.clear();
        this.sourceMap.clear();
        int i = 0;
        while (i < this.getRowSize()) {
            j = 0;
            while (j < this.getColSize()) {
                cell = this.getCell(i, j);
                if (!this.isMerged(i, j)) {
                    this.sourceMap.put(ExtCellSet.getId(i, j), cell);
                    if (cell != null) {
                        this.cellList.put(cell);
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.getRowSize()) {
            j = 0;
            while (j < this.getColSize()) {
                if (!(i == 0 && j == 0 || (cell = this.getCell(i, j)) == null || this.isMerged(i, j))) {
                    cell.setLeftHead(this.getLeftHead(cell));
                    cell.setTopHead(this.getTopHead(cell));
                    cell.prepareCalculate();
                }
                ++j;
            }
            ++i;
        }
        ExtCell cell2 = this.getCell(0, 0);
        List subCellList = cell2.getSubCells();
        if (subCellList != null) {
            subCellList.clear();
            Iterator it = this.sourceMap.values().iterator();
            while (it.hasNext()) {
                ExtCell sub = (ExtCell)it.next();
                if (sub == null || sub.getLeftHead() != cell2 || sub.getTopHead() != cell2) continue;
                subCellList.add(sub);
            }
        }
    }

    void insertRow(int row, int count) {
        this.matrix.addRows(row, count);
        int i = row + count;
        while (i < this.getRowSize()) {
            int j = 0;
            while (j < this.getColSize()) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null) {
                    cell.move(count, 0);
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean rowTypeIsNormal(int row) {
        if (row == 0) {
            return true;
        }
        ExtCell cell = this.getCell(row, 0);
        if (cell == null) {
            return true;
        }
        Object type = cell.getPropValue(3103);
        return type == null || type.equals(CellPropertyDefine.CRT_NORMAL) || type.equals(CellPropertyDefine.CRT_TABLE_HEADER);
    }

    int getDataBegin() {
        int size = this.getRowSize();
        int i = 1;
        while (i < size) {
            if (this.rowTypeIsNormal(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getDataEnd() {
        int size = this.getRowSize();
        int i = size - 1;
        while (i >= 1) {
            if (this.rowTypeIsNormal(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    void insertCol(int col, int count) {
        this.insertCol(col, count, this.getDataBegin(), this.getDataEnd(), true);
    }

    void insertCol(int col, int count, int begin, int end, boolean alignColHead) {
        if (begin > 0) {
            this.matrix.addCols(col, count, begin, end, alignColHead);
        }
        int i = col + count;
        while (i < this.getColSize()) {
            int j = 0;
            while (j <= this.getRowSize()) {
                ExtCell cell;
                if ((alignColHead && j == 0 || j >= begin && j <= end) && (cell = this.getCell(j, i)) != null) {
                    cell.move(0, count);
                }
                ++j;
            }
            ++i;
        }
    }

    void setCell(int row, int col, ExtCell cell) {
        this.matrix.set(row, col, cell);
        if (cell != null) {
            cell.setLocation(row, col);
        }
    }

    protected int getBeginRow(ExtCell cell) {
        int row = cell.getRow();
        List subCells = cell.getSubCells();
        if (subCells != null) {
            int i = 0;
            while (i < subCells.size()) {
                ExtCell sub = (ExtCell)subCells.get(i);
                int beginRow = this.getBeginRow(sub);
                if (beginRow < row) {
                    row = beginRow;
                }
                ++i;
            }
        }
        return row;
    }

    protected int getEndRow(ExtCell cell) {
        int row = cell.getRow() + cell.getRowMerge();
        List subCells = cell.getSubCells();
        if (subCells != null) {
            int i = 0;
            while (i < subCells.size()) {
                ExtCell sub = (ExtCell)subCells.get(i);
                int endRow = this.getEndRow(sub);
                if (endRow > row) {
                    row = endRow;
                }
                ++i;
            }
        }
        return row;
    }

    public void extendRow(ExtCell cell, int count) {
        int beginRow = this.getBeginRow(cell);
        int endRow = this.getEndRow(cell);
        int rowCount = endRow - beginRow;
        ExtCell[] extCells = new ExtCell[count];
        extCells[0] = cell;
        cell.setExtCells(extCells);
        this.insertRow(endRow, rowCount * (count - 1));
        int i = beginRow;
        while (i < endRow) {
            ExtCell sub = this.getCell(i, 0);
            if (sub != null) {
                int j = 1;
                while (j < count) {
                    this.setCell(i + rowCount * j, 0, (ExtCell)sub.clone());
                    ++j;
                }
            }
            ++i;
        }
        cell.expandLeftHead(rowCount * (count - 1));
        i = beginRow;
        while (i < endRow) {
            int j = 1;
            while (j < this.getColSize()) {
                ExtCell sub = this.getCell(i, j);
                if (sub != null && cell.isLeftHeadOf(sub)) {
                    int m = 1;
                    while (m < count) {
                        ExtCell newSub = (ExtCell)sub.clone();
                        this.setCell(i + m * rowCount, j, newSub);
                        if (sub != cell) {
                            this.cellList.put(newSub);
                        } else {
                            extCells[m] = newSub;
                            newSub.setExtCells(extCells);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = beginRow;
        while (i < endRow) {
            int j = 1;
            while (j < this.getColSize()) {
                ExtCell sub = this.getCell(i, j);
                if (sub != null && cell.isLeftHeadOf(sub)) {
                    ExtCell head = sub.getLeftHead();
                    int m = 1;
                    while (m < count) {
                        ExtCell newSub = this.getCell(i + rowCount * m, j);
                        if (sub != cell) {
                            ExtCell newHead = this.getCell(head.getRow() + rowCount * m, head.getCol());
                            newSub.setLeftHead(newHead);
                        }
                        if (sub.getTopHead() != this.getCell(0, 0)) {
                            newSub.setTopHead(sub.getTopHead());
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected int getBeginCol(ExtCell cell) {
        int col = cell.getCol();
        List subCells = cell.getSubCells();
        if (subCells != null) {
            int i = 0;
            while (i < subCells.size()) {
                ExtCell sub = (ExtCell)subCells.get(i);
                int beginCol = this.getBeginCol(sub);
                if (beginCol < col) {
                    col = beginCol;
                }
                ++i;
            }
        }
        return col;
    }

    protected int getEndCol(ExtCell cell) {
        int col = cell.getCol() + cell.getColMerge();
        List subCells = cell.getSubCells();
        if (subCells != null) {
            int i = 0;
            while (i < subCells.size()) {
                ExtCell sub = (ExtCell)subCells.get(i);
                int endCol = this.getEndCol(sub);
                if (endCol > col) {
                    col = endCol;
                }
                ++i;
            }
        }
        return col;
    }

    public void extendCol(ExtCell cell, int count) {
        if (!this.rowTypeIsNormal(cell.getRow())) {
            throw new ReportError("\u975e\u6570\u636e\u533a\u5355\u5143\u683c\u4e0d\u80fd\u6a2a\u5411\u6269\u5c55");
        }
        int beginCol = this.getBeginCol(cell);
        int endCol = this.getEndCol(cell);
        int colCount = endCol - beginCol;
        ExtCell[] extCells = new ExtCell[count];
        extCells[0] = cell;
        cell.setExtCells(extCells);
        this.insertCol(endCol, colCount * (count - 1));
        int i = beginCol;
        while (i < endCol) {
            ExtCell sub = this.getCell(0, i);
            if (sub != null) {
                int j = 1;
                while (j < count) {
                    this.setCell(0, i + j * colCount, (ExtCell)sub.clone());
                    ++j;
                }
            }
            ++i;
        }
        cell.expandTopHead(colCount * (count - 1));
        i = beginCol;
        while (i < endCol) {
            int j = 1;
            while (j < this.getRowSize()) {
                ExtCell sub = this.getCell(j, i);
                if (sub != null && cell.isTopHeadOf(sub)) {
                    int m = 1;
                    while (m < count) {
                        ExtCell newSub = (ExtCell)sub.clone();
                        this.setCell(j, i + m * colCount, newSub);
                        if (sub != cell) {
                            this.cellList.put(newSub);
                        } else {
                            extCells[m] = newSub;
                            newSub.setExtCells(extCells);
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = beginCol;
        while (i < endCol) {
            int j = 1;
            while (j < this.getRowSize()) {
                ExtCell sub = this.getCell(j, i);
                if (sub != null && cell.isTopHeadOf(sub)) {
                    ExtCell head = sub.getTopHead();
                    int m = 1;
                    while (m < count) {
                        ExtCell newSub = this.getCell(j, i + colCount * m);
                        if (sub != cell) {
                            ExtCell newHead = this.getCell(head.getRow(), head.getCol() + colCount * m);
                            newSub.setTopHead(newHead);
                        }
                        if (sub.getLeftHead() != this.getCell(0, 0)) {
                            newSub.setLeftHead(sub.getLeftHead());
                        }
                        ++m;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void calcProperties() {
        this.resetDSCurrent();
        this.setDSCurrent();
        int i = 0;
        while (i < this.getRowSize()) {
            int j = 0;
            while (j < this.getColSize()) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null) {
                    this.setCurrent(cell);
                    cell.calcProperties();
                }
                ++j;
            }
            ++i;
        }
    }

    void dumpCellList() {
        int i = 0;
        while (i < this.cellList.size()) {
            this.printCell((ExtCell)this.cellList.peek(i));
            ++i;
        }
    }

    void dump() {
        int i = 1;
        while (i < this.getRowSize()) {
            int j = 1;
            while (j < this.getColSize()) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null) {
                    System.out.print("\t");
                    this.printCell(cell);
                }
                ++j;
            }
            ++i;
        }
    }

    void printCell(ExtCell cell) {
        System.out.print(String.valueOf(cell.getId()) + ": ");
        System.out.print("Src=" + cell.getSourceId() + ", ");
        ExtCell c = cell.getLeftHead();
        System.out.print("LeftHead=" + (c == null ? "" : c.getId()) + ", ");
        c = cell.getTopHead();
        System.out.print("TopHead=" + (c == null ? "" : c.getId()) + ", ");
        System.out.print("Exp=" + (cell.engine == null ? "" : cell.engine.expStr) + ", ");
        ExtCell[] extCells = cell.getExtCells();
        System.out.print("Ext=(");
        if (extCells != null) {
            int i = 0;
            while (i < extCells.length) {
                System.out.print(extCells[i].getId());
                if (i != extCells.length - 1) {
                    System.out.print(",");
                }
                ++i;
            }
        }
        System.out.println(")");
    }

    public void calculate() {
        try {
            ExtCell cell;
            ExtCell cell2;
            NStringMap dsMap = this.env.getDataSetsMap();
            if (dsMap != null) {
                Iterator it = dsMap.keySet().iterator();
                while (it.hasNext()) {
                    Object key = it.next();
                    DataSet ds = (DataSet)dsMap.get(key);
                    if (ds == null) continue;
                    ds.finish();
                }
            }
            this.replaceMacros();
            this.prepareCalculate();
            this.removeMergedCells();
            Queue graphCellList = new Queue();
            while (!this.cellList.isEmpty()) {
                cell2 = (ExtCell)this.cellList.get();
                if (CellPropertyDefine.CDT_GRAPH.equals(cell2.getPropValue(4101))) {
                    graphCellList.put(cell2);
                    continue;
                }
                try {
                    this.current = cell2;
                    cell2.calculate();
                    cell2.clearDependCells();
                }
                catch (CellNotSetValueException e) {
                    if (e.getCell().dependOn(cell2)) {
                        throw new ReportError(String.valueOf(e.getCell().getSourceId()) + "\u4e0e" + cell2.getSourceId() + "\u5faa\u73af\u5f15\u7528");
                    }
                    cell2.addDependCell(e.getCell());
                    this.cellList.put(cell2);
                }
            }
            this.resetDSCurrent();
            this.setDSCurrent();
            this.state = GRAPH;
            while (!graphCellList.isEmpty()) {
                this.current = cell2 = (ExtCell)graphCellList.get();
                cell2.calculate();
            }
            this.calcProperties();
            this.addMergedCells();
            this.rightAlign();
            if (this.isInput()) {
                this.state = GET_EXP;
                int i = 0;
                while (i < this.getRowSize()) {
                    int j = 0;
                    while (j < this.getColSize()) {
                        this.current = cell = this.getCell(i, j);
                        if (cell != null && !this.isMerged(i, j)) {
                            cell.calcInput();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (this.drillable) {
                this.state = FOLD;
                int i = 0;
                while (i < this.getRowSize()) {
                    int j = 0;
                    while (j < this.getColSize()) {
                        cell = this.getCell(i, j);
                        if (cell != null && !this.isMerged(i, j)) {
                            cell.calcFold();
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.state = FINISHED;
        }
        catch (ReportError re) {
            if (this.current != null) {
                re.setCellId(this.current.getSourceId());
            }
            throw re;
        }
        catch (Throwable e) {
            if (this.current == null) {
                throw new ReportError(e.getMessage(), e);
            }
            throw new ReportError("\u5355\u5143\u683c" + this.current.getSourceId() + "\u4e2d\u6709\u9519\u8bef\uff0c" + e.getMessage(), e);
        }
    }

    int getState() {
        return this.state;
    }

    private void rightAlign() {
        int key = 4101;
        int colSize = this.getColSize();
        int size = 1;
        int rowSize = this.getRowSize();
        int i = 1;
        while (i < rowSize) {
            int j = colSize - 1;
            while (j >= 1) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null && !CellPropertyDefine.CDT_BLANK.equals(cell.getPropValue(key))) break;
                --j;
            }
            if (j + 1 > size) {
                size = j + 1;
            }
            ++i;
        }
        key = 4108;
        this.matrix.setColSize(size);
        rowSize = this.getRowSize();
        i = 1;
        while (i < rowSize) {
            if (!this.rowTypeIsNormal(i)) {
                ExtCell cell;
                boolean aligned = false;
                int j = 1;
                while (j < size) {
                    cell = this.getCell(i, j);
                    if (cell != null && Boolean.TRUE.equals(cell.getPropValue(key))) {
                        this.rightAlign(cell);
                        aligned = true;
                        break;
                    }
                    ++j;
                }
                if (!aligned) {
                    j = size;
                    while (j >= 1) {
                        cell = this.getCell(i, j);
                        if (cell != null) {
                            this.rightAlign(cell);
                        }
                        --j;
                    }
                }
            }
            ++i;
        }
    }

    private void removeCell(ExtCell cell) {
        int i = cell.getRow();
        while (i <= cell.getEndRow()) {
            int j = cell.getCol();
            while (j <= cell.getEndCol()) {
                this.matrix.set(i, j, null);
                ++j;
            }
            ++i;
        }
    }

    private void addCell(ExtCell cell) {
        int i = cell.getRow();
        while (i <= cell.getEndRow()) {
            int j = cell.getCol();
            while (j <= cell.getEndCol()) {
                this.matrix.set(i, j, cell);
                ++j;
            }
            ++i;
        }
    }

    private void rightAlign(ExtCell cell) {
        int key = 4108;
        int row = cell.getRow();
        int col = cell.getCol();
        int colSize = this.getColSize();
        int endCol = cell.getEndCol();
        if (Boolean.TRUE.equals(cell.getPropValue(key))) {
            int i = colSize;
            while (i >= col) {
                if (this.getCell(row, i) != null) {
                    endCol = this.getCell(row, i).getEndCol();
                    break;
                }
                --i;
            }
            int move = colSize - endCol - 1;
            if (move > 0) {
                int i2 = endCol;
                while (i2 >= col) {
                    ExtCell cell1 = this.getCell(row, i2);
                    if (cell1 != null) {
                        this.removeCell(cell1);
                        cell1.move(0, move);
                        this.addCell(cell1);
                    }
                    --i2;
                }
            }
            if (col > 1 && this.getCell(row, col - 1) != null) {
                this.rightAlign(this.getCell(row, col - 1));
            }
        } else {
            int expand = 0;
            int i = endCol + 1;
            while (i < colSize) {
                if (this.getCell(row, i) != null) break;
                ++expand;
                ++i;
            }
            if (expand > 0) {
                this.removeCell(cell);
                cell.expand(0, expand);
                this.addCell(cell);
            }
        }
    }

    public void read(CellSet cs) {
        CellSetTransfer.transfer(cs, this);
    }

    public CellSet write() {
        this.clearDSRef();
        this.clearCellRef();
        CellSet cs = new CellSet(this.getRowSize(), this.getColSize());
        CellSetTransfer.transfer(this, cs);
        return cs;
    }

    void replaceMacros() {
        NStringMap macros = this.env.getMacrosMap();
        if (macros != null && macros.size() > 0) {
            int rowSize = this.getRowSize();
            int colSize = this.getColSize();
            int i = 0;
            while (i < rowSize) {
                int j = 0;
                while (j < colSize) {
                    ExtCell cell = this.getCell(i, j);
                    if (cell != null && !this.isMerged(i, j)) {
                        cell.replaceMacros(macros);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    protected static String getId(int row, int col) {
        if (row < 51 && col >= 0 && col < 27) {
            return cellIds[row][col];
        }
        return CellPosition.toExcelNotation(row, col);
    }

    public void clearDSRef() {
        int rowSize = this.getRowSize();
        int colSize = this.getColSize();
        int i = 1;
        while (i < rowSize) {
            int j = 1;
            while (j < colSize) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null) {
                    cell.clearDSRef();
                }
                ++j;
            }
            ++i;
        }
    }

    public void clearCellRef() {
        this.sourceMap = null;
        this.cellList = null;
        this.current = null;
        this.savedCurrent = null;
        int rowSize = this.getRowSize();
        int colSize = this.getColSize();
        int i = 1;
        while (i < rowSize) {
            int j = 1;
            while (j < colSize) {
                ExtCell cell = this.getCell(i, j);
                if (cell != null) {
                    cell.clearCellRef();
                }
                ++j;
            }
            ++i;
        }
    }

    void removeRow(int row) {
        if (row <= 0) {
            return;
        }
        int j = 1;
        while (j < this.getColSize()) {
            int merge;
            ExtCell cell = this.getCell(row, j);
            if (cell != null && (merge = cell.getRowMerge()) > 1) {
                cell.setMerge(merge - 1, cell.getColMerge());
            }
            ++j;
        }
        int i = row + 1;
        while (i < this.getRowSize()) {
            int j2 = 0;
            while (j2 < this.getColSize()) {
                ExtCell cell;
                if (!this.isMerged(i, j2) && (cell = this.getCell(i, j2)) != null) {
                    cell.move(-1, 0);
                }
                ++j2;
            }
            ++i;
        }
        this.matrix.deleteRow(row);
    }

    void removeCol(int col) {
        if (col <= 0) {
            return;
        }
        int i = 1;
        while (i < this.getRowSize()) {
            int merge;
            ExtCell cell = this.getCell(i, col);
            if (cell != null && (merge = cell.getColMerge()) > 1) {
                cell.setMerge(cell.getRowMerge(), merge - 1);
            }
            ++i;
        }
        int j = col + 1;
        while (j < this.getColSize()) {
            int i2 = 0;
            while (i2 < this.getRowSize()) {
                ExtCell cell;
                if (!this.isMerged(i2, j) && (cell = this.getCell(i2, j)) != null) {
                    cell.move(0, -1);
                }
                ++i2;
            }
            ++j;
        }
        this.matrix.deleteCol(col);
    }
}

