/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.Constant;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.FunctionLib;
import com.runqian.report.engine.Node;
import com.runqian.report.usermodel.Env;
import java.util.ArrayList;

public abstract class Function
extends Node {
    protected ExtCellSet cs;
    protected Env env;
    protected DataSet ds;
    protected ArrayList paramList = new ArrayList(3);

    protected void setParameter(String paramStr) {
        ArgumentTokenizer arg = new ArgumentTokenizer(paramStr == null ? null : paramStr.trim(), ',');
        while (arg.hasMoreElements()) {
            String token = arg.nextToken().trim();
            Expression exp = null;
            if (token.length() > 0) {
                exp = new Expression(this.cs, this.ds, token);
            }
            this.paramList.add(exp);
        }
    }

    public abstract Object calculate();

    protected boolean isExtended() {
        return false;
    }

    public String getExp() {
        Class<?> c = this.getClass();
        String funName = (String)FunctionLib.tFunMap.get(c);
        if (funName == null) {
            funName = (String)FunctionLib.tDSFunMap.get(c);
        }
        throw new ReportError(String.valueOf(funName) + "\u51fd\u6570\u672a\u5b9e\u73b0\u5230javascript\u51fd\u6570\u7684\u8f6c\u6362");
    }

    protected Node optimize() {
        boolean opt = true;
        if (this.left != null) {
            this.left = this.left.optimize();
            if (!(this.left instanceof Constant)) {
                opt = false;
            }
        }
        if (this.right != null) {
            this.right = this.right.optimize();
            if (!(this.right instanceof Constant)) {
                opt = false;
            }
        }
        if (this.paramList != null) {
            int i = 0;
            while (i < this.paramList.size()) {
                Expression exp = (Expression)this.paramList.get(i);
                if (exp != null) {
                    exp.optimize();
                    if (!exp.isConstantExpression()) {
                        opt = false;
                    }
                }
                ++i;
            }
        }
        if (opt && this.canOptimized()) {
            return new Constant(this.calculate());
        }
        return this;
    }
}

