/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ReportError;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.Function;
import java.util.HashMap;

public class FunctionLib {
    private static HashMap funMap = new HashMap(20);
    private static HashMap dsFunMap = new HashMap(20);
    static HashMap tFunMap = new HashMap(20);
    static HashMap tDSFunMap = new HashMap(20);

    static {
        FunctionLib.loadSystemFunctions();
    }

    public static void addFunction(String funName, String className) {
        try {
            funName = funName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (funMap.containsKey(funName)) {
                throw new RuntimeException("\u7cfb\u7edf\u4e2d\u6709\u4e24\u4e2a\u53eb" + funName + "\u7684\u51fd\u6570\uff01");
            }
            funMap.put(funName, funClass);
            tFunMap.put(funClass, funName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void addFunction(String funName, Class funClass) {
        if (funMap.containsKey(funName = funName.toLowerCase())) {
            throw new RuntimeException("\u7cfb\u7edf\u4e2d\u6709\u4e24\u4e2a\u53eb" + funName + "\u7684\u51fd\u6570\uff01");
        }
        funMap.put(funName, funClass);
        tFunMap.put(funClass, funName);
    }

    public static void addDSFunction(String funName, String className) {
        try {
            funName = funName.toLowerCase();
            Class<?> funClass = Class.forName(className);
            if (dsFunMap.containsKey(funName)) {
                throw new RuntimeException("\u7cfb\u7edf\u4e2d\u6709\u4e24\u4e2a\u53eb" + funName + "\u7684\u6570\u636e\u96c6\u51fd\u6570\uff01");
            }
            dsFunMap.put(funName, funClass);
            tDSFunMap.put(funClass, funName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isFunName(String id) {
        return funMap.containsKey(id.toLowerCase());
    }

    public static boolean isDSFunName(String id) {
        return dsFunMap.containsKey(id.toLowerCase());
    }

    public static Function newFunction(String funName, ExtCellSet cs, DataSet ds) {
        try {
            Class funClass = (Class)funMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            fun.cs = cs;
            if (cs != null) {
                fun.env = cs.getEnv();
            }
            fun.ds = ds;
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Function newDSFunction(String funName, ExtCellSet cs, DataSet ds) {
        try {
            if (ds == null) {
                throw new ReportError("\u6570\u636e\u96c6\u672a\u4ea7\u751f\uff0c\u53ef\u80fd\u56e0\u4e3a\u672a\u8fde\u63a5\u6570\u636e\u5e93");
            }
            Class funClass = (Class)dsFunMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            fun.ds = ds;
            fun.cs = cs;
            if (cs != null) {
                fun.env = cs.getEnv();
            }
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Function newDSFunction(String funName, ExtCellSet cs) {
        try {
            Class funClass = (Class)dsFunMap.get(funName.toLowerCase());
            Function fun = (Function)funClass.newInstance();
            fun.cs = cs;
            if (cs != null) {
                fun.env = cs.getEnv();
            }
            return fun;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void loadSystemFunction() {
        FunctionLib.loadSystemFunctions();
    }

    public static void loadSystemFunctions() {
        FunctionLib.addDSFunction("select", "com.runqian.report.engine.function.DSSelect");
        FunctionLib.addDSFunction("select1", "com.runqian.report.engine.function.DSSelectOne");
        FunctionLib.addDSFunction("select_one", "com.runqian.report.engine.function.DSSelectOne");
        FunctionLib.addDSFunction("get", "com.runqian.report.engine.function.DSSelectOne");
        FunctionLib.addDSFunction("group", "com.runqian.report.engine.function.DSGroup");
        FunctionLib.addDSFunction("rgroup", "com.runqian.report.engine.function.DSRootGroup");
        FunctionLib.addDSFunction("sum", "com.runqian.report.engine.function.DSSum");
        FunctionLib.addDSFunction("count", "com.runqian.report.engine.function.DSCount");
        FunctionLib.addDSFunction("avg", "com.runqian.report.engine.function.DSAverage");
        FunctionLib.addDSFunction("average", "com.runqian.report.engine.function.DSAverage");
        FunctionLib.addDSFunction("max", "com.runqian.report.engine.function.DSMax");
        FunctionLib.addDSFunction("min", "com.runqian.report.engine.function.DSMin");
        FunctionLib.addDSFunction("last", "com.runqian.report.engine.function.DSLast");
        FunctionLib.addDSFunction("first", "com.runqian.report.engine.function.DSFirst");
        FunctionLib.addDSFunction("colcount", "com.runqian.report.engine.function.DSColCount");
        FunctionLib.addDSFunction("field", "com.runqian.report.engine.function.DSField");
        FunctionLib.addDSFunction("fieldname", "com.runqian.report.engine.function.DSFieldName");
        FunctionLib.addDSFunction("plot", "com.runqian.report.engine.function.DSPlot");
        FunctionLib.addDSFunction("rselect", "com.runqian.report.engine.function.DSRootSelect");
        FunctionLib.addFunction("sum", "com.runqian.report.engine.function.Sum");
        FunctionLib.addFunction("count", "com.runqian.report.engine.function.Count");
        FunctionLib.addFunction("avg", "com.runqian.report.engine.function.Average");
        FunctionLib.addFunction("average", "com.runqian.report.engine.function.Average");
        FunctionLib.addFunction("max", "com.runqian.report.engine.function.Max");
        FunctionLib.addFunction("min", "com.runqian.report.engine.function.Min");
        FunctionLib.addFunction("list", "com.runqian.report.engine.function.ValueList");
        FunctionLib.addFunction("map", "com.runqian.report.engine.function.ValueMap");
        FunctionLib.addFunction("string", "com.runqian.report.engine.function.ToString");
        FunctionLib.addFunction("str", "com.runqian.report.engine.function.ToString");
        FunctionLib.addFunction("if", "com.runqian.report.engine.function.IfFun");
        FunctionLib.addFunction("nvl", "com.runqian.report.engine.function.Nvl");
        FunctionLib.addFunction("case", "com.runqian.report.engine.function.Case");
        FunctionLib.addFunction("select", "com.runqian.report.engine.function.Select");
        FunctionLib.addFunction("move", "com.runqian.report.engine.function.Move");
        FunctionLib.addFunction("ds", "com.runqian.report.engine.function.GetDataSet");
        FunctionLib.addFunction("dsmember", "com.runqian.report.engine.function.DSMember");
        FunctionLib.addFunction("offset", "com.runqian.report.engine.function.Offset");
        FunctionLib.addFunction("address", "com.runqian.report.engine.function.Address");
        FunctionLib.addFunction("query", "com.runqian.report.engine.function.Query");
        FunctionLib.addFunction("query2", "com.runqian.report.engine.function.Query2");
        FunctionLib.addFunction("sql", "com.runqian.report.engine.function.Query");
        FunctionLib.addFunction("call", "com.runqian.report.engine.function.Call");
        FunctionLib.addFunction("graph", "com.runqian.report.engine.function.CalcGraph");
        FunctionLib.addFunction("subrpt", "com.runqian.report.engine.function.CalcSubRpt");
        FunctionLib.addFunction("row", "com.runqian.report.engine.function.CellRowNo");
        FunctionLib.addFunction("col", "com.runqian.report.engine.function.CellColNo");
        FunctionLib.addFunction("esc", "com.runqian.report.engine.function.Esc");
        FunctionLib.addFunction("disp", "com.runqian.report.engine.function.DispValue");
        FunctionLib.addFunction("eval", "com.runqian.report.engine.function.Evaluator");
        FunctionLib.addFunction("plot", "com.runqian.report.engine.function.Plot");
        FunctionLib.addFunction("sort", "com.runqian.report.engine.function.Sort");
        FunctionLib.addFunction("maxwidth", "com.runqian.report.engine.function.MaxWidth");
        FunctionLib.addFunction("date_time", "com.runqian.report.engine.function.datetime.DateTime");
        FunctionLib.addFunction("datetime", "com.runqian.report.engine.function.datetime.DateTime");
        FunctionLib.addFunction("datetime2", "com.runqian.report.engine.function.datetime.DateTime2");
        FunctionLib.addFunction("day", "com.runqian.report.engine.function.datetime.Day");
        FunctionLib.addFunction("day_name", "com.runqian.report.engine.function.datetime.DayName");
        FunctionLib.addFunction("dayname", "com.runqian.report.engine.function.datetime.DayName");
        FunctionLib.addFunction("day_number", "com.runqian.report.engine.function.datetime.DayNumber");
        FunctionLib.addFunction("daynum", "com.runqian.report.engine.function.datetime.DayNumber");
        FunctionLib.addFunction("days_after", "com.runqian.report.engine.function.datetime.DaysAfter");
        FunctionLib.addFunction("daysafter", "com.runqian.report.engine.function.datetime.DaysAfter");
        FunctionLib.addFunction("hour", "com.runqian.report.engine.function.datetime.Hour");
        FunctionLib.addFunction("minute", "com.runqian.report.engine.function.datetime.Minute");
        FunctionLib.addFunction("month", "com.runqian.report.engine.function.datetime.Month");
        FunctionLib.addFunction("monthend", "com.runqian.report.engine.function.datetime.MonthEnd");
        FunctionLib.addFunction("monthbegin", "com.runqian.report.engine.function.datetime.MonthBegin");
        FunctionLib.addFunction("quaterbegin", "com.runqian.report.engine.function.datetime.QuaterBegin");
        FunctionLib.addFunction("quaterend", "com.runqian.report.engine.function.datetime.QuaterEnd");
        FunctionLib.addFunction("lastmonth", "com.runqian.report.engine.function.datetime.LastMonth");
        FunctionLib.addFunction("lastyear", "com.runqian.report.engine.function.datetime.LastYear");
        FunctionLib.addFunction("relative_date", "com.runqian.report.engine.function.datetime.RelativeDate");
        FunctionLib.addFunction("reldate", "com.runqian.report.engine.function.datetime.RelativeDate");
        FunctionLib.addFunction("relative_time", "com.runqian.report.engine.function.datetime.RelativeTime");
        FunctionLib.addFunction("reltime", "com.runqian.report.engine.function.datetime.RelativeTime");
        FunctionLib.addFunction("second", "com.runqian.report.engine.function.datetime.Second");
        FunctionLib.addFunction("seconds_after", "com.runqian.report.engine.function.datetime.SecondsAfter");
        FunctionLib.addFunction("secondsafter", "com.runqian.report.engine.function.datetime.SecondsAfter");
        FunctionLib.addFunction("date", "com.runqian.report.engine.function.datetime.ToDate");
        FunctionLib.addFunction("time", "com.runqian.report.engine.function.datetime.ToTime");
        FunctionLib.addFunction("year", "com.runqian.report.engine.function.datetime.Year");
        FunctionLib.addFunction("now", "com.runqian.report.engine.function.datetime.Now");
        FunctionLib.addFunction("daysinmonth", "com.runqian.report.engine.function.datetime.DaysInMonth");
        FunctionLib.addFunction("daysinyear", "com.runqian.report.engine.function.datetime.DaysInYear");
        FunctionLib.addFunction("weekbegin", "com.runqian.report.engine.function.datetime.WeekBegin");
        FunctionLib.addFunction("weekend", "com.runqian.report.engine.function.datetime.WeekEnd");
        FunctionLib.addFunction("lastday", "com.runqian.report.engine.function.datetime.LastDay");
        FunctionLib.addFunction("abs", "com.runqian.report.engine.function.math.Abs");
        FunctionLib.addFunction("ceil", "com.runqian.report.engine.function.math.Ceiling");
        FunctionLib.addFunction("cos", "com.runqian.report.engine.function.math.Cos");
        FunctionLib.addFunction("exp", "com.runqian.report.engine.function.math.Exp");
        FunctionLib.addFunction("fact", "com.runqian.report.engine.function.math.Fact");
        FunctionLib.addFunction("int", "com.runqian.report.engine.function.math.Int");
        FunctionLib.addFunction("log", "com.runqian.report.engine.function.math.Log");
        FunctionLib.addFunction("log10", "com.runqian.report.engine.function.math.LogTen");
        FunctionLib.addFunction("pi", "com.runqian.report.engine.function.math.Pi");
        FunctionLib.addFunction("pow", "com.runqian.report.engine.function.math.Pow");
        FunctionLib.addFunction("rand", "com.runqian.report.engine.function.math.Rand");
        FunctionLib.addFunction("round", "com.runqian.report.engine.function.math.Round");
        FunctionLib.addFunction("sign", "com.runqian.report.engine.function.math.Sign");
        FunctionLib.addFunction("sin", "com.runqian.report.engine.function.math.Sin");
        FunctionLib.addFunction("sqrt", "com.runqian.report.engine.function.math.Sqrt");
        FunctionLib.addFunction("tan", "com.runqian.report.engine.function.math.Tan");
        FunctionLib.addFunction("floor", "com.runqian.report.engine.function.math.Floor");
        FunctionLib.addFunction("fill", "com.runqian.report.engine.function.string.Fill");
        FunctionLib.addFunction("left", "com.runqian.report.engine.function.string.Left");
        FunctionLib.addFunction("left_trim", "com.runqian.report.engine.function.string.LeftTrim");
        FunctionLib.addFunction("ltrim", "com.runqian.report.engine.function.string.LeftTrim");
        FunctionLib.addFunction("len", "com.runqian.report.engine.function.string.Len");
        FunctionLib.addFunction("lower", "com.runqian.report.engine.function.string.Lower");
        FunctionLib.addFunction("mid", "com.runqian.report.engine.function.string.Mid");
        FunctionLib.addFunction("pos", "com.runqian.report.engine.function.string.Pos");
        FunctionLib.addFunction("right", "com.runqian.report.engine.function.string.Right");
        FunctionLib.addFunction("right_trim", "com.runqian.report.engine.function.string.RightTrim");
        FunctionLib.addFunction("rtrim", "com.runqian.report.engine.function.string.RightTrim");
        FunctionLib.addFunction("space", "com.runqian.report.engine.function.string.Space");
        FunctionLib.addFunction("trim", "com.runqian.report.engine.function.string.Trim");
        FunctionLib.addFunction("upper", "com.runqian.report.engine.function.string.Upper");
        FunctionLib.addFunction("word_cap", "com.runqian.report.engine.function.string.WordCap");
        FunctionLib.addFunction("like2", "com.runqian.report.engine.function.string.Like2");
        FunctionLib.addFunction("rmvquote", "com.runqian.report.engine.function.string.QuoteRemover");
        FunctionLib.addFunction("integer", "com.runqian.report.engine.function.convert.ToInteger");
        FunctionLib.addFunction("toint", "com.runqian.report.engine.function.convert.ToInteger");
        FunctionLib.addFunction("long", "com.runqian.report.engine.function.convert.ToLong");
        FunctionLib.addFunction("double", "com.runqian.report.engine.function.convert.ToDouble");
        FunctionLib.addFunction("number", "com.runqian.report.engine.function.convert.ToNumber");
        FunctionLib.addFunction("asc", "com.runqian.report.engine.function.convert.Asc");
        FunctionLib.addFunction("char", "com.runqian.report.engine.function.convert.Char");
        FunctionLib.addFunction("isdate", "com.runqian.report.engine.function.convert.IsDate");
        FunctionLib.addFunction("isnumber", "com.runqian.report.engine.function.convert.IsNumber");
        FunctionLib.addFunction("istime", "com.runqian.report.engine.function.convert.IsTime");
        FunctionLib.addFunction("rmb", "com.runqian.report.engine.function.convert.ToRMB");
        FunctionLib.addFunction("chn", "com.runqian.report.engine.function.convert.ToChinese");
        FunctionLib.addFunction("rgb", "com.runqian.report.engine.function.convert.RGB");
        FunctionLib.addFunction("bigint", "com.runqian.report.engine.function.convert.ToBigInteger");
        FunctionLib.addFunction("decimal", "com.runqian.report.engine.function.convert.ToBigDecimal");
    }
}

