/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ReportError;
import java.util.ArrayList;
import java.util.List;

public class Matrix
implements Cloneable {
    public static final int ROWSET = 0;
    public static final int COLSET = 1;
    protected int type;
    protected ArrayList listlist;
    protected int initRowCap;
    protected int initColCap;
    protected int rowSize;
    protected int colSize;

    public Matrix(int type, int initRowCap, int initColCap) {
        if (type != 0 && type != 1) {
            throw new RuntimeException();
        }
        if (initRowCap <= 0 || initColCap <= 0) {
            throw new RuntimeException();
        }
        this.type = type;
        this.initRowCap = initRowCap;
        this.initColCap = initColCap;
        this.listlist = this.type == 0 ? new ArrayList(this.initRowCap) : new ArrayList(this.initColCap);
        this.rowSize = 0;
        this.colSize = 0;
    }

    public Matrix(int initRowCap, int initColCap) {
        this(0, initRowCap, initColCap);
    }

    public Matrix() {
        this(20, 10);
    }

    public void setRowSize(int size) {
        if (size < 0) {
            throw new RuntimeException();
        }
        if (this.type == 0) {
            while (this.rowSize > size) {
                this.listlist.remove(--this.rowSize);
            }
            while (this.rowSize < size) {
                ArrayList<Object> list = new ArrayList<Object>(this.initColCap);
                int i = 0;
                while (i < this.colSize) {
                    list.add(null);
                    ++i;
                }
                this.listlist.add(this.rowSize++, list);
            }
        } else {
            int i = 0;
            while (i < this.colSize) {
                ArrayList list = (ArrayList)this.listlist.get(i);
                while (list.size() > size) {
                    list.remove(list.size() - 1);
                }
                while (list.size() < size) {
                    list.add(null);
                }
                ++i;
            }
            this.rowSize = size;
        }
    }

    public void transpose() {
        this.type = this.type == 0 ? 1 : 0;
        int temp = this.initRowCap;
        this.initRowCap = this.initColCap;
        this.initColCap = temp;
        temp = this.rowSize;
        this.rowSize = this.colSize;
        this.colSize = temp;
    }

    public void setColSize(int size) {
        this.transpose();
        this.setRowSize(size);
        this.transpose();
    }

    public void setSize(int rowSize, int colSize) {
        this.setRowSize(rowSize);
        this.setColSize(colSize);
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public int getColSize() {
        return this.colSize;
    }

    public void set(int row, int col, Object obj) {
        if (this.type == 0) {
            ArrayList list = (ArrayList)this.listlist.get(row);
            list.set(col, obj);
        } else {
            ArrayList list = (ArrayList)this.listlist.get(col);
            list.set(row, obj);
        }
    }

    public Object get(int row, int col) {
        if (this.type == 0) {
            ArrayList list = (ArrayList)this.listlist.get(row);
            return list.get(col);
        }
        ArrayList list = (ArrayList)this.listlist.get(col);
        return list.get(row);
    }

    public void addRow(int index) {
        if (this.type == 0) {
            ArrayList<Object> list = new ArrayList<Object>(this.initColCap);
            int i = 0;
            while (i < this.colSize) {
                list.add(null);
                ++i;
            }
            this.listlist.add(index, list);
        } else {
            int i = 0;
            while (i < this.colSize) {
                ArrayList list = (ArrayList)this.listlist.get(i);
                list.add(index, null);
                ++i;
            }
        }
        ++this.rowSize;
    }

    public void addCol(int index) {
        this.transpose();
        this.addRow(index);
        this.transpose();
    }

    public void addRow() {
        this.addRow(this.rowSize);
    }

    public void addCol() {
        this.addCol(this.colSize);
    }

    private List newRow() {
        ArrayList<Object> list = new ArrayList<Object>(this.initColCap > this.colSize ? this.initColCap : this.colSize);
        int i = 0;
        while (i < this.colSize) {
            list.add(null);
            ++i;
        }
        return list;
    }

    private List newElementList(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            list.add(null);
            ++i;
        }
        return list;
    }

    private List newRowList(int size) {
        ArrayList<List> list = new ArrayList<List>(size);
        int i = 0;
        while (i < size) {
            list.add(this.newRow());
            ++i;
        }
        return list;
    }

    public void addRows(int index, int count) {
        if (index < 0 || index > this.rowSize || count < 0) {
            throw new RuntimeException();
        }
        if (count == 0) {
            return;
        }
        this.listlist.addAll(index, this.newRowList(count));
        this.rowSize += count;
    }

    public void addCols(int index, int count) {
        if (index < 0 || index > this.rowSize || count < 0) {
            throw new RuntimeException();
        }
        if (count == 0) {
            return;
        }
        List temp = this.newElementList(count);
        int i = 0;
        while (i < this.rowSize) {
            List list = (List)this.listlist.get(i);
            list.addAll(index, temp);
            ++i;
        }
        this.colSize += count;
    }

    public void addCols(int index, int count, int beginRow, int endRow) {
        this.addCols(index, count, beginRow, endRow, true);
    }

    public void addCols(int index, int count, int beginRow, int endRow, boolean alignColHead) {
        if (index < 0 || index > this.colSize || count < 0) {
            throw new RuntimeException();
        }
        if (count == 0) {
            return;
        }
        List temp = this.newElementList(count);
        int i = 0;
        while (i < this.rowSize) {
            List list = (List)this.listlist.get(i);
            if (i >= beginRow && i <= endRow) {
                list.addAll(index, temp);
            } else if (i == 0) {
                if (alignColHead) {
                    list.addAll(index, temp);
                } else {
                    list.addAll(temp);
                }
            } else {
                list.addAll(temp);
            }
            ++i;
        }
        this.colSize += count;
    }

    public void deleteRow(int index) {
        if (this.type == 0) {
            this.listlist.remove(index);
        } else {
            int i = 0;
            while (i < this.colSize) {
                ArrayList list = (ArrayList)this.listlist.get(i);
                list.remove(index);
                ++i;
            }
        }
        --this.rowSize;
    }

    public void deleteCol(int index) {
        this.transpose();
        this.deleteRow(index);
        this.transpose();
    }

    public void clear() {
        this.setSize(0, 0);
    }

    public Object clone() {
        try {
            Matrix newMatrix = (Matrix)super.clone();
            newMatrix.listlist = (ArrayList)this.listlist.clone();
            int i = 0;
            while (i < this.listlist.size()) {
                ArrayList list = (ArrayList)this.listlist.get(i);
                newMatrix.listlist.set(i, list.clone());
                ++i;
            }
            return newMatrix;
        }
        catch (CloneNotSupportedException e) {
            throw new ReportError(e.getMessage(), e);
        }
    }
}

