/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.report.engine.Constant;

public abstract class Node {
    public static final int PRI_ASS = 0;
    public static final int PRI_CON = 1;
    public static final int PRI_TO = 1;
    public static final int PRI_LINK = 1;
    public static final int PRI_OR = 2;
    public static final int PRI_AND = 3;
    public static final int PRI_BOR = 4;
    public static final int PRI_BXOR = 5;
    public static final int PRI_BAND = 6;
    public static final int PRI_IN = 7;
    public static final int PRI_EQ = 7;
    public static final int PRI_NEQ = 7;
    public static final int PRI_GT = 8;
    public static final int PRI_SL = 8;
    public static final int PRI_NGT = 8;
    public static final int PRI_NSL = 8;
    public static final int PRI_LIKE = 8;
    public static final int PRI_SHIFT = 9;
    public static final int PRI_ADD = 10;
    public static final int PRI_SUB = 10;
    public static final int PRI_MUL = 11;
    public static final int PRI_DIV = 11;
    public static final int PRI_MOD = 11;
    public static final int PRI_NEW = 12;
    public static final int PRI_NOT = 13;
    public static final int PRI_ADR = 13;
    public static final int PRI_PRF = 14;
    public static final int PRI_SUF = 14;
    public static final int PRI_NUM = 15;
    public static final int PRI_BRK = 16;
    protected int priority = 15;
    protected Node left;
    protected Node right;

    protected Node() {
    }

    public void setInBrackets(int inBrackets) {
        this.priority += inBrackets * 16;
    }

    public void setLeft(Node node) {
        this.left = node;
    }

    public void setRight(Node node) {
        this.right = node;
    }

    public Node getLeft() {
        return this.left;
    }

    public Node getRight() {
        return this.right;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isOperator() {
        return false;
    }

    protected boolean isExtended() {
        if (this.left != null && this.left.isExtended()) {
            return true;
        }
        return this.right != null && this.right.isExtended();
    }

    public abstract Object calculate();

    public abstract String getExp();

    protected boolean canOptimized() {
        return true;
    }

    protected Node optimize() {
        boolean opt = true;
        if (this.left != null) {
            this.left = this.left.optimize();
            if (!(this.left instanceof Constant)) {
                opt = false;
            }
        }
        if (this.right != null) {
            this.right = this.right.optimize();
            if (!(this.right instanceof Constant)) {
                opt = false;
            }
        }
        if (opt && this.canOptimized()) {
            return new Constant(this.calculate());
        }
        return this;
    }
}

