/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.ExtCellSet;

class SubRpt {
    private ExtCellSet cs;
    private ExtCellSet subRpt;
    private ExtCell cell;

    SubRpt(ExtCellSet cs, ExtCell cell, ExtCellSet subRpt) {
        this.cs = cs;
        this.cell = cell;
        this.subRpt = subRpt;
        this.clean();
    }

    private boolean canExportRow(int row) {
        ExtCell cell = this.subRpt.getCell(row, 0);
        if (cell == null) {
            return true;
        }
        Object visible = cell.getPropValue(4106);
        if (visible != null && visible.equals(Boolean.FALSE)) {
            return false;
        }
        Object type = cell.getPropValue(3103);
        return type == null || !type.equals(CellPropertyDefine.CRT_PAGE_HEADER) && !type.equals(CellPropertyDefine.CRT_PAGE_FOOTER);
    }

    private boolean canExportCol(int col) {
        ExtCell cell = this.subRpt.getCell(0, col);
        if (cell == null) {
            return true;
        }
        Object visible = cell.getPropValue(4106);
        return visible == null || visible.equals(Boolean.TRUE);
    }

    private void clean() {
        int i = this.subRpt.getRowSize() - 1;
        while (i > 0) {
            if (!this.canExportRow(i)) {
                this.subRpt.removeRow(i);
            }
            --i;
        }
        int j = this.subRpt.getColSize() - 1;
        while (j > 0) {
            if (!this.canExportCol(j)) {
                this.subRpt.removeCol(j);
            }
            --j;
        }
    }

    private boolean isCsRowVisible(int row) {
        ExtCell cell = this.cs.getCell(row, 0);
        if (cell == null) {
            return true;
        }
        Object visible = cell.getPropValue(4106);
        return visible == null || visible.equals(Boolean.TRUE);
    }

    private boolean isCsColVisible(int col) {
        ExtCell cell = this.cs.getCell(0, col);
        if (cell == null) {
            return true;
        }
        Object visible = cell.getPropValue(4106);
        return visible == null || visible.equals(Boolean.TRUE);
    }

    private int getBlankRowNum() {
        int nextRow = this.cell.getRow() + 1;
        int num = 0;
        int endCol = Math.min(this.cs.getColSize(), this.cell.getCol() + this.subRpt.getColSize());
        int i = nextRow;
        while (i < this.cs.getRowSize()) {
            int j = this.cell.getCol();
            while (j < endCol) {
                ExtCell cellx = this.cs.getCell(i, j);
                if (cellx != null && !CellPropertyDefine.CDT_BLANK.equals(cellx.getPropValue(4101))) {
                    return num;
                }
                ++j;
            }
            ++num;
            ++i;
        }
        return num;
    }

    private int getBlankColNum() {
        int nextCol = this.cell.getCol() + 1;
        int num = 0;
        int begin = Math.max(this.cs.getDataBegin(), this.cell.getRow());
        int end = Math.min(this.cs.getDataEnd(), this.cell.getRow() + this.subRpt.getRowSize());
        int j = nextCol;
        while (j < this.cs.getColSize()) {
            int i = begin;
            while (i < end) {
                ExtCell cellx = this.cs.getCell(i, j);
                if (cellx != null && !CellPropertyDefine.CDT_BLANK.equals(cellx.getPropValue(4101))) {
                    return num;
                }
                ++i;
            }
            ++num;
            ++j;
        }
        return num;
    }

    void extendSubRpt() {
        int cellRow = this.cell.getRow();
        int cellCol = this.cell.getCol();
        int rptRowNum = this.subRpt.getRowSize() - 1;
        int rptColNum = this.subRpt.getColSize() - 1;
        int blankRowNum = this.getBlankRowNum();
        int insertRowPos = cellRow + blankRowNum + 1;
        int insertRowNum = rptRowNum - blankRowNum - 1;
        if (insertRowNum < 0) {
            insertRowNum = 0;
        }
        this.cs.insertRow(insertRowPos, insertRowNum);
        int i = insertRowPos;
        while (i < insertRowPos + insertRowNum) {
            if (this.cs.getCell(i, 0) == null) {
                this.cs.setCell(i, 0, this.subRpt.getCell(rptRowNum - insertRowPos - insertRowNum + i + 1, 0));
            }
            ++i;
        }
        int blankColNum = this.getBlankColNum();
        int insertColPos = cellCol + blankColNum + 1;
        int insertColNum = rptColNum - blankColNum - 1;
        if (insertColNum < 0) {
            insertColNum = 0;
        }
        int oldCsColSize = this.cs.getColSize();
        this.cs.insertCol(insertColPos, insertColNum, cellRow, cellRow + rptRowNum - 1, false);
        int j = oldCsColSize;
        while (j < insertColPos + insertColNum) {
            if (this.cs.getCell(0, j) == null) {
                this.cs.setCell(0, j, this.subRpt.getCell(0, j - cellCol + 1));
            }
            ++j;
        }
        int i2 = 1;
        while (i2 <= rptRowNum) {
            int j2 = 1;
            while (j2 <= rptColNum) {
                ExtCell cellx = this.subRpt.getCell(i2, j2);
                if (cellx != null && !this.subRpt.isMerged(i2, j2)) {
                    ExtCell celly;
                    int k;
                    this.cs.setCell(cellRow + i2 - 1, cellCol + j2 - 1, cellx);
                    if (cellx.getEndCol() == cellCol + rptColNum - 1) {
                        k = cellx.getRow();
                        while (k <= Math.min(cellx.getEndRow(), insertRowPos - 1)) {
                            celly = this.cs.getCell(k, cellx.getEndCol() + 1);
                            if (celly != null) {
                                celly.setPropValue(4401, cellx.getPropValue(4404));
                                celly.setPropValue(4402, cellx.getPropValue(4405));
                                celly.setPropValue(4403, cellx.getPropValue(4406));
                            }
                            ++k;
                        }
                    }
                    if (cellx.getEndRow() == cellRow + rptRowNum - 1) {
                        k = cellx.getCol();
                        while (k <= cellx.getEndCol()) {
                            celly = this.cs.getCell(cellx.getEndRow() + 1, k);
                            if (celly != null) {
                                celly.setPropValue(4407, cellx.getPropValue(4410));
                                celly.setPropValue(4408, cellx.getPropValue(4411));
                                celly.setPropValue(4409, cellx.getPropValue(4412));
                            }
                            ++k;
                        }
                    }
                }
                ++j2;
            }
            ++i2;
        }
    }
}

