/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.usermodel.ReportDefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class SubRptList {
    private ArrayList rptList;
    private ArrayList rptName;
    private ArrayList rptType;
    public static final String URL = "url";
    public static final String ABSOLUTE_ADD = "\u7edd\u5bf9\u8def\u5f84";
    public static final String RELATIVE_ADD = "\u76f8\u5bf9\u8def\u5f84";

    public SubRptList() {
        this.rptList = new ArrayList();
        this.rptName = new ArrayList();
        this.rptType = new ArrayList();
    }

    public SubRptList(ArrayList rptName, ArrayList rptType, ArrayList rptList) {
        this.rptName = rptName;
        this.rptType = rptType;
        this.rptList = rptList;
    }

    public SubRptList(String cfgStr) {
        ArgumentTokenizer at = new ArgumentTokenizer(cfgStr, ';');
        int c = at.countTokens();
        this.rptList = new ArrayList(c);
        this.rptName = new ArrayList(c);
        this.rptType = new ArrayList(c);
        while (at.hasNext()) {
            String cfg = at.next();
            if (cfg == null || cfg.trim().length() == 0) continue;
            SegmentSet ss = new SegmentSet(cfg, ',');
            this.addRpt(ss.get("name"), ss.get("type"), SubRptList.getRealString(ss.get("address")));
        }
    }

    public void addRpt(String name, String type, String add) {
        if (name == null || name.trim().length() == 0) {
            return;
        }
        if (type == null || type.trim().length() == 0) {
            return;
        }
        if (add == null || add.trim().length() == 0) {
            return;
        }
        this.rptName.add(name);
        this.rptType.add(type);
        this.rptList.add(add);
    }

    public ReportDefine getReportDefine(String name) throws Exception {
        int i = 0;
        while (i < this.rptName.size()) {
            String s = (String)this.rptName.get(i);
            if (s.equals(name)) break;
            ++i;
        }
        if (i >= this.rptName.size()) {
            return null;
        }
        return this.getReportDefine(i);
    }

    public ReportDefine getReportDefine(int index) throws Exception {
        String rptAddress = (String)this.rptList.get(index);
        String type = (String)this.rptType.get(index);
        InputStream in = null;
        if (type.equals(URL)) {
            URL url = new URL(rptAddress);
            in = url.openStream();
        } else if (type.equals(RELATIVE_ADD)) {
            String home = System.getProperty("home");
            File f = new File(home, rptAddress);
            in = new FileInputStream(f);
        } else {
            in = new FileInputStream(rptAddress);
        }
        return new ReportDefine(in);
    }

    public String getType(int index) {
        return (String)this.rptType.get(index);
    }

    public String getAddress(int index) {
        return (String)this.rptList.get(index);
    }

    public String getType(String name) {
        int i = 0;
        while (i < this.rptName.size()) {
            String s = (String)this.rptName.get(i);
            if (s.equals(name)) break;
            ++i;
        }
        if (i >= this.rptName.size()) {
            return null;
        }
        return this.getType(i);
    }

    public String getAddress(String name) {
        int i = 0;
        while (i < this.rptName.size()) {
            String s = (String)this.rptName.get(i);
            if (s.equals(name)) break;
            ++i;
        }
        if (i >= this.rptName.size()) {
            return null;
        }
        return this.getAddress(i);
    }

    public String[] getRptNames() {
        return this.rptName.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.rptName.size() * 50);
        int i = 0;
        while (i < this.rptName.size()) {
            sb.append("name=").append((String)this.rptName.get(i)).append(",");
            sb.append("type=").append((String)this.rptType.get(i)).append(",");
            sb.append("address=").append(Escape.addEscAndQuote((String)this.rptList.get(i))).append(";");
            ++i;
        }
        return sb.toString();
    }

    private static String getRealString(String str) {
        if (str != null) {
            str = str.trim();
        }
        if (str != null && str.length() >= 2 && str.charAt(0) == '\"') {
            str = Escape.removeEscAndQuote(str);
            str = str.trim();
        }
        return str;
    }
}

