/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine;

import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.graph.GraphFont;
import com.runqian.base.graph.GraphParam;
import com.runqian.base.graph.StatisticGraph;
import com.runqian.report.graph.GraphProperty;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

public class TransGraphProperty {
    public static byte[] drawImage(GraphProperty gp, GraphDataSource dataSource, int width, int height, StringBuffer sb) throws Exception {
        String alarmLine;
        String coorColor;
        GraphParam graphParam = new GraphParam();
        graphParam.setGraphType(Integer.parseInt(gp.getPropertyValue("type")));
        switch (Integer.parseInt(gp.getPropertyValue("type"))) {
            case 18: 
            case 23: {
                graphParam.setStateDataSource(dataSource);
                graphParam.setStateBarH(Integer.parseInt(gp.getPropertyValue("statusBarHeight")));
                graphParam.setTimeScale(Integer.parseInt(gp.getPropertyValue("statusTimeType")));
                break;
            }
            case 19: {
                graphParam.setTimeRange(gp.getPropertyValue("xValues"));
                graphParam.setTrendDataSource(dataSource);
                break;
            }
            default: {
                String topn = gp.getPropertyValue("useTopN");
                if (topn == null || topn.trim().length() == 0) {
                    topn = "0";
                }
                graphParam.setDataSource(dataSource, Integer.parseInt(topn));
            }
        }
        graphParam.setGraphExtent(width, height);
        graphParam.setScaleMark(gp.getPropertyValue("yUnit"));
        String text = "";
        text = gp.getPropertyValue("graphTitle");
        GraphFont gf = gp.getFont("0");
        graphParam.GFV_TITLE = graphParam.getGraphFontView(gf, text, 0);
        text = "";
        gf = gp.getFont("5");
        graphParam.GFV_LEGEND = graphParam.getGraphFontView(gf, text, 5);
        text = "";
        gf = gp.getFont("6");
        graphParam.GFV_VALUE = graphParam.getGraphFontView(gf, text, 6);
        text = gp.getPropertyValue("xTitle");
        gf = gp.getFont("1");
        graphParam.GFV_XTITLE = graphParam.getGraphFontView(gf, text, 1);
        text = gp.getPropertyValue("yTitle");
        gf = gp.getFont("2");
        graphParam.GFV_YTITLE = graphParam.getGraphFontView(gf, text, 2);
        text = "";
        gf = gp.getFont("3");
        graphParam.GFV_XLABEL = graphParam.getGraphFontView(gf, text, 3);
        text = "";
        gf = gp.getFont("4");
        graphParam.GFV_YLABEL = graphParam.getGraphFontView(gf, text, 4);
        text = gp.getPropertyValue("margin");
        if (text != null && text.trim().length() > 0) {
            graphParam.graphMargin = Integer.parseInt(text);
        }
        if ((coorColor = gp.getPropertyValue("axisColor")) != null && coorColor.trim().length() > 0) {
            graphParam.setCoorColor(new Color(Integer.parseInt(coorColor)));
        }
        if ((coorColor = gp.getPropertyValue("gridLineColor")) != null && coorColor.trim().length() > 0) {
            graphParam.setGridColor(new Color(Integer.parseInt(coorColor)));
        }
        graphParam.setDispValueOntop(!gp.getPropertyValue("displayValue").equals("1"));
        graphParam.setGraphTransparent(gp.getPropertyValue("graphTransparent").equals("1"));
        graphParam.setColorScheme(gp.getPropertyValue("colorConfig"));
        graphParam.setGraphBackColor(Integer.parseInt(gp.getPropertyValue("backColor")), gp.getPropertyValue("backTransparent"));
        graphParam.setDataMarkFormat(gp.getPropertyValue("displayValueFormat"));
        graphParam.setLegendPosition(gp.getPropertyValue("legendLocation"));
        String startValue = gp.getPropertyValue("yStartValue");
        String endValue = gp.getPropertyValue("yEndValue");
        String interval = gp.getPropertyValue("yInterval");
        graphParam.setValueRange(startValue, endValue, interval);
        String minMarks = gp.getPropertyValue("yMinMarks");
        try {
            if (minMarks != null && minMarks.trim().length() > 0) {
                graphParam.setMinTicknum(Integer.parseInt(minMarks));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((alarmLine = gp.getPropertyValue("alarmLines")) != null && alarmLine.trim().length() > 0) {
            graphParam.setWarnLine(alarmLine);
        }
        StatisticGraph sg = new StatisticGraph(graphParam);
        BufferedImage bi = sg.drawImage(gp.getPropertyValue("graphFormat"), sb, gp.getPropertyValue("link"), gp.getPropertyValue("linkTarget"));
        ByteArrayOutputStream bt = new ByteArrayOutputStream();
        StatisticGraph.drawGraph(bt, gp.getPropertyValue("graphFormat"), bi);
        return bt.toByteArray();
    }
}

