/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine.function;

import com.runqian.base.graph.GraphDataSource;
import com.runqian.base.util.Escape;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.engine.CSVariable;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.Function;
import com.runqian.report.engine.TransGraphProperty;
import com.runqian.report.engine.Variant2;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.XAxisValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CalcGraph
extends Function {
    protected String param;

    protected int getCellWidth() {
        ExtCell current = this.cs.getCurrent();
        int width = 0;
        int i = current.getCol();
        while (i < current.getCol() + current.getColMerge()) {
            Boolean b = null;
            ExtCell cell = this.cs.getCell(0, i);
            if (cell != null) {
                b = (Boolean)cell.getPropValue(4106);
            }
            if (b == null || b.booleanValue()) {
                width += this.cs.getColWidth(i);
            }
            ++i;
        }
        return width;
    }

    protected int getCellHeight() {
        ExtCell current = this.cs.getCurrent();
        int height = 0;
        int i = current.getRow();
        while (i < current.getRow() + current.getRowMerge()) {
            height += this.cs.getRowHeight(i);
            ++i;
        }
        return height;
    }

    protected void calcPropValues(GraphProperty gProp) {
        SegmentSet segSet = gProp.getProperties();
        Object[] keys = segSet.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String key = (String)keys[i];
            if (!(key.equals("categoryExp") || key.equals("seriesValuesExp") || key.equals("xValues") || key.equals("fonts") || key.equals("alarmLines") || key.equals("statusCategery") || key.equals("statusState") || key.equals("statusStartTime") || key.equals("statusEndTime"))) {
                String expStr = segSet.get(key);
                if ((expStr = Escape.removeEscAndQuote(expStr)).trim().length() > 0) {
                    Expression exp = new Expression(this.cs, expStr);
                    Object value = Variant2.getValue(exp.calculate());
                    segSet.put(key, Escape.addEscAndQuote(value.toString()));
                }
            }
            ++i;
        }
        this.setXAxisValues(gProp);
    }

    protected void setXAxisValues(GraphProperty gProp) {
        ArrayList xAxisList = gProp.getXAxisValues();
        int i = 0;
        while (i < xAxisList.size()) {
            String endValue;
            XAxisValue xAxisValue = (XAxisValue)xAxisList.get(i);
            String startValue = xAxisValue.getStartValue();
            if (startValue != null && startValue.trim().length() > 0) {
                Expression exp = new Expression(this.cs, startValue);
                Object result = Variant2.getValue(exp.calculate());
                xAxisValue.setStartValue(result.toString());
            }
            if ((endValue = xAxisValue.getEndValue()) != null && endValue.trim().length() > 0) {
                Expression exp = new Expression(this.cs, endValue);
                Object result = Variant2.getValue(exp.calculate());
                xAxisValue.setEndValue(result.toString());
            }
            ++i;
        }
        gProp.setXAxisValues(xAxisList);
    }

    private void cal1(GraphProperty gProp, GraphDataSource catMap) {
        String catExpStr = gProp.getPropertyValue("statusCategery");
        ExtCell source = this.cs.getSource(catExpStr);
        if (source == null) {
            throw new ReportError("\u65f6\u5e8f\u72b6\u6001\u56fe\u7684\u5206\u7c7b\u8868\u8fbe\u5f0f\u5e94\u8be5\u4e3a\u5355\u5143\u683c");
        }
        Expression starttimeExp = new Expression(this.cs, this.ds, gProp.getPropertyValue("statusStartTime"));
        Expression endtimeExp = new Expression(this.cs, this.ds, gProp.getPropertyValue("statusEndTime"));
        Expression statusExp = new Expression(this.cs, this.ds, gProp.getPropertyValue("statusState"));
        CSVariable var = new CSVariable(source);
        var = (CSVariable)var.calculate();
        List cellList = var.getCells(null);
        int i = 0;
        while (i < cellList.size()) {
            ExtCell cell = (ExtCell)cellList.get(i);
            String catValue = Variant2.toString(cell.getValue(true));
            Vector[] vec = (Vector[])catMap.get(catValue);
            if (vec == null) {
                vec = new Vector[]{new Vector(), new Vector(), new Vector()};
                catMap.add(catValue, vec);
            }
            this.cs.setCurrent(cell);
            String starttimeValue = Variant2.toString(Variant2.getValue(starttimeExp.calculate()));
            String endtimeValue = Variant2.toString(Variant2.getValue(endtimeExp.calculate()));
            Object statusValue = Variant2.getValue(statusExp.calculate());
            vec[0].add(statusValue);
            vec[1].add(starttimeValue);
            vec[2].add(endtimeValue);
            ++i;
        }
    }

    private List getListValue(Object obj, ExtCell leftHead, ExtCell topHead, boolean dispValue) {
        List<Object> list = null;
        if (obj instanceof List) {
            list = (ArrayList<Object>)obj;
        } else if (obj instanceof CSVariable) {
            CSVariable var = (CSVariable)obj;
            ExtCell vsrc = var.getSource();
            ExtCell left = var.getLeftHead();
            ExtCell top = var.getTopHead();
            ExtCell lsrc = left.getSource();
            ExtCell tsrc = top.getSource();
            if (leftHead == null || !lsrc.isLeftHeadOf(leftHead.getSource()) || !leftHead.getSource().isLeftHeadOf(vsrc)) {
                leftHead = left;
            }
            if (topHead == null || !tsrc.isTopHeadOf(topHead.getSource()) || !topHead.getSource().isTopHeadOf(vsrc)) {
                topHead = top;
            }
            list = var.getCells(leftHead, topHead, null);
        } else {
            list = new ArrayList<Object>(1);
            list.add(obj);
        }
        return (List)Variant2.getValue(list, dispValue);
    }

    private final List toList(Object obj, ExtCell leftHead, ExtCell topHead) {
        if (obj instanceof List) {
            return (List)obj;
        }
        if (obj instanceof CSVariable) {
            CSVariable var = (CSVariable)obj;
            ExtCell vsrc = var.getSource();
            ExtCell left = var.getLeftHead();
            ExtCell top = var.getTopHead();
            ExtCell lsrc = left.getSource();
            ExtCell tsrc = top.getSource();
            if (leftHead == null || !lsrc.isLeftHeadOf(leftHead.getSource()) || !leftHead.getSource().isLeftHeadOf(vsrc)) {
                leftHead = left;
            }
            if (topHead == null || !tsrc.isTopHeadOf(topHead.getSource()) || !topHead.getSource().isTopHeadOf(vsrc)) {
                topHead = top;
            }
            return var.getCells(leftHead, topHead, null);
        }
        ArrayList<Object> list = new ArrayList<Object>(1);
        list.add(obj);
        return list;
    }

    private final GraphDataSource getSeriesMap(GraphDataSource catMap, Object cat) {
        GraphDataSource seriesMap = (GraphDataSource)catMap.get(cat);
        if (seriesMap == null) {
            seriesMap = new GraphDataSource();
            catMap.add(cat, seriesMap);
        }
        return seriesMap;
    }

    private void cal21(GraphDataSource catMap, Object catValue, String[][] seriesArray) {
        List catList = this.toList(catValue, null, null);
        int n = 0;
        while (n < seriesArray.length) {
            Object val;
            Object ser;
            GraphDataSource seriesMap;
            String cat;
            int i;
            Expression seriesExp = new Expression(this.cs, seriesArray[n][0]);
            Expression valueExp = new Expression(this.cs, seriesArray[n][1]);
            Object seriesValue = seriesExp.calculate();
            Object valueValue = valueExp.calculate();
            if (catValue instanceof CSVariable) {
                i = 0;
                while (i < catList.size()) {
                    List seriesList;
                    cat = Variant2.toString(Variant2.getValue(catList.get(i), true));
                    seriesMap = this.getSeriesMap(catMap, cat);
                    if (seriesValue instanceof CSVariable) {
                        Head head1 = new Head(catValue, catList.get(i), null, null);
                        seriesList = this.toList(seriesValue, head1.leftHead, head1.topHead);
                        int j = 0;
                        while (j < seriesList.size()) {
                            Head head2 = new Head(catValue, catList.get(i), seriesValue, seriesList.get(j));
                            List valueList = this.getListValue(valueValue, head2.leftHead, head2.topHead, false);
                            Object ser2 = Variant2.getValue(seriesList.get(j), true);
                            Object val2 = Variant2.getSingleValue(valueList);
                            seriesMap.add(Variant2.toString(ser2), val2);
                            ++j;
                        }
                    } else {
                        Head head = new Head(catValue, catList.get(i), null, null);
                        seriesList = this.getListValue(seriesValue, null, null, true);
                        List valueList = this.getListValue(valueValue, head.leftHead, head.topHead, false);
                        int j = 0;
                        while (j < seriesList.size()) {
                            if (j < valueList.size()) {
                                ser = seriesList.get(j);
                                val = valueList.get(j);
                                seriesMap.add(Variant2.toString(ser), val);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < catList.size()) {
                    List seriesList;
                    cat = Variant2.toString(Variant2.getValue(catList.get(i)));
                    seriesMap = this.getSeriesMap(catMap, cat);
                    if (seriesValue instanceof CSVariable) {
                        seriesList = this.toList(seriesValue, null, null);
                        int j = 0;
                        while (j < seriesList.size()) {
                            Head head = new Head(null, null, seriesValue, seriesList.get(j));
                            List valueList = this.getListValue(valueValue, head.leftHead, head.topHead, false);
                            ser = Variant2.getValue(seriesList.get(j), true);
                            val = Variant2.getSingleValue(valueList);
                            seriesMap.add(Variant2.toString(ser), val);
                            ++j;
                        }
                    } else {
                        seriesList = this.getListValue(seriesValue, null, null, true);
                        List valueList = this.getListValue(valueValue, null, null, false);
                        int j = 0;
                        while (j < seriesList.size()) {
                            if (j < valueList.size()) {
                                Object ser3 = seriesList.get(j);
                                Object val3 = valueList.get(j);
                                seriesMap.add(Variant2.toString(ser3), val3);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++n;
        }
    }

    private void cal2(GraphProperty gProp, GraphDataSource catMap) {
        String[] catExpStrs = gProp.getCategories();
        int ii = 0;
        while (ii < catExpStrs.length) {
            String catExpStr = catExpStrs[ii];
            Expression catExp = new Expression(this.cs, catExpStr);
            Object catValue = catExp.calculate();
            this.cal21(catMap, catValue, gProp.getSeries(catExpStr));
            ++ii;
        }
    }

    public Object calculate() {
        String disp;
        GraphProperty gProp = new GraphProperty(this.param);
        GraphDataSource catMap = new GraphDataSource();
        ExtCell current = this.cs.getCurrent();
        String type = gProp.getPropertyValue("type");
        if (String.valueOf(18).equals(type) || String.valueOf(23).equals(type)) {
            this.cal1(gProp, catMap);
        } else {
            this.cal2(gProp, catMap);
        }
        this.cs.setCurrent(current);
        this.calcPropValues(gProp);
        StringBuffer sb = new StringBuffer();
        byte[] result = null;
        try {
            result = TransGraphProperty.drawImage(gProp, catMap, this.getCellWidth(), this.getCellHeight(), sb);
        }
        catch (Exception e) {
            throw new ReportError("\u7edf\u8ba1\u56fe\u8ba1\u7b97\u5f02\u5e38:" + e.getMessage(), e);
        }
        String style = gProp.getPropertyValue("graphFormat");
        if (style != null) {
            current.setPropValue(4104, style);
        }
        if ((disp = sb.toString()) != null) {
            current.setPropValue(4105, disp);
        }
        return result;
    }

    public void setParameter(String param) {
        this.param = param;
    }

    protected boolean canOptimized() {
        return false;
    }

    class Head {
        ExtCell leftHead = null;
        ExtCell topHead = null;

        public Head() {
        }

        public Head(Object catValue, Object catCell, Object seriesValue, Object seriesCell) {
            Integer ext;
            ExtCell cell;
            if (catValue instanceof CSVariable) {
                cell = (ExtCell)catCell;
                ext = ((CSVariable)catValue).getCell().getExtensible();
                if (CellPropertyDefine.CEX_VERTICAL.equals(ext)) {
                    this.leftHead = cell;
                } else if (CellPropertyDefine.CEX_HORIZONTAL.equals(ext)) {
                    this.topHead = cell;
                } else {
                    this.leftHead = cell.getLeftHead();
                    this.topHead = cell.getTopHead();
                }
            }
            if (seriesValue instanceof CSVariable) {
                cell = (ExtCell)seriesCell;
                ext = ((CSVariable)seriesValue).getCell().getExtensible();
                if (CellPropertyDefine.CEX_VERTICAL.equals(ext)) {
                    this.leftHead = (ExtCell)seriesCell;
                } else if (CellPropertyDefine.CEX_HORIZONTAL.equals(ext)) {
                    this.topHead = (ExtCell)seriesCell;
                } else {
                    this.leftHead = cell.getLeftHead();
                    this.topHead = cell.getTopHead();
                }
            }
        }
    }
}

