/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine.function;

import com.runqian.base.util.ReportError;
import com.runqian.report.engine.CalcRpt;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.engine.Function;
import com.runqian.report.engine.SubRptList;
import com.runqian.report.engine.Variant2;
import com.runqian.report.usermodel.Env;
import com.runqian.report.usermodel.ReportDefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class CalcSubRpt
extends Function {
    public Object calculate() {
        SubRptList srl = this.cs.getEnv().getSubRptList();
        if (srl == null) {
            throw new ReportError("\u5f53\u524d\u62a5\u8868\u6ca1\u6709\u5f15\u5165\u5b50\u62a5\u8868\uff0c\u4e0d\u80fd\u8fdb\u884c\u5b50\u62a5\u8868\u8fd0\u7b97");
        }
        if (this.paramList.size() < 3 || this.paramList.size() > 4) {
            throw new ReportError("\u5b50\u62a5\u8868\u8fd0\u7b97\u51fd\u6570\u7684\u53c2\u6570\u683c\u5f0f\u5e94\u4e3acalcSubRpt(rpt, List1, List2) \u6216\u8005 calcSubRpt(rpt, List1, List2,importOrEmbed)");
        }
        Expression param1 = (Expression)this.paramList.get(0);
        if (param1 == null) {
            throw new ReportError("\u5b50\u62a5\u8868\u8fd0\u7b97\u51fd\u6570\u51fa\u73b0\u65e0\u6548\u53c2\u6570");
        }
        Object result1 = Variant2.getValue(param1.calculate());
        int importOrEmbed = 0;
        if (this.paramList.size() == 4) {
            Expression param4 = (Expression)this.paramList.get(3);
            if (param4 == null) {
                throw new ReportError("\u5b50\u62a5\u8868\u8fd0\u7b97\u51fd\u6570\u51fa\u73b0\u65e0\u6548\u53c2\u6570");
            }
            Object result4 = Variant2.getValue(param4.calculate());
            try {
                importOrEmbed = (Integer)result4;
            }
            catch (Exception e) {
                importOrEmbed = 0;
            }
        }
        if (result1 instanceof String) {
            String address = srl.getAddress((String)result1);
            String type = srl.getType((String)result1);
            ReportDefine rd = this.readRpt(address, type);
            Expression param2 = (Expression)this.paramList.get(1);
            Expression param3 = (Expression)this.paramList.get(2);
            if (param2 != null && param3 != null) {
                Object result2 = Variant2.getValue(param2.calculate());
                Object result3 = Variant2.getValue(param3.calculate());
                if (result2 instanceof List && result3 instanceof List) {
                    return this.calcRpt(rd, (List)result2, (List)result3, importOrEmbed);
                }
                return this.calcRpt(rd, null, null, importOrEmbed);
            }
            return this.calcRpt(rd, null, null, importOrEmbed);
        }
        throw new ReportError("\u5b50\u62a5\u8868\u8fd0\u7b97\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5e94\u4e3a\u5f15\u5165\u7684\u5b50\u62a5\u8868\u540d");
    }

    private ReportDefine readRpt(String address, String type) {
        ReportDefine rd = null;
        if ("\u7edd\u5bf9\u8def\u5f84".equalsIgnoreCase(type)) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(address);
            }
            catch (FileNotFoundException e) {
                throw new ReportError("\u6ca1\u6709\u627e\u5230\u5b50\u62a5\u8868\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6");
            }
            try {
                rd = new ReportDefine(fis);
            }
            catch (Exception e) {
                throw new ReportError("\u4ece\u5b50\u62a5\u8868\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u521b\u5efa\u62a5\u8868\u5b9a\u4e49\u65f6\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if ("\u76f8\u5bf9\u8def\u5f84".equalsIgnoreCase(type)) {
            InputStream is;
            block18: {
                is = null;
                String mainDir = this.cs.getEnv().getMainDir();
                try {
                    is = new FileInputStream(new File(mainDir, address));
                }
                catch (FileNotFoundException e) {
                    if (this.cs.getEnv().getServletContext() != null) {
                        if (!address.startsWith("/")) {
                            address = "/" + address;
                        }
                        String fName = String.valueOf(mainDir) + address;
                        is = this.cs.getEnv().getServletContext().getResourceAsStream(fName);
                    }
                    if (is != null) break block18;
                    throw new ReportError("\u62a5\u8868\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
            }
            try {
                rd = new ReportDefine(is);
            }
            catch (Exception e) {
                throw new ReportError("\u4ece\u5b50\u62a5\u8868\u6307\u5b9a\u76ee\u5f55\u4e0b\u7684\u6587\u4ef6\u521b\u5efa\u62a5\u8868\u5b9a\u4e49\u65f6\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        if ("url".equalsIgnoreCase(type)) {
            URL url = null;
            try {
                url = new URL(address);
            }
            catch (MalformedURLException e) {
                throw new ReportError("\u5b50\u62a5\u8868\u7684url\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
            try {
                rd = new ReportDefine(url.openStream());
            }
            catch (IOException e) {
                throw new ReportError("\u5b50\u62a5\u8868\u7684url\u8bbf\u95ee\u88ab\u62d2\u7edd\u6216\u51fa\u9519");
            }
            catch (Exception e) {
                throw new ReportError("\u4ece\u5b50\u62a5\u8868\u7684url\u8bfb\u5165\u5e76\u521b\u5efa\u62a5\u8868\u5b9a\u4e49\u7684\u65f6\u5019\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rd;
    }

    private Object calcRpt(ReportDefine rd, List nameList, List expList, int importOrEmbed) {
        Env env = this.cs.getEnv();
        if (nameList != null && expList != null) {
            if (nameList.size() != expList.size()) {
                throw new ReportError("\u5b50\u62a5\u8868\u53c2\u6570\u540d\u5217\u8868\u548c\u53c2\u6570\u8868\u8fbe\u5f0f\u5217\u8868\u4e2a\u6570\u4e0d\u4e00\u81f4");
            }
            int i = 0;
            while (i < nameList.size()) {
                String name = (String)nameList.get(i);
                Object exp = expList.get(i);
                if (name != null) {
                    env.putParam(name, exp);
                }
                ++i;
            }
        }
        ExtCellSet ecs = new ExtCellSet(env);
        ecs.read(rd.getCellSet());
        CalcRpt.calcRpt(rd, true, ecs);
        if (importOrEmbed == 0) {
            ecs.setSubRptType(ExtCellSet.SRT_EMBED);
        } else {
            ecs.setSubRptType(ExtCellSet.SRT_IMPORT);
        }
        return ecs;
    }

    protected boolean canOptimized() {
        return false;
    }
}

