/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.engine.function;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.ReportError;
import com.runqian.report.engine.CSVariable;
import com.runqian.report.engine.ExtCell;
import com.runqian.report.engine.Function;
import com.runqian.report.engine.Variant2;
import java.util.ArrayList;
import java.util.List;

public class Move
extends Function {
    protected boolean isAbbr = false;
    protected int leftMove;
    protected int topMove;
    protected ArrayList leftMoveList;
    protected ArrayList topMoveList;

    public Move() {
        this.priority = 14;
        this.leftMoveList = new ArrayList();
        this.topMoveList = new ArrayList();
    }

    public void setParameter(String param) {
        ArgumentTokenizer arg = new ArgumentTokenizer(param, ';');
        String left = null;
        String top = null;
        String moveStr = null;
        if (arg.hasMoreTokens()) {
            left = arg.nextToken();
        }
        if (arg.hasMoreTokens()) {
            top = arg.nextToken();
        }
        if (left != null && left.length() > 0) {
            arg = new ArgumentTokenizer(left, ',');
            while (arg.hasMoreTokens()) {
                moveStr = arg.nextToken();
                if (moveStr.length() <= 0) continue;
                this.leftMoveList.add(this.getScopeMove(moveStr));
            }
        }
        if (top != null && top.length() > 0) {
            arg = new ArgumentTokenizer(top, ',');
            while (arg.hasMoreTokens()) {
                moveStr = arg.nextToken();
                if (moveStr.length() <= 0) continue;
                this.topMoveList.add(this.getScopeMove(moveStr));
            }
        }
        int leftSize = this.leftMoveList.size();
        int topSize = this.topMoveList.size();
        if (leftSize == 0) {
            if (topSize == 1) {
                ScopeMove sm = (ScopeMove)this.topMoveList.get(0);
                if (sm.source == null && sm.type == 1) {
                    this.isAbbr = true;
                    this.leftMove = 0;
                    this.topMove = sm.position;
                }
            }
        } else if (leftSize == 1) {
            ScopeMove sm = (ScopeMove)this.leftMoveList.get(0);
            if (sm.source == null && sm.type == 1) {
                ScopeMove sm1;
                if (topSize == 0) {
                    this.isAbbr = true;
                    this.leftMove = sm.position;
                    this.topMove = 0;
                } else if (topSize == 1 && (sm1 = (ScopeMove)this.topMoveList.get(0)) == null && sm1.type == 1) {
                    this.isAbbr = true;
                    this.leftMove = sm.position;
                    this.topMove = sm1.position;
                }
            }
        }
    }

    protected ScopeMove getScopeMove(String moveStr) {
        ArgumentTokenizer arg = new ArgumentTokenizer(moveStr, ':');
        String source = null;
        String position = null;
        if (arg.hasMoreTokens() && (source = arg.nextToken()) != null) {
            source = source.trim();
        }
        if (arg.hasMoreElements()) {
            position = arg.nextToken();
        }
        if (!this.cs.isSource(source)) {
            position = source;
            source = null;
        }
        ScopeMove move = new ScopeMove();
        if (source != null) {
            move.source = this.cs.getSource(source);
            if (move.source == null) {
                throw new ReportError("\u4e0d\u80fd\u8bc6\u522b\u7684\u5355\u5143\u683c" + source);
            }
        }
        if (position != null) {
            try {
                switch (position.charAt(0)) {
                    case '+': {
                        move.type = 1;
                        move.position = Integer.parseInt(position.substring(1));
                        break;
                    }
                    case '-': {
                        move.type = 1;
                        move.position = -Integer.parseInt(position.substring(1));
                        break;
                    }
                    case '0': {
                        move.type = 1;
                        move.position = 0;
                        break;
                    }
                    default: {
                        move.type = 0;
                        move.position = Integer.parseInt(position) - 1;
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new ReportError("\u4f4d\u7f6e\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        } else {
            move.type = 2;
        }
        return move;
    }

    public Object calculate() {
        ExtCell head;
        int position;
        ScopeMove sm;
        if (this.left == null) {
            throw new ReportError("\u4f4d\u79fb\u51fd\u6570[]\u5de6\u64cd\u4f5c\u6570\u4e3a\u7a7a");
        }
        Object leftResult = this.left.calculate();
        if (!(leftResult instanceof CSVariable)) {
            throw new ReportError("\u4f4d\u79fb\u51fd\u6570[]\u5de6\u64cd\u4f5c\u6570\u5e94\u4e3a\u5355\u5143\u683c");
        }
        CSVariable var = (CSVariable)leftResult;
        ExtCell source = var.getSource();
        if (this.isAbbr) {
            return this.cal(source, this.leftMove, this.topMove);
        }
        int leftSize = this.leftMoveList.size();
        int topSize = this.topMoveList.size();
        ExtCell current = this.cs.getCurrent();
        ExtCell leftHead = current.getLeftHead();
        ExtCell topHead = current.getTopHead();
        int i = 0;
        while (i < leftSize) {
            sm = (ScopeMove)this.leftMoveList.get(i);
            position = 0;
            if (sm.source == null) {
                sm.source = source.getExtCells() != null ? source : source.getLeftHead();
            }
            head = current.getLeftHead(sm.source);
            switch (sm.type) {
                case 0: {
                    position = sm.position;
                    break;
                }
                case 1: {
                    if (head == null) {
                        throw new ReportError("\u4f4d\u79fb\u5bf9\u8c61\u8d85\u51fa\u8303\u56f4");
                    }
                    position = head.getPosition() + sm.position;
                    break;
                }
                case 2: {
                    if (head == null) {
                        throw new ReportError("\u4f4d\u79fb\u5bf9\u8c61\u8d85\u51fa\u8303\u56f4");
                    }
                    position = head.getPosition();
                }
            }
            leftHead = sm.source.isLeftHeadOf(leftHead.getSource()) ? leftHead.getLeftHead(sm.source) : leftHead.getSubCell(sm.source);
            if (leftHead == null) {
                return null;
            }
            leftHead.testValue();
            leftHead = leftHead.getExtCell(position);
            if (leftHead == null) {
                return null;
            }
            ++i;
        }
        i = 0;
        while (i < topSize) {
            sm = (ScopeMove)this.topMoveList.get(i);
            position = 0;
            if (sm.source == null) {
                sm.source = source.getExtCells() != null ? source : source.getTopHead();
            }
            head = current.getTopHead(sm.source);
            switch (sm.type) {
                case 0: {
                    position = sm.position;
                    break;
                }
                case 1: {
                    if (head == null) {
                        throw new ReportError("\u4f4d\u79fb\u5bf9\u8c61\u8d85\u51fa\u8303\u56f4");
                    }
                    position = head.getPosition() + sm.position;
                    break;
                }
                case 2: {
                    if (head == null) {
                        throw new ReportError("\u4f4d\u79fb\u5bf9\u8c61\u8d85\u51fa\u8303\u56f4");
                    }
                    position = head.getPosition();
                }
            }
            topHead = sm.source.isTopHeadOf(topHead.getSource()) ? topHead.getTopHead(sm.source) : topHead.getSubCell(sm.source);
            if (topHead == null) {
                return null;
            }
            topHead.testValue();
            topHead = topHead.getExtCell(position);
            if (topHead == null) {
                return null;
            }
            ++i;
        }
        return new CSVariable(source, leftHead, topHead);
    }

    private Object cal(ExtCell source, int leftMove, int topMove) {
        ExtCell topSource;
        ExtCell topHead;
        ExtCell leftSource;
        ExtCell leftHead;
        ExtCell current = this.cs.getCurrent();
        if (current.getCol() == 10 && current.getRow() == 18) {
            System.out.println("current row: " + current.getRow());
        }
        if ((leftHead = current.getLeftHead(leftSource = source.getCommonLeftHead(current.getSource()))) == current) {
            leftHead = current.getLeftHead();
        }
        if ((topHead = current.getTopHead(topSource = source.getCommonTopHead(current.getSource()))) == current) {
            topHead = current.getTopHead();
        }
        try {
            if (leftMove != 0 && (leftHead = this.getLeftHead(leftHead, leftHead.getSource(), leftMove)) == null) {
                return null;
            }
            if (topMove != 0 && (topHead = this.getTopHead(topHead, topHead.getSource(), topMove)) == null) {
                return null;
            }
        }
        catch (StackOverflowError e) {
            System.out.println("current: " + current.getRow() + ", " + current.getCol());
            throw e;
        }
        leftHead.testValue();
        topHead.testValue();
        return new CSVariable(source, leftHead, topHead);
    }

    private ExtCell getLeftHead(ExtCell head, ExtCell headSource, int leftMove) {
        if (head == null) {
            return null;
        }
        if (head.getSource() == headSource) {
            if (leftMove == 0) {
                return head;
            }
            ExtCell[] exts = head.getExtCells();
            if (exts == null || exts.length == 1) {
                leftMove += leftMove > 0 ? -1 : 1;
            } else {
                int p = head.getPosition();
                int pos = p + leftMove;
                if (pos >= 0 && pos < exts.length) {
                    return exts[pos];
                }
                leftMove = leftMove > 0 ? (leftMove -= exts.length - p) : leftMove + p + 1;
            }
            head = this.getNextLeftHead(head, leftMove);
            return this.getLeftHead(head, headSource, leftMove);
        }
        if ((head = this.getSubBySameSource(head, headSource)) == null) {
            return null;
        }
        ExtCell[] exts = head.getExtCells();
        if (exts != null) {
            head = leftMove > 0 ? exts[0] : exts[exts.length - 1];
        }
        return this.getLeftHead(head, headSource, leftMove);
    }

    private ExtCell getNextLeftHead(ExtCell head, int leftMove) {
        int sign = leftMove > 0 ? 1 : -1;
        head = head.getLeftHead();
        while (head != null) {
            int p;
            ExtCell[] exts = head.getExtCells();
            if (exts != null && (p = head.getPosition() + sign) >= 0 && p < exts.length) {
                return exts[p];
            }
            head = head.getLeftHead();
        }
        return null;
    }

    private ExtCell getSubBySameSource(ExtCell head, ExtCell headSource) {
        List subs = head.getSubCells();
        int i = 0;
        while (i < subs.size()) {
            ExtCell c = (ExtCell)subs.get(i);
            if (c.getSource().isLeftHeadOf(headSource)) {
                return c;
            }
            ++i;
        }
        return null;
    }

    private ExtCell getTopHead(ExtCell head, ExtCell headSource, int topMove) {
        if (head == null) {
            return null;
        }
        if (head.getSource() == headSource) {
            if (this.leftMove == 0) {
                return head;
            }
            ExtCell[] exts = head.getExtCells();
            if (exts == null || exts.length == 1) {
                this.leftMove += this.leftMove > 0 ? -1 : 1;
            } else {
                int p = head.getPosition();
                int pos = p + topMove;
                if (pos >= 0 && pos < exts.length) {
                    return exts[pos];
                }
                topMove = topMove > 0 ? (topMove -= exts.length - p) : topMove + p + 1;
            }
            head = this.getNextTopHead(head, topMove);
            return this.getTopHead(head, headSource, topMove);
        }
        if ((head = this.getSubBySameSource(head, headSource)) == null) {
            return null;
        }
        ExtCell[] exts = head.getExtCells();
        if (exts != null) {
            head = topMove > 0 ? exts[0] : exts[exts.length - 1];
        }
        return this.getTopHead(head, headSource, this.leftMove);
    }

    private ExtCell getNextTopHead(ExtCell head, int topMove) {
        int sign = topMove > 0 ? 1 : -1;
        head = head.getTopHead();
        while (head != null) {
            int p;
            ExtCell[] exts = head.getExtCells();
            if (exts != null && (p = head.getPosition() + sign) >= 0 && p < exts.length) {
                return exts[p];
            }
            head = head.getTopHead();
        }
        return null;
    }

    public String getExp() {
        Object o = this.calculate();
        if (o instanceof CSVariable) {
            return Variant2.getExp(((CSVariable)o).getCell());
        }
        return null;
    }

    protected static class ScopeMove {
        public static final int TYPE_ABSOLUTE = 0;
        public static final int TYPE_RELATIVE = 1;
        public static final int TYPE_NOPOSITION = 2;
        public ExtCell source;
        public int type;
        public int position;

        protected ScopeMove() {
        }
    }
}

