/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.ColorComboBox;
import com.runqian.base.swing.JTableEx;
import com.runqian.base.tool.MessageBox;
import com.runqian.report.graph.AlarmLine;
import com.runqian.report.graph.ColorRenderer;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.LineTypeBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AlarmLineTable
extends JPanel
implements ActionListener {
    JTableEx table;
    private JButton addButton;
    private JButton delButton;
    private Font font;

    public AlarmLineTable(GraphProperty gp) {
        Object[] columnNames = new String[]{"\u540d\u79f0", "\u8b66\u6212\u503c", "\u7ebf\u578b", "\u989c\u8272"};
        ArrayList lines = gp.getAlarmLines();
        Object[][] data = new Object[lines.size()][4];
        int row = 0;
        while (row < lines.size()) {
            AlarmLine line = (AlarmLine)lines.get(row);
            data[row][0] = line.getName();
            data[row][1] = line.getAlarmValue();
            data[row][2] = LineTypeBox.valueToDisp(line.getLineType());
            data[row][3] = line.getColor();
            ++row;
        }
        this.table = new JTableEx();
        this.table.setModel(new DefaultTableModel(data, columnNames));
        this.table.setRowHeight(20);
        TableColumn column = this.table.getColumn("\u7ebf\u578b");
        column.setCellEditor(new DefaultCellEditor(new LineTypeBox()));
        column = this.table.getColumn("\u989c\u8272");
        column.setCellRenderer(new ColorRenderer());
        column.setCellEditor(new DefaultCellEditor(new ColorComboBox()));
        this.setClickCountToStart();
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.table);
        this.add(jsp);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 8));
        panel.setPreferredSize(new Dimension(70, 50));
        this.font = new Font("\u5b8b\u4f53", 0, 12);
        this.addButton = new JButton("\u6dfb\u52a0");
        this.addButton.setFont(this.font);
        this.addButton.addActionListener(this);
        this.delButton = new JButton("\u5220\u9664");
        this.delButton.setFont(this.font);
        this.delButton.addActionListener(this);
        panel.add(this.addButton);
        panel.add(this.delButton);
        this.add((Component)panel, "East");
    }

    private void setClickCountToStart() {
        int row = 0;
        while (row < this.table.getRowCount()) {
            int col = 0;
            while (col < this.table.getColumnCount()) {
                TableCellEditor editor = this.table.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                ++col;
            }
            ++row;
        }
    }

    public String toString() {
        String s = "";
        TableModel model = this.table.getModel();
        int rows = this.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String lineString = model.getValueAt(row, 0) + "=";
            lineString = String.valueOf(lineString) + model.getValueAt(row, 1).toString();
            lineString = String.valueOf(lineString) + "," + LineTypeBox.dispToValue(model.getValueAt(row, 2).toString());
            lineString = String.valueOf(lineString) + "," + (Integer)model.getValueAt(row, 3);
            if (s.length() > 0) {
                s = String.valueOf(s) + "&";
            }
            s = String.valueOf(s) + lineString;
            ++row;
        }
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj;
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((obj = e.getSource()).equals(this.addButton)) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"\u8b66\u6212\u7ebf" + (this.table.getRowCount() + 1), new Double(0.0), "\u5b9e\u7ebf", new Integer(Color.red.getRGB())});
            this.setClickCountToStart();
        } else if (obj.equals(this.delButton)) {
            int currRow = this.table.getSelectedRow();
            if (currRow < 0) {
                new MessageBox((JDialog)this.getTopLevelAncestor(), "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u8b66\u6212\u7ebf!", Color.red, this.font).show();
                return;
            }
            ((DefaultTableModel)this.table.getModel()).removeRow(currRow);
        }
    }

    public static void main(String[] a) {
        final AlarmLineTable panel = new AlarmLineTable(new GraphProperty(""));
        JFrame f = new JFrame();
        f.setSize(500, 400);
        f.getContentPane().add(panel);
        JButton b = new JButton("ok");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, panel.toString());
            }
        });
        f.getContentPane().add((Component)b, "South");
        f.show();
    }
}

