/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.JTableExListener;
import com.runqian.report.graph.CategoryTable;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.SeriesTable;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class CSPanel
extends JPanel
implements JTableExListener {
    private CategoryTable cPanel;
    private SeriesTable sPanel;

    public CSPanel(GraphProperty gp) {
        this.setLayout(new GridBagLayout());
        this.cPanel = new CategoryTable(gp);
        String[] categories = gp.getCategories();
        this.sPanel = categories.length > 0 ? new SeriesTable(gp.getSeries(categories[0])) : new SeriesTable(new String[0][0]);
        Font font = new Font("\u5b8b\u4f53", 0, 12);
        this.cPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u5206\u7c7b\u8f74", 0, 0, font));
        this.sPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u7cfb\u5217", 0, 0, font));
        this.cPanel.table.addTableExListener(this);
        this.add((Component)this.cPanel, this.createBaseGBC(1, 0, 1, 1));
        this.add((Component)this.sPanel, this.createBaseGBC(2, 0, 1, 1));
    }

    private GridBagConstraints createBaseGBC(int rowIndex, int colIndex, int rowSpan, int colSpan) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = colIndex;
        gbc.gridy = rowIndex;
        gbc.gridwidth = colSpan;
        gbc.gridheight = rowSpan;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 3, 3);
        gbc.fill = 1;
        return gbc;
    }

    public String getCategories() {
        this.cPanel.table.acceptText();
        String s = "";
        TableModel model = this.cPanel.table.getModel();
        int rows = this.cPanel.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String category = (String)model.getValueAt(row, 0);
            if (category != null && category.trim().length() != 0) {
                if (s.length() > 0) {
                    s = String.valueOf(s) + "|";
                }
                s = String.valueOf(s) + category.trim();
            }
            ++row;
        }
        return s;
    }

    public String getSeries() {
        this.saveCurrSery();
        String s = "";
        TableModel model = this.cPanel.table.getModel();
        int rows = this.cPanel.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String category = (String)model.getValueAt(row, 0);
            if (category != null && category.trim().length() != 0) {
                category = category.trim();
                String[][] series = (String[][])this.cPanel.c_series.get(category);
                String sery = "";
                int i = 0;
                while (i < series.length) {
                    if (sery.length() > 0) {
                        sery = String.valueOf(sery) + "&";
                    }
                    sery = String.valueOf(sery) + series[i][0] + "=" + series[i][1];
                    ++i;
                }
                s = String.valueOf(s) + "|" + sery;
            }
            ++row;
        }
        if (s.length() > 0) {
            s = s.substring(1);
        }
        return s;
    }

    private void saveCurrSery() {
        this.cPanel.table.acceptText();
        this.sPanel.table.acceptText();
        int row = this.cPanel.table.getSelectedRow();
        if (row < 0) {
            return;
        }
        String category = (String)this.cPanel.table.getModel().getValueAt(row, 0);
        if (category == null || category.trim().length() == 0) {
            return;
        }
        this.cPanel.c_series.put(category, this.sPanel.toArray());
    }

    public void rightClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void doubleClicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void clicked(int xpos, int ypos, int row, int col, MouseEvent e) {
    }

    public void rowfocusChanged(int oldRow, int newRow) {
        TableModel model = this.cPanel.table.getModel();
        if (oldRow >= 0) {
            String oldCategory = (String)model.getValueAt(oldRow, 0);
            this.sPanel.table.acceptText();
            if (oldCategory != null) {
                this.cPanel.c_series.put(oldCategory, this.sPanel.toArray());
            }
        }
        String newCategory = (String)model.getValueAt(newRow, 0);
        String[][] data = null;
        if (newCategory != null) {
            data = (String[][])this.cPanel.c_series.get(newCategory);
        }
        this.sPanel.changeModel(data);
    }

    public static void main(String[] a) {
        CSPanel panel = new CSPanel(new GraphProperty(""));
        JFrame f = new JFrame();
        f.setSize(500, 400);
        f.getContentPane().add(panel);
        JButton b = new JButton("ok");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, CSPanel.this.getSeries());
            }
        });
        f.getContentPane().add((Component)b, "South");
        f.show();
    }
}

