/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.JTableEx;
import com.runqian.report.graph.GraphProperty;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class CategoryTable
extends JPanel
implements ActionListener {
    public JTableEx table;
    private JButton addButton;
    private JButton delButton;
    private Font font;
    public Hashtable c_series = new Hashtable();
    private static int count = 1;

    public CategoryTable(GraphProperty gp) {
        Object[] columnNames = new String[]{"\u5206\u7c7b\u8f74\u5b9a\u4e49"};
        String[] categories = gp.getCategories();
        Object[][] data = new String[categories.length][1];
        int i = 0;
        while (i < categories.length) {
            data[i][0] = categories[i];
            this.c_series.put(categories[i], gp.getSeries(categories[i]));
            ++i;
        }
        this.table = new JTableEx();
        this.table.setModel(new DefaultTableModel(data, columnNames));
        this.table.setRowHeight(20);
        if (categories.length > 0) {
            this.table.selectRow(0);
        }
        this.setClickCountToStart();
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.table);
        this.add(jsp);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 8));
        panel.setPreferredSize(new Dimension(70, 50));
        this.font = new Font("\u5b8b\u4f53", 0, 12);
        this.addButton = new JButton("\u6dfb\u52a0");
        this.addButton.setFont(this.font);
        this.addButton.addActionListener(this);
        this.delButton = new JButton("\u5220\u9664");
        this.delButton.setFont(this.font);
        this.delButton.addActionListener(this);
        panel.add(this.addButton);
        panel.add(this.delButton);
        this.add((Component)panel, "East");
    }

    private void setClickCountToStart() {
        int row = 0;
        while (row < this.table.getRowCount()) {
            int col = 0;
            while (col < this.table.getColumnCount()) {
                TableCellEditor editor = this.table.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                ++col;
            }
            ++row;
        }
    }

    protected ArrayList getCategories() {
        ArrayList<String> al = new ArrayList<String>();
        TableModel model = this.table.getModel();
        int rows = this.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String name = (String)model.getValueAt(row, 0);
            if (name != null && name.trim().length() != 0) {
                al.add(name.trim());
            }
            ++row;
        }
        return al;
    }

    public String toString() {
        String s = "";
        ArrayList al = this.getCategories();
        int i = 0;
        while (i < al.size()) {
            String c = (String)al.get(i);
            if (s.length() > 0) {
                s = String.valueOf(s) + "|";
            }
            s = String.valueOf(s) + c;
            ++i;
        }
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.addButton)) {
            int currRow = this.table.addRow(new String[]{"\u5206\u7c7b" + count});
            ++count;
            this.setClickCountToStart();
        } else if (obj.equals(this.delButton)) {
            this.table.deleteSelectedRows();
        }
    }

    public static void main(String[] a) {
        final CategoryTable panel = new CategoryTable(new GraphProperty(""));
        JFrame f = new JFrame();
        f.setSize(500, 400);
        f.getContentPane().add(panel);
        JButton b = new JButton("ok");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, panel.toString());
            }
        });
        f.getContentPane().add((Component)b, "South");
        f.show();
    }
}

