/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.graph.GraphFont;
import com.runqian.base.swing.ColorComboBox;
import com.runqian.report.graph.ColorRenderer;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.IntEditor;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class FontEditTable
extends JTable {
    public FontEditTable(GraphProperty gp) {
        Object[][] data = new Object[7][8];
        data[0][0] = "\u6807\u9898";
        data[1][0] = "\u6a2a\u8f74\u6807\u9898";
        data[2][0] = "\u7eb5\u8f74\u6807\u9898";
        data[3][0] = "\u6a2a\u8f74\u6807\u7b7e";
        data[4][0] = "\u7eb5\u8f74\u6807\u7b7e";
        data[5][0] = "\u56fe\u4f8b";
        data[6][0] = "\u56fe\u663e\u793a\u503c";
        int row = 0;
        while (row < 7) {
            GraphFont font = gp.getFont(String.valueOf(row));
            data[row][1] = font.getFamily();
            data[row][2] = new Boolean(font.isAutoResize());
            data[row][3] = new Integer(font.getSize());
            data[row][4] = new Boolean(font.isBold());
            data[row][5] = font.getColor();
            data[row][6] = new Boolean(font.isVerticalText());
            data[row][7] = new Integer(font.getAngle());
            ++row;
        }
        this.setModel(new FontTableModel(data));
        this.setRowHeight(20);
        TableColumn column = this.getColumn("\u5b57\u4f53");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        JComboBox<String> m_cbFonts = new JComboBox<String>(fontNames);
        m_cbFonts.setFont(new Font("\u5b8b\u4f53", 0, 12));
        column.setCellEditor(new DefaultCellEditor(m_cbFonts));
        column = this.getColumn("\u989c\u8272");
        column.setCellRenderer(new ColorRenderer());
        column.setCellEditor(new DefaultCellEditor(new ColorComboBox()));
        column = this.getColumn("\u5927\u5c0f");
        column.setCellEditor(new IntEditor(new JTextField()));
        column = this.getColumn("\u65cb\u8f6c\u89d2\u5ea6");
        column.setCellEditor(new IntEditor(new JTextField()));
        int row2 = 0;
        while (row2 < this.getRowCount()) {
            int col = 0;
            while (col < this.getColumnCount()) {
                TableCellEditor editor = this.getCellEditor(row2, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                if (col == 3 || col == 7) {
                    ((DefaultTableCellRenderer)this.getCellRenderer(row2, col)).setHorizontalAlignment(2);
                }
                ++col;
            }
            ++row2;
        }
    }

    public String toString() {
        String s = "";
        TableModel model = this.getModel();
        int rows = this.getRowCount();
        int row = 0;
        while (row < rows) {
            String fontString = String.valueOf(row) + "=";
            fontString = String.valueOf(fontString) + model.getValueAt(row, 1);
            fontString = String.valueOf(fontString) + "," + ((Boolean)model.getValueAt(row, 2) != false ? "1" : "0");
            fontString = String.valueOf(fontString) + "," + model.getValueAt(row, 3).toString();
            fontString = String.valueOf(fontString) + "," + ((Boolean)model.getValueAt(row, 4) != false ? "1" : "0");
            fontString = String.valueOf(fontString) + "," + (Integer)model.getValueAt(row, 5);
            fontString = String.valueOf(fontString) + "," + ((Boolean)model.getValueAt(row, 6) != false ? "1" : "0");
            fontString = String.valueOf(fontString) + "," + model.getValueAt(row, 7).toString();
            if (s.length() > 0) {
                s = String.valueOf(s) + "&";
            }
            s = String.valueOf(s) + fontString;
            ++row;
        }
        return s;
    }

    public static void main(String[] a) {
        final FontEditTable table = new FontEditTable(new GraphProperty(""));
        JFrame f = new JFrame();
        f.setSize(500, 400);
        JScrollPane jsp = new JScrollPane(table);
        f.getContentPane().add(jsp);
        JButton b = new JButton("ok");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ((DefaultTableModel)table.getModel()).removeRow(0);
                JOptionPane.showMessageDialog(null, table.toString());
            }
        });
        f.getContentPane().add((Component)b, "South");
        f.show();
    }

    private class FontTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"\u6587\u5b57\u4f4d\u7f6e", "\u5b57\u4f53", "\u81ea\u52a8\u8c03\u6574\u5927\u5c0f", "\u5927\u5c0f", "\u7c97\u4f53", "\u989c\u8272", "\u7ad6\u6392\u6587\u5b57", "\u65cb\u8f6c\u89d2\u5ea6"};
        private Object[][] data;

        public FontTableModel(Object[][] data) {
            this.data = data;
        }

        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            return this.data[0][col].getClass();
        }

        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public boolean isCellEditable(int row, int col) {
            return col != 0;
        }
    }
}

