/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.ColorComboBox;
import com.runqian.base.tool.MessageBox;
import com.runqian.base.util.Escape;
import com.runqian.report.graph.AlarmLineTable;
import com.runqian.report.graph.CSPanel;
import com.runqian.report.graph.DisplayDataBox;
import com.runqian.report.graph.FontEditTable;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.LegendLocationBox;
import com.runqian.report.graph.LineTypeBox;
import com.runqian.report.graph.TimeTypeBox;
import com.runqian.report.graph.TypeSelectBox;
import com.runqian.report.graph.UnitBox;
import com.runqian.report.graph.XAxisTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class GraphEditDialog
extends JDialog
implements ActionListener,
FocusListener {
    private GraphProperty props;
    private Font baseFont;
    private JButton okButton;
    private JButton cancelButton;
    private int m_option = 2;
    private JFrame pFrame;
    private TypeSelectBox typeSelectBox;
    private JTextField topNField;
    private JTextField statusStartTimeField;
    private JTextField statusEndTimeField;
    private JTextField statusCategeryField;
    private JTextField statusStateField;
    private CSPanel csPanel;
    private JPanel timeDSPanel;
    private JTextField titleField;
    private JTextField xTitleField;
    private JTextField yTitleField;
    private JComboBox graphFormatBox = new JComboBox<String>(new String[]{"JPG", "GIF", "PNG"});
    private JComboBox displayDataBox = new DisplayDataBox();
    private JLabel displayDataFormatLabel;
    private JTextField displayDataFormatField;
    private JCheckBox graphTransparent;
    private JCheckBox backTransparent;
    private JComboBox gridLineBox = new LineTypeBox();
    private JLabel gridLineLabel;
    private JPanel barIntervalPanel;
    private JTextField barIntervalField;
    private JTextField yStartField;
    private JTextField yEndField;
    private JTextField yIntervalField;
    private JTextField yMinMarksField;
    private UnitBox unitBox = new UnitBox();
    private JTextField marginField;
    private AlarmLineTable alarmLinePanel;
    private ColorComboBox backColorBox;
    private ColorComboBox axisColorBox;
    private JLabel gridLineColorLabel;
    private ColorComboBox gridLineColorBox;
    private LegendLocationBox legendLocationBox = new LegendLocationBox();
    private JComboBox colorConfigBox;
    private FontEditTable fontTable;
    private JTextField htmlLinkField;
    private JTextField htmlLinkTargetField;
    private JPanel timeDefinePanel;
    private JTextField statusBarHeightField;
    private JComboBox timeTypeBox = new TimeTypeBox();
    private XAxisTable xAxisTable;

    public GraphEditDialog(String graphPropertyString, JFrame frame) {
        super(frame);
        this.pFrame = frame;
        this.setDefaultCloseOperation(2);
        this.baseFont = new Font("\u5b8b\u4f53", 0, 12);
        this.setTitle("\u7edf\u8ba1\u56fe\u5c5e\u6027\u5b9a\u4e49");
        this.setModal(true);
        this.setSize(500, 460);
        Dimension size = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (screenSize.width - size.width) / 2;
        int newY = (screenSize.height - size.height) / 2;
        this.setLocation(newX, newY);
        if (graphPropertyString != null && graphPropertyString.trim().length() > 0) {
            graphPropertyString = graphPropertyString.substring(graphPropertyString.indexOf("(") + 1, graphPropertyString.length() - 1);
            graphPropertyString = Escape.removeEscAndQuote(graphPropertyString);
        }
        this.props = new GraphProperty(graphPropertyString);
        JTabbedPane tp = new JTabbedPane();
        tp.setFont(this.baseFont);
        tp.addTab("\u56fe\u7c7b\u578b\u53ca\u6570\u636e", this.createDSPanel());
        tp.addTab("\u56fe\u5f62\u7279\u6027", this.createDefinePanel());
        tp.addTab("\u663e\u793a\u5916\u89c2", this.createAppearancePanel());
        tp.addTab("\u65f6\u5e8f\u72b6\u6001\u56fe\u53ca\u65f6\u95f4\u8d70\u52bf\u56fe\u7279\u6027", this.createEspecialDefinePanel());
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add(tp);
        int type = 7;
        try {
            type = Integer.parseInt(this.props.getPropertyValue("type"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.typeSelectBox.setValue(type);
        JPanel panel = new JPanel();
        this.okButton = new JButton("\u786e\u5b9a(O)");
        this.okButton.setMnemonic('O');
        this.initButton(this.okButton);
        panel.add(this.okButton);
        this.cancelButton = new JButton("\u53d6\u6d88(C)");
        this.cancelButton.setMnemonic('C');
        this.initButton(this.cancelButton);
        panel.add(this.cancelButton);
        pane.add((Component)panel, "South");
    }

    private JPanel createDSPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 8, 5, 8));
        panel.add((Component)this.createTextLabel(" \u7edf\u8ba1\u56fe\u7c7b\u578b"), this.createBaseGBC(0, 0, 1, 1));
        this.typeSelectBox = new TypeSelectBox();
        this.typeSelectBox.addActionListener(this);
        panel.add((Component)this.typeSelectBox, this.createBaseGBC(0, 1, 1, 1));
        panel.add((Component)this.createTextLabel("  \u4ec5\u7528\u524d"), this.createBaseGBC(0, 2, 1, 1));
        this.topNField = new JTextField();
        this.initTextField(this.topNField, "useTopN");
        GridBagConstraints gbc1 = this.createBaseGBC(0, 3, 1, 1);
        gbc1.weightx = 1.0;
        panel.add((Component)this.topNField, gbc1);
        panel.add((Component)this.createTextLabel("\u6761\u6570\u636e\u8bb0\u5f55\u6765\u753b\u7edf\u8ba1\u56fe"), this.createBaseGBC(0, 4, 1, 1));
        this.csPanel = new CSPanel(this.props);
        GridBagConstraints gbc3 = this.createBaseGBC(1, 0, 1, 5);
        gbc3.insets = new Insets(3, 3, 1, 0);
        gbc3.weighty = 1.0;
        gbc3.fill = 1;
        panel.add((Component)this.csPanel, gbc3);
        this.timeDSPanel = new JPanel(new GridBagLayout());
        this.timeDSPanel.setFont(this.baseFont);
        this.timeDSPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u65f6\u5e8f\u72b6\u6001\u56fe\u6570\u636e", 0, 0, this.baseFont));
        GridBagConstraints gbc4 = this.createBaseGBC(4, 0, 1, 5);
        gbc4.weightx = 1.0;
        gbc4.insets = new Insets(3, 5, 3, 3);
        panel.add((Component)this.timeDSPanel, gbc4);
        this.timeDSPanel.add((Component)this.createTextLabel("\u8d77\u59cb\u65f6\u95f4\u8868\u8fbe\u5f0f"), this.createBaseGBC(0, 0, 1, 1));
        this.statusStartTimeField = new JTextField();
        this.initTextField(this.statusStartTimeField, "statusStartTime");
        this.timeDSPanel.add((Component)this.statusStartTimeField, this.createBaseGBC(0, 1, 1, 1, true));
        this.timeDSPanel.add((Component)this.createTextLabel("\u7ed3\u675f\u65f6\u95f4\u8868\u8fbe\u5f0f"), this.createBaseGBC(1, 0, 1, 1));
        this.statusEndTimeField = new JTextField();
        this.initTextField(this.statusEndTimeField, "statusEndTime");
        this.timeDSPanel.add((Component)this.statusEndTimeField, this.createBaseGBC(1, 1, 1, 1, true));
        this.timeDSPanel.add((Component)this.createTextLabel("  \u5206\u7c7b\u8868\u8fbe\u5f0f"), this.createBaseGBC(0, 2, 1, 1));
        this.statusCategeryField = new JTextField();
        this.initTextField(this.statusCategeryField, "statusCategery");
        this.timeDSPanel.add((Component)this.statusCategeryField, this.createBaseGBC(0, 3, 1, 1, true));
        this.timeDSPanel.add((Component)this.createTextLabel("  \u72b6\u6001\u8868\u8fbe\u5f0f"), this.createBaseGBC(1, 2, 1, 1));
        this.statusStateField = new JTextField();
        this.initTextField(this.statusStateField, "statusState");
        this.timeDSPanel.add((Component)this.statusStateField, this.createBaseGBC(1, 3, 1, 1, true));
        return panel;
    }

    private JPanel createDefinePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 8));
        panel.add((Component)this.createTextLabel("\u7edf\u8ba1\u56fe\u6807\u9898"), this.createBaseGBC(0, 0, 1, 1));
        this.titleField = new JTextField();
        this.initTextField(this.titleField, "graphTitle");
        panel.add((Component)this.titleField, this.createBaseGBC(0, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("  \u6a2a\u8f74\u6807\u9898"), this.createBaseGBC(0, 2, 1, 1));
        this.xTitleField = new JTextField();
        this.initTextField(this.xTitleField, "xTitle");
        panel.add((Component)this.xTitleField, this.createBaseGBC(0, 3, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u7eb5\u8f74\u6807\u9898"), this.createBaseGBC(1, 0, 1, 1));
        this.yTitleField = new JTextField();
        this.initTextField(this.yTitleField, "yTitle");
        panel.add((Component)this.yTitleField, this.createBaseGBC(1, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("  \u56fe\u5f62\u683c\u5f0f"), this.createBaseGBC(1, 2, 1, 1));
        String format = this.props.getPropertyValue("graphFormat");
        if (format == null || format.trim().length() == 0) {
            format = "JPG";
        }
        this.graphFormatBox.setSelectedItem(format);
        this.graphFormatBox.setFont(this.baseFont);
        this.graphFormatBox.addActionListener(this);
        panel.add((Component)this.graphFormatBox, this.createBaseGBC(1, 3, 1, 1));
        panel.add((Component)this.createTextLabel("\u56fe\u4e2d\u663e\u793a\u6570\u636e"), this.createBaseGBC(2, 0, 1, 1));
        String displayData = this.props.getPropertyValue("displayValue");
        if (displayData == null || displayData.trim().length() == 0) {
            displayData = "1";
        }
        this.displayDataBox.setSelectedItem(DisplayDataBox.valueToDisp(displayData));
        panel.add((Component)this.displayDataBox, this.createBaseGBC(2, 1, 1, 1, true));
        JPanel cbPanel = new JPanel(new GridLayout(1, 2, 30, 0));
        this.graphTransparent = new JCheckBox("\u56fe\u5f62\u900f\u660e");
        this.initCheckBox(this.graphTransparent, "graphTransparent");
        cbPanel.add(this.graphTransparent);
        this.backTransparent = new JCheckBox("\u80cc\u666f\u900f\u660e");
        this.initCheckBox(this.backTransparent, "backTransparent");
        if (format.equals("JPG")) {
            this.backTransparent.setEnabled(false);
        }
        cbPanel.add(this.backTransparent);
        GridBagConstraints gbc1 = this.createBaseGBC(2, 2, 1, 2, true);
        gbc1.insets = new Insets(3, 10, 3, 5);
        panel.add((Component)cbPanel, gbc1);
        this.displayDataFormatLabel = this.createTextLabel("\u56fe\u4e2d\u663e\u793a\u6570\u636e\u683c\u5f0f");
        panel.add((Component)this.displayDataFormatLabel, this.createBaseGBC(4, 0, 1, 1));
        this.displayDataFormatField = new JTextField();
        this.initTextField(this.displayDataFormatField, "displayValueFormat");
        panel.add((Component)this.displayDataFormatField, this.createBaseGBC(4, 1, 1, 1, true));
        this.barIntervalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = this.createBaseGBC(4, 2, 1, 2, true);
        gbc2.insets = new Insets(3, 1, 3, 1);
        panel.add((Component)this.barIntervalPanel, gbc2);
        this.barIntervalPanel.add((Component)this.createTextLabel("  \u67f1\u5f62\u6216\u6761\u5f62\u56fe\u95f4\u8ddd"), this.createBaseGBC(0, 0, 1, 1));
        this.barIntervalField = new JTextField();
        this.initTextField(this.barIntervalField, "barDistance");
        this.barIntervalPanel.add((Component)this.barIntervalField, this.createBaseGBC(0, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u7edf\u8ba1\u503c\u8d77\u59cb\u503c"), this.createBaseGBC(5, 0, 1, 1));
        this.yStartField = new JTextField();
        this.initTextField(this.yStartField, "yStartValue");
        panel.add((Component)this.yStartField, this.createBaseGBC(5, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("  \u7edf\u8ba1\u503c\u7ed3\u675f\u503c"), this.createBaseGBC(5, 2, 1, 1));
        this.yEndField = new JTextField();
        this.initTextField(this.yEndField, "yEndValue");
        panel.add((Component)this.yEndField, this.createBaseGBC(5, 3, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u7edf\u8ba1\u503c\u6807\u7b7e\u95f4\u9694"), this.createBaseGBC(6, 0, 1, 1));
        this.yIntervalField = new JTextField();
        this.initTextField(this.yIntervalField, "yInterval");
        panel.add((Component)this.yIntervalField, this.createBaseGBC(6, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("  \u7edf\u8ba1\u503c\u5355\u4f4d"), this.createBaseGBC(6, 2, 1, 1));
        String unit = this.props.getPropertyValue("yUnit");
        if (unit == null || unit.trim().length() == 0) {
            unit = "1";
        }
        this.unitBox.setSelectedItem(UnitBox.valueToDisp(unit));
        panel.add((Component)this.unitBox, this.createBaseGBC(6, 3, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u7edf\u8ba1\u503c\u6700\u5c11\u523b\u5ea6\u6570"), this.createBaseGBC(7, 0, 1, 1));
        this.yMinMarksField = new JTextField();
        this.initTextField(this.yMinMarksField, "yMinMarks");
        panel.add((Component)this.yMinMarksField, this.createBaseGBC(7, 1, 1, 1, true));
        this.gridLineLabel = this.createTextLabel("  \u7f51\u683c\u7ebf\u98ce\u683c");
        panel.add((Component)this.gridLineLabel, this.createBaseGBC(7, 2, 1, 1));
        this.gridLineBox.addActionListener(this);
        panel.add((Component)this.gridLineBox, this.createBaseGBC(7, 3, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u6807\u9898\u4e0e\u56fe\u5f62\u7684\u95f4\u8ddd"), this.createBaseGBC(8, 0, 1, 1));
        this.marginField = new JTextField();
        this.initTextField(this.marginField, "margin");
        panel.add((Component)this.marginField, this.createBaseGBC(8, 1, 1, 1, true));
        this.alarmLinePanel = new AlarmLineTable(this.props);
        this.alarmLinePanel.setPreferredSize(new Dimension(100, 120));
        this.alarmLinePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u8b66\u6212\u7ebf", 0, 0, this.baseFont));
        GridBagConstraints gbc6 = this.createBaseGBC(9, 0, 1, 4);
        gbc6.insets = new Insets(3, 0, 3, 3);
        gbc6.weighty = 1.0;
        gbc6.fill = 1;
        panel.add((Component)this.alarmLinePanel, gbc6);
        return panel;
    }

    private JPanel createAppearancePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 8));
        panel.add((Component)this.createTextLabel("\u80cc\u666f\u989c\u8272"), this.createBaseGBC(0, 0, 1, 1));
        this.backColorBox = new ColorComboBox();
        this.initColorBox(this.backColorBox, "backColor");
        panel.add((Component)this.backColorBox, this.createBaseGBC(0, 1, 1, 1, true));
        panel.add((Component)this.createTextLabel("  \u5750\u6807\u7ebf\u989c\u8272"), this.createBaseGBC(0, 2, 1, 1));
        this.axisColorBox = new ColorComboBox();
        this.initColorBox(this.axisColorBox, "axisColor");
        panel.add((Component)this.axisColorBox, this.createBaseGBC(0, 3, 1, 1, true));
        this.gridLineColorLabel = this.createTextLabel("\u7f51\u683c\u7ebf\u989c\u8272");
        panel.add((Component)this.gridLineColorLabel, this.createBaseGBC(1, 0, 1, 1));
        this.gridLineColorBox = new ColorComboBox();
        this.initColorBox(this.gridLineColorBox, "gridLineColor");
        panel.add((Component)this.gridLineColorBox, this.createBaseGBC(1, 1, 1, 1, true));
        String gridLine = this.props.getPropertyValue("gridLineType");
        if (gridLine == null || gridLine.trim().length() == 0) {
            gridLine = "1";
        }
        this.gridLineBox.setSelectedItem(LineTypeBox.valueToDisp(gridLine));
        panel.add((Component)this.createTextLabel("  \u56fe\u4f8b\u4f4d\u7f6e"), this.createBaseGBC(1, 2, 1, 1));
        String legendLocation = this.props.getPropertyValue("legendLocation");
        if (legendLocation == null || legendLocation.trim().length() == 0) {
            legendLocation = "2";
        }
        this.legendLocationBox.setSelectedItem(LegendLocationBox.valueToDisp(legendLocation));
        panel.add((Component)this.legendLocationBox, this.createBaseGBC(1, 3, 1, 1, true));
        panel.add((Component)this.createTextLabel("\u7edf\u8ba1\u56fe\u914d\u8272\u65b9\u6848"), this.createBaseGBC(2, 0, 1, 1));
        Vector<String> v = new Vector<String>();
        try {
            Properties p = new Properties();
            p.load(this.getClass().getResourceAsStream("/color.properties"));
            Enumeration<?> em = p.propertyNames();
            while (em.hasMoreElements()) {
                String pName = (String)em.nextElement();
                pName = new String(pName.getBytes("iso8859-1"), "GBK");
                v.add(pName);
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        this.colorConfigBox = new JComboBox(v);
        String colorCfg = this.props.getPropertyValue("colorConfig");
        if (colorCfg == null || colorCfg.trim().length() == 0) {
            if (v.size() > 0) {
                this.colorConfigBox.setSelectedIndex(0);
            }
        } else {
            this.colorConfigBox.setSelectedItem(colorCfg);
        }
        this.colorConfigBox.setFont(this.baseFont);
        panel.add((Component)this.colorConfigBox, this.createBaseGBC(2, 1, 1, 1));
        panel.add((Component)this.createTextLabel("  \u8d85\u94fe\u63a5\u76ee\u6807\u7a97\u53e3"), this.createBaseGBC(2, 2, 1, 1));
        this.htmlLinkTargetField = new JTextField();
        this.initTextField(this.htmlLinkTargetField, "linkTarget");
        panel.add((Component)this.htmlLinkTargetField, this.createBaseGBC(2, 3, 1, 1));
        panel.add((Component)this.createTextLabel("\u56fe\u5f62\u8d85\u94fe\u63a5"), this.createBaseGBC(3, 0, 1, 1));
        this.htmlLinkField = new JTextField();
        this.initTextField(this.htmlLinkField, "link");
        GridBagConstraints gbc4 = this.createBaseGBC(3, 1, 1, 3);
        gbc4.weightx = 1.0;
        panel.add((Component)this.htmlLinkField, gbc4);
        this.fontTable = new FontEditTable(this.props);
        JScrollPane jsp = new JScrollPane(this.fontTable);
        jsp.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u5b57\u4f53\u8bbe\u7f6e", 0, 0, this.baseFont));
        GridBagConstraints gbc3 = this.createBaseGBC(5, 0, 1, 4);
        gbc3.insets = new Insets(3, 0, 3, 3);
        gbc3.fill = 1;
        gbc3.weighty = 1.0;
        panel.add((Component)jsp, gbc3);
        this.fontTable.getColumn("\u81ea\u52a8\u8c03\u6574\u5927\u5c0f").setMinWidth(80);
        return panel;
    }

    private JPanel createEspecialDefinePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 8));
        this.timeDefinePanel = new JPanel(new GridBagLayout());
        this.timeDefinePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u65f6\u5e8f\u72b6\u6001\u56fe", 0, 0, this.baseFont));
        GridBagConstraints gbc7 = this.createBaseGBC(0, 0, 1, 1, true);
        gbc7.insets = new Insets(3, 0, 3, 3);
        panel.add((Component)this.timeDefinePanel, gbc7);
        this.timeDefinePanel.add((Component)this.createTextLabel("\u72b6\u6001\u6761\u9ad8\u5ea6"), this.createBaseGBC(0, 0, 1, 1));
        this.statusBarHeightField = new JTextField();
        this.initTextField(this.statusBarHeightField, "statusBarHeight");
        this.timeDefinePanel.add((Component)this.statusBarHeightField, this.createBaseGBC(0, 1, 1, 1, true));
        this.timeDefinePanel.add((Component)this.createTextLabel("  \u65f6\u95f4\u523b\u5ea6\u9009\u62e9"), this.createBaseGBC(0, 2, 1, 1));
        String timeType = this.props.getPropertyValue("statusTimeType");
        if (timeType == null || timeType.trim().length() == 0) {
            timeType = "4";
        }
        this.timeTypeBox.setSelectedItem(TimeTypeBox.valueToDisp(timeType));
        this.timeDefinePanel.add((Component)this.timeTypeBox, this.createBaseGBC(0, 3, 1, 1, true));
        this.xAxisTable = new XAxisTable(this.props);
        this.xAxisTable.setPreferredSize(new Dimension(200, 150));
        this.xAxisTable.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "\u65f6\u95f4\u8d70\u52bf\u56fe\u6a2a\u8f74\u5750\u6807\u53d6\u503c", 0, 0, this.baseFont));
        GridBagConstraints gbc3 = this.createBaseGBC(3, 0, 1, 1, true);
        gbc3.insets = new Insets(3, 0, 3, 3);
        gbc3.fill = 1;
        panel.add((Component)this.xAxisTable, gbc3);
        GridBagConstraints gbc = this.createBaseGBC(5, 0, 1, 1);
        gbc.weighty = 1.0;
        panel.add((Component)new JPanel(), gbc);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        JComponent jc = (JComponent)e.getSource();
        if (jc.equals(this.okButton)) {
            TableCellEditor ce = this.fontTable.getCellEditor();
            if (ce != null) {
                ce.stopCellEditing();
            }
            this.alarmLinePanel.table.acceptText();
            this.xAxisTable.table.acceptText();
            if (!this.checkDataValid()) {
                return;
            }
            this.props.setPropertyValue("categoryExp", this.csPanel.getCategories());
            this.props.setPropertyValue("seriesValuesExp", this.csPanel.getSeries());
            this.props.setPropertyValue("graphFormat", (String)this.graphFormatBox.getSelectedItem());
            this.props.setPropertyValue("displayValue", DisplayDataBox.dispToValue((String)this.displayDataBox.getSelectedItem()));
            this.props.setPropertyValue("graphTransparent", this.graphTransparent.isSelected() ? "1" : "0");
            this.props.setPropertyValue("backTransparent", this.backTransparent.isSelected() ? "1" : "0");
            this.props.setPropertyValue("gridLineType", LineTypeBox.dispToValue((String)this.gridLineBox.getSelectedItem()));
            this.props.setPropertyValue("alarmLines", this.alarmLinePanel.toString());
            this.props.setPropertyValue("statusTimeType", TimeTypeBox.dispToValue((String)this.timeTypeBox.getSelectedItem()));
            this.props.setPropertyValue("backColor", "" + this.backColorBox.getColor());
            this.props.setPropertyValue("axisColor", "" + this.axisColorBox.getColor());
            this.props.setPropertyValue("gridLineColor", "" + this.gridLineColorBox.getColor());
            this.props.setPropertyValue("legendLocation", LegendLocationBox.dispToValue((String)this.legendLocationBox.getSelectedItem()));
            this.props.setPropertyValue("colorConfig", (String)this.colorConfigBox.getSelectedItem());
            this.props.setPropertyValue("yUnit", UnitBox.dispToValue((String)this.unitBox.getSelectedItem()));
            this.props.setPropertyValue("fonts", this.fontTable.toString());
            this.props.setPropertyValue("xValues", this.xAxisTable.toString());
            this.m_option = 0;
            this.dispose();
        } else if (jc.equals(this.cancelButton)) {
            this.m_option = 2;
            this.dispose();
        } else if (jc.equals(this.typeSelectBox)) {
            int type = this.typeSelectBox.getValue();
            this.props.setPropertyValue("type", String.valueOf(type));
            this.graphTypeChanged(type);
        } else if (jc.equals(this.gridLineBox)) {
            if (this.gridLineBox.getSelectedIndex() == 0) {
                this.gridLineColorLabel.setEnabled(false);
                this.gridLineColorBox.setEnabled(false);
            } else {
                this.gridLineColorLabel.setEnabled(true);
                this.gridLineColorBox.setEnabled(true);
            }
        } else if (jc.equals(this.graphFormatBox)) {
            String format = (String)this.graphFormatBox.getSelectedItem();
            this.backTransparent.setEnabled(!format.equals("JPG"));
        }
    }

    private JLabel createTextLabel(String text) {
        JLabel label = new JLabel(text);
        label.setFont(this.baseFont);
        return label;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        JComponent jc = (JComponent)e.getSource();
        if (jc.equals(this.topNField)) {
            if (!this.checkIntField(this.topNField, "\u4ec5\u7528\u524dX\u6761\u6570\u636e\u8bb0\u5f55\u6765\u753b\u7edf\u8ba1\u56fe")) {
                return;
            }
            this.props.setPropertyValue("useTopN", this.topNField.getText().trim());
        } else if (jc.equals(this.statusStartTimeField)) {
            if (this.isFieldEmpty(this.statusStartTimeField, "\u8bf7\u8f93\u5165\u8d77\u59cb\u65f6\u95f4\u8868\u8fbe\u5f0f!")) {
                return;
            }
            this.props.setPropertyValue("statusStartTime", this.statusStartTimeField.getText().trim());
        } else if (jc.equals(this.statusEndTimeField)) {
            if (this.isFieldEmpty(this.statusEndTimeField, "\u8bf7\u8f93\u5165\u7ed3\u675f\u65f6\u95f4\u8868\u8fbe\u5f0f!")) {
                return;
            }
            this.props.setPropertyValue("statusEndTime", this.statusEndTimeField.getText().trim());
        } else if (jc.equals(this.statusCategeryField)) {
            if (this.isFieldEmpty(this.statusCategeryField, "\u8bf7\u8f93\u5165\u5206\u7c7b\u8868\u8fbe\u5f0f!")) {
                return;
            }
            this.props.setPropertyValue("statusCategery", this.statusCategeryField.getText().trim());
        } else if (jc.equals(this.statusStateField)) {
            if (this.isFieldEmpty(this.statusStateField, "\u8bf7\u8f93\u5165\u72b6\u6001\u8868\u8fbe\u5f0f!")) {
                return;
            }
            this.props.setPropertyValue("statusState", this.statusStateField.getText().trim());
        } else if (jc.equals(this.titleField)) {
            this.props.setPropertyValue("graphTitle", this.titleField.getText().trim());
        } else if (jc.equals(this.xTitleField)) {
            this.props.setPropertyValue("xTitle", this.xTitleField.getText().trim());
        } else if (jc.equals(this.yTitleField)) {
            this.props.setPropertyValue("yTitle", this.yTitleField.getText().trim());
        } else if (jc.equals(this.barIntervalField)) {
            if (!this.checkIntField(this.barIntervalField, "\u67f1\u5f62\u6216\u6761\u5f62\u56fe\u95f4\u8ddd")) {
                return;
            }
            this.props.setPropertyValue("barDistance", this.barIntervalField.getText().trim());
        } else if (jc.equals(this.statusBarHeightField)) {
            if (!this.checkIntField(this.statusBarHeightField, "\u72b6\u6001\u6761\u9ad8\u5ea6")) {
                return;
            }
            this.props.setPropertyValue("statusBarHeight", this.statusBarHeightField.getText().trim());
        } else if (jc.equals(this.yStartField)) {
            if (!this.checkDoubleField(this.yStartField, "\u7edf\u8ba1\u503c\u8d77\u59cb\u503c")) {
                return;
            }
            this.props.setPropertyValue("yStartValue", this.yStartField.getText().trim());
        } else if (jc.equals(this.yEndField)) {
            if (!this.checkDoubleField(this.yEndField, "\u7edf\u8ba1\u503c\u7ed3\u675f\u503c")) {
                return;
            }
            this.props.setPropertyValue("yEndValue", this.yEndField.getText().trim());
        } else if (jc.equals(this.yIntervalField)) {
            if (!this.checkDoubleField(this.yIntervalField, "\u7edf\u8ba1\u503c\u6807\u7b7e\u95f4\u9694\u503c")) {
                return;
            }
            this.props.setPropertyValue("yInterval", this.yIntervalField.getText().trim());
        } else if (jc.equals(this.yMinMarksField)) {
            if (!this.checkIntField(this.yMinMarksField, "\u7edf\u8ba1\u503c\u6700\u5c11\u523b\u5ea6\u6570")) {
                return;
            }
            this.props.setPropertyValue("yMinMarks", this.yMinMarksField.getText().trim());
        } else if (jc.equals(this.marginField)) {
            if (!this.checkIntField(this.marginField, "\u6807\u9898\u4e0e\u56fe\u5f62\u7684\u95f4\u8ddd")) {
                return;
            }
            this.props.setPropertyValue("margin", this.marginField.getText().trim());
        } else if (jc.equals(this.htmlLinkField)) {
            this.props.setPropertyValue("link", this.htmlLinkField.getText().trim());
        } else if (jc.equals(this.htmlLinkTargetField)) {
            this.props.setPropertyValue("linkTarget", this.htmlLinkTargetField.getText().trim());
        } else if (jc.equals(this.displayDataFormatField)) {
            this.props.setPropertyValue("displayValueFormat", this.displayDataFormatField.getText().trim());
        }
    }

    private boolean isFieldEmpty(JTextField field, String msg) {
        return false;
    }

    private GridBagConstraints createBaseGBC(int rowIndex, int colIndex, int rowSpan, int colSpan, boolean xExtend) {
        GridBagConstraints gbc = this.createBaseGBC(rowIndex, colIndex, rowSpan, colSpan);
        if (xExtend) {
            gbc.weightx = 1.0;
        }
        return gbc;
    }

    private GridBagConstraints createBaseGBC(int rowIndex, int colIndex, int rowSpan, int colSpan) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = colIndex;
        gbc.gridy = rowIndex;
        gbc.gridwidth = colSpan;
        gbc.gridheight = rowSpan;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 3, 5);
        gbc.fill = 2;
        return gbc;
    }

    private void initTextField(JTextField field, String key) {
        String value = this.props.getPropertyValue(key);
        if (value != null) {
            field.setText(value);
        }
        field.addFocusListener(this);
    }

    private boolean checkDataValid() {
        switch (this.typeSelectBox.getValue()) {
            case 18: 
            case 23: {
                if (this.isFieldEmpty(this.statusStartTimeField, "\u8bf7\u8f93\u5165\u8d77\u59cb\u65f6\u95f4\u8868\u8fbe\u5f0f!")) {
                    return false;
                }
                if (this.isFieldEmpty(this.statusEndTimeField, "\u8bf7\u8f93\u5165\u7ed3\u675f\u65f6\u95f4\u8868\u8fbe\u5f0f!")) {
                    return false;
                }
                if (this.isFieldEmpty(this.statusCategeryField, "\u8bf7\u8f93\u5165\u5206\u7c7b\u8868\u8fbe\u5f0f!")) {
                    return false;
                }
                if (!this.isFieldEmpty(this.statusStateField, "\u8bf7\u8f93\u5165\u72b6\u6001\u8868\u8fbe\u5f0f!")) break;
                return false;
            }
        }
        return true;
    }

    private boolean checkIntField(JTextField field, String label) {
        return true;
    }

    private boolean checkDoubleField(JTextField field, String label) {
        return true;
    }

    private void showMessage(String msg) {
        Font msgFont = new Font("\u5b8b\u4f53", 0, 12);
        new MessageBox(this.pFrame, msg, Color.red, msgFont).show();
    }

    private void initButton(JButton button) {
        button.setFont(this.baseFont);
        button.addActionListener(this);
    }

    private void graphTypeChanged(int type) {
        switch (type) {
            case 18: 
            case 23: {
                this.setContainerEnabled(this.csPanel, false);
                this.setContainerEnabled(this.timeDSPanel, true);
                this.setContainerEnabled(this.timeDefinePanel, true);
                break;
            }
            default: {
                this.setContainerEnabled(this.csPanel, true);
                this.setContainerEnabled(this.timeDSPanel, false);
                this.setContainerEnabled(this.timeDefinePanel, false);
            }
        }
        this.setGridLineBoxEnabled(type);
        this.setBarDistanceEnabled(type);
        this.setAlarmLineEnabled(type);
        this.setTimeTrendDefineEnabled(type);
    }

    private void setContainerEnabled(Container container, boolean enabled) {
        Component[] child = container.getComponents();
        if (child.length == 0) {
            return;
        }
        int i = 0;
        while (i < child.length) {
            child[i].setEnabled(enabled);
            this.setContainerEnabled((Container)child[i], enabled);
            ++i;
        }
    }

    private void setGridLineBoxEnabled(int type) {
        switch (type) {
            case 13: 
            case 17: {
                this.gridLineLabel.setEnabled(false);
                this.gridLineBox.setEnabled(false);
                this.gridLineColorLabel.setEnabled(false);
                this.gridLineColorBox.setEnabled(false);
                break;
            }
            default: {
                this.gridLineLabel.setEnabled(true);
                this.gridLineBox.setEnabled(true);
                if (this.gridLineBox.getSelectedIndex() == 0) {
                    this.gridLineColorLabel.setEnabled(false);
                    this.gridLineColorBox.setEnabled(false);
                    break;
                }
                this.gridLineColorLabel.setEnabled(true);
                this.gridLineColorBox.setEnabled(true);
            }
        }
    }

    private void setBarDistanceEnabled(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.setContainerEnabled(this.barIntervalPanel, true);
                break;
            }
            default: {
                this.setContainerEnabled(this.barIntervalPanel, false);
            }
        }
    }

    private void setAlarmLineEnabled(int type) {
        switch (type) {
            case 3: 
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                this.setContainerEnabled(this.alarmLinePanel, false);
                break;
            }
            default: {
                this.setContainerEnabled(this.alarmLinePanel, true);
            }
        }
    }

    private void setTimeTrendDefineEnabled(int type) {
        this.setContainerEnabled(this.xAxisTable, type == 19);
    }

    private void initCheckBox(JCheckBox box, String key) {
        box.setFont(this.baseFont);
        String value = this.props.getPropertyValue(key);
        if (value != null && value.equals("1")) {
            box.setSelected(true);
        }
    }

    private void initColorBox(ColorComboBox box, String key) {
        String value = this.props.getPropertyValue(key);
        try {
            box.setSelectedItem(Integer.valueOf(value));
        }
        catch (Exception e) {
            if (key == "axisColor") {
                box.setSelectedItem(new Integer(Color.black.getRGB()));
            }
            if (key == "gridLineColor") {
                box.setSelectedItem(new Integer(Color.lightGray.getRGB()));
            }
            box.setSelectedItem(new Integer(Color.white.getRGB()));
        }
    }

    public int getOption() {
        return this.m_option;
    }

    public String getGraphProperty() {
        String exp = this.props.toString();
        exp = Escape.addEscAndQuote(exp);
        exp = "graph(" + exp + ")";
        return exp;
    }

    public void dispose() {
        super.dispose();
        this.baseFont = null;
        this.okButton = null;
        this.cancelButton = null;
        this.typeSelectBox = null;
        this.topNField = null;
        this.statusStartTimeField = null;
        this.statusEndTimeField = null;
        this.statusCategeryField = null;
        this.statusStateField = null;
        this.csPanel = null;
        this.timeDSPanel = null;
        this.titleField = null;
        this.xTitleField = null;
        this.yTitleField = null;
        this.graphFormatBox = null;
        this.displayDataBox = null;
        this.displayDataFormatLabel = null;
        this.displayDataFormatField = null;
        this.graphTransparent = null;
        this.backTransparent = null;
        this.gridLineBox = null;
        this.gridLineLabel = null;
        this.barIntervalPanel = null;
        this.barIntervalField = null;
        this.yStartField = null;
        this.yEndField = null;
        this.yIntervalField = null;
        this.yMinMarksField = null;
        this.unitBox = null;
        this.alarmLinePanel = null;
        this.backColorBox = null;
        this.axisColorBox = null;
        this.gridLineColorLabel = null;
        this.gridLineColorBox = null;
        this.legendLocationBox = null;
        this.fontTable = null;
        this.htmlLinkField = null;
        this.htmlLinkTargetField = null;
        this.timeDefinePanel = null;
        this.statusBarHeightField = null;
        this.timeTypeBox = null;
        this.xAxisTable = null;
    }
}

