/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.graph.GraphFont;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.graph.AlarmLine;
import com.runqian.report.graph.XAxisValue;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class GraphProperty {
    public static final String GRAPH_TYPE = "type";
    public static final String AXIS_COLOR = "axisColor";
    public static final String BACK_COLOR = "backColor";
    public static final String CATEGORY_EXP = "categoryExp";
    public static final String SERIES_VALUES_EXP = "seriesValuesExp";
    public static final String X_TITLE = "xTitle";
    public static final String Y_TITLE = "yTitle";
    public static final String GRAPH_TITLE = "graphTitle";
    public static final String GRID_LINE_TYPE = "gridLineType";
    public static final String GRID_LINE_COLOR = "gridLineColor";
    public static final String BAR_DISTANCE = "barDistance";
    public static final String GRAPH_FORMAT = "graphFormat";
    public static final String GRAPH_TRANSPARENT = "graphTransparent";
    public static final String BACK_TRANSPARENT = "backTransparent";
    public static final String USE_TOP_N = "useTopN";
    public static final String STATUS_STARTTIME = "statusStartTime";
    public static final String STATUS_ENDTIME = "statusEndTime";
    public static final String STATUS_CATEGERY = "statusCategery";
    public static final String STATUS_STATE = "statusState";
    public static final String STATUS_BARHEIGHT = "statusBarHeight";
    public static final String STATUS_TIMETYPE = "statusTimeType";
    public static final String GRAPH_FONTS = "fonts";
    public static final String ALARM_LINES = "alarmLines";
    public static final String GRAPH_DISPLAY_VALUE = "displayValue";
    public static final String GRAPH_DISPLAY_VALUE_FORMAT = "displayValueFormat";
    public static final String GRAPH_LINK = "link";
    public static final String GRAPH_LINK_TARGET = "linkTarget";
    public static final String GRAPH_LEGEND_LOCATION = "legendLocation";
    public static final String GRAPH_COLOR_CONFIG = "colorConfig";
    public static final String GRAPH_YSTARTVALUE = "yStartValue";
    public static final String GRAPH_YENDVALUE = "yEndValue";
    public static final String GRAPH_YINTERVAL = "yInterval";
    public static final String GRAPH_YUNIT = "yUnit";
    public static final String GRAPH_YMINMARKS = "yMinMarks";
    public static final String GRAPH_MARGIN = "margin";
    public static final String TIMETREND_XVALUES = "xValues";
    public static final String FONT_TITLE = "0";
    public static final String FONT_XTITLE = "1";
    public static final String FONT_YTITLE = "2";
    public static final String FONT_XLABEL = "3";
    public static final String FONT_YLABEL = "4";
    public static final String FONT_LEGEND = "5";
    public static final String FONT_DISPLAY_VALUE = "6";
    private SegmentSet props;

    public GraphProperty(String propsString) {
        this.props = propsString != null && propsString.trim().length() > 0 ? new SegmentSet(Escape.removeEscAndQuote(propsString), true, ',') : new SegmentSet("", true, ',');
    }

    public SegmentSet getProperties() {
        return this.props;
    }

    public void setPropertyValue(String key, String value) {
        if (value != null && value.trim().length() > 0) {
            value = Escape.addEscAndQuote(value, true);
        }
        this.props.put(key, value);
    }

    public String getPropertyValue(String key) {
        String value = this.props.get(key);
        if (value != null && value.trim().length() > 0) {
            value = Escape.removeEscAndQuote(value);
        }
        return value;
    }

    public String toString() {
        return this.props.toString(",");
    }

    public String[] getCategories() {
        String tmp = this.getPropertyValue(CATEGORY_EXP);
        if (tmp == null || tmp.trim().length() == 0) {
            return new String[0];
        }
        ArgumentTokenizer at = new ArgumentTokenizer(tmp, '|');
        String[] categories = new String[at.countTokens()];
        int row = 0;
        while (at.hasNext()) {
            categories[row] = at.nextToken();
            ++row;
        }
        return categories;
    }

    public String[][] getSeries() {
        String tmp = this.getPropertyValue(SERIES_VALUES_EXP);
        if (tmp == null || tmp.trim().length() == 0) {
            return new String[0][2];
        }
        ArgumentTokenizer at = new ArgumentTokenizer(tmp, '&');
        String[][] series = new String[at.countTokens()][2];
        int row = 0;
        while (at.hasNext()) {
            String sery = at.next();
            ArgumentTokenizer at1 = new ArgumentTokenizer(sery, '=');
            series[row][0] = at1.nextToken();
            series[row][1] = at1.nextToken();
            ++row;
        }
        return series;
    }

    public String[][] getSeries(String category) {
        if (category == null) {
            return new String[0][2];
        }
        String[] categories = this.getCategories();
        int index = -1;
        int i = 0;
        while (i < categories.length) {
            if (category.equalsIgnoreCase(categories[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return new String[0][2];
        }
        String tmp = this.getPropertyValue(SERIES_VALUES_EXP);
        if (tmp == null || tmp.trim().length() == 0) {
            return new String[0][2];
        }
        ArgumentTokenizer at = new ArgumentTokenizer(tmp, '|');
        try {
            int i2 = 0;
            while (i2 < index) {
                at.nextToken();
                ++i2;
            }
            at = new ArgumentTokenizer(at.nextToken(), '&');
        }
        catch (Throwable t) {
            return new String[0][2];
        }
        String[][] series = new String[at.countTokens()][2];
        int row = 0;
        while (at.hasNext()) {
            String sery = at.next();
            ArgumentTokenizer at1 = new ArgumentTokenizer(sery, '=');
            series[row][0] = at1.nextToken();
            series[row][1] = at1.nextToken();
            ++row;
        }
        return series;
    }

    public GraphFont getFont(String fontKey) {
        Hashtable<String, GraphFont> fonts = new Hashtable<String, GraphFont>();
        String fontsString = this.getPropertyValue(GRAPH_FONTS);
        if (fontsString == null) {
            fontsString = "";
        }
        SegmentSet segs = new SegmentSet(fontsString, '&');
        int i = 0;
        while (i < 7) {
            GraphFont font = new GraphFont();
            fonts.put(String.valueOf(i), font);
            String tmp = segs.get(String.valueOf(i));
            if (tmp != null && tmp.trim().length() != 0) {
                ArgumentTokenizer at = new ArgumentTokenizer(tmp, ',');
                font.setFamily(at.nextToken());
                font.setAutoResize(at.nextToken().equals(FONT_XTITLE));
                font.setSize(Integer.parseInt(at.nextToken()));
                font.setBold(at.nextToken().equals(FONT_XTITLE));
                font.setColor(Integer.valueOf(at.nextToken()));
                font.setVerticalText(at.nextToken().equals(FONT_XTITLE));
                font.setAngle(Integer.parseInt(at.nextToken()));
            }
            ++i;
        }
        return (GraphFont)fonts.get(fontKey);
    }

    public ArrayList getAlarmLines() {
        ArrayList<AlarmLine> lines = new ArrayList<AlarmLine>();
        String linesString = this.getPropertyValue(ALARM_LINES);
        if (linesString != null && linesString.trim().length() > 0) {
            SegmentSet segs = new SegmentSet(linesString, '&');
            Iterator it = segs.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                StringTokenizer st = new StringTokenizer(segs.get(name), ",");
                AlarmLine line = new AlarmLine();
                line.setName(name);
                line.setAlarmValue(st.nextToken());
                line.setLineType(st.nextToken());
                line.setColor(Integer.valueOf(st.nextToken()));
                lines.add(line);
            }
        }
        return lines;
    }

    public void setAlarmLines(ArrayList al) {
        String s = "";
        int i = 0;
        while (i < al.size()) {
            AlarmLine line = (AlarmLine)al.get(i);
            String str = String.valueOf(line.getName()) + "=";
            str = String.valueOf(str) + line.getAlarmValue();
            str = String.valueOf(str) + "," + line.getLineType();
            str = String.valueOf(str) + "," + line.getColor();
            if (s.length() > 0) {
                s = String.valueOf(s) + "&";
            }
            s = String.valueOf(s) + str;
            ++i;
        }
        this.setPropertyValue(ALARM_LINES, s);
    }

    public ArrayList getXAxisValues() {
        ArrayList<XAxisValue> values = new ArrayList<XAxisValue>();
        String str = this.getPropertyValue(TIMETREND_XVALUES);
        if (str != null && str.trim().length() > 0) {
            ArgumentTokenizer at = new ArgumentTokenizer(str, '/');
            while (at.hasMoreTokens()) {
                String tmp = at.nextToken();
                ArgumentTokenizer token = new ArgumentTokenizer(tmp, '\t');
                XAxisValue xav = new XAxisValue();
                xav.setStartValue(token.nextToken());
                xav.setEndValue(token.nextToken());
                xav.setSampleInterval(token.nextToken());
                xav.setMarkInterval(token.nextToken());
                values.add(xav);
            }
        }
        return values;
    }

    public void setXAxisValues(ArrayList values) {
        String s = "";
        int i = 0;
        while (i < values.size()) {
            XAxisValue value = (XAxisValue)values.get(i);
            String str = value.getStartValue();
            str = String.valueOf(str) + "\t" + value.getEndValue();
            str = String.valueOf(str) + "\t" + value.getSampleInterval();
            str = String.valueOf(str) + "\t" + value.getMarkInterval();
            if (s.length() > 0) {
                s = String.valueOf(s) + "/";
            }
            s = String.valueOf(s) + str;
            ++i;
        }
        this.setPropertyValue(TIMETREND_XVALUES, s);
    }
}

