/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.JTableEx;
import com.runqian.base.tool.MessageBox;
import com.runqian.base.util.ArgumentTokenizer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class SeriesTable
extends JPanel
implements ActionListener {
    public JTableEx table = new JTableEx();
    private JButton addButton;
    private JButton delButton;
    private Font font;
    String[] columnNames = new String[]{"\u7cfb\u5217\u540d\u79f0", "\u7cfb\u5217\u503c"};

    public SeriesTable(String[][] data) {
        this.table.setModel(new DefaultTableModel(data, this.columnNames));
        this.table.setRowHeight(20);
        this.setClickCountToStart();
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.table);
        this.add(jsp);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 8));
        panel.setPreferredSize(new Dimension(70, 50));
        this.font = new Font("\u5b8b\u4f53", 0, 12);
        this.addButton = new JButton("\u6dfb\u52a0");
        this.addButton.setFont(this.font);
        this.addButton.addActionListener(this);
        this.delButton = new JButton("\u5220\u9664");
        this.delButton.setFont(this.font);
        this.delButton.addActionListener(this);
        panel.add(this.addButton);
        panel.add(this.delButton);
        this.add((Component)panel, "East");
    }

    void changeModel(String[][] data) {
        this.table.setModel(new DefaultTableModel(data, this.columnNames));
        this.table.setRowHeight(20);
        this.setClickCountToStart();
    }

    private void setClickCountToStart() {
        int row = 0;
        while (row < this.table.getRowCount()) {
            int col = 0;
            while (col < this.table.getColumnCount()) {
                TableCellEditor editor = this.table.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                ++col;
            }
            ++row;
        }
    }

    public String toString() {
        String s = "";
        TableModel model = this.table.getModel();
        int rows = this.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String name = (String)model.getValueAt(row, 0);
            if (name != null && name.trim().length() != 0) {
                String lineString = String.valueOf(name) + "=";
                String value = (String)model.getValueAt(row, 1);
                if (value != null && value.trim().length() != 0) {
                    lineString = String.valueOf(lineString) + value;
                    if (s.length() > 0) {
                        s = String.valueOf(s) + "&";
                    }
                    s = String.valueOf(s) + lineString;
                }
            }
            ++row;
        }
        return s;
    }

    public String[][] toArray() {
        ArgumentTokenizer at = new ArgumentTokenizer(this.toString(), '&');
        String[][] series = new String[at.countTokens()][2];
        int row = 0;
        while (at.hasNext()) {
            String sery = at.next();
            ArgumentTokenizer at1 = new ArgumentTokenizer(sery, '=');
            series[row][0] = at1.nextToken();
            series[row][1] = at1.nextToken();
            ++row;
        }
        return series;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj.equals(this.addButton)) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"", ""});
            this.setClickCountToStart();
        } else if (obj.equals(this.delButton)) {
            int currRow = this.table.getSelectedRow();
            if (currRow < 0) {
                new MessageBox((JDialog)this.getTopLevelAncestor(), "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7cfb\u5217!", Color.red, this.font).show();
                return;
            }
            this.table.deleteSelectedRows();
        }
    }
}

