/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.graph;

import com.runqian.base.swing.JTableEx;
import com.runqian.base.tool.MessageBox;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.graph.TimeTypeBox;
import com.runqian.report.graph.TimestampEditor;
import com.runqian.report.graph.XAxisValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class XAxisTable
extends JPanel
implements ActionListener {
    JTableEx table;
    private JButton addButton;
    private JButton delButton;
    private Font font;

    public XAxisTable(GraphProperty gp) {
        Object[] columnNames = new String[]{"\u8d77\u59cb\u503c", "\u7ed3\u675f\u503c", "\u53d6\u6837\u95f4\u9694", "\u6807\u7b7e\u95f4\u9694"};
        ArrayList values = gp.getXAxisValues();
        Object[][] data = new Object[values.size()][4];
        int row = 0;
        while (row < values.size()) {
            XAxisValue xav = (XAxisValue)values.get(row);
            data[row][0] = xav.getStartValue();
            data[row][1] = xav.getEndValue();
            data[row][2] = TimeTypeBox.valueToDisp(xav.getSampleInterval());
            data[row][3] = TimeTypeBox.valueToDisp(xav.getMarkInterval());
            ++row;
        }
        this.table = new JTableEx();
        this.table.setModel(new DefaultTableModel(data, columnNames));
        this.table.setRowHeight(20);
        TableColumn column = this.table.getColumn("\u53d6\u6837\u95f4\u9694");
        column.setMaxWidth(60);
        column.setCellEditor(new DefaultCellEditor(new TimeTypeBox()));
        column = this.table.getColumn("\u6807\u7b7e\u95f4\u9694");
        column.setMaxWidth(60);
        column.setCellEditor(new DefaultCellEditor(new TimeTypeBox()));
        column = this.table.getColumn("\u8d77\u59cb\u503c");
        column.setCellEditor(new TimestampEditor(new JTextField()));
        column = this.table.getColumn("\u7ed3\u675f\u503c");
        column.setCellEditor(new TimestampEditor(new JTextField()));
        this.setClickCountToStart();
        this.setLayout(new BorderLayout());
        JScrollPane jsp = new JScrollPane(this.table);
        this.add(jsp);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 8));
        panel.setPreferredSize(new Dimension(70, 50));
        this.font = new Font("\u5b8b\u4f53", 0, 12);
        this.addButton = new JButton("\u6dfb\u52a0");
        this.addButton.setFont(this.font);
        this.addButton.addActionListener(this);
        this.delButton = new JButton("\u5220\u9664");
        this.delButton.setFont(this.font);
        this.delButton.addActionListener(this);
        panel.add(this.addButton);
        panel.add(this.delButton);
        this.add((Component)panel, "East");
    }

    private void setClickCountToStart() {
        int row = 0;
        while (row < this.table.getRowCount()) {
            int col = 0;
            while (col < this.table.getColumnCount()) {
                TableCellEditor editor = this.table.getCellEditor(row, col);
                if (editor != null && editor instanceof DefaultCellEditor) {
                    ((DefaultCellEditor)editor).setClickCountToStart(1);
                }
                ++col;
            }
            ++row;
        }
    }

    public String toString() {
        String s = "";
        TableModel model = this.table.getModel();
        int rows = this.table.getRowCount();
        int row = 0;
        while (row < rows) {
            String str = model.getValueAt(row, 0).toString();
            str = String.valueOf(str) + "\t" + model.getValueAt(row, 1).toString();
            str = String.valueOf(str) + "\t" + TimeTypeBox.dispToValue(model.getValueAt(row, 2).toString());
            str = String.valueOf(str) + "\t" + TimeTypeBox.dispToValue(model.getValueAt(row, 3).toString());
            if (s.length() > 0) {
                s = String.valueOf(s) + "/";
            }
            s = String.valueOf(s) + str;
            ++row;
        }
        return s;
    }

    public void actionPerformed(ActionEvent e) {
        Object obj;
        TableCellEditor editor = this.table.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((obj = e.getSource()).equals(this.addButton)) {
            ((DefaultTableModel)this.table.getModel()).addRow(new Object[]{"", "", "\u5206", "\u65f6"});
            this.setClickCountToStart();
        } else if (obj.equals(this.delButton)) {
            int currRow = this.table.getSelectedRow();
            if (currRow < 0) {
                new MessageBox((JDialog)this.getTopLevelAncestor(), "\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u53d6\u503c!", Color.red, this.font).show();
                return;
            }
            ((DefaultTableModel)this.table.getModel()).removeRow(currRow);
        }
    }

    public static void main(String[] a) {
        final XAxisTable panel = new XAxisTable(new GraphProperty(""));
        JFrame f = new JFrame();
        f.setSize(500, 400);
        f.getContentPane().add(panel);
        JButton b = new JButton("ok");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, panel.toString());
            }
        });
        f.getContentPane().add((Component)b, "South");
        f.show();
    }
}

