/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.usermodel.Report;
import com.runqian.report.view.excel.ExcelReport;
import com.runqian.report.view.html.HtmlReport;
import com.runqian.report.view.pdf.PdfReport;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;

public class CellSetConverter {
    private CellSet csSrc;
    private String toFile;
    private int fileType;

    public CellSetConverter(CellSet cs, HashMap setting) {
        this.csSrc = (CellSet)cs.clone();
        this.toFile = (String)setting.get("FileName");
        this.fileType = (Integer)setting.get("FileType");
    }

    private void toHtml() throws Exception {
        HtmlReport hr = new HtmlReport(this.csSrc, this.toFile, "", null);
        String syntax = hr.generateHtml();
        PrintWriter pw = new PrintWriter(new FileOutputStream(this.toFile));
        pw.print(syntax);
        pw.flush();
        pw.close();
    }

    private void toExcel() throws Exception {
        ExcelReport er = new ExcelReport(this.csSrc, 999999999, 999999999);
        FileOutputStream fos = new FileOutputStream(this.toFile);
        er.out(fos);
        fos.flush();
        fos.close();
    }

    private void toExcelPage() throws Exception {
        ExcelReport er = new ExcelReport(this.csSrc);
        FileOutputStream fos = new FileOutputStream(this.toFile);
        er.out(fos);
        fos.flush();
        fos.close();
    }

    private void toText() throws Exception {
        Report er = new Report(this.csSrc);
        FileOutputStream fos = new FileOutputStream(this.toFile);
        er.exportToText(fos);
        fos.flush();
        fos.close();
    }

    private void toPdf() throws Exception {
        PdfReport pr = new PdfReport(this.csSrc);
        FileOutputStream fos = new FileOutputStream(this.toFile);
        pr.out(fos);
        fos.flush();
        fos.close();
    }

    public void convert() throws Throwable {
        switch (this.fileType) {
            case 175: {
                this.toExcel();
                break;
            }
            case 176: {
                this.toExcelPage();
                break;
            }
            case 185: {
                this.toPdf();
                break;
            }
            case 188: {
                this.toText();
                break;
            }
            case 180: {
                this.toHtml();
            }
        }
    }
}

