/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.LimitedStack;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.ide.AppOption;
import com.runqian.report.ide.MessageDispatcher;
import com.runqian.report.ide.ReportEditor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

class CmdUndoManager {
    LimitedStack undoContainer = new LimitedStack(AppOption.stackVolumn);
    LimitedStack redoContainer = new LimitedStack(AppOption.stackVolumn);
    ReportEditor mEditor;
    private final int CMD_SET_VALUE = 0;
    private final int CMD_SET_EXPRESSION = 1;
    private final int CMD_SET_MAP_PROPERTY = 2;
    private final int CMD_SET_COLUMN = 3;
    private final int CMD_SET_ROW = 4;
    private final int CMD_MOVE_CELL = 5;
    private final int CMD_SET_ADDROW = 6;
    private final int CMD_SET_ADDCOL = 7;

    public CmdUndoManager(ReportEditor editor) {
        this.mEditor = editor;
    }

    public long undo() {
        if (this.undoContainer.empty()) {
            return 0L;
        }
        Vector cmds = (Vector)this.undoContainer.pop();
        return this.executeCommands(cmds, this.redoContainer);
    }

    public long redo() {
        if (this.redoContainer.empty()) {
            return 0L;
        }
        Vector cmds = (Vector)this.redoContainer.pop();
        return this.executeCommands(cmds, this.undoContainer);
    }

    public long doing(Vector microCmds) {
        this.redoContainer.clear();
        return this.executeCommands(microCmds, this.undoContainer);
    }

    Vector reverseVector(Vector v) {
        Vector rv = new Vector();
        int i = v.size() - 1;
        while (i >= 0) {
            rv.add(v.get(i));
            --i;
        }
        return rv;
    }

    private long executeCommands(Vector cmds, LimitedStack stack) {
        Vector<HashMap> vReverseCmds = new Vector<HashMap>();
        this.mEditor.editControl.setAutoRepaint(false);
        int i = 0;
        while (i < cmds.size()) {
            if (i == cmds.size() - 1) {
                this.mEditor.editControl.setAutoRepaint(true);
            }
            HashMap cmd = (HashMap)cmds.get(i);
            HashMap revCmd = this.doCommand(cmd);
            vReverseCmds.add(revCmd);
            ++i;
        }
        stack.push(this.reverseVector(vReverseCmds));
        this.mEditor.isDataChanged = true;
        this.refreshMenu();
        return 1L;
    }

    public void refreshMenu() {
        try {
            this.mEditor.message.setConsumer((short)2);
            this.mEditor.message.setName(1400);
            this.mEditor.menuStatus.clear();
            this.mEditor.menuStatus.put(205, new Boolean(!this.undoContainer.empty()));
            this.mEditor.menuStatus.put(210, new Boolean(!this.redoContainer.empty()));
            this.mEditor.menuStatus.put(125, new Boolean(this.mEditor.isDataChanged));
            this.mEditor.message.setArgument(this.mEditor.menuStatus);
            MessageDispatcher.send(this.mEditor.message);
        }
        catch (Throwable t) {
            Tools.showException(t);
        }
    }

    private HashMap doCommand(HashMap cmd) {
        int command = (Integer)cmd.get("Command");
        Object reverseValue = null;
        switch (command) {
            case 0: {
                CellPosition cp = (CellPosition)cmd.get("UnitCell");
                Object propertyName = cmd.get("PropertyName");
                Object propertyValue = cmd.get("PropertyValue");
                reverseValue = this.mEditor.editControl.setCellPropertyValue(cp, (Integer)propertyName, propertyValue);
                cmd.put("PropertyValue", reverseValue);
                break;
            }
            case 1: {
                CellPosition cp = (CellPosition)cmd.get("UnitCell");
                int propertyName = (Integer)cmd.get("PropertyName");
                Object propertyValue = cmd.get("PropertyValue");
                reverseValue = this.mEditor.editControl.setCellPropertyExpression(cp, propertyName, (String)propertyValue);
                cmd.put("PropertyValue", reverseValue);
                break;
            }
            case 2: {
                CellPosition cp = (CellPosition)cmd.get("UnitCell");
                IntHashtable propertyMap = (IntHashtable)cmd.get("PropertyMap");
                reverseValue = propertyMap == null ? this.mEditor.editControl.setCellPropertyMap(cp, null) : this.mEditor.editControl.setCellPropertyMap(cp.getRow(), cp.getColumn(), propertyMap);
                cmd.put("PropertyMap", reverseValue);
                break;
            }
            case 3: {
                int c = (Integer)cmd.get("ColumnIndex");
                Vector columnPropertyMaps = (Vector)cmd.get("ColumnPropertyMaps");
                if (columnPropertyMaps == null) {
                    reverseValue = this.mEditor.editControl.removeColumn(c);
                } else {
                    this.mEditor.editControl.insertColumn(c, columnPropertyMaps);
                    reverseValue = null;
                }
                cmd.put("ColumnPropertyMaps", reverseValue);
                break;
            }
            case 7: {
                Vector colPropertyMaps = (Vector)cmd.get("ColumnPropertyMaps");
                this.mEditor.editControl.insertColumn(this.mEditor.editControl.getColumnCount() + 1, colPropertyMaps);
                reverseValue = null;
                cmd.put("ColumnPropertyMaps", reverseValue);
                break;
            }
            case 4: {
                int r = (Integer)cmd.get("RowIndex");
                Vector rowPropertyMaps = (Vector)cmd.get("RowPropertyMaps");
                if (rowPropertyMaps == null) {
                    reverseValue = this.mEditor.editControl.removeRow(r);
                } else {
                    this.mEditor.editControl.insertRow(r, rowPropertyMaps);
                    reverseValue = null;
                }
                cmd.put("RowPropertyMaps", reverseValue);
                break;
            }
            case 6: {
                Vector PropertyMaps = (Vector)cmd.get("RowPropertyMaps");
                int curRow = this.mEditor.editControl.getRowCount() + 1;
                this.mEditor.editControl.insertRow(curRow, PropertyMaps);
                reverseValue = null;
                cmd.put("RowPropertyMaps", reverseValue);
                break;
            }
            case 5: {
                CellRegion regionFrom = (CellRegion)cmd.get("From");
                CellRegion regionTo = (CellRegion)cmd.get("To");
                HashMap mapOfFrom = (HashMap)cmd.get("FromMaps");
                HashMap mapOfTo = (HashMap)cmd.get("ToMaps");
                Vector<CellRegion> regions = new Vector<CellRegion>();
                regions.add(regionFrom);
                HashSet fromCells = this.mEditor.getSelectedCells(regions, 6, false);
                HashMap oldMapOfFrom = this.getMultiCellMaps(fromCells);
                regions.setSize(0);
                regions.add(regionTo);
                HashSet toCells = this.mEditor.getSelectedCells(regions, 6, true);
                HashMap oldMapOfTo = this.getMultiCellMaps(toCells);
                if (mapOfFrom == null) {
                    int dRow = regionTo.getTop() - regionFrom.getTop();
                    int dCol = regionTo.getLeft() - regionFrom.getLeft();
                    this.setMultiCellMaps(mapOfFrom, dRow, dCol);
                    this.clearRegion(regionFrom);
                } else {
                    this.setMultiCellMaps(mapOfFrom, 0, 0);
                    this.setMultiCellMaps(mapOfTo, 0, 0);
                }
                cmd.put("MapFrom", oldMapOfFrom);
                cmd.put("MapTo", oldMapOfTo);
            }
        }
        return cmd;
    }

    public Vector getSetMapProperty(HashMap cellPropertyMap) {
        Vector cmds = new Vector();
        Iterator it = cellPropertyMap.keySet().iterator();
        while (it.hasNext()) {
            CellPosition unitCell = (CellPosition)it.next();
            HashMap<String, Comparable<Integer>> cmd = new HashMap<String, Comparable<Integer>>();
            cmd.put("Command", new Integer(2));
            cmd.put("UnitCell", unitCell);
            cmd.put("PropertyMap", (Comparable<Integer>)cellPropertyMap.get(unitCell));
            cmds.add(cmd);
        }
        return cmds;
    }

    public long setMapProperty(HashMap cellPropertyMap) {
        return this.doing(this.getSetMapProperty(cellPropertyMap));
    }

    public long clearMapProperty(HashSet cells) {
        Vector cmds = new Vector();
        Iterator it = cells.iterator();
        while (it.hasNext()) {
            CellPosition unitCell = (CellPosition)it.next();
            HashMap<String, Object> cmd = new HashMap<String, Object>();
            cmd.put("Command", new Integer(2));
            cmd.put("UnitCell", unitCell);
            this.mEditor.editControl.getCellSet();
            cmd.put("PropertyMap", CellSet.createDefaultPropertyMap());
            cmds.add(cmd);
        }
        return this.doing(cmds);
    }

    public long setPropertyValue(HashSet cells, IntHashtable propertyPairs) {
        if (cells == null || propertyPairs == null) {
            return -1L;
        }
        Vector cmdToBeExcuted = this.setProperties(new Integer(0), cells, propertyPairs);
        return this.doing(cmdToBeExcuted);
    }

    public Vector getSetPropertyValue(HashSet cells, IntHashtable propertyPairs) {
        if (cells == null || propertyPairs == null) {
            return null;
        }
        Vector cmdToBeExcuted = this.setProperties(new Integer(0), cells, propertyPairs);
        return cmdToBeExcuted;
    }

    public long setPropertyValue(HashMap settings) {
        Vector cmdToBeExcuted = new Vector();
        Iterator it = settings.keySet().iterator();
        while (it.hasNext()) {
            HashSet cells = (HashSet)it.next();
            IntHashtable properties = (IntHashtable)settings.get(cells);
            cmdToBeExcuted.addAll(this.setProperties(new Integer(0), cells, properties));
        }
        return this.doing(cmdToBeExcuted);
    }

    public long setPropertyExpression(HashSet cells, IntHashtable propertyPairs) {
        Vector cmdToBeExcuted = this.setProperties(new Integer(1), cells, propertyPairs);
        return this.doing(cmdToBeExcuted);
    }

    public Vector getSetPropertyExpression(HashSet cells, IntHashtable propertyPairs) {
        Vector cmdToBeExcuted = this.setProperties(new Integer(1), cells, propertyPairs);
        return cmdToBeExcuted;
    }

    private Vector setProperties(Integer cmdType, HashSet cells, IntHashtable propertyPairs) {
        Vector cmds = new Vector();
        Iterator it = cells.iterator();
        while (it.hasNext()) {
            CellPosition unitCell = (CellPosition)it.next();
            IntHashtable.Enumerator propertyNames = propertyPairs.keys();
            while (propertyNames.hasMoreElements()) {
                int propertyName = propertyNames.nextElement();
                Object propertyValue = propertyPairs.get(propertyName);
                HashMap<String, Object> cmd = new HashMap<String, Object>();
                cmd.put("Command", cmdType);
                cmd.put("UnitCell", unitCell);
                cmd.put("PropertyName", new Integer(propertyName));
                cmd.put("PropertyValue", propertyValue);
                cmds.add(cmd);
            }
        }
        return cmds;
    }

    public long insertColumn(Integer columnIndex, int copies) {
        Vector cmds = new Vector();
        Vector emptyMaps = new Vector();
        int i = 0;
        while (i < copies) {
            HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
            cmd.put("Command", new Integer(3));
            cmd.put("ColumnIndex", columnIndex);
            cmd.put("ColumnPropertyMaps", emptyMaps);
            cmds.add(cmd);
            ++i;
        }
        return this.doing(cmds);
    }

    public long deleteColumns(HashSet columnIndexes) {
        Vector cmds = new Vector();
        Integer cmdType = new Integer(3);
        Iterator it = columnIndexes.iterator();
        while (it.hasNext()) {
            HashMap<String, Integer> cmd = new HashMap<String, Integer>();
            cmd.put("Command", cmdType);
            cmd.put("ColumnIndex", (Integer)it.next());
            cmds.add(cmd);
        }
        return this.doing(cmds);
    }

    public long deleteColumns(Vector columnIndexes) {
        Vector cmds = new Vector();
        Integer cmdType = new Integer(3);
        int i = columnIndexes.size() - 1;
        while (i >= 0) {
            HashMap<String, Integer> cmd = new HashMap<String, Integer>();
            cmd.put("Command", cmdType);
            cmd.put("ColumnIndex", (Integer)columnIndexes.get(i));
            cmds.add(cmd);
            --i;
        }
        return this.doing(cmds);
    }

    public long insertRow(Integer rowIndex, int insertRowNumber) {
        Vector cmds = new Vector();
        Vector emptyMaps = new Vector();
        int i = 0;
        while (i < insertRowNumber) {
            HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
            cmd.put("Command", new Integer(4));
            cmd.put("RowIndex", rowIndex);
            cmd.put("RowPropertyMaps", emptyMaps);
            cmds.add(cmd);
            ++i;
        }
        return this.doing(cmds);
    }

    public long addRow() {
        Vector cmds = new Vector();
        Vector emptyMaps = new Vector();
        HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
        cmd.put("Command", new Integer(6));
        cmd.put("RowPropertyMaps", emptyMaps);
        cmds.add(cmd);
        return this.doing(cmds);
    }

    public long addCol() {
        Vector cmds = new Vector();
        Vector emptyMaps = new Vector();
        HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
        cmd.put("Command", new Integer(7));
        cmd.put("ColumnPropertyMaps", emptyMaps);
        cmds.add(cmd);
        return this.doing(cmds);
    }

    public long deleteRows(HashSet rowIndexes) {
        Vector cmds = new Vector();
        Integer cmdType = new Integer(4);
        Iterator it = rowIndexes.iterator();
        while (it.hasNext()) {
            HashMap<String, Integer> cmd = new HashMap<String, Integer>();
            cmd.put("Command", cmdType);
            cmd.put("RowIndex", (Integer)it.next());
            cmds.add(cmd);
        }
        return this.doing(cmds);
    }

    public long deleteRows(Vector rowIndexes) {
        Vector cmds = new Vector();
        Integer cmdType = new Integer(4);
        int i = rowIndexes.size() - 1;
        while (i >= 0) {
            HashMap<String, Integer> cmd = new HashMap<String, Integer>();
            cmd.put("Command", cmdType);
            cmd.put("RowIndex", (Integer)rowIndexes.get(i));
            cmds.add(cmd);
            --i;
        }
        return this.doing(cmds);
    }

    public long moveCells(CellRegion regionFrom, CellRegion regionTo) {
        Vector cmds = new Vector();
        HashMap<String, Serializable> cmd = new HashMap<String, Serializable>();
        cmd.put("Command", new Integer(5));
        cmd.put("From", regionFrom);
        cmd.put("To", regionTo);
        cmds.add(cmd);
        return this.doing(cmds);
    }

    private HashMap getMultiCellMaps(HashSet cells) {
        HashMap<CellPosition, IntHashtable> mapPairs = new HashMap<CellPosition, IntHashtable>();
        Iterator it = cells.iterator();
        while (it.hasNext()) {
            CellPosition unitCell = (CellPosition)it.next();
            IntHashtable tmpMap = this.mEditor.editControl.getCellPropertyMap(unitCell);
            mapPairs.put(unitCell, tmpMap);
        }
        return mapPairs;
    }

    private long setMultiCellMaps(HashMap mapPairs, int dRow, int dCol) {
        Iterator it = mapPairs.keySet().iterator();
        while (it.hasNext()) {
            CellPosition unitCell = (CellPosition)it.next();
            IntHashtable tmpMap = (IntHashtable)mapPairs.get(unitCell);
            this.mEditor.editControl.setCellPropertyMap(unitCell.getRow() + dRow, unitCell.getColumn() + dCol, tmpMap);
        }
        return 1L;
    }

    public void clearcmd() {
        this.undoContainer.clear();
        this.redoContainer.clear();
    }

    private long clearRegion(CellRegion region) {
        Vector<CellRegion> regions = new Vector<CellRegion>();
        regions.add(region);
        HashSet allCells = this.mEditor.getSelectedCells(regions, 6, true);
        Iterator it = allCells.iterator();
        while (it.hasNext()) {
            CellPosition cellPosition = (CellPosition)it.next();
        }
        return 1L;
    }
}

