/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.ide.SheetTransfer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelImporter {
    private HSSFSheet[] sheets;
    private String[] sheetNames;
    private String[] fileNames;
    private HSSFFont[] fonts;
    private String excelFile;

    public ExcelImporter(String excelFile) throws Exception {
        this.excelFile = excelFile;
        FileInputStream fis = new FileInputStream(excelFile);
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)fis);
        fis.close();
        ArrayList<HSSFSheet> al = new ArrayList<HSSFSheet>();
        ArrayList<String> al_names = new ArrayList<String>();
        int i = 0;
        while (i < wb.getNumberOfSheets()) {
            HSSFSheet sheet = wb.getSheetAt(i);
            if (sheet.getLastRowNum() != 0) {
                al.add(sheet);
                al_names.add(wb.getSheetName(i));
            }
            ++i;
        }
        if (al.size() == 0) {
            throw new Exception("\u6587\u4ef6" + excelFile + "\u4e2d\u6ca1\u6709\u5185\u5bb9!");
        }
        this.sheets = new HSSFSheet[al.size()];
        this.sheetNames = new String[al.size()];
        this.fileNames = new String[al.size()];
        i = 0;
        while (i < this.sheets.length) {
            this.sheets[i] = (HSSFSheet)al.get(i);
            this.sheetNames[i] = (String)al_names.get(i);
            ++i;
        }
        this.fonts = new HSSFFont[wb.getNumberOfFonts() + 1];
        i = 0;
        while (i < this.fonts.length) {
            this.fonts[i] = wb.getFontAt((short)i);
            ++i;
        }
    }

    public CellSet getCellSet(int sheetIndex) {
        SheetTransfer st = new SheetTransfer(this.sheets[sheetIndex], this.fonts);
        return st.toCellSet();
    }

    public String[] saveTo(String raqDir) throws Exception {
        String prefix;
        int pos;
        if (!(raqDir = Sentence.replace(raqDir, "\\", "/", 1)).endsWith("/")) {
            raqDir = String.valueOf(raqDir) + "/";
        }
        if ((pos = (prefix = this.excelFile).lastIndexOf(".")) >= 0) {
            prefix = prefix.substring(0, pos);
        }
        if ((pos = (prefix = Sentence.replace(prefix, "\\", "/", 1)).lastIndexOf("/")) >= 0) {
            prefix = prefix.substring(pos + 1);
        }
        if (this.sheets.length == 1) {
            String raqFile = String.valueOf(raqDir) + prefix + ".raq";
            this.fileNames[0] = this.save(this.sheets[0], raqFile);
        } else {
            int i = 0;
            while (i < this.sheets.length) {
                HSSFSheet sheet = this.sheets[i];
                String raqFile = String.valueOf(raqDir) + prefix + "_" + this.sheetNames[i] + ".raq";
                this.fileNames[i] = this.save(sheet, raqFile);
                ++i;
            }
        }
        return this.fileNames;
    }

    private String save(HSSFSheet sheet, String raqFile) throws Exception {
        File file = new File(raqFile);
        if (file.exists() && JOptionPane.showConfirmDialog(null, "\u6587\u4ef6" + raqFile + "\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f") == 1) {
            int i = 1;
            while (i < 100) {
                String tmp = raqFile.substring(0, raqFile.lastIndexOf("."));
                if (!new File(tmp = String.valueOf(tmp) + "_" + i + ".raq").exists()) {
                    raqFile = tmp;
                    break;
                }
                ++i;
            }
        }
        SheetTransfer st = new SheetTransfer(sheet, this.fonts);
        st.toCellSet();
        st.save(raqFile);
        return raqFile;
    }
}

