/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.tool.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;

public class PrintPreview
extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected int m_orientation;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;

    public PrintPreview(Printable target) {
        this(target, "\u6253\u5370\u9884\u89c8", 1);
    }

    public PrintPreview(Printable target, String title, int orientation) {
        super(title);
        this.setSize(600, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_target = target;
        this.m_orientation = orientation;
        JToolBar tb = new JToolBar();
        JButton bt = new JButton("\u6253\u5370", new ImageIcon("print.gif"));
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    PageFormat pageFormat = prnJob.defaultPage();
                    pageFormat.setOrientation(PrintPreview.this.m_orientation);
                    prnJob.setPrintable(PrintPreview.this.m_target, pageFormat);
                    if (!prnJob.printDialog()) {
                        return;
                    }
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                    prnJob.print();
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                    PrintPreview.this.dispose();
                }
                catch (PrinterException ex) {
                    Tools.showException(ex);
                }
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(4, 6, 4, 6));
        tb.add(bt);
        bt = new JButton("\u5173\u95ed");
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(4, 6, 4, 6));
        tb.add(bt);
        String[] scales = new String[]{"10 %", "25 %", "50 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(scales);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        String str = 3.access$0(this.this$1).m_cbScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = 3.access$0(this.this$1).m_wPage * scale / 100;
                        int h = 3.access$0(this.this$1).m_hPage * scale / 100;
                        Component[] comps = 3.access$0(this.this$1).m_preview.getComponents();
                        int k = 0;
                        while (k < comps.length) {
                            if (comps[k] instanceof PagePreview) {
                                PagePreview pp = (PagePreview)comps[k];
                                pp.setScaledSize(w, h);
                            }
                            ++k;
                        }
                        3.access$0(this.this$1).m_preview.doLayout();
                        3.access$0(this.this$1).m_preview.getParent().getParent().validate();
                    }
                };
                runner.start();
            }

            static /* synthetic */ PrintPreview access$0(3 var0) {
                return var0.PrintPreview.this;
            }
        };
        this.m_cbScale.addActionListener(lst);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        tb.addSeparator();
        tb.add(this.m_cbScale);
        this.getContentPane().add((Component)tb, "North");
        this.m_preview = new PreviewContainer();
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        pageFormat.setOrientation(this.m_orientation);
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("\u65e0\u6cd5\u786e\u5b9a\u9ed8\u8ba4\u6253\u5370\u9875\u5927\u5c0f");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int scale = 10;
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (target.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.m_preview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            Tools.showException(e);
        }
        JScrollPane ps = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)ps, "Center");
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    class PreviewContainer
    extends JPanel {
        protected int H_GAP = 16;
        protected int V_GAP = 10;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            int k = 0;
            while (k < nRow) {
                int m = 0;
                while (m < nCol) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                    ++m;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
                ++k;
            }
        }
    }

    class PagePreview
    extends JPanel {
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }
}

