/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.module.DataSource;
import com.runqian.base.module.DataSourceListModel;
import com.runqian.base.swing.VFlowLayout;
import com.runqian.base.tool.AppTools;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Tools;
import com.runqian.base.tool.XMLFile;
import com.runqian.base.util.Console;
import com.runqian.base.util.LLObject;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.engine.FunctionLib;
import com.runqian.report.ide.AppOption;
import com.runqian.report.ide.EditToolBar;
import com.runqian.report.ide.Message;
import com.runqian.report.ide.MessageAcceptor;
import com.runqian.report.ide.MessageDispatcher;
import com.runqian.report.ide.ReportFrame_PropertyPanel_ComponentAdapter;
import com.runqian.report.ide.ReportFrame_this_windowAdapter;
import com.runqian.report.ide.ReportMenuBar;
import com.runqian.report.ide.ReportPropertyBar;
import com.runqian.report.ide.ReportStatusBar;
import com.runqian.report.ide.ReportToolBar;
import com.runqian.report.ide.SheetBrowser;
import com.runqian.report.ide.SheetEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ReportFrame
extends JFrame
implements MessageAcceptor {
    public static ReportMenuBar mainMenu;
    public static ReportToolBar toolsBar;
    public static EditToolBar editBar;
    public static ReportPropertyBar propertyBar;
    public DataSourceListModel dss;
    public static ReportStatusBar statusBar;
    public String defaultFile2Open = "";
    private Message message;
    static final double SPLIT_POS = 0.75;
    static final int SPLIT_WIDTH = 3;
    private JPanel barPanel = new JPanel(new VFlowLayout(true, false));
    private JDesktopPane desk;
    private static String currentFile;
    private JSplitPane jView = new JSplitPane();
    static JScrollPane jSPPropertyBar;
    public JTextArea consoleText = new JTextArea();
    public static String currentDirectory;
    private boolean runned = false;
    Runnable run = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object o;
            Object object = o = new Object();
            synchronized (object) {
                try {
                    o.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    };

    static {
        editBar = new EditToolBar();
        currentDirectory = System.getProperty("user.dir");
    }

    public ReportFrame(String openFile) {
        super("\u6da6\u4e7e\u62a5\u8868");
        this.defaultFile2Open = openFile;
        this.checkLicense();
        try {
            MessageDispatcher.addRelativeObject((short)17, editBar);
            AppOption.load();
            if (AppOption.logDebugMessage.booleanValue()) {
                new Console(this.consoleText);
            }
            AppTools.loadTmpDirectory();
            this.loadFunctions();
            this.message = new Message();
            this.message.setProducer((short)1);
            toolsBar = new ReportToolBar(this);
            propertyBar = new ReportPropertyBar(this);
            statusBar = new ReportStatusBar();
            mainMenu = new ReportMenuBar(this);
            DataSourceListModel.textShow = statusBar;
            this.dss = new DataSourceListModel(AppTools.CONFIG_FILE, "RUNQIAN/DATASOURCES");
            this.desk = new JDesktopPane();
            this.desk.setDragMode(JDesktopPane.LIVE_DRAG_MODE);
            this.desk.revalidate();
            jSPPropertyBar = new JScrollPane(propertyBar);
            this.jView = new JSplitPane();
            this.getContentPane().add((Component)this.jView, "Center");
            this.jView.setDividerSize(3);
            this.jView.setDebugGraphicsOptions(0);
            this.jView.setContinuousLayout(false);
            this.jView.setOrientation(1);
            this.jView.add((Component)this.desk, "left");
            this.jView.add((Component)jSPPropertyBar, "right");
            int splitPos = new Double(0.75 * Toolkit.getDefaultToolkit().getScreenSize().getWidth()).intValue();
            this.jView.setDividerLocation(splitPos);
            this.getContentPane().add((Component)this.barPanel, "North");
            this.barPanel.add(toolsBar);
            this.barPanel.add(editBar);
            jSPPropertyBar.addComponentListener(new ReportFrame_PropertyPanel_ComponentAdapter(this));
            this.getContentPane().add((Component)statusBar, "South");
            this.setIconImage(Tools.getImageIcon("/com/runqian/report/ide/resources/app_logo.jpg").getImage());
            MessageDispatcher.addRelativeObject((short)1, this);
            this.setJMenuBar(mainMenu);
            this.pack();
            this.jbInit();
            ReportFrame.resetMenu(null);
            Tools.setMainFrame(this);
            this.startAutoRecent();
        }
        catch (Throwable e) {
            Tools.showException(e);
            System.exit(0);
        }
    }

    private void loadFunctions() {
        try {
            String className;
            String item;
            XMLFile file = new XMLFile(AppTools.CONFIG_FILE);
            String path = "RUNQIAN/FUNCTIONS/Normal";
            Section items = file.listElement(path);
            int i = 0;
            while (i < items.size()) {
                item = items.get(i);
                className = file.getAttribute(String.valueOf(path) + "/" + item + "/class");
                FunctionLib.addFunction(item, className);
                ++i;
            }
            path = "RUNQIAN/FUNCTIONS/DataSet";
            items = file.listElement(path);
            i = 0;
            while (i < items.size()) {
                item = items.get(i);
                className = file.getAttribute(String.valueOf(path) + "/" + item + "/class");
                FunctionLib.addDSFunction(item, className);
                ++i;
            }
        }
        catch (RuntimeException re) {
            Tools.showException(new RuntimeException("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u51fd\u6570\u51fa\u9519\uff1a" + re.getMessage()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void startAutoRecent() {
        try {
            if (ReportFrame.mainMenu.firstConnect != null) {
                this.connect(ReportFrame.mainMenu.firstConnect);
            }
            if (Tools.isValidString(this.defaultFile2Open)) {
                mainMenu.openSpecifiedFile(this.defaultFile2Open);
            } else if (ReportFrame.mainMenu.firstFileToOpen != null) {
                mainMenu.openSpecifiedFile(ReportFrame.mainMenu.firstFileToOpen);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void PropertyPanel_componentResized(ComponentEvent e) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            frames[i].setPreferredSize(this.desk.getSize());
            ++i;
        }
    }

    public Object receive(Message command) throws Throwable {
        int cmd = command.getName();
        this.message.setConsumer((short)5);
        this.message.setName(cmd);
        switch (cmd) {
            case 150: {
                return this.print();
            }
            case 125: {
                if (this.desk.getSelectedFrame() == null) {
                    return null;
                }
                JInternalFrame selectFrame = this.desk.getSelectedFrame();
                currentFile = (String)command.getArgument();
                this.mixedMessage(125, command.getArgument());
                if (selectFrame instanceof SheetEditor) {
                    ((SheetEditor)selectFrame).setCurrentFile(currentFile);
                    selectFrame.setTitle(currentFile);
                }
                return null;
            }
            case 175: 
            case 176: 
            case 180: 
            case 185: 
            case 188: {
                return this.export(cmd);
            }
            case 20001: 
            case 20002: 
            case 20003: 
            case 20004: {
                Tools.arrangeWindow(cmd, this.desk);
                return null;
            }
            case 155: {
                HashMap hm = (HashMap)command.getArgument();
                SheetBrowser bf = this.newBrowser((String)hm.get("filename"));
                if (bf != null) {
                    bf.setCellSet((CellSet)hm.get("cellset"));
                }
                return null;
            }
            case 120: {
                String tmpStr = (String)command.getArgument();
                if (this.newEditor(tmpStr) == null) {
                    return null;
                }
                this.message.setArgument(tmpStr);
                break;
            }
            case 110: {
                String tmpStr = this.newEditor("");
                this.message.setArgument(tmpStr);
                break;
            }
            case 135: {
                return this.closeSheet((String)command.getArgument());
            }
            case 136: {
                return new Boolean(this.closeAll());
            }
            case 430: {
                JInternalFrame jif = this.getSheet((String)command.getArgument());
                this.showSheet(jif);
                break;
            }
            case 165: {
                JInternalFrame[] frames = this.desk.getAllFrames();
                int i = 0;
                while (i < frames.length) {
                    this.message.setName(135);
                    this.message.setArgument(frames[i].getTitle());
                    frames[i].setVisible(false);
                    frames[i].dispose();
                    ++i;
                }
                break;
            }
        }
        MessageDispatcher.send(this.message);
        return null;
    }

    private Object closeSheet(String wnd2Close) throws Exception {
        JInternalFrame tmpFrame = this.getSheet(wnd2Close);
        if (tmpFrame == null) {
            return null;
        }
        this.desk.getDesktopManager().closeFrame(tmpFrame);
        int i = this.desk.getAllFrames().length;
        if (i == 0) {
            ReportFrame.resetMenu(null);
        } else {
            JInternalFrame[] frames = this.desk.getAllFrames();
            if (tmpFrame instanceof SheetBrowser) {
                StringTokenizer st = new StringTokenizer(wnd2Close);
                st.nextToken();
                this.showSheet(this.getSheet(st.nextToken()));
            } else if (frames.length > 1) {
                this.showSheet(frames[1]);
            }
        }
        return Boolean.TRUE;
    }

    public void connect(String dsName) throws Throwable {
        DataSource ds = this.dss.getDataSource(dsName);
        if (ds == null) {
            return;
        }
        ReportFrame reportFrame = this;
        if (reportFrame.dss.getActiveDS() != null) {
            ReportFrame reportFrame2 = this;
            reportFrame2.dss.getActiveDS().close();
            this.dss.setActiveDS(null);
        }
        ds.connect();
        mainMenu.refreshRecentConn(dsName);
        this.dss.setActiveDS(ds);
    }

    private Object mixedMessage(int mName, Object aArg) throws Throwable {
        JInternalFrame selectFrame = this.desk.getSelectedFrame();
        if (selectFrame instanceof SheetEditor) {
            this.message.setConsumer((short)5);
        } else {
            this.message.setConsumer((short)15);
        }
        this.message.setName(mName);
        this.message.setArgument(aArg);
        MessageDispatcher.send(this.message);
        return null;
    }

    private Object print() throws Throwable {
        return this.mixedMessage(150, null);
    }

    private Object export(int fileType) throws Throwable {
        JFileChooser chooser = new JFileChooser(currentDirectory);
        switch (fileType) {
            case 175: 
            case 176: {
                chooser.addChoosableFileFilter(Tools.getFileFilter(".xls", "*.XLS"));
                break;
            }
            case 180: {
                chooser.addChoosableFileFilter(Tools.getFileFilter(".htm", "*.HTM"));
                break;
            }
            case 185: {
                chooser.addChoosableFileFilter(Tools.getFileFilter(".pdf", "*.PDF"));
                break;
            }
            case 188: {
                chooser.addChoosableFileFilter(Tools.getFileFilter(".txt", "*.TXT"));
            }
        }
        if (chooser.showSaveDialog(this) != 0) {
            return null;
        }
        File saveFile = chooser.getSelectedFile();
        String sfile = saveFile.getAbsolutePath();
        String sdesc = chooser.getFileFilter().getDescription().substring(1);
        currentDirectory = saveFile.getParent();
        if (sdesc.equalsIgnoreCase("\u6240\u6709\u6587\u4ef6")) {
            sdesc = sfile.substring(sfile.length() - 4);
        } else if (!sfile.toUpperCase().endsWith(sdesc)) {
            saveFile = new File(saveFile.getParent(), String.valueOf(saveFile.getName()) + sdesc);
            sfile = saveFile.getAbsolutePath();
        }
        if (!(sdesc.equalsIgnoreCase(".pdf") || sdesc.equalsIgnoreCase(".htm") || sdesc.equalsIgnoreCase(".xls") || sdesc.equalsIgnoreCase(".txt"))) {
            JOptionPane.showMessageDialog(this, "\u5c1a\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
            return null;
        }
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("FileName", sfile);
        hm.put("FileType", new Integer(fileType));
        return this.mixedMessage(170, hm);
    }

    public static void resetMenu(Boolean editingReport) {
        int[] menus = new int[]{110, 120, 140, 165, 305, 308, 338, 20001, 20002, 20003, 730, 20004, 710, 720, 750, 309, 310, 410, 420, 10000, 10001};
        if (editingReport == null) {
            mainMenu.setMenuAll(false);
            mainMenu.setMenuEnable(menus, true);
            editBar.clear();
            toolsBar.setEnable(false);
            propertyBar.config(4, false, false);
        } else if (editingReport.booleanValue()) {
            mainMenu.setMenuAll(true);
            editBar.setEnable(true);
            toolsBar.setEnable(true);
            propertyBar.setEnabled(true);
            propertyBar.setBackground(Color.white);
        } else {
            mainMenu.setMenuAll(false);
            mainMenu.setMenuEnable(menus, true);
            menus = new int[]{140, 145, 150, 135, 136, 130, 175, 176, 180, 185, 188};
            mainMenu.setMenuEnable(menus, true);
            editBar.setEnable(false);
            toolsBar.setEnable(false);
            propertyBar.setEnabled(false);
            propertyBar.setBackground(Color.lightGray);
        }
    }

    public boolean isReportEditing() {
        JInternalFrame jni = this.desk.getSelectedFrame();
        if (jni == null) {
            return false;
        }
        return jni instanceof SheetEditor;
    }

    private JDesktopPane getDesktop() {
        return this.desk;
    }

    private void checkLicense() {
        String smsg = "\u8bf7\u8054\u7cfb\u83b7\u53d6\u8be5\u6587\u4ef6\u3002\r\n\u7535\u8bdd\uff1a010-82893346/7\r\n\u7f51\u5740\uff1a http://www.runqian.com.cn";
        LLObject lc = LLObject.get();
        if (lc == null) {
            JOptionPane.showMessageDialog(this, String.valueOf(smsg) + "\r\n\u7c7b\u8def\u5f84\u4e0a\u65e0\u6b64\u6587\u4ef6:xrq_license.dat", "\u6ca1\u6709\u6709\u6548\u7684\u6388\u6743\u6587\u4ef6", 2);
            System.exit(0);
        }
        if (!lc.checkExpiration()) {
            JOptionPane.showMessageDialog(this, smsg, "\u8bd5\u7528\u7248\u5df2\u8fc7\u671f", 2);
            System.exit(0);
        }
    }

    private void showSheet(JInternalFrame s) throws Exception {
        if (s == null) {
            return;
        }
        s.toFront();
        s.show();
        s.setSelected(true);
    }

    public JInternalFrame getSheet(String title) {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].getTitle().equalsIgnoreCase(title)) {
                return frames[i];
            }
            ++i;
        }
        return null;
    }

    private boolean isSheetOpened(String sheetName) {
        JInternalFrame jif = this.getSheet(sheetName);
        return jif != null;
    }

    private String newEditor(String filePath) throws Throwable {
        if (this.isSheetOpened(filePath)) {
            this.showSheet(this.getSheet(filePath));
            return null;
        }
        currentFile = filePath;
        SheetEditor frame = new SheetEditor(filePath, true, true, true, true);
        frame.editor.setParentFrame(this);
        Dimension d = this.desk.getSize();
        frame.setBounds(0, 0, d.width, d.height);
        frame.show();
        this.desk.add(frame);
        frame.setMaximum(true);
        frame.setSelected(true);
        return frame.getCurrentPath();
    }

    private SheetBrowser newBrowser(String filePath) throws Throwable {
        String tmpName;
        if (filePath == null) {
            filePath = "";
        }
        if (this.isSheetOpened(tmpName = "\u6d4f\u89c8\u62a5\u8868[  " + filePath + "  ]")) {
            this.showSheet(this.getSheet(tmpName));
            return null;
        }
        SheetBrowser frame = new SheetBrowser(filePath, true, true, true, true);
        Dimension d = this.desk.getSize();
        frame.setBounds(0, 0, d.width, d.height);
        frame.show();
        this.desk.add(frame);
        frame.setMaximum(true);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return frame;
    }

    public void openReportFile(String fileName) {
        this.defaultFile2Open = fileName;
        this.startAutoRecent();
    }

    public static void main(String[] args) throws Exception {
        ReportFrame rf = ReportFrame.main0(args);
        rf.setVisible(true);
    }

    public static ReportFrame main0(String[] args) throws Exception {
        try {
            Font font = new Font("Dialog", 0, 12);
            Enumeration keys = UIManager.getLookAndFeelDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (!(UIManager.get(key) instanceof Font)) continue;
                UIManager.put(key, font);
            }
        }
        catch (Exception font) {
            // empty catch block
        }
        String sTmp = System.getProperty("java.version");
        String sPath = System.getProperty("java.home");
        if (sTmp.compareTo("1.4.1") < 0) {
            JOptionPane.showMessageDialog(null, "\u8fd0\u884c\u6da6\u4e7e\u62a5\u8868\u9700\u8981\u81f3\u5c111.4.1\u7248\u672c\u7684JDK\u3002\n\u5f53\u524d\u7684JDK\u6240\u5728\u8def\u5f84\u4e3a\uff1a" + sPath + "\n" + "\u5f53\u524d\u7684JDK\u7248\u672c\u4e3a\uff1a" + sTmp);
            System.exit(0);
        }
        String arg = "";
        if (args.length == 1) {
            arg = args[0];
        } else if (args.length == 2) {
            arg = args[1];
        }
        File f = new File(arg);
        if (!f.isFile()) {
            arg = "";
        }
        ReportFrame frame = new ReportFrame(arg);
        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        frame.setExtendedState(6);
        return frame;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setEnabled(true);
        this.addWindowListener(new ReportFrame_this_windowAdapter(this));
    }

    public String getActivateOpenFile() {
        String ls_file = "";
        try {
            File f = new File(AppTools.CONFIG_FILE);
            if (!f.isFile()) {
                return "";
            }
            XMLFile file = new XMLFile(AppTools.CONFIG_FILE);
            if (!file.isPathExists("RUNQIAN/OTHER")) {
                file.newElement("RUNQIAN", "OTHER");
            }
            ls_file = file.getAttribute("RUNQIAN/OTHER/ActivateOpenFile");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ls_file;
    }

    void this_windowActivated(WindowEvent e) {
        Tools.setMainFrame(this);
        double w = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        boolean if800_600 = w <= 800.0;
        toolsBar.refreshBar(if800_600);
        editBar.refreshBar(if800_600);
    }

    void this_windowDeactivated(WindowEvent e) {
    }

    public boolean closeAll() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            this.message.setConsumer((short)2);
            this.message.setName(135);
            this.message.setArgument(frames[i].getTitle());
            try {
                Boolean close = (Boolean)MessageDispatcher.send(this.message);
                if (!close.booleanValue()) {
                    return false;
                }
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
            ++i;
        }
        return true;
    }

    void this_windowClosing(WindowEvent e) {
        if (Boolean.getBoolean("com.runqian.report.c")) {
            if (!this.closeAll()) {
                return;
            }
            if (!this.runned) {
                Thread t = new Thread(this.run);
                t.start();
            }
            this.hide();
            return;
        }
        ReportFrame.mainMenu.askOptionWhileExit = 0;
        if (!this.closeAll()) {
            return;
        }
        ReportFrame.mainMenu.askOptionWhileExit = 1;
        this.message.setConsumer((short)2);
        this.message.setName(165);
        this.message.setArgument("SaveRecentMenu");
        try {
            MessageDispatcher.send(this.message);
        }
        catch (Throwable ex) {
            Tools.showException(ex);
        }
    }
}

