/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.module.DataSetConfig;
import com.runqian.base.module.DataSetConfigs;
import com.runqian.base.module.DataSourceListModel;
import com.runqian.base.tool.AppTools;
import com.runqian.base.tool.Section;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.IntHashtable;
import com.runqian.base.util.SQLParser;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellRegion;
import com.runqian.report.control.EditControl;
import com.runqian.report.ide.wizard.DialogCrossEditor;
import com.runqian.report.ide.wizard.DialogGroupEditor;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;

public class ReportTemplate {
    private int style;
    private DataSetConfigs dsct;
    private EditControl editControl;
    String appr;
    String tables;
    CellPosition cp;
    CellPropertyDefine cd = new CellPropertyDefine();
    HashMap dsColumns = null;

    public ReportTemplate(int sty, DataSetConfigs dsc, EditControl ec) {
        this.style = sty;
        this.dsct = dsc;
        this.editControl = ec;
        this.editControl.setCellPropertyValue(0, 0, 1102, this.dsct.toString());
    }

    public void generate() throws Throwable {
        switch (this.style) {
            case 1: {
                this.genGrid();
                break;
            }
            case 2: {
                this.genCross();
                break;
            }
            case 3: {
                this.genGroup();
                break;
            }
            case 4: {
                this.genBigRpt();
            }
        }
    }

    private Vector listColumns(String sql, String sqlType, boolean ifName) {
        Vector v = new Vector();
        try {
            Tools.logDebugMessage(String.valueOf(this.getClass().getName()) + "List column Original sql:" + sql);
            if (DataSourceListModel.getActiveDS() != null) {
                Tools.setConnection(DataSourceListModel.getActiveDS().getRQConnection().getConnection());
                String tables = SQLParser.getClause(sql, 1);
                ResultSetMetaData rsmd = Tools.getSqlRSMD(sql);
                if (rsmd == null) {
                    String ls_sql = SQLParser.modify(sql, 2, "1=0");
                    v = AppTools.listColumns(Tools.executeSql(ls_sql), ifName, tables);
                } else {
                    v = AppTools.listColumns(rsmd, ifName, tables);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v;
    }

    void setFieldAppr(CellPosition cell2Set, String appr) {
        if (appr == null) {
            return;
        }
        SegmentSet ss = new SegmentSet(appr);
        String val = ss.get("TEXT_FACE");
        if (val != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4301, val);
        }
        if ((val = ss.get("TEXT_SIZE")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4302, val);
        }
        if ((val = ss.get("TEXT_COLOR")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4303, new Integer(val));
        }
        if ((val = ss.get("BACK_COLOR")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4413, new Integer(val));
        }
        if ((val = ss.get("ALIGN")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4201, this.convertAlign(val));
        }
        if ((val = ss.get("TEXT_BOLD")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4304, new Boolean(val));
        }
        if ((val = ss.get("TEXT_ITALIC")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4305, new Boolean(val));
        }
        if ((val = ss.get("TEXT_UNDERLINE")) != null) {
            this.editControl.setCellPropertyValue(cell2Set, 4306, new Boolean(val));
        }
    }

    private Integer convertAlign(Object align) {
        if (align instanceof String) {
            if (align.equals("\u5de6\u5bf9\u9f50")) {
                return CellPropertyDefine.CA_LEFT;
            }
            if (align.equals("\u5c45\u4e2d")) {
                return CellPropertyDefine.CA_CENTER;
            }
            if (align.equals("\u53f3\u5bf9\u9f50")) {
                return CellPropertyDefine.CA_RIGHT;
            }
        }
        return null;
    }

    private void genGrid() throws Throwable {
        int c = 0;
        Section dsNames = new Section();
        HashMap hm = this.getDSCols();
        Iterator it = hm.keySet().iterator();
        while (it.hasNext()) {
            String sName = (String)it.next();
            dsNames.addSection(sName);
        }
        String[] names = dsNames.toStringArray();
        int i = 0;
        while (i < names.length) {
            if (i == 0) {
                this.editControl.setCellPropertyValue(1, 0, 3103, CellPropertyDefine.CRT_TABLE_HEADER);
            }
            Vector columns = (Vector)hm.get(names[i]);
            c = 0;
            int m = 0;
            while (m < columns.size()) {
                String sTmp = (String)columns.get(m);
                this.editControl.setCellPropertyValue(i * 3 + 1, ++c, 4102, sTmp);
                sTmp = (String)columns.get(m);
                this.cp = new CellPosition(i * 3 + 2, c);
                if (1 == c) {
                    this.editControl.setCellPropertyExpression(this.cp, 4102, String.valueOf(names[i]) + ".Select(" + sTmp + ")");
                    this.editControl.setCellPropertyValue(this.cp, 4501, CellPropertyDefine.CEX_VERTICAL);
                } else {
                    this.editControl.setCellPropertyExpression(this.cp, 4102, String.valueOf(names[i]) + "." + sTmp);
                }
                ++m;
            }
            ++i;
        }
    }

    private void genGroup() throws Throwable {
        String sTmp;
        HashMap hm = new HashMap();
        String[] names = this.dsct.getDataSetNames();
        hm = this.getDSCols();
        DialogGroupEditor dge = new DialogGroupEditor((JFrame)this.editControl.getTopLevelAncestor(), "\u6570\u636e\u5206\u7ec4\u5b9a\u4e49", true);
        dge.setDS(hm);
        dge.show();
        if (dge.getOption() != 0) {
            return;
        }
        Vector columns = dge.getGroup();
        Vector colString = dge.getGroupString();
        String all_groups = "";
        int c = 0;
        int i = 0;
        while (i < colString.size()) {
            ++c;
            hm = (HashMap)columns.get(i);
            Object s = hm.get("group");
            if (s != null) {
                all_groups = String.valueOf(all_groups) + "," + (String)s;
            }
            sTmp = (String)colString.get(i);
            this.editControl.setCellPropertyValue(2, c, 4501, CellPropertyDefine.CEX_VERTICAL);
            this.editControl.setCellPropertyExpression(2, c, 4102, sTmp);
            ++i;
        }
        int n = 0;
        columns = dge.getFields();
        if (columns == null) {
            int i2 = 0;
            while (i2 < names.length) {
                DataSetConfig d = this.dsct.get(names[i2]);
                n = 0;
                columns = this.listColumns(d.getSQL(), DataSetConfig.getSqlTypeName(d.getSQLType()), true);
                this.tables = SQLParser.getClause(d.getSQL(), 1);
                int k = 0;
                while (k < columns.size()) {
                    sTmp = (String)columns.get(k);
                    if (all_groups.indexOf(sTmp) <= 0) {
                        ++n;
                        this.editControl.setCellPropertyValue(1, ++c, 4102, sTmp);
                        this.cp = new CellPosition(2, c);
                        this.appr = AppTools.getFieldAppr(this.tables, sTmp);
                        this.setFieldAppr(this.cp, this.appr);
                        if (n == 1) {
                            this.editControl.setCellPropertyExpression(this.cp, 4102, String.valueOf(names[i2]) + ".Select(" + sTmp + ")");
                            this.editControl.setCellPropertyValue(this.cp, 4501, CellPropertyDefine.CEX_VERTICAL);
                        } else {
                            this.editControl.setCellPropertyExpression(this.cp, 4102, String.valueOf(names[i2]) + "." + sTmp);
                        }
                    }
                    ++k;
                }
                ++i2;
            }
        } else {
            int k = 0;
            while (k < columns.size()) {
                sTmp = (String)columns.get(k);
                this.editControl.setCellPropertyValue(1, ++c, 4102, sTmp);
                this.cp = new CellPosition(2, c);
                if (++n == 1) {
                    this.editControl.setCellPropertyExpression(this.cp, 4102, sTmp);
                    this.editControl.setCellPropertyValue(this.cp, 4501, CellPropertyDefine.CEX_VERTICAL);
                } else {
                    this.editControl.setCellPropertyExpression(this.cp, 4102, sTmp);
                }
                ++k;
            }
        }
    }

    public void setDSMap(HashMap dscols) {
        this.dsColumns = dscols;
    }

    public HashMap getDSCols() {
        return this.dsColumns;
    }

    private void genCross() throws Throwable {
        DialogCrossEditor dce = new DialogCrossEditor((JFrame)this.editControl.getTopLevelAncestor(), "\u4ea4\u53c9\u62a5\u8868\u5b9a\u4e49", true);
        dce.setDS(this.getDSCols());
        dce.show();
        if (dce.getOption() != 0) {
            return;
        }
        HashMap hm = dce.getCross();
        if (hm == null) {
            return;
        }
        Vector rowItems = (Vector)hm.get("row");
        Vector colItems = (Vector)hm.get("col");
        Vector valItems = (Vector)hm.get("val");
        int r = rowItems.size();
        int c = colItems.size();
        int v = valItems.size();
        int i = 0;
        while (i < c) {
            CellRegion cr = new CellRegion(i + 1, r + 1, i + 1, r + v);
            IntHashtable propertyPairs = new IntHashtable();
            String mergeStr = cr.toMergeString();
            this.editControl.setCellPropertyExpression(i + 1, r + 1, 4102, (String)colItems.get(i));
            this.editControl.setCellPropertyValue(i + 1, r + 1, 4501, CellPropertyDefine.CEX_HORIZONTAL);
            int k = 0;
            while (k < v) {
                this.editControl.setCellPropertyValue(i + 1, r + 1 + k, 4103, mergeStr);
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < r) {
            this.editControl.setCellPropertyExpression(c + 1, i + 1, 4102, (String)rowItems.get(i));
            this.editControl.setCellPropertyValue(c + 1, i + 1, 4501, CellPropertyDefine.CEX_VERTICAL);
            ++i;
        }
        i = 0;
        while (i < v) {
            this.editControl.setCellPropertyExpression(c + 1, r + 1 + i, 4102, (String)valItems.get(i));
            ++i;
        }
    }

    private void genBigRpt() throws Throwable {
    }
}

