/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.base.tool.Tools;
import com.runqian.base.util.IntHashtable;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.control.PrintFrame;
import com.runqian.report.control.ScanControl;
import com.runqian.report.ide.CellSetConverter;
import com.runqian.report.ide.Message;
import com.runqian.report.ide.MessageAcceptor;
import com.runqian.report.ide.MessageDispatcher;
import com.runqian.report.ide.ReportFrame;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class SheetBrowser
extends JInternalFrame
implements MessageAcceptor {
    private ScanControl browser;
    private String currentTitle;

    public SheetBrowser(String currentPath, boolean resizable, boolean closable, boolean maxmizable, boolean iconifiable) {
        super(currentPath, resizable, closable, maxmizable, iconifiable);
        this.currentTitle = "\u6d4f\u89c8\u62a5\u8868[  " + currentPath + "  ]";
        this.setTitle(this.currentTitle);
        this.browser = new ScanControl();
        this.getContentPane().add(this.browser);
        this.addInternalFrameListener(new Listener(this));
    }

    public void save(String fileName) {
        try {
            this.browser.saveData(fileName);
        }
        catch (Exception e) {
            Tools.showException(e);
        }
    }

    public Object receive(Message command) throws Throwable {
        int cmd = command.getName();
        switch (cmd) {
            case 125: {
                String filePath = (String)command.getArgument();
                this.browser.saveData(filePath);
                break;
            }
            case 150: {
                PrintFrame pf = new PrintFrame((CellSet)this.browser.getCellSet().clone(), false, (JFrame)this.browser.getTopLevelAncestor());
                pf.show();
                break;
            }
            case 170: {
                new CellSetConverter(this.browser.getCellSet(), (HashMap)command.getArgument()).convert();
                break;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.browser != null) {
            this.browser.dispose();
            this.browser = null;
        }
    }

    public void setCellSet(CellSet cellSet) {
        this.browser.setCellSet(cellSet);
    }

    class Listener
    extends InternalFrameAdapter {
        private SheetBrowser sb;
        private Message ss;
        private IntHashtable argument;

        public Listener(SheetBrowser frame) {
            this.sb = frame;
            this.ss = new Message();
            this.argument = new IntHashtable();
        }

        public void internalFrameActivated(InternalFrameEvent e) {
            ReportFrame.resetMenu(Boolean.FALSE);
            MessageDispatcher.addRelativeObject((short)15, this.sb);
            this.ss.setConsumer((short)2);
            this.ss.setName(1500);
            this.ss.setArgument(SheetBrowser.this.getTitle());
            try {
                MessageDispatcher.send(this.ss);
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
        }

        public void dispose() {
            MessageDispatcher.removeRelativeObject((short)15);
            this.sb.dispose();
            this.sb = null;
        }

        public void internalFrameClosing(InternalFrameEvent e) {
            this.ss.setConsumer((short)2);
            this.ss.setName(135);
            this.ss.setArgument(SheetBrowser.this.currentTitle);
            try {
                MessageDispatcher.send(this.ss);
                this.dispose();
            }
            catch (Throwable t) {
                Tools.showException(t);
            }
        }
    }
}

