/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.ide;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetWriter;
import com.runqian.report.view.excel.ExcelColor;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.Region;

public class SheetTransfer {
    private Region[] regions;
    private CellSet cs;
    private HSSFSheet sheet;
    private HSSFFont[] fonts;

    public SheetTransfer(HSSFSheet sheet, HSSFFont[] fonts) {
        this.sheet = sheet;
        this.fonts = fonts;
        int rows = sheet.getLastRowNum() + 1;
        int cols = this.getLastCol(sheet);
        this.cs = new CellSet(rows + 1, cols + 1);
        int i = 1;
        while (i <= rows) {
            HSSFRow r = sheet.getRow(i - 1);
            if (r != null) {
                float h = r.getHeight();
                this.cs.setPropertyValue(i, 0, 3101, new Float(h /= 20.64f));
            }
            ++i;
        }
        i = 1;
        while (i <= cols) {
            float w = sheet.getColumnWidth((short)(i - 1));
            if (w != 8.0f) {
                this.cs.setPropertyValue(0, i, 2101, new Float(w /= 46.44f));
            }
            ++i;
        }
        this.regions = new Region[sheet.getNumMergedRegions()];
        i = 0;
        while (i < this.regions.length) {
            this.regions[i] = sheet.getMergedRegionAt(i);
            ++i;
        }
    }

    public CellSet toCellSet() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("#.######");
        int row = 1;
        while (row < this.cs.getRow()) {
            HSSFRow r = this.sheet.getRow(row - 1);
            if (r != null) {
                int col = 1;
                while (col < this.cs.getColumn()) {
                    HSSFCell cell = r.getCell((short)(col - 1));
                    if (cell != null) {
                        String merge = this.getMergeExp(row, col);
                        if (merge != null) {
                            this.cs.setPropertyValue(row, col, 4103, merge);
                        }
                        int type = cell.getCellType();
                        String value = "";
                        switch (type) {
                            case 1: {
                                value = cell.getStringCellValue();
                                break;
                            }
                            case 0: {
                                double d = cell.getNumericCellValue();
                                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)cell)) {
                                    Date dd = HSSFDateUtil.getJavaDate((double)d);
                                    int dateType = this.getDateType(cell.getCellStyle().getDataFormat());
                                    if (dateType == 0) {
                                        value = sdf.format(dd);
                                        break;
                                    }
                                    if (dateType == 1) {
                                        value = new SimpleDateFormat("HH:mm:ss").format(dd);
                                        break;
                                    }
                                    if (dateType != 2) break;
                                    value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dd);
                                    break;
                                }
                                value = df.format(d);
                                int pos = value.indexOf(".");
                                if (pos < 0) break;
                                boolean allZero = true;
                                ++pos;
                                while (pos < value.length()) {
                                    if (value.charAt(pos) != '0') {
                                        allZero = false;
                                        break;
                                    }
                                    ++pos;
                                }
                                if (!allZero) break;
                                value = value.substring(0, value.indexOf("."));
                                break;
                            }
                            case 2: {
                                value = df.format(cell.getNumericCellValue());
                            }
                        }
                        if (value != null && value.trim().length() > 0) {
                            this.cs.setPropertyValue(row, col, 4102, value);
                        }
                        HSSFCellStyle style = cell.getCellStyle();
                        Integer align = CellPropertyDefine.CA_LEFT;
                        short align1 = style.getAlignment();
                        if (align1 == 2) {
                            align = CellPropertyDefine.CA_CENTER;
                        } else if (align1 == 3) {
                            align = CellPropertyDefine.CA_RIGHT;
                        }
                        this.cs.setPropertyValue(row, col, 4201, align);
                        Integer valign = CellPropertyDefine.CVA_MIDDLE;
                        short valign1 = style.getVerticalAlignment();
                        if (valign1 == 0) {
                            valign = CellPropertyDefine.CVA_TOP;
                        } else if (valign1 == 2) {
                            valign = CellPropertyDefine.CVA_BOTTOM;
                        }
                        this.cs.setPropertyValue(row, col, 4202, valign);
                        if (style.getWrapText()) {
                            this.cs.setPropertyValue(row, col, 4107, Boolean.TRUE);
                        }
                        HSSFFont font = this.fonts[style.getFontIndex()];
                        this.cs.setPropertyValue(row, col, 4301, font.getFontName());
                        short fontSize = font.getFontHeightInPoints();
                        this.cs.setPropertyValue(row, col, 4302, new Integer(fontSize));
                        this.cs.setPropertyValue(row, col, 4303, ExcelColor.getColorInReport(font.getColor(), Color.black));
                        if (font.getBoldweight() == 700) {
                            this.cs.setPropertyValue(row, col, 4304, Boolean.TRUE);
                        }
                        if (font.getItalic()) {
                            this.cs.setPropertyValue(row, col, 4305, Boolean.TRUE);
                        }
                        if (font.getUnderline() != 0) {
                            this.cs.setPropertyValue(row, col, 4306, Boolean.TRUE);
                        }
                        this.setBorder(style.getBorderTop(), style.getTopBorderColor(), row, col, 1);
                        this.setBorder(style.getBorderBottom(), style.getBottomBorderColor(), row, col, 2);
                        this.setBorder(style.getBorderLeft(), style.getLeftBorderColor(), row, col, 3);
                        this.setBorder(style.getBorderRight(), style.getRightBorderColor(), row, col, 4);
                        Integer bc = ExcelColor.getColorInReport(style.getFillForegroundColor(), Color.white);
                        this.cs.setPropertyValue(row, col, 4413, bc);
                    }
                    ++col;
                }
            }
            ++row;
        }
        return this.cs;
    }

    public void save(String raqFile) throws Exception {
        new CellSetWriter(this.cs).write(raqFile);
    }

    private String getMergeExp(int row, int col) {
        int i = 0;
        while (i < this.regions.length) {
            int row1 = this.regions[i].getRowFrom() + 1;
            int row2 = this.regions[i].getRowTo() + 1;
            int col1 = this.regions[i].getColumnFrom() + 1;
            int col2 = this.regions[i].getColumnTo() + 1;
            if (row >= row1 && row <= row2 && col >= col1 && col <= col2) {
                return String.valueOf(row1) + "," + col1 + "-" + row2 + "," + col2;
            }
            ++i;
        }
        return null;
    }

    private void setBorder(short border, short color, int row, int col, int location) {
        Integer bs = CellPropertyDefine.CBS_NONE;
        float bw = 0.75f;
        switch (border) {
            case 7: 
            case 9: 
            case 11: {
                bs = CellPropertyDefine.CBS_DOTTED;
                break;
            }
            case 3: {
                bs = CellPropertyDefine.CBS_DASHED;
                break;
            }
            case 6: {
                bs = CellPropertyDefine.CBS_DOUBLE;
                break;
            }
            case 4: {
                bs = CellPropertyDefine.CBS_SOLID;
                break;
            }
            case 2: {
                bs = CellPropertyDefine.CBS_SOLID;
                bw = 1.5f;
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                bs = CellPropertyDefine.CBS_DOTTED;
                bw = 1.5f;
                break;
            }
            case 8: {
                bs = CellPropertyDefine.CBS_DASHED;
                bw = 1.5f;
                break;
            }
            case 0: {
                bs = CellPropertyDefine.CBS_NONE;
                break;
            }
            case 5: {
                bs = CellPropertyDefine.CBS_SOLID;
                bw = 2.0f;
                break;
            }
            case 1: {
                bs = CellPropertyDefine.CBS_SOLID;
                bw = 1.0f;
            }
        }
        int bsKey = 0;
        int bwKey = 0;
        int bcKey = 0;
        switch (location) {
            case 1: {
                bsKey = 4407;
                bwKey = 4408;
                bcKey = 4409;
                break;
            }
            case 2: {
                bsKey = 4410;
                bwKey = 4411;
                bcKey = 4412;
                break;
            }
            case 3: {
                bsKey = 4401;
                bwKey = 4402;
                bcKey = 4403;
                break;
            }
            case 4: {
                bsKey = 4404;
                bwKey = 4405;
                bcKey = 4406;
            }
        }
        this.cs.setPropertyValue(row, col, bsKey, bs);
        this.cs.setPropertyValue(row, col, bwKey, new Float(bw));
        this.cs.setPropertyValue(row, col, bcKey, ExcelColor.getColorInReport(color, Color.black));
    }

    private int getLastCol(HSSFSheet sheet) {
        short col = 0;
        int rows = sheet.getLastRowNum();
        int i = 0;
        while (i <= rows) {
            short n;
            HSSFRow r = sheet.getRow(i);
            if (r != null && (n = r.getLastCellNum()) > col) {
                col = n;
            }
            ++i;
        }
        return col;
    }

    private int getDateType(short format) {
        switch (format) {
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 32: 
            case 33: 
            case 55: 
            case 56: 
            case 179: 
            case 180: {
                return 1;
            }
            case 22: 
            case 183: {
                return 2;
            }
        }
        return 0;
    }
}

