/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.input;

import com.runqian.base.util.Escape;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.input.InputProcessor;
import com.runqian.report.usermodel.Env;
import java.sql.Connection;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AbstractProcessor
implements InputProcessor {
    protected HttpSession session;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected String tableId;
    private Env env;
    private SegmentSet data;
    private String errorMsg;
    private ArrayList sqls = new ArrayList();

    public boolean process() {
        return true;
    }

    public void setContext(HttpServletRequest request, HttpServletResponse response, HttpSession session, Env env, SegmentSet data) {
        this.request = request;
        this.response = response;
        this.session = session;
        this.env = env;
        this.data = data;
    }

    public Connection getConnection() {
        return this.env.getConnection();
    }

    public Connection getConnection(String dsn) {
        return this.env.getConnection(dsn);
    }

    public String getCellData(String cellName) {
        if (cellName == null) {
            return "";
        }
        cellName = cellName.toUpperCase();
        return Escape.removeEscAndQuote(this.data.get(cellName));
    }

    public void setCellData(String cellName, String cellValue) {
        if (cellName == null) {
            return;
        }
        cellName = cellName.toUpperCase();
        this.data.put(cellName, Escape.addEscAndQuote(cellValue));
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String msg) {
        this.errorMsg = msg;
    }

    public void processAfterSave() {
    }

    void addSql(String sql) {
        this.sqls.add(sql);
    }

    protected String[] getSqls() {
        String[] s = new String[this.sqls.size()];
        int i = 0;
        while (i < s.length) {
            s[i] = (String)this.sqls.get(i);
            ++i;
        }
        return s;
    }
}

