/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.input;

import com.runqian.base.util.Sentence;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.input.ExcelNotation;
import java.util.ArrayList;

public class ExpTransform {
    private ArrayList parts = new ArrayList();
    private CellSet cs;

    public ExpTransform(String exp, CellSet cs) throws Exception {
        this.cs = cs;
        if (exp == null) {
            exp = "";
        }
        int len = exp.length();
        int idx = 0;
        while (idx < len) {
            int tmp;
            char ch = exp.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                tmp = Sentence.scanQuotation(exp, idx, '\\');
                if (tmp < 0) {
                    throw new Exception("\u8868\u8fbe\u5f0f" + exp + "\u4e2d\u5f15\u53f7\u4e0d\u5339\u914d\uff01");
                }
                this.add(exp.substring(idx, tmp + 1));
                idx = tmp + 1;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch)) {
                tmp = Sentence.scanIdentifier(exp, idx);
                String thisPart = "";
                thisPart = tmp < len - 1 ? exp.substring(idx, tmp + 1) : exp.substring(idx);
                this.add(thisPart);
                idx = tmp + 1;
                continue;
            }
            this.add(String.valueOf(ch));
            ++idx;
        }
    }

    private void add(String s) {
        this.parts.add(s);
    }

    public void move(int deltaRow, int deltaCol) throws Exception {
        int maxRow = this.cs.getRow() - 1;
        int maxCol = this.cs.getColumn() - 1;
        int i = 0;
        while (i < this.parts.size()) {
            String part = (String)this.parts.get(i);
            if (!part.startsWith("$")) {
                CellPosition pos;
                boolean rowFixed = false;
                boolean colFixed = false;
                int n = part.indexOf("$");
                if (n > 0) {
                    if (n == part.length() - 1) {
                        rowFixed = true;
                    } else {
                        colFixed = true;
                    }
                    part = this.removeDollar(part);
                }
                if (ExcelNotation.isValidExcelNotation(part) && (pos = ExcelNotation.toCellPosition(part)).getRow() <= maxRow && pos.getColumn() <= maxCol) {
                    if (!rowFixed) {
                        pos.addRow(deltaRow);
                    }
                    if (!colFixed) {
                        pos.addColumn(deltaCol);
                    }
                    if (pos.getRow() >= 0 && pos.getColumn() >= 0 && pos.getRow() <= maxRow && pos.getColumn() <= maxCol) {
                        this.parts.set(i, ExcelNotation.toExcelNotation(pos.getRow(), pos.getColumn()));
                    }
                }
            }
            ++i;
        }
    }

    public void removeDollar() {
        int i = 0;
        while (i < this.parts.size()) {
            String part = (String)this.parts.get(i);
            if (part.indexOf("$") >= 0 && ExcelNotation.isValidExcelNotation(part = this.removeDollar(part))) {
                this.parts.set(i, part);
            }
            ++i;
        }
    }

    private String removeDollar(String src) {
        src = StringUtils.replace(src, "$", "");
        return src;
    }

    public void replaceExcelNotation(String str, String dotEndStr) {
        int i = 0;
        while (i < this.parts.size()) {
            String part = (String)this.parts.get(i);
            if (this.isValidCell(i)) {
                String replace = str;
                if (i < this.parts.size() - 1 && ".".equals((String)this.parts.get(i + 1))) {
                    replace = dotEndStr;
                }
                replace = Sentence.replace(replace, "[EXCELNOTATION]", part.toUpperCase(), 19);
                this.parts.set(i, replace);
            }
            ++i;
        }
    }

    public void replaceParamExcelNotation(String formName) {
        int i = 0;
        while (i < this.parts.size()) {
            CellPosition pos;
            String paramName;
            String part = (String)this.parts.get(i);
            if (this.isValidCell(i) && (paramName = (String)this.cs.getPropertyValue((pos = ExcelNotation.toCellPosition(part)).getRow(), pos.getColumn(), 4702)) != null && paramName.trim().length() != 0) {
                this.parts.set(i, "document." + formName + "." + paramName.trim() + ".value");
            }
            ++i;
        }
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.parts.size()) {
            s = String.valueOf(s) + (String)this.parts.get(i);
            ++i;
        }
        return s;
    }

    public ArrayList getParts() {
        return this.parts;
    }

    public boolean isValidCell(int partIndex) {
        String part = (String)this.parts.get(partIndex);
        if (!ExcelNotation.isValidExcelNotation(part)) {
            return false;
        }
        CellPosition pos = new CellPosition(part);
        return pos.getRow() >= 0 && pos.getRow() < this.cs.getRow() && pos.getColumn() >= 0 && pos.getColumn() < this.cs.getColumn();
    }

    public static void main(String[] args) {
        try {
            ExpTransform et = new ExpTransform("updateValue = ${8} d6,b$6,c6$,$b3;keyValue=b6", new CellSet(10, 20));
            et.move(1, 1);
            et.removeDollar();
            System.out.println(et);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

