/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.input;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Logger;
import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellPosition;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.input.ExcelNotation;
import com.runqian.report.input.ExpTransform;
import com.runqian.report.input.UpdateProp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class InputUtils {
    public static void resolvePropertyRef(CellSet cs, int key, int refKey, String refPropName) throws Exception {
        int col;
        if (cs.isNewInputVersion()) {
            return;
        }
        CellSetParser parser = new CellSetParser(cs);
        int row = 0;
        while (row < cs.getRow()) {
            col = 0;
            while (col < cs.getColumn()) {
                String self;
                String ref;
                if (!(parser.isMerged(row, col) && !parser.isMergedFirstCell(row, col) || (ref = (String)cs.getPropertyValue(row, col, refKey)) == null || ref.trim().length() == 0 || (self = (String)cs.getPropertyValue(row, col, key)) != null && self.trim().length() != 0)) {
                    CellPosition refPos = InputUtils.getRefCell(cs, ref);
                    if (refPos == null) {
                        throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684" + refPropName + ref + "\u4e0d\u6b63\u786e\uff01");
                    }
                    ref = (String)cs.getPropertyValue(refPos.getRow(), refPos.getColumn(), key);
                    if (ref != null && ref.trim().length() != 0) {
                        ref = InputUtils.resolveDollarBrace(ref, row - refPos.getRow(), col - refPos.getColumn());
                        ExpTransform et = new ExpTransform(ref, cs);
                        et.move(row - refPos.getRow(), col - refPos.getColumn());
                        cs.setPropertyValue(row, col, key, et.toString());
                    }
                }
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < cs.getRow()) {
            col = 0;
            while (col < cs.getColumn()) {
                String self = (String)cs.getPropertyValue(row, col, key);
                if (self != null && self.trim().length() != 0) {
                    ExpTransform et = new ExpTransform(self, cs);
                    et.removeDollar();
                    cs.setPropertyValue(row, col, key, et.toString());
                }
                ++col;
            }
            ++row;
        }
    }

    private static CellPosition getRefCell(CellSet cs, String ref) {
        if ((ref = ref.trim().toUpperCase()).startsWith("#REF!")) {
            return null;
        }
        CellPosition refPos = null;
        try {
            refPos = new CellPosition(Integer.parseInt(ref), 0);
        }
        catch (Exception e) {
            if (InputUtils.isAllLetter(ref)) {
                refPos = new CellPosition(String.valueOf(ref) + "0");
            }
            try {
                refPos = new CellPosition(ref);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (refPos.getRow() >= cs.getRow() || refPos.getRow() < 0 || refPos.getColumn() >= cs.getColumn() || refPos.getColumn() < 0) {
            refPos = null;
        }
        return refPos;
    }

    public static ArrayList getUpdates(CellSet cs) throws Exception {
        ArrayList<UpdateProp> al = new ArrayList<UpdateProp>();
        CellSetParser parser = new CellSetParser(cs);
        int row = 0;
        while (row < cs.getRow()) {
            int col = 0;
            while (col < cs.getColumn()) {
                String update;
                if ((!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) && (update = (String)cs.getPropertyValue(row, col, 4801)) != null && update.trim().length() != 0) {
                    if (update.startsWith("#REF!")) {
                        throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684\u66f4\u65b0\u8bbe\u7f6e" + update + "\u4e0d\u6b63\u786e\uff01");
                    }
                    UpdateProp up = new UpdateProp(update);
                    al.add(up);
                    Logger.debug("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684\u66f4\u65b0\u5c5e\u6027\uff1a" + update);
                }
                ++col;
            }
            ++row;
        }
        return al;
    }

    private static boolean isAllLetter(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (!Character.isLetter(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static HashSet getKeyCells(CellSet cellset) throws Exception {
        HashSet<String> keyCells = new HashSet<String>();
        CellSetParser parser = new CellSetParser(cellset);
        int row = 0;
        while (row < cellset.getRow()) {
            int col = 0;
            while (col < cellset.getColumn()) {
                if (!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) {
                    String update = (String)cellset.getPropertyValue(row, col, 4801);
                    UpdateProp up = new UpdateProp(update);
                    int i = 0;
                    while (i < up.getUpdateCount()) {
                        ArgumentTokenizer at = new ArgumentTokenizer(up.getKeyValue(i), ',');
                        while (at.hasMoreTokens()) {
                            keyCells.add(at.nextToken().trim().toUpperCase());
                        }
                        ++i;
                    }
                }
                ++col;
            }
            ++row;
        }
        return keyCells;
    }

    public static HashSet getUpdatableCells(CellSet cellset) throws Exception {
        HashSet<String> updatableCells = new HashSet<String>();
        CellSetParser parser = new CellSetParser(cellset);
        int row = 0;
        while (row < cellset.getRow()) {
            int col = 0;
            while (col < cellset.getColumn()) {
                if (!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) {
                    String update = (String)cellset.getPropertyValue(row, col, 4801);
                    UpdateProp up = new UpdateProp(update);
                    int i = 0;
                    while (i < up.getUpdateCount()) {
                        ArgumentTokenizer at = new ArgumentTokenizer(up.getUpdateValue(i), ',');
                        while (at.hasMoreTokens()) {
                            updatableCells.add(at.nextToken().trim().toUpperCase());
                        }
                        ++i;
                    }
                }
                ++col;
            }
            ++row;
        }
        return updatableCells;
    }

    public static ArrayList getAutoCalcList(CellSet cellset) throws Exception {
        InputUtils.resolvePropertyRef(cellset, 4807, 4809, "\u586b\u5199\u65f6\u8ba1\u7b97\u8868\u8fbe\u5f0f\u5f15\u7528");
        ArrayList<String> cells = new ArrayList<String>();
        ArrayList<String> calcs = new ArrayList<String>();
        CellSetParser parser = new CellSetParser(cellset);
        int row = 1;
        while (row < cellset.getRow()) {
            int col = 1;
            while (col < cellset.getColumn()) {
                String autoCalc;
                if ((!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) && (autoCalc = (String)cellset.getPropertyValue(row, col, 4807)) != null && autoCalc.trim().length() != 0) {
                    if (autoCalc.startsWith("#REF!")) {
                        throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684\u586b\u62a5\u65f6\u8ba1\u7b97\u8868\u8fbe\u5f0f" + autoCalc + "\u4e0d\u6b63\u786e\uff01");
                    }
                    autoCalc = autoCalc.trim();
                    cells.add(ExcelNotation.toExcelNotation(row, col));
                    calcs.add(autoCalc);
                }
                ++col;
            }
            ++row;
        }
        ArrayList<String> al = new ArrayList<String>(cells.size());
        int counts = 0;
        while (cells.size() > 0) {
            if (counts > 1000) {
                String s = "";
                int i = 0;
                while (i < calcs.size()) {
                    s = String.valueOf(s) + (String)cells.get(i) + " = " + (String)calcs.get(i) + ",";
                    ++i;
                }
                s = s.substring(0, s.length() - 1);
                throw new Exception("\u586b\u62a5\u65f6\u8ba1\u7b97\u8868\u8fbe\u5f0f" + s + "\u4e2d\u6709\u5faa\u73af\u5f15\u7528\uff01");
            }
            String cellName = (String)cells.get(0);
            String autoCalc = (String)calcs.get(0);
            ExpTransform et = new ExpTransform(autoCalc, cellset);
            ArrayList parts = et.getParts();
            boolean calcNext = false;
            int i = 0;
            while (i < parts.size()) {
                if (et.isValidCell(i)) {
                    String part = (String)parts.get(i);
                    CellPosition cp = new CellPosition(part = part.toUpperCase());
                    String tmp = (String)cellset.getPropertyValue(cp.getRow(), cp.getColumn(), 4807);
                    if (tmp != null && tmp.trim().length() > 0 && cells.contains(part)) {
                        calcNext = true;
                        break;
                    }
                }
                ++i;
            }
            cells.remove(0);
            calcs.remove(0);
            if (calcNext) {
                cells.add(cellName);
                calcs.add(autoCalc);
            } else {
                al.add(String.valueOf(cellName) + "=" + autoCalc);
            }
            ++counts;
        }
        return al;
    }

    public static String createAutoCalcScript(CellSet cellset, String reportName, boolean inNS) throws Exception {
        ArrayList al = InputUtils.getAutoCalcList(cellset);
        StringBuffer sb = new StringBuffer();
        sb.append("\t\tvar value;\n");
        int i = 0;
        while (i < al.size()) {
            String autoCalc = (String)al.get(i);
            int pos = autoCalc.indexOf("=");
            String cell = autoCalc.substring(0, pos);
            autoCalc = autoCalc.substring(pos + 1);
            sb.append("\t\ttry { value = ");
            ExpTransform et = new ExpTransform(autoCalc, cellset);
            if (inNS) {
                et.replaceExcelNotation("_parseValue( document.getElementById( '" + reportName + "_[EXCELNOTATION]' ) )", "document.getElementById( '" + reportName + "_[EXCELNOTATION]' ).value");
                sb.append(String.valueOf(et.toString()) + ";\n");
                sb.append("\t\tdocument.getElementById( '" + reportName + "_" + cell + "' ).value = value + \"\";\n");
                sb.append("\t\tdocument.getElementById( '" + reportName + "_" + cell + "' ).innerHTML = value + \"\";\n");
                sb.append("\t\t_formatCalcValue( document.getElementById( '" + reportName + "_" + cell + "' ) );\n");
            } else {
                et.replaceExcelNotation("_parseValue( " + reportName + "_[EXCELNOTATION] )", String.valueOf(reportName) + "_[EXCELNOTATION].value");
                sb.append(String.valueOf(et.toString()) + ";\n");
                sb.append("\t\t" + reportName + "_" + cell + ".value = value + \"\";\n");
                sb.append("\t\t" + reportName + "_" + cell + ".innerText = value;\n");
                sb.append("\t\t_formatCalcValue( " + reportName + "_" + cell + " );\n");
            }
            sb.append("\t\t}catch(e1){}\n");
            ++i;
        }
        return sb.toString();
    }

    public static HashMap getValidInfo(CellSet cellset) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CellSetParser parser = new CellSetParser(cellset);
        int row = 0;
        while (row < cellset.getRow()) {
            int col = 0;
            while (col < cellset.getColumn()) {
                String valid;
                if ((!parser.isMerged(row, col) || parser.isMergedFirstCell(row, col)) && (valid = (String)cellset.getPropertyValue(row, col, 4803)) != null && valid.trim().length() != 0) {
                    if (valid.startsWith("#REF!")) {
                        throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684\u6570\u636e\u6709\u6548\u6027\u8868\u8fbe\u5f0f" + valid + "\u4e0d\u6b63\u786e\uff01");
                    }
                    valid = InputUtils.resolveDollarBrace(valid, 0, 0);
                    ArgumentTokenizer at = new ArgumentTokenizer(valid, '\u0001');
                    while (at.hasMoreTokens()) {
                        ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), '\u0000');
                        String exp = at1.nextToken();
                        String msg = at1.nextToken();
                        exp = InputUtils.replaceEqual(exp, 0);
                        exp = Sentence.replace(exp, "<>", "!=", 2);
                        exp = Sentence.replace(exp, " and ", " && ", 3);
                        exp = Sentence.replace(exp, " or ", " || ", 3);
                        map.put(exp, msg);
                    }
                }
                ++col;
            }
            ++row;
        }
        return map;
    }

    public static String createCheckValidScript(CellSet cellset, String reportName, boolean inNS) throws Exception {
        StringBuffer sb = new StringBuffer();
        HashMap map = InputUtils.getValidInfo(cellset);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String exp = (String)it.next();
            String msg = (String)map.get(exp);
            ExpTransform et = new ExpTransform(exp, cellset);
            if (inNS) {
                et.replaceExcelNotation("_parseValue( document.getElementById( '" + reportName + "_[EXCELNOTATION]' ) )", "document.getElementById( '" + reportName + "_[EXCELNOTATION]' ).attributes.getNamedItem( \"value\" ).value");
            } else {
                et.replaceExcelNotation("_parseValue( " + reportName + "_[EXCELNOTATION] )", String.valueOf(reportName) + "_[EXCELNOTATION].value");
            }
            sb.append("\t\tif( ! ( " + et.toString() + " ) ) {\n");
            sb.append("\t\t\talert( '" + msg + "' );\n");
            sb.append("\t\t\treturn false;\n");
            sb.append("\t\t}\n");
        }
        sb.append("\t\treturn true;\n");
        return sb.toString();
    }

    public static String replaceEqual(String exp, int start) {
        int pos = Sentence.indexOf(exp, "=", start, 2);
        if (pos >= 0) {
            char c;
            boolean needReplace = true;
            if (pos > 0 && ((c = exp.charAt(pos - 1)) == '=' || c == '!' || c == '>' || c == '<')) {
                needReplace = false;
            }
            if (pos < exp.length() - 1 && (c = exp.charAt(pos + 1)) == '=') {
                needReplace = false;
            }
            if (needReplace) {
                exp = String.valueOf(exp.substring(0, pos)) + "==" + exp.substring(pos + 1);
                start = pos + 2;
                return InputUtils.replaceEqual(exp, start);
            }
            start = pos + 1;
            return InputUtils.replaceEqual(exp, start);
        }
        return exp;
    }

    private static String resolveDollarBrace(String src, int rowMove, int colMove) {
        int move = rowMove;
        if (move == 0) {
            move = colMove;
        }
        int start;
        while ((start = src.indexOf("${")) >= 0) {
            int end = src.indexOf("}", start);
            if (end < 0) {
                return src;
            }
            String tmp = src.substring(start + 2, end);
            try {
                int newValue = Integer.parseInt(tmp.trim());
                src = String.valueOf(src.substring(0, start)) + (newValue += move) + src.substring(end + 1);
            }
            catch (Exception exception) {
            }
        }
        return src;
    }

    public static HashMap getValidInfo(CellSet cellset, int row, int col) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CellSetParser parser = new CellSetParser(cellset);
        String valid = (String)cellset.getPropertyValue(row, col, 4803);
        if (valid == null || valid.trim().length() == 0) {
            return map;
        }
        if (valid.startsWith("#REF!")) {
            throw new Exception("\u7b2c" + row + "\u884c\u7b2c" + col + "\u5217\u7684\u6570\u636e\u6709\u6548\u6027\u8868\u8fbe\u5f0f" + valid + "\u4e0d\u6b63\u786e\uff01");
        }
        valid = InputUtils.resolveDollarBrace(valid, 0, 0);
        ArgumentTokenizer at = new ArgumentTokenizer(valid, '\u0001');
        while (at.hasMoreTokens()) {
            String rightNow;
            ArgumentTokenizer at1 = new ArgumentTokenizer(at.nextToken(), '\u0000');
            String exp = at1.nextToken();
            String msg = at1.nextToken();
            if (!at1.hasMoreTokens() || !(rightNow = at1.nextToken()).equals("1")) continue;
            exp = InputUtils.replaceEqual(exp, 0);
            exp = Sentence.replace(exp, "<>", "!=", 2);
            exp = Sentence.replace(exp, " and ", " && ", 3);
            exp = Sentence.replace(exp, " or ", " || ", 3);
            map.put(exp, msg);
        }
        return map;
    }

    public static String createCheckValidScript(CellSet cellset, String reportName, int row, int col, boolean inNS) throws Exception {
        StringBuffer sb = new StringBuffer();
        HashMap map = InputUtils.getValidInfo(cellset, row, col);
        if (map.size() == 0) {
            return "";
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String exp = (String)it.next();
            String msg = (String)map.get(exp);
            ExpTransform et = new ExpTransform(exp, cellset);
            if (inNS) {
                et.replaceExcelNotation("_parseValue( document.getElementById( '" + reportName + "_[EXCELNOTATION]' ) )", "document.getElementById( '" + reportName + "_[EXCELNOTATION]' ).attributes.getNamedItem( \"value\" ).value");
            } else {
                et.replaceExcelNotation("_parseValue( " + reportName + "_[EXCELNOTATION] )", String.valueOf(reportName) + "_[EXCELNOTATION].value");
            }
            sb.append("\t\tif( ! ( " + et.toString() + " ) ) {\n");
            sb.append("\t\t\talert( '" + msg + "' );\n");
            sb.append("\t\t\treturn false;\n");
            sb.append("\t\t}\n");
        }
        sb.append("\t\treturn true;\n");
        return sb.toString();
    }

    public static String createParamCheckValidScript(CellSet cellset, String formName) throws Exception {
        StringBuffer sb = new StringBuffer();
        HashMap map = InputUtils.getValidInfo(cellset);
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String exp = (String)it.next();
            String msg = (String)map.get(exp);
            ExpTransform et = new ExpTransform(exp, cellset);
            et.replaceParamExcelNotation(formName);
            sb.append("\t\tif( ! ( " + et.toString() + " ) ) {\n");
            sb.append("\t\t\talert( '" + msg + "' );\n");
            sb.append("\t\t\treturn false;\n");
            sb.append("\t\t}\n");
        }
        sb.append("\t\treturn true;\n");
        return sb.toString();
    }

    public static String createParamCheckValidScript(CellSet cellset, String formName, int row, int col) throws Exception {
        StringBuffer sb = new StringBuffer();
        HashMap map = InputUtils.getValidInfo(cellset, row, col);
        if (map.size() == 0) {
            return "";
        }
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String exp = (String)it.next();
            String msg = (String)map.get(exp);
            ExpTransform et = new ExpTransform(exp, cellset);
            et.replaceParamExcelNotation(formName);
            sb.append("\t\tif( ! ( " + et.toString() + " ) ) {\n");
            sb.append("\t\t\talert( '" + msg + "' );\n");
            sb.append("\t\t\treturn false;\n");
            sb.append("\t\t}\n");
        }
        sb.append("\t\treturn true;\n");
        return sb.toString();
    }
}

