/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.pager;

import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.pager.Pager;
import com.runqian.report.pager.SimplePager;
import java.awt.print.PageFormat;
import java.util.ArrayList;

public class PageBuilder {
    private Pager pager;
    private CellSet cs;
    private int columns;
    public static final int UNLIMITED_PAGESIZE = 999999999;
    private boolean isInEditor = false;
    private boolean processLeanLine = true;

    public PageBuilder(CellSet cellset) throws Exception {
        this.init(cellset, 0, 0, 0);
    }

    public PageBuilder(CellSet cellset, int pageWidth, int pageHeight) throws Exception {
        this.init(cellset, pageWidth, pageHeight, 0);
    }

    public PageBuilder(CellSet cellset, int pageWidth, int pageHeight, boolean isInEditor, boolean processLeanLine) throws Exception {
        this.isInEditor = isInEditor;
        this.processLeanLine = processLeanLine;
        this.init(cellset, pageWidth, pageHeight, 0);
    }

    public PageBuilder(CellSet cellset, int pageWidth, int pageHeight, int columns) throws Exception {
        this.init(cellset, pageWidth, pageHeight, columns);
    }

    public PageBuilder(CellSet cellset, int pageWidth, int pageHeight, int columns, boolean processLeanLine) throws Exception {
        this.processLeanLine = processLeanLine;
        this.init(cellset, pageWidth, pageHeight, columns);
    }

    private void init(CellSet cellset, int pageWidth, int pageHeight, int columns) throws Exception {
        this.cs = cellset;
        CellSetParser parser = new CellSetParser(cellset);
        if (columns == 0) {
            columns = parser.getColumns();
        }
        PageFormat pf = parser.getPageFormat();
        if (pageWidth == 0) {
            pageWidth = (int)pf.getImageableWidth();
        }
        if (pageHeight == 0) {
            pageHeight = (int)pf.getImageableHeight();
        }
        if (pageWidth < 0) {
            pageWidth = 999999999;
        }
        if (pageHeight < 0) {
            pageHeight = 999999999;
        }
        this.pager = new SimplePager(cellset, pageWidth, pageHeight, this.processLeanLine);
        this.pager.setColumns(columns);
        this.columns = columns;
        this.pager.isInEditor = this.isInEditor;
        this.pager.createPages();
    }

    public int getPageCount() {
        return this.pager.getPageCount();
    }

    public CellSet getPage(int pageNo) throws Exception {
        if (pageNo < 1 || pageNo > this.getPageCount()) {
            throw new Exception("\u9875\u53f7\u65e0\u6548");
        }
        return this.pager.getPage(pageNo - 1);
    }

    public ArrayList getAllPages() {
        ArrayList<CellSet> al = new ArrayList<CellSet>();
        int i = 0;
        while (i < this.pager.getPageCount()) {
            al.add(this.pager.getPage(i));
            ++i;
        }
        return al;
    }

    public int getColumns() {
        return this.columns;
    }

    public CellSet getCellSet() {
        return this.cs;
    }

    public int getPapersCount() {
        CellSetParser csp = new CellSetParser(this.cs);
        int count = (int)Math.ceil((double)this.getPageCount() * 1.0 / (double)(csp.getLayoutRows() * csp.getLayoutCols()));
        return count;
    }
}

