/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.pager;

import com.runqian.base.util.Logger;
import com.runqian.base.util.Sentence;
import com.runqian.base.util.StringUtils;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetOperator;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.control.ControlUtils;
import com.runqian.report.control.LeanLine;
import com.runqian.report.pager.PageBuilder;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;

abstract class Pager {
    protected int pageWidth = 0;
    protected int pageHeight = 0;
    protected int columns = 1;
    protected CellSet inCellSet;
    protected CellSetParser parser;
    protected CellSetOperator operator;
    protected ArrayList pages;
    private ArrayList pageGetted = new ArrayList();
    public boolean isInEditor = false;

    public Pager(CellSet cellset, int pageWidth, int pageHeight) {
        this(cellset, pageWidth, pageHeight, true);
    }

    public Pager(CellSet cellset, int pageWidth, int pageHeight, boolean processLeanLine) {
        int col;
        this.pageHeight = pageHeight;
        this.pageWidth = pageWidth;
        this.inCellSet = cellset;
        this.parser = new CellSetParser(cellset);
        this.operator = new CellSetOperator(cellset);
        this.pages = new ArrayList();
        int rows = cellset.getRow();
        int cols = cellset.getColumn();
        int row = 1;
        while (row < rows) {
            col = 1;
            while (col < cols) {
                if (!this.parser.isMerged(row, col) || this.parser.isMergedFirstCell(row, col)) {
                    Object obj;
                    Integer dataType;
                    Object hideRow;
                    Object pageBreak;
                    Object dataType2;
                    Object wrap = cellset.getPropertyValue(row, col, 4107);
                    if (wrap != null && ((Boolean)wrap).booleanValue() && ((Integer)(dataType2 = cellset.getPropertyValue(row, col, 4101))).intValue() == CellPropertyDefine.CDT_TEXT.intValue()) {
                        String text = "";
                        Object data = this.parser.getPropertyValue(row, col, 4105);
                        if (data != null) {
                            text = data.toString().trim();
                        }
                        if (text.length() == 0 && (data = this.parser.getPropertyValue(row, col, 4102)) != null) {
                            text = data.toString().trim();
                        }
                        if (text.trim().length() > 0) {
                            this.adjustRowHeight(row, col, text);
                        }
                    }
                    if ((pageBreak = cellset.getPropertyValue(row, col, 3102)) != null && ((Boolean)pageBreak).booleanValue()) {
                        if (this.parser.isMerged(row, col)) {
                            if (this.parser.isMergedFirstCell(row, col)) {
                                int endRow = this.parser.getMergedEndRow(row, col);
                                cellset.setPropertyValue(endRow, 0, 3102, Boolean.TRUE);
                            }
                        } else {
                            cellset.setPropertyValue(row, 0, 3102, Boolean.TRUE);
                        }
                    }
                    if ((pageBreak = cellset.getPropertyValue(row, col, 2103)) != null && ((Boolean)pageBreak).booleanValue()) {
                        if (this.parser.isMerged(row, col)) {
                            if (this.parser.isMergedFirstCell(row, col)) {
                                int endCol = this.parser.getMergedEndCol(row, col);
                                cellset.setPropertyValue(0, endCol, 2103, Boolean.TRUE);
                            }
                        } else {
                            cellset.setPropertyValue(0, col, 2103, Boolean.TRUE);
                        }
                    }
                    if ((hideRow = cellset.getPropertyValue(row, col, 4111)) != null && ((Boolean)hideRow).booleanValue()) {
                        if (this.parser.isMerged(row, col)) {
                            if (this.parser.isMergedFirstCell(row, col)) {
                                cellset.setPropertyValue(row, 0, 4106, Boolean.FALSE);
                            }
                        } else {
                            cellset.setPropertyValue(row, 0, 4106, Boolean.FALSE);
                        }
                    }
                    if ((dataType = (Integer)cellset.getPropertyValue(row, col, 4101)).intValue() == CellPropertyDefine.CDT_PIC_FILE.intValue() && (obj = cellset.getPropertyValue(row, col, 4102)) != null && obj instanceof String) {
                        File picFile = new File(obj.toString());
                        try {
                            InputStream is = null;
                            is = picFile.exists() ? new FileInputStream(picFile) : this.getClass().getResourceAsStream("/com/runqian/report/ide/resources/app_logo.jpg");
                            cellset.setPropertyValue(row, col, 4102, ControlUtils.getStreamBytes(is));
                            is.close();
                        }
                        catch (Exception is) {
                            // empty catch block
                        }
                    }
                    if (dataType.intValue() == CellPropertyDefine.CDT_PIC_FILE.intValue() || dataType.intValue() == CellPropertyDefine.CDT_PIC_DB.intValue()) {
                        obj = this.parser.getPropertyValue(row, col, 4102);
                        if (obj instanceof byte[]) {
                            int w = this.parser.getMergedWidth(row, col, false);
                            int h = this.parser.getMergedHeight(row, col, false);
                            Image image = new ImageIcon((byte[])obj).getImage();
                            int iw = image.getWidth(null);
                            int ih = image.getHeight(null);
                            if (iw > w || ih > h) {
                                Object adjust = this.parser.getPropertyValue(row, col, 4109);
                                if (((Integer)adjust).intValue() == CellPropertyDefine.CAS_EXTEND.intValue()) {
                                    this.adjustCellSize(row, col, iw, ih);
                                } else if (((Integer)adjust).intValue() == CellPropertyDefine.CAS_SHRINK.intValue()) {
                                    int newW = w;
                                    int newH = h;
                                    if (iw > w && ih > h) {
                                        double scale = (double)w * 1.0 / (double)iw;
                                        if ((double)h * 1.0 / (double)ih < scale) {
                                            scale = (double)h * 1.0 / (double)ih;
                                        }
                                        newW = (int)((double)iw * scale);
                                        newH = (int)((double)ih * scale);
                                    } else if (iw > w) {
                                        newW = w;
                                        newH = (int)((double)(ih * w) * 1.0 / (double)iw);
                                    } else if (ih > h) {
                                        newH = h;
                                        newW = (int)((double)(iw * h) * 1.0 / (double)ih);
                                    }
                                    try {
                                        BufferedImage bi = new BufferedImage(newW, newH, 1);
                                        bi.getGraphics().drawImage(image, 0, 0, newW, newH, null);
                                        cellset.setPropertyValue(row, col, 4102, this.BufferedImage2Bytes(bi));
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                        }
                    } else if (dataType.intValue() == CellPropertyDefine.CDT_SUBREPORT.intValue()) {
                        obj = this.parser.getPropertyValue(row, col, 4102);
                        if (obj instanceof CellSet) {
                            CellSet sub = (CellSet)obj;
                            int columns = 1;
                            try {
                                columns = Integer.parseInt(sub.getPropertyValue(0, 0, 1106).toString());
                            }
                            catch (Exception image) {
                                // empty catch block
                            }
                            if (columns > 1) {
                                try {
                                    sub = new PageBuilder(sub, 999999999, 999999999, columns).getPage(1);
                                    cellset.setPropertyValue(row, col, 4102, sub);
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), e);
                                }
                            }
                            int w = this.parser.getMergedWidth(row, col, false);
                            int h = this.parser.getMergedHeight(row, col, false);
                            CellSetParser subParser = new CellSetParser(sub);
                            int subw = subParser.getCellSetWidth();
                            int subh = subParser.getCellSetHeight();
                            if (subw > w || subh > h) {
                                Object adjust = this.parser.getPropertyValue(row, col, 4109);
                                if (((Integer)adjust).intValue() == CellPropertyDefine.CAS_EXTEND.intValue()) {
                                    this.adjustCellSize(row, col, subw, subh);
                                } else if (((Integer)adjust).intValue() == CellPropertyDefine.CAS_SHRINK.intValue()) {
                                    int i;
                                    if (subh > h) {
                                        int subRows = subParser.getRowCount();
                                        i = 1;
                                        while (i < subRows) {
                                            if (subParser.isRowVisible(i)) {
                                                int hh = subParser.getRowHeight(i);
                                                int newH = hh * h / subh;
                                                sub.setPropertyValue(i, 0, 3101, new Float(newH));
                                            }
                                            ++i;
                                        }
                                    }
                                    if (subw > w) {
                                        int subCols = subParser.getColCount();
                                        i = 1;
                                        while (i < subCols) {
                                            if (subParser.isColVisible(i)) {
                                                int ww = subParser.getColWidth(i);
                                                int newW = ww * w / subw;
                                                sub.setPropertyValue(0, i, 2101, new Float(newW));
                                            }
                                            ++i;
                                        }
                                    }
                                }
                            }
                        }
                    } else if (dataType.intValue() == CellPropertyDefine.CDT_TEXT.intValue() && ((Integer)(obj = this.parser.getPropertyValue(row, col, 4109))).intValue() == CellPropertyDefine.CAS_EXTEND.intValue()) {
                        FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(this.getFont(row, col));
                        String text = "";
                        obj = this.parser.getPropertyValue(row, col, 4105);
                        if (obj != null) {
                            text = obj.toString().trim();
                        }
                        if (text.length() == 0 && (obj = this.parser.getPropertyValue(row, col, 4102)) != null) {
                            text = obj.toString().trim();
                        }
                        int w = fm.stringWidth(text);
                        int indent = (Integer)this.parser.getPropertyValue(row, col, 4203);
                        int align = (Integer)this.parser.getPropertyValue(row, col, 4201);
                        if (align == CellPropertyDefine.CA_CENTER) {
                            indent *= 2;
                        }
                        int h = this.parser.getMergedHeight(row, col, false);
                        this.adjustCellSize(row, col, w + indent + 2, h);
                    }
                }
                ++col;
            }
            ++row;
        }
        if (processLeanLine) {
            row = 1;
            while (row < rows) {
                col = 1;
                while (col < cols) {
                    Object obj;
                    if (!(this.parser.isMerged(row, col) && !this.parser.isMergedFirstCell(row, col) || (obj = cellset.getPropertyValue(row, col, 4414)) == null || Integer.parseInt(obj.toString()) <= 1 || !((obj = this.parser.getPropertyValue(row, col, 4102)) instanceof String) && obj != null)) {
                        int w = this.parser.getMergedWidth(row, col, false);
                        int h = this.parser.getMergedHeight(row, col, false);
                        if (w != 0 && h != 0) {
                            BufferedImage bi = new BufferedImage(w, h, 1);
                            LeanLine ll = new LeanLine(this.parser, row, col);
                            ll.draw(bi.getGraphics(), 0, 0, w, h);
                            try {
                                cellset.setPropertyValue(row, col, 4101, CellPropertyDefine.CDT_PIC_FILE);
                                cellset.setPropertyValue(row, col, 4102, this.BufferedImage2Bytes(bi));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++col;
                }
                ++row;
            }
        }
    }

    protected int getPageCount() {
        return this.pages.size();
    }

    protected CellSet getPage(int pageNo) {
        CellSet pcs = (CellSet)this.pages.get(pageNo);
        if (this.isInEditor) {
            return pcs;
        }
        if (!this.pageGetted.contains(String.valueOf(pageNo))) {
            CellSetParser csp = new CellSetParser(pcs);
            Field header = csp.getPageHeader();
            this.replacePageNo(header, pcs, pageNo + 1);
            Field title = csp.getTitleField();
            this.replacePageNo(title, pcs, pageNo + 1);
            Field tableFooter = csp.getFooterField();
            this.replacePageNo(tableFooter, pcs, pageNo + 1);
            Field footer = csp.getPageFooter();
            this.replacePageNo(footer, pcs, pageNo + 1);
            this.pageGetted.add(String.valueOf(pageNo));
        }
        return pcs;
    }

    private void replacePageNo(Field field, CellSet cs, int pageNo) {
        if (field != null) {
            int start = field.getStartRow();
            int end = field.getEndRow();
            int totalPage = this.getPageCount();
            int row = start;
            while (row <= end) {
                int col = 1;
                while (col < cs.getColumn()) {
                    Object value = cs.getPropertyValue(row, col, 4102);
                    if (value != null && value instanceof String) {
                        String s = (String)value;
                        s = Sentence.replace(s, "{currpage_cn}", StringUtils.toChinese(pageNo, true, false), 19);
                        s = Sentence.replace(s, "{totalpage_cn}", StringUtils.toChinese(totalPage, true, false), 19);
                        s = Sentence.replace(s, "{currpage}", String.valueOf(pageNo), 19);
                        s = Sentence.replace(s, "{totalpage}", String.valueOf(totalPage), 19);
                        cs.setPropertyValue(row, col, 4102, s);
                    }
                    ++col;
                }
                ++row;
            }
        }
    }

    protected void setColumns(int columns) {
        this.columns = columns;
    }

    abstract void createPages() throws Exception;

    private void adjustRowHeight(int row, int col, String text) {
        if (text.trim().length() == 0) {
            return;
        }
        if (this.parser.isMerged(row, col) && !this.parser.isMergedFirstCell(row, col)) {
            return;
        }
        int w = this.parser.getMergedWidth(row, col, false);
        FontMetrics fm = new BufferedImage(10, 10, 2).getGraphics().getFontMetrics(this.getFont(row, col));
        ArrayList al = ControlUtils.wrapString(text, fm, w -= (Integer)this.parser.getPropertyValue(row, col, 4203) * 2);
        int lineH = fm.getAscent() + fm.getDescent() + fm.getLeading();
        int totalH = lineH * al.size() + 5;
        int oldH = this.parser.getMergedHeight(row, col, false);
        if (oldH < totalH) {
            if (this.parser.isMerged(row, col)) {
                int rowspan = this.parser.getRowSpan(row, col, false);
                int dh = (int)Math.ceil((double)(totalH - oldH) * 1.0 / (double)rowspan);
                int startRow = this.parser.getMergedStartRow(row, col);
                int endRow = this.parser.getMergedEndRow(row, col);
                int i = startRow;
                while (i <= endRow) {
                    if (this.parser.isRowVisible(i)) {
                        int h = this.parser.getRowHeight(i);
                        this.inCellSet.setPropertyValue(i, 0, 3101, new Float(h += dh));
                    }
                    ++i;
                }
            } else {
                this.inCellSet.setPropertyValue(row, 0, 3101, new Float(totalH));
            }
        }
    }

    private Font getFont(int row, int col) {
        Object value = this.parser.getPropertyValue(row, col, 4301);
        String face = "\u5b8b\u4f53";
        if (value != null) {
            face = value.toString();
        }
        value = this.parser.getPropertyValue(row, col, 4302);
        int size = 12;
        if (value != null) {
            size = Integer.parseInt(value.toString());
        }
        int fontStyle = 0;
        value = this.parser.getPropertyValue(row, col, 4304);
        if (value != null && ((Boolean)value).booleanValue()) {
            ++fontStyle;
        }
        if ((value = this.parser.getPropertyValue(row, col, 4305)) != null && ((Boolean)value).booleanValue()) {
            fontStyle += 2;
        }
        return new Font(face, fontStyle, size);
    }

    private void adjustCellSize(int row, int col, int toWidth, int toHeight) {
        int i;
        int w = this.parser.getMergedWidth(row, col, false);
        int h = this.parser.getMergedHeight(row, col, false);
        if (toWidth > w) {
            if (this.parser.isMerged(row, col)) {
                int colspan = this.parser.getColSpan(row, col, false);
                int dw = (int)Math.ceil((double)(toWidth - w) * 1.0 / (double)colspan);
                int startCol = this.parser.getMergedStartCol(row, col);
                int endCol = this.parser.getMergedEndCol(row, col);
                i = startCol;
                while (i <= endCol) {
                    if (this.parser.isColVisible(i)) {
                        int ww = this.parser.getColWidth(i);
                        this.inCellSet.setPropertyValue(0, i, 2101, new Float(ww += dw));
                    }
                    ++i;
                }
            } else {
                this.inCellSet.setPropertyValue(0, col, 2101, new Float(toWidth));
            }
        }
        if (toHeight > h) {
            if (this.parser.isMerged(row, col)) {
                int rowspan = this.parser.getRowSpan(row, col, false);
                int dh = (int)Math.ceil((double)(toHeight - h) * 1.0 / (double)rowspan);
                int startRow = this.parser.getMergedStartRow(row, col);
                int endRow = this.parser.getMergedEndRow(row, col);
                i = startRow;
                while (i <= endRow) {
                    if (this.parser.isRowVisible(i)) {
                        int hh = this.parser.getRowHeight(i);
                        this.inCellSet.setPropertyValue(i, 0, 3101, new Float(hh += dh));
                    }
                    ++i;
                }
            } else {
                this.inCellSet.setPropertyValue(row, 0, 3101, new Float(toHeight));
            }
        }
    }

    private byte[] BufferedImage2Bytes(BufferedImage bi) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        JPEGEncodeParam jp = encoder.getDefaultJPEGEncodeParam(bi);
        jp.setDensityUnit(1);
        jp.setQuality(1.0f, true);
        encoder.encode(bi, jp);
        return out.toByteArray();
    }
}

