/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.pager;

import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetOperator;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.Field;
import com.runqian.report.pager.Pager;

class SimplePager
extends Pager {
    private int displayedRow = 0;
    private int displayedCol = 0;
    private int currPageRowNo;
    private int currPageColNo;
    private int currPageHeight;
    private int currPageWidth;
    private Field titleField;
    private Field topHeader;
    private Field footerField;
    private Field dataField;
    private Field pageHeader;
    private Field pageFooter;
    private CellSetOperator rowsOperator;
    private CellSetParser rowsParser;
    private int tableEndRow;
    private boolean isFirstCol = true;

    public SimplePager(CellSet cellset, int pageWidth, int pageHeight, boolean processLeanLine) {
        super(cellset, pageWidth, pageHeight, processLeanLine);
    }

    void createPages() throws Exception {
        int hfs;
        this.titleField = this.parser.getTitleField();
        this.topHeader = this.parser.getTopHeader();
        this.footerField = this.parser.getFooterField();
        this.dataField = this.parser.getDataField();
        this.pageHeader = this.parser.getPageHeader();
        this.pageFooter = this.parser.getPageFooter();
        if (this.pageWidth == 999999999 && this.pageHeight == 999999999 && this.columns == 1) {
            this.adjustTitleAndFooter(this.inCellSet);
            this.modifyMergedExp(this.inCellSet);
            this.pages.add(this.inCellSet);
            return;
        }
        if (this.pageHeight == 999999999 && this.columns == 1) {
            this.rowsParser = new CellSetParser(this.inCellSet);
            this.rowsOperator = new CellSetOperator(this.inCellSet);
            this.displayedCol = 0;
            this.splitPageCols(this.inCellSet);
            return;
        }
        this.tableEndRow = this.dataField.getEndRow();
        if (this.footerField != null) {
            this.pageHeight -= this.parser.getFieldScanHeight(this.footerField);
        }
        boolean hasPageHeader = false;
        boolean hasPageFooter = false;
        int pageStyle = (Integer)this.parser.getPropertyValue(0, 0, 1210);
        if (this.pageHeader != null) {
            if (pageStyle == CellPropertyDefine.CPS_PAPER) {
                hasPageHeader = true;
            }
            if (pageStyle == CellPropertyDefine.CPS_ROWS) {
                hfs = (Integer)this.parser.getPropertyValue(0, 0, 1215);
                if (hfs == CellPropertyDefine.CHS_ALL) {
                    hasPageHeader = false;
                }
                if (hfs == CellPropertyDefine.CHS_ONE) {
                    hasPageHeader = true;
                }
            }
        }
        if (this.pageFooter != null) {
            if (pageStyle == CellPropertyDefine.CPS_PAPER) {
                hasPageFooter = true;
            }
            if (pageStyle == CellPropertyDefine.CPS_ROWS) {
                hfs = (Integer)this.parser.getPropertyValue(0, 0, 1215);
                if (hfs == CellPropertyDefine.CHS_ALL) {
                    hasPageFooter = false;
                }
                if (hfs == CellPropertyDefine.CHS_ONE) {
                    hasPageFooter = true;
                }
            }
        }
        if (hasPageHeader) {
            this.pageHeight -= this.parser.getFieldScanHeight(this.pageHeader);
        }
        if (hasPageFooter) {
            this.pageHeight -= this.parser.getFieldScanHeight(this.pageFooter);
        }
        this.splitPageRows();
    }

    private void splitPageRows() throws Exception {
        block2: while (this.displayedRow != this.tableEndRow) {
            int k;
            CellSetParser csp;
            int row;
            CellSet currPageRows = new CellSet(1, this.inCellSet.getColumn());
            currPageRows.setNeedAdjust(false);
            this.operator.copyRowTo(0, currPageRows, 0);
            this.currPageRowNo = 1;
            this.currPageHeight = 0;
            this.copyPageHeaderField(currPageRows);
            this.copyTitleField(currPageRows);
            int topHeaderStartRow = this.currPageRowNo;
            this.copyTopHeader(currPageRows);
            Object pagerStyle = this.parser.getPropertyValue(0, 0, 1210);
            if (((Integer)pagerStyle).intValue() == CellPropertyDefine.CPS_PAPER.intValue()) {
                int dataStartRow = this.currPageRowNo;
                if (this.columns == 1) {
                    int firstDataRow;
                    int row2 = firstDataRow = this.displayedRow + 1;
                    while (row2 <= this.tableEndRow) {
                        String candisplayrow = this.canDisplayRow(row2);
                        if (candisplayrow.equals("yes") || candisplayrow.equals("pageBreak") && row2 == firstDataRow) {
                            this.operator.copyRowTo(row2, currPageRows, this.currPageRowNo);
                            this.rowDisplayed(row2);
                        } else if (candisplayrow.equals("invisible")) {
                            this.operator.copyRowTo(row2, currPageRows, this.currPageRowNo);
                            ++this.currPageRowNo;
                            if (this.displayedRow < row2) {
                                this.displayedRow = row2;
                            }
                        } else {
                            if (row2 == firstDataRow) {
                                throw new Exception("\u62a5\u8868\u4e2d\u7b2c" + row2 + "\u884c\u7684\u9ad8\u5ea6\u6bd4\u7ed9\u5b9a\u7eb8\u5f20\u9ad8\uff0c\u65e0\u6cd5\u5206\u9875!");
                            }
                            this.processMergedCellRowCut(row2, currPageRows, 1);
                            break;
                        }
                        ++row2;
                    }
                }
                if (this.columns > 1) {
                    int willDisplayStartRow;
                    int willDisplayEndRow = willDisplayStartRow = this.displayedRow + 1;
                    int currColumnHeight = 0;
                    row = this.displayedRow + 1;
                    block4: while (row <= this.tableEndRow) {
                        String canDisplay = this.canDisplayRowForColumn(row, currColumnHeight);
                        if (canDisplay.equals("yes")) {
                            willDisplayEndRow = row;
                            currColumnHeight += this.parser.getRowHeight(row);
                        } else {
                            if (canDisplay.equals("no")) {
                                int tmpRowsPerColumns = row - willDisplayStartRow;
                                int tmpEndRow = willDisplayStartRow + this.columns * tmpRowsPerColumns - 1;
                                tmpEndRow = tmpEndRow < this.dataField.getEndRow() ? tmpEndRow : this.dataField.getEndRow();
                                int i = row;
                                while (i <= tmpEndRow) {
                                    Boolean pageBreak = (Boolean)this.inCellSet.getPropertyValue(i, 0, 3102);
                                    if (pageBreak != null && pageBreak.booleanValue()) {
                                        willDisplayEndRow = i;
                                        break block4;
                                    }
                                    willDisplayEndRow = i++;
                                }
                                break;
                            }
                            if (canDisplay.equals("pageBreak") && row != this.displayedRow + 1) {
                                willDisplayEndRow = row - 1;
                                break;
                            }
                        }
                        ++row;
                    }
                    int willDisplayRows = willDisplayEndRow - willDisplayStartRow + 1;
                    int rowsPerColumn = willDisplayRows % this.columns == 0 ? willDisplayRows / this.columns : willDisplayRows / this.columns + 1;
                    int currColumn = 1;
                    while (currColumn <= this.columns) {
                        if (currColumn == 1) {
                            int row3 = willDisplayStartRow;
                            while (row3 < willDisplayStartRow + rowsPerColumn) {
                                this.operator.copyRowTo(row3, currPageRows, this.currPageRowNo);
                                this.rowDisplayed(row3);
                                ++row3;
                            }
                        } else {
                            int startRow;
                            int endRow;
                            int col = 1;
                            while (col < this.parser.getColCount()) {
                                int targetCol = col + (currColumn - 1) * (this.parser.getColCount() - 1);
                                this.operator.copyCellTo(0, col, currPageRows, 0, targetCol);
                                ++col;
                            }
                            int k2 = 0;
                            if (this.topHeader != null) {
                                int row4 = this.topHeader.getStartRow();
                                while (row4 <= this.topHeader.getEndRow()) {
                                    int targetRow = topHeaderStartRow + k2;
                                    int col2 = this.topHeader.getStartColumn();
                                    while (col2 <= this.topHeader.getEndColumn()) {
                                        int targetCol = col2 + (currColumn - 1) * (this.topHeader.getEndColumn() - this.topHeader.getStartColumn() + 1);
                                        this.operator.copyCellTo(row4, col2, currPageRows, targetRow, targetCol);
                                        ++col2;
                                    }
                                    ++k2;
                                    ++row4;
                                }
                            }
                            endRow = (endRow = (startRow = willDisplayStartRow + (currColumn - 1) * rowsPerColumn) + rowsPerColumn - 1) < willDisplayEndRow ? endRow : willDisplayEndRow;
                            k2 = 0;
                            int row5 = startRow;
                            while (row5 <= endRow) {
                                int targetRow = dataStartRow + k2;
                                int col3 = this.dataField.getStartColumn();
                                while (col3 <= this.dataField.getEndColumn()) {
                                    int targetCol = col3 + (currColumn - 1) * (this.dataField.getEndColumn() - this.dataField.getStartColumn() + 1);
                                    this.operator.copyCellTo(row5, col3, currPageRows, targetRow, targetCol);
                                    ++col3;
                                }
                                this.displayedRow = row5++;
                                ++k2;
                            }
                        }
                        if (this.displayedRow < this.parser.getRowCount() - 1) {
                            this.processMergedCellRowCut(this.displayedRow + 1, currPageRows, currColumn);
                        }
                        ++currColumn;
                    }
                }
            } else if (((Integer)pagerStyle).intValue() == CellPropertyDefine.CPS_ROWS.intValue()) {
                int firstDataRow;
                Object oPageRows = this.parser.getPropertyValue(0, 0, 1211);
                int pageRows = 10;
                if (oPageRows != null) {
                    try {
                        pageRows = Integer.parseInt(oPageRows.toString());
                        if (pageRows < 1) {
                            pageRows = 10;
                        }
                    }
                    catch (Exception willDisplayEndRow) {
                        // empty catch block
                    }
                }
                int copyedRows = 0;
                row = firstDataRow = this.displayedRow + 1;
                while (row <= this.tableEndRow) {
                    this.operator.copyRowTo(row, currPageRows, this.currPageRowNo);
                    ++this.currPageRowNo;
                    if (this.displayedRow < row) {
                        this.displayedRow = row;
                    }
                    if (this.parser.isRowVisible(row)) {
                        ++copyedRows;
                    }
                    if (copyedRows == pageRows && row < this.tableEndRow) {
                        this.processMergedCellRowCut(row + 1, currPageRows, 1);
                        break;
                    }
                    ++row;
                }
            }
            if (this.footerField != null) {
                int row6 = this.footerField.getStartRow();
                while (row6 <= this.footerField.getEndRow()) {
                    this.operator.copyRowTo(row6, currPageRows, this.currPageRowNo);
                    ++this.currPageRowNo;
                    ++row6;
                }
            }
            this.copyPageFooterField(currPageRows);
            if (this.pageWidth == 999999999) {
                csp = new CellSetParser(currPageRows);
                k = 1;
                while (k < csp.getRowCount()) {
                    if (csp.isRowVisible(k)) {
                        this.adjustTitleAndFooter(currPageRows);
                        this.modifyMergedExp(currPageRows);
                        this.pages.add(currPageRows);
                        continue block2;
                    }
                    ++k;
                }
                continue;
            }
            this.rowsParser = new CellSetParser(currPageRows);
            this.rowsOperator = new CellSetOperator(currPageRows);
            this.displayedCol = 0;
            csp = new CellSetParser(currPageRows);
            k = 1;
            while (k < csp.getRowCount()) {
                if (csp.isRowVisible(k)) {
                    this.adjustTitleAndFooter(currPageRows);
                    this.modifyMergedExp(currPageRows);
                    this.splitPageCols(currPageRows);
                    continue block2;
                }
                ++k;
            }
        }
    }

    private void copyPageHeaderField(CellSet cs) {
        if (this.pageHeader == null) {
            return;
        }
        int startRow = this.pageHeader.getStartRow();
        int endRow = this.pageHeader.getEndRow();
        int row = startRow;
        while (row <= endRow) {
            this.operator.copyRowTo(row, cs, this.currPageRowNo++);
            if (this.displayedRow < row) {
                this.displayedRow = row;
            }
            ++row;
        }
        cs.insertRow(this.currPageRowNo);
        cs.setPropertyValue(this.currPageRowNo, 0, 4106, new Boolean(false));
        cs.setPropertyValue(this.currPageRowNo++, 0, 3103, CellPropertyDefine.CRT_PAGE_HEADER);
    }

    private void copyPageFooterField(CellSet cs) {
        if (this.pageFooter == null) {
            return;
        }
        int startRow = this.pageFooter.getStartRow();
        int endRow = this.pageFooter.getEndRow();
        int hideRow = this.currPageRowNo;
        int row = startRow;
        while (row <= endRow) {
            ++this.currPageRowNo;
            this.operator.copyRowTo(row, cs, this.currPageRowNo);
            ++row;
        }
        cs.setPropertyValue(hideRow, 0, 4106, new Boolean(false));
        cs.setPropertyValue(hideRow, 0, 3103, CellPropertyDefine.CRT_PAGE_FOOTER);
    }

    private void copyTitleField(CellSet cs) {
        if (this.titleField == null) {
            return;
        }
        int startRow = this.titleField.getStartRow();
        int endRow = this.titleField.getEndRow();
        int row = startRow;
        while (row <= endRow) {
            this.operator.copyRowTo(row, cs, this.currPageRowNo);
            this.rowDisplayed(row);
            ++row;
        }
    }

    private void copyTopHeader(CellSet cs) {
        if (this.topHeader == null) {
            return;
        }
        int startRow = this.topHeader.getStartRow();
        int endRow = this.topHeader.getEndRow();
        int row = startRow;
        while (row <= endRow) {
            this.operator.copyRowTo(row, cs, this.currPageRowNo);
            this.rowDisplayed(row);
            ++row;
        }
    }

    private void copyLeftHeaderField(CellSet srcCs, CellSet cs) {
        CellSetParser srcParser = new CellSetParser(srcCs);
        Field leftHeader = srcParser.getLeftHeader();
        if (leftHeader == null) {
            return;
        }
        int startCol = leftHeader.getStartColumn();
        int endCol = leftHeader.getEndColumn();
        CellSetOperator srcOperator = new CellSetOperator(srcCs);
        int col = startCol;
        while (col <= endCol) {
            srcOperator.copyColumnTo(col, cs, this.currPageColNo);
            this.colDisplayed(col);
            ++col;
        }
    }

    private void rowDisplayed(int row) {
        this.currPageHeight += this.parser.getRowHeight(row);
        ++this.currPageRowNo;
        if (this.displayedRow < row) {
            this.displayedRow = row;
        }
    }

    private String canDisplayRow(int row) {
        if (this.parser.getRowHeight(row) > this.pageHeight - this.currPageHeight) {
            return "no";
        }
        Boolean pageBreak = (Boolean)this.inCellSet.getPropertyValue(row - 1, 0, 3102);
        if (pageBreak != null && pageBreak.booleanValue()) {
            return "pageBreak";
        }
        if (!this.parser.isRowVisible(row)) {
            return "invisible";
        }
        return "yes";
    }

    private String canDisplayRowForColumn(int row, int currColumnHeight) {
        if (this.parser.getRowHeight(row) > this.pageHeight - this.currPageHeight - currColumnHeight) {
            return "no";
        }
        Boolean pageBreak = (Boolean)this.inCellSet.getPropertyValue(row - 1, 0, 3102);
        if (pageBreak != null && pageBreak.booleanValue()) {
            return "pageBreak";
        }
        return "yes";
    }

    private void processMergedCellRowCut(int row, CellSet currPageRows, int currColumn) {
        int col = 1;
        while (col < this.parser.getColCount()) {
            String selfMerge = this.parser.getMergedExp(row, col);
            String topMerge = this.parser.getMergedExp(row - 1, col);
            if (selfMerge.length() > 0 && selfMerge.equalsIgnoreCase(topMerge)) {
                Integer dataType = (Integer)this.parser.getPropertyValue(row, col, 4101);
                if (dataType.intValue() == CellPropertyDefine.CDT_SUBREPORT.intValue()) {
                    throw new RuntimeException("\u8bf7\u52a0\u5927\u7eb8\u5f20\u9ad8\u5ea6\uff0c\u4ee5\u4f7f\u5b50\u62a5\u8868\u80fd\u663e\u793a\u5728\u4e00\u9875\u4e2d\uff01");
                }
                int startRow = this.parser.getMergedStartRow(row, col);
                int endRow = this.parser.getMergedEndRow(row, col);
                int startCol = this.parser.getMergedStartCol(row, col);
                String newMerge = String.valueOf(row) + selfMerge.substring(selfMerge.indexOf(","));
                int i = row;
                while (i <= endRow) {
                    if (i == row && col == startCol) {
                        this.operator.copyCellTo(startRow, startCol, this.inCellSet, i, col);
                    }
                    this.operator.setMergedExp(i, col, newMerge);
                    ++i;
                }
                Boolean repeat = (Boolean)this.inCellSet.getPropertyValue(startRow, startCol, 4601);
                if (!repeat.booleanValue()) {
                    this.inCellSet.setPropertyValue(row, col, 4102, null);
                }
                newMerge = String.valueOf(topMerge.substring(0, topMerge.indexOf("-") + 1)) + (row - 1) + topMerge.substring(topMerge.lastIndexOf(","));
                int pagedCol = (currColumn - 1) * (this.parser.getColCount() - 1) + col;
                int i2 = this.currPageRowNo - (row - startRow);
                while (i2 < this.currPageRowNo) {
                    new CellSetOperator(currPageRows).setMergedExp(i2, pagedCol, newMerge);
                    ++i2;
                }
            }
            ++col;
        }
    }

    private void modifyMergedExp(CellSet cs) {
        CellSetParser csp = new CellSetParser(cs);
        CellSetOperator cso = new CellSetOperator(cs);
        int row = 1;
        while (row < csp.getRowCount()) {
            int col = 1;
            while (col < csp.getColCount()) {
                if (csp.isMergedFirstCell(row, col)) {
                    int n;
                    int colSpan = csp.getColSpan(row, col, true);
                    colSpan = colSpan > (n = csp.getColCount() - col) ? n : colSpan;
                    int rowSpan = csp.getRowSpan(row, col, true);
                    String newMerge = String.valueOf(row) + "," + col + "-" + (row + rowSpan - 1) + "," + (col + colSpan - 1);
                    int i = row;
                    while (i < row + rowSpan) {
                        int j = col;
                        while (j < col + colSpan) {
                            cso.setMergedExp(i, j, newMerge);
                            ++j;
                        }
                        ++i;
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    private void splitPageCols(CellSet currPageRows) throws Exception {
        block0: while (this.displayedCol != currPageRows.getColumn() - 1) {
            int firstDataCol;
            CellSet currPageCellSet = new CellSet(currPageRows.getRow(), 1);
            currPageCellSet.setNeedAdjust(false);
            this.rowsOperator.copyColumnTo(0, currPageCellSet, 0);
            this.currPageColNo = 1;
            this.currPageWidth = 0;
            this.copyLeftHeaderField(currPageRows, currPageCellSet);
            this.isFirstCol = true;
            int col = firstDataCol = this.displayedCol + 1;
            while (col < this.rowsParser.getColCount()) {
                String candisplaycol = this.canDisplayCol(col);
                if (candisplaycol.equals("yes") || candisplaycol.equals("pageBreak") && col == firstDataCol) {
                    this.rowsOperator.copyColumnTo(col, currPageCellSet, this.currPageColNo);
                    this.colDisplayed(col);
                    this.isFirstCol = false;
                } else if (candisplaycol.equals("invisible")) {
                    this.rowsOperator.copyColumnTo(col, currPageCellSet, this.currPageColNo);
                    ++this.currPageColNo;
                    if (this.displayedCol < col) {
                        this.displayedCol = col;
                    }
                } else {
                    this.processMergedCellColCut(col, currPageCellSet);
                    break;
                }
                ++col;
            }
            this.modifyMergedExp(currPageCellSet);
            CellSetParser csp = new CellSetParser(currPageCellSet);
            int k = 1;
            while (k < csp.getColCount()) {
                if (csp.isColVisible(k)) {
                    this.pages.add(currPageCellSet);
                    continue block0;
                }
                ++k;
            }
        }
    }

    private String canDisplayCol(int col) throws Exception {
        if (this.rowsParser.getColWidth(col) > this.pageWidth - this.currPageWidth) {
            if (this.isFirstCol) {
                throw new Exception("\u62a5\u8868\u4e2d\u7b2c" + col + "\u5217\u7684\u5bbd\u5ea6\u6bd4\u7ed9\u5b9a\u7eb8\u5f20\u5bbd\uff0c\u65e0\u6cd5\u5206\u9875!");
            }
            return "no";
        }
        Boolean pageBreak = (Boolean)this.rowsParser.getPropertyValue(0, col - 1, 2103);
        if (pageBreak != null && pageBreak.booleanValue()) {
            return "pageBreak";
        }
        if (!this.rowsParser.isColVisible(col)) {
            return "invisible";
        }
        return "yes";
    }

    private void colDisplayed(int col) {
        this.currPageWidth += this.rowsParser.getColWidth(col);
        ++this.currPageColNo;
        if (this.displayedCol < col) {
            this.displayedCol = col;
        }
    }

    private void processMergedCellColCut(int col, CellSet currPageCellSet) {
        int row = 1;
        while (row < this.rowsParser.getRowCount()) {
            String selfMerge = this.rowsParser.getMergedExp(row, col);
            String leftMerge = this.rowsParser.getMergedExp(row, col - 1);
            if (selfMerge.length() > 0 && selfMerge.equalsIgnoreCase(leftMerge)) {
                Integer dataType = (Integer)this.rowsParser.getPropertyValue(row, col, 4101);
                if (dataType.intValue() == CellPropertyDefine.CDT_SUBREPORT.intValue()) {
                    throw new RuntimeException("\u8bf7\u52a0\u5927\u7eb8\u5f20\u5bbd\u5ea6\uff0c\u4ee5\u4f7f\u5b50\u62a5\u8868\u80fd\u663e\u793a\u5728\u4e00\u9875\u4e2d\uff01");
                }
                int startRow = this.rowsParser.getMergedStartRow(row, col);
                int endCol = this.rowsParser.getMergedEndCol(row, col);
                int startCol = this.rowsParser.getMergedStartCol(row, col);
                String newMerge = String.valueOf(selfMerge.substring(0, selfMerge.indexOf(",") + 1)) + col + selfMerge.substring(selfMerge.indexOf("-"));
                int i = col;
                while (i <= endCol) {
                    if (i == col && row == startRow) {
                        this.rowsOperator.copyCellTo(startRow, startCol, this.rowsParser.getCellSet(), row, i);
                    }
                    this.rowsOperator.setMergedExp(row, i, newMerge);
                    ++i;
                }
                Boolean repeat = (Boolean)this.rowsParser.getPropertyValue(startRow, startCol, 4601);
                if (!repeat.booleanValue()) {
                    this.rowsOperator.setPropertyValue(row, col, 4102, null);
                }
                newMerge = String.valueOf(leftMerge.substring(0, leftMerge.lastIndexOf(",") + 1)) + (col - 1);
                int i2 = this.currPageColNo - (col - startCol);
                while (i2 < this.currPageColNo) {
                    new CellSetOperator(currPageCellSet).setMergedExp(row, i2, newMerge);
                    ++i2;
                }
            }
            ++row;
        }
    }

    private void adjustTitleAndFooter(CellSet cs) {
        CellSetParser csp = new CellSetParser(cs);
        if (this.columns < 2) {
            return;
        }
        int startRow = -1;
        int endRow = -1;
        Field tHeader = csp.getTopHeader();
        if (tHeader != null) {
            startRow = tHeader.getStartRow();
        }
        Field data = csp.getDataField();
        if (startRow == -1) {
            startRow = data.getStartRow();
        }
        endRow = data.getEndRow();
        int row = 1;
        while (row < cs.getRow()) {
            if (row < startRow || row > endRow) {
                this.adjustRow(cs, row);
            }
            ++row;
        }
    }

    private void adjustRow(CellSet cs, int row) {
        CellSetParser csp = new CellSetParser(cs);
        CellSetOperator cso = new CellSetOperator(cs);
        int colDelta = csp.getColCount() - this.parser.getColCount();
        boolean rightMoved = false;
        int col = 1;
        while (col < this.parser.getColCount()) {
            Boolean rightMove = (Boolean)csp.getPropertyValue(row, col, 4108);
            if (rightMove != null && rightMove.booleanValue()) {
                rightMoved = true;
                int i = col;
                while (i < this.parser.getColCount()) {
                    cso.copyCellTo(row, i, cs, row, i + colDelta);
                    ++i;
                }
                this.strechCol(cs, row, col - 1, colDelta);
                break;
            }
            ++col;
        }
        if (!rightMoved) {
            this.strechCol(cs, row, this.parser.getColCount() - 1, colDelta);
        }
    }

    private void strechCol(CellSet cs, int row, int col, int colDelta) {
        CellSetParser csp = new CellSetParser(cs);
        CellSetOperator cso = new CellSetOperator(cs);
        if (csp.isMerged(row, col)) {
            int colspan = csp.getColSpan(row, col, true);
            String mergeExp = csp.getMergedExp(row, col);
            String newMerge = String.valueOf(mergeExp.substring(0, mergeExp.indexOf(",") + 1)) + (col - colspan + 1) + mergeExp.substring(mergeExp.indexOf("-"), mergeExp.lastIndexOf(",") + 1) + (col + colDelta);
            int i = col - colspan + 1;
            while (i <= col + colDelta) {
                if (i > col) {
                    cs.setPropertyMap(row, i, cs.getPropertyMap(row, col));
                }
                cso.setMergedExp(row, i, newMerge);
                ++i;
            }
        } else {
            String merge = String.valueOf(row) + "," + col + "-" + row + "," + (col + colDelta);
            int i = col;
            while (i <= col + colDelta) {
                if (i > col) {
                    cs.setPropertyMap(row, i, cs.getPropertyMap(row, col));
                }
                cso.setMergedExp(row, i, merge);
                ++i;
            }
        }
    }
}

