/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.tag;

import com.runqian.base.util.Argument;
import com.runqian.base.util.Arguments;
import com.runqian.base.util.Escape;
import com.runqian.base.util.Logger;
import com.runqian.base.util.Macros;
import com.runqian.base.util.SegmentSet;
import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.tag.DefaultTagProps;
import com.runqian.report.usermodel.Report;
import com.runqian.report.view.CachedReportPool;
import com.runqian.report.view.ConnectionConfigPool;
import com.runqian.report.view.LicenseException;
import com.runqian.report.view.ParamsPool;
import com.runqian.report.view.ReportCalculator;
import com.runqian.report.view.ServletMappings;
import com.runqian.report.view.html.HtmlReport;
import com.runqian.report.view.html.HtmlReportPage;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class HtmlTag
extends TagSupport {
    private static int sessionId = 100000;
    private String name = null;
    private String reportFileName = null;
    private String scale = null;
    private String srcType = null;
    private String beanName = null;
    private String width = null;
    private String height = null;
    private String columns = null;
    private String needPageMark = null;
    private String funcBarFontFace = null;
    private String funcBarFontSize = null;
    private String funcBarFontColor = null;
    private String functionBarColor = null;
    private String separator = null;
    private String needSaveAsExcel = null;
    private String needSaveAsPdf = null;
    private String needSaveAsText = null;
    private String needPrint = null;
    private String canModifyBeforePrint = null;
    private String funcBarLocation = null;
    private String pageMarkLabel = null;
    private String firstPageLabel = null;
    private String prevPageLabel = null;
    private String nextPageLabel = null;
    private String lastPageLabel = null;
    private String printLabel = null;
    private String excelLabel = null;
    private String pdfLabel = null;
    private String textLabel = null;
    private String textDataSeparator = null;
    private String generateParamForm = null;
    private String displayNoLinkPageMark = null;
    private String connection = null;
    private String params = null;
    private String saveAsName = null;
    private String submit = null;
    private String needOfflineInput = null;
    private String offline = null;
    private String processor = null;
    private String outerDS = null;
    private String needImportExcel = null;
    private String importExcelLabel = null;
    private String usePaperSizePrint = null;
    private String excelPageStyle = null;
    private String printedRaq = null;
    private String backAndRefresh = null;
    private String excelUsePaperSize = null;
    private String canImport2DB;
    private String userFuncBarElements = null;

    public int doStartTag() throws JspTagException {
        try {
            Object report;
            String cachedIdParamName;
            String cachedId;
            boolean inNS;
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            request.setCharacterEncoding("GBK");
            JspWriter out = this.pageContext.getOut();
            String appRoot = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            if (!DefaultTagProps.resolved) {
                DefaultTagProps.resolve(request.getContextPath());
                DefaultTagProps.resolved = true;
            }
            this.initParameters();
            this.name = this.name.trim();
            String turnPageParam = this.getPageParam(request, this.name);
            boolean isInput = false;
            boolean isFile = true;
            boolean bl = inNS = request.getHeader("user-agent").toLowerCase().indexOf("msie") < 0;
            if (this.srcType.equalsIgnoreCase("reportBean") || this.srcType.equalsIgnoreCase("defineBean")) {
                isFile = false;
                String srcId = request.getParameter("srcId");
                if (srcId == null) {
                    if (this.beanName == null || this.beanName.trim().length() == 0) {
                        throw new Exception("\u8bf7\u5728TAG\u4e2d\u6307\u660e\u62a5\u8868\u7684beanName\u5c5e\u6027\uff01");
                    }
                    Report r = (Report)request.getAttribute(this.beanName);
                    request.removeAttribute(this.beanName);
                    if (r == null) {
                        throw new Exception("\u6307\u5b9a\u7684" + this.srcType + " \u201c" + this.beanName + "\u201d\u4e0d\u5b58\u5728\uff01");
                    }
                    srcId = CachedReportPool.put(r.getCellSet());
                } else if (this.beanName != null && this.beanName.trim().length() > 0) {
                    request.removeAttribute(this.beanName);
                }
                this.reportFileName = srcId;
            }
            String resultPageUrl = HtmlTag.getCurrURL(request, this.name);
            String paramsForm = HtmlTag.generateParamsFormHtml(this.generateParamForm, this.srcType, this.reportFileName, appRoot, resultPageUrl, this.pageContext.getServletContext());
            String reportParamsId = request.getParameter("reportParamsId");
            if (reportParamsId != null) {
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=reportParamsId value=" + reportParamsId + ">\n";
            } else if (this.params != null) {
                SegmentSet segs = new SegmentSet(this.params, true, ';');
                Iterator it = segs.keySet().iterator();
                Hashtable<String, String> hash = new Hashtable<String, String>(segs.size());
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String value = segs.get(name);
                    value = Escape.removeEscAndQuote(value);
                    hash.put(name, value);
                }
                reportParamsId = ParamsPool.createParamsId();
                ParamsPool.put(reportParamsId, hash);
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=reportParamsId value=" + reportParamsId + ">\n";
            }
            if (!isFile) {
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=srcId value=" + this.reportFileName + ">\n";
            }
            if (this.connection != null) {
                this.connection = ConnectionConfigPool.put(this.connection);
            }
            if ((cachedId = request.getParameter(cachedIdParamName = String.valueOf(this.name) + "_cachedId")) == null) {
                cachedId = "";
            }
            CellSet[] pages = null;
            String sidParamName = String.valueOf(this.name) + "_sessionId";
            String sessionId = request.getParameter(sidParamName);
            if (sessionId != null) {
                pages = (CellSet[])CachedReportPool.get(sessionId);
            }
            if (pages == null) {
                int i;
                ArrayList al_pages;
                PageBuilder pb;
                ReportCalculator rc = new ReportCalculator(this.pageContext.getServletContext());
                rc.setParameter("fileName", this.reportFileName);
                rc.setParameter("srcType", this.srcType);
                if (reportParamsId != null) {
                    rc.setParameter("reportParamsId", reportParamsId);
                }
                if (this.connection != null) {
                    rc.setParameter("connection", this.connection);
                }
                CellSet cellSet = null;
                try {
                    cellSet = rc.calc();
                }
                catch (LicenseException le) {
                    throw new Exception(le.getMessage());
                }
                if (((Integer)cellSet.getPropertyValue(0, 0, 1101)).intValue() == CellPropertyDefine.CRT_INPUT.intValue()) {
                    isInput = true;
                }
                cachedId = CachedReportPool.put((CellSet)cellSet.clone());
                Object fold = cellSet.getPropertyValue(0, 0, 1109);
                boolean foldable = fold != null && (Boolean)fold != false;
                Logger.debug("\u5f00\u59cb\u5206\u9875......");
                if (!isInput && !foldable) {
                    pb = new PageBuilder(cellSet, Integer.parseInt(this.width), Integer.parseInt(this.height), Integer.parseInt(this.columns));
                    al_pages = pb.getAllPages();
                    pages = new CellSet[al_pages.size()];
                    i = 0;
                    while (i < pages.length) {
                        pages[i] = (CellSet)al_pages.get(i);
                        ++i;
                    }
                    if (pages.length > 1) {
                        sessionId = CachedReportPool.put(pages);
                    }
                } else {
                    pb = new PageBuilder(cellSet, 999999999, 999999999, 1);
                    al_pages = pb.getAllPages();
                    pages = new CellSet[al_pages.size()];
                    i = 0;
                    while (i < pages.length) {
                        pages[i] = (CellSet)al_pages.get(i);
                        ++i;
                    }
                }
                Logger.debug("\u5206\u9875\u7ed3\u675f......");
            }
            CellSetParser parser = new CellSetParser(pages[0]);
            int pageCount = (int)Math.ceil((double)pages.length * 1.0 / (double)(parser.getLayoutRows() * parser.getLayoutCols()));
            String currPageParamName = String.valueOf(this.name) + "_currPage";
            String sCurrPage = request.getParameter(currPageParamName);
            if (sCurrPage == null) {
                sCurrPage = "1";
            }
            int currPage = Integer.parseInt(sCurrPage);
            if (isInput) {
                String inputJS = "input.js";
                if (inNS) {
                    inputJS = "input4ns.js";
                }
                out.println("<script language=javascript src=\"" + appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + inputJS + "\">");
                out.println("</script>");
                out.println("<div id=\"div_" + this.name + "\">");
            }
            if (paramsForm.length() > 0) {
                out.print(paramsForm);
            }
            String funcBarStart = "<table>\n";
            funcBarStart = String.valueOf(funcBarStart) + "\t<tr><td style=\"background-color:" + this.functionBarColor + "\">\n";
            funcBarStart = String.valueOf(funcBarStart) + "\t\t<div style=\"font-family:" + this.funcBarFontFace + ";font-size:" + this.funcBarFontSize + ";color:" + this.funcBarFontColor + "\">\n";
            StringBuffer sbFuncBar = new StringBuffer();
            if (!isInput && this.needPageMark.equalsIgnoreCase("yes")) {
                this.pageMarkLabel = Sentence.replace(this.pageMarkLabel, "{currPage}", String.valueOf(currPage), 1);
                this.pageMarkLabel = Sentence.replace(this.pageMarkLabel, "{totalPage}", String.valueOf(pageCount), 1);
                sbFuncBar.append("\t\t\t" + this.pageMarkLabel + this.separator);
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=" + currPageParamName + " value=\"\">\n";
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=" + sidParamName + " value=" + sessionId + ">\n";
                turnPageParam = String.valueOf(turnPageParam) + "<input type=hidden name=" + cachedIdParamName + " value=" + cachedId + ">\n";
                if (currPage > 1) {
                    sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( 1 );return false\">" + this.firstPageLabel + "</a>" + this.separator);
                    sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( " + (currPage - 1) + " );return false\">" + this.prevPageLabel + "</a>" + this.separator);
                    if (currPage < pageCount) {
                        sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( " + (currPage + 1) + " );return false\">" + this.nextPageLabel + "</a>" + this.separator);
                        sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( " + pageCount + " );return false\">" + this.lastPageLabel + "</a>");
                    } else if (this.displayNoLinkPageMark.equalsIgnoreCase("yes")) {
                        sbFuncBar.append(String.valueOf(this.nextPageLabel) + this.separator);
                        sbFuncBar.append(this.lastPageLabel);
                    }
                } else {
                    if (this.displayNoLinkPageMark.equalsIgnoreCase("yes")) {
                        sbFuncBar.append(String.valueOf(this.firstPageLabel) + this.separator);
                        sbFuncBar.append(String.valueOf(this.prevPageLabel) + this.separator);
                    }
                    if (pageCount > 1) {
                        sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( " + (currPage + 1) + " );return false\">" + this.nextPageLabel + "</a>" + this.separator);
                        sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_toPage( " + pageCount + " );return false\">" + this.lastPageLabel + "</a>");
                    } else if (this.displayNoLinkPageMark.equalsIgnoreCase("yes")) {
                        sbFuncBar.append(String.valueOf(this.nextPageLabel) + this.separator);
                        sbFuncBar.append(this.lastPageLabel);
                    }
                }
                turnPageParam = "<form name=\"" + this.name + "_turnPageForm\" method=post action=\"" + request.getRequestURL().toString() + "?" + new Date().getTime() + "\" style=\"display:none\">\n" + turnPageParam;
                turnPageParam = String.valueOf(turnPageParam) + "</form><script language=javascript>\n\tfunction " + this.name + "_toPage( pageNo ) {\n" + "\t\tdocument." + this.name + "_turnPageForm." + currPageParamName + ".value = pageNo;\n" + "\t\tdocument." + this.name + "_turnPageForm.submit();\n\t}\n</script>\n";
                out.print(turnPageParam);
            }
            String printedFileName = this.reportFileName;
            if (this.printedRaq != null) {
                printedFileName = this.printedRaq;
            }
            String xlsUrl = String.valueOf(appRoot) + ServletMappings.getMapping("com.runqian.report.view.excel.ExcelReportServlet") + "?file=" + printedFileName + "&columns=" + this.columns + "&srcType=" + this.srcType;
            if (this.excelUsePaperSize.equalsIgnoreCase("no")) {
                xlsUrl = String.valueOf(xlsUrl) + "&width=" + this.width + "&height=" + this.height;
            }
            if (reportParamsId != null) {
                xlsUrl = String.valueOf(xlsUrl) + "&reportParamsId=" + reportParamsId;
            }
            if (this.connection != null) {
                xlsUrl = String.valueOf(xlsUrl) + "&connection=" + this.connection;
            }
            if (this.saveAsName != null) {
                xlsUrl = String.valueOf(xlsUrl) + "&saveAsName=" + this.saveAsName;
            }
            if (this.printedRaq == null) {
                xlsUrl = String.valueOf(xlsUrl) + "&cachedId=" + cachedId;
            }
            xlsUrl = String.valueOf(xlsUrl) + "&t_i_m_e=" + new Date().getTime();
            try {
                xlsUrl = URLEncoder.encode(xlsUrl);
            }
            catch (Throwable t) {
                xlsUrl = URLEncoder.encode(xlsUrl);
            }
            out.println("<script language=javascript>");
            out.println("\tfunction " + this.name + "_saveAsExcel() {");
            out.println("\t\tvar address = \"" + appRoot + ServletMappings.getMapping("com.runqian.report.view.excel.ConfigExcelServlet") + "?url=" + xlsUrl + "\";");
            if (this.excelPageStyle != null) {
                String pageStyle = "0";
                if (this.excelPageStyle.equals("1")) {
                    pageStyle = "1";
                }
                if (inNS) {
                    out.println("\t\tdocument.getElementById( \"" + this.name + "_saveAs_frame\" ).src = address + \"&pageStyle=" + pageStyle + "\";");
                } else {
                    out.println("\t\tdocument." + this.name + "_saveAs_frame.location = address + \"&pageStyle=" + pageStyle + "\";");
                }
            } else {
                out.println("\t\twindow.open( address + \"&frame=" + this.name + "_saveAs_frame\", \"\", \"width=300, height=180, left=250, top=200, status=no resizable=yes\" );");
            }
            out.println("\t}");
            out.println("</script>");
            if (this.needSaveAsExcel.equalsIgnoreCase("yes")) {
                if (sbFuncBar.length() > 0) {
                    sbFuncBar.append(this.separator);
                }
                sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_saveAsExcel();return false\">" + this.excelLabel + "</a>");
            }
            String pdfUrl = String.valueOf(appRoot) + ServletMappings.getMapping("com.runqian.report.view.pdf.PdfReportServlet") + "?file=" + printedFileName + "&columns=" + this.columns + "&srcType=" + this.srcType;
            if (reportParamsId != null) {
                pdfUrl = String.valueOf(pdfUrl) + "&reportParamsId=" + reportParamsId;
            }
            if (this.connection != null) {
                pdfUrl = String.valueOf(pdfUrl) + "&connection=" + this.connection;
            }
            if (this.saveAsName != null) {
                pdfUrl = String.valueOf(pdfUrl) + "&saveAsName=" + this.saveAsName;
            }
            if (this.printedRaq == null) {
                pdfUrl = String.valueOf(pdfUrl) + "&cachedId=" + cachedId;
            }
            pdfUrl = String.valueOf(pdfUrl) + "&t_i_m_e=" + new Date().getTime();
            out.println("<script language=javascript>");
            out.println("\tfunction " + this.name + "_saveAsPdf() {");
            if (inNS) {
                out.println("\t\tdocument.getElementById( \"" + this.name + "_saveAs_frame\" ).src = \"" + pdfUrl + "\";");
            } else {
                out.println("\t\tdocument." + this.name + "_saveAs_frame.location = \"" + pdfUrl + "\";");
            }
            out.println("\t}");
            out.println("</script>\n");
            out.println("<iframe name=\"" + this.name + "_saveAs_frame\" id=\"" + this.name + "_saveAs_frame\" style=\"display:none\"></iframe>");
            if (this.needSaveAsPdf.equalsIgnoreCase("yes")) {
                if (sbFuncBar.length() > 0) {
                    sbFuncBar.append(this.separator);
                }
                sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_saveAsPdf();return false\">" + this.pdfLabel + "</a>");
            }
            String textUrl = String.valueOf(appRoot) + ServletMappings.getMapping("com.runqian.report.view.text.TextFileServlet") + "?file=" + printedFileName + "&srcType=" + this.srcType + "&separator=" + URLEncoder.encode(this.textDataSeparator);
            if (reportParamsId != null) {
                textUrl = String.valueOf(textUrl) + "&reportParamsId=" + reportParamsId;
            }
            if (this.connection != null) {
                textUrl = String.valueOf(textUrl) + "&connection=" + this.connection;
            }
            if (this.saveAsName != null) {
                textUrl = String.valueOf(textUrl) + "&saveAsName=" + this.saveAsName;
            }
            if (this.printedRaq == null) {
                textUrl = String.valueOf(textUrl) + "&cachedId=" + cachedId;
            }
            textUrl = String.valueOf(textUrl) + "&t_i_m_e=" + new Date().getTime();
            out.println("<script language=javascript>");
            out.println("\tfunction " + this.name + "_saveAsText() {");
            if (inNS) {
                out.println("\t\tdocument.getElementById( \"" + this.name + "_saveAs_frame\" ).src = \"" + textUrl + "\";");
            } else {
                out.println("\t\tdocument." + this.name + "_saveAs_frame.location = \"" + textUrl + "\";");
            }
            out.println("\t}");
            out.println("</script>\n");
            if (this.needSaveAsText.equalsIgnoreCase("yes")) {
                if (sbFuncBar.length() > 0) {
                    sbFuncBar.append(this.separator);
                }
                sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_saveAsText();return false\">" + this.textLabel + "</a>");
            }
            String printUrl = String.valueOf(appRoot) + ServletMappings.getMapping("com.runqian.report.view.html.PrintServlet") + "?name=" + this.name + "&reportFileName=" + printedFileName + "&canModifyBeforePrint=" + this.canModifyBeforePrint + "&srcType=" + this.srcType;
            if (reportParamsId != null) {
                printUrl = String.valueOf(printUrl) + "&reportParamsId=" + reportParamsId;
            }
            if (this.connection != null) {
                printUrl = String.valueOf(printUrl) + "&connection=" + this.connection;
            }
            if (this.printedRaq == null) {
                printUrl = String.valueOf(printUrl) + "&cachedId=" + cachedId;
            }
            printUrl = String.valueOf(printUrl) + "&t_i_m_e=" + new Date().getTime();
            out.println("<script language=javascript>");
            out.println("\tfunction " + this.name + "_print() {");
            if (inNS) {
                out.println("\t\tdocument.getElementById( \"" + this.name + "_printIFrame\" ).src = \"" + printUrl + "\";");
            } else {
                out.println("\t\tdocument." + this.name + "_printIFrame.location = \"" + printUrl + "\";");
            }
            out.println("\t}");
            out.println("</script>");
            out.println("<iframe name=\"" + this.name + "_printIFrame\" id=\"" + this.name + "_printIFrame\" style=\"position:absolute;left:-100px;top:-100px\" width=50 height=50></iframe>");
            if (this.needPrint.equalsIgnoreCase("yes")) {
                if (sbFuncBar.length() > 0) {
                    sbFuncBar.append(this.separator);
                }
                sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_print();return false\">" + this.printLabel + "</a>");
            }
            if (isInput) {
                if (sbFuncBar.length() > 0) {
                    sbFuncBar.append(this.separator);
                }
                if (this.needImportExcel.equalsIgnoreCase("yes")) {
                    sbFuncBar.append("<a href=\"#\" onclick=\"" + this.name + "_importExcel();return false\">" + this.importExcelLabel + "</a>" + this.separator);
                }
                if (inNS) {
                    sbFuncBar.append("<span id=runqian_submit style=\"cursor:pointer\" onclick=\"_submitTable( document.getElementById( '" + this.name + "' ) )\">" + this.submit + "</span>");
                } else {
                    sbFuncBar.append("<span id=runqian_submit style=\"cursor:pointer\" onclick=\"_submitTable( " + this.name + " )\">" + this.submit + "</span>");
                }
                if (!inNS && this.needOfflineInput.equalsIgnoreCase("yes")) {
                    int pos;
                    String localName = this.saveAsName;
                    if ((localName == null || localName.trim().length() == 0) && (pos = (localName = this.reportFileName).lastIndexOf(".")) > 0) {
                        localName = localName.substring(0, pos);
                    }
                    localName = String.valueOf(localName) + ".html";
                    if (inNS) {
                        sbFuncBar.append(String.valueOf(this.separator) + "<span style=\"cursor:pointer\" onclick=\"_saveToLocal( document.getElementById( '" + this.name + "' ), '" + localName + "' )\">" + this.offline + "</span>");
                    } else {
                        sbFuncBar.append(String.valueOf(this.separator) + "<span style=\"cursor:pointer\" onclick=\"_saveToLocal( " + this.name + ", '" + localName + "' )\">" + this.offline + "</span>");
                    }
                }
            }
            String funcBar = "";
            if (sbFuncBar.length() > 0) {
                funcBar = String.valueOf(funcBarStart) + sbFuncBar.toString();
                if (this.userFuncBarElements != null) {
                    funcBar = String.valueOf(funcBar) + this.separator + this.userFuncBarElements;
                }
                funcBar = String.valueOf(funcBar) + "\t\t</div>";
                funcBar = String.valueOf(funcBar) + "\t</td></tr>";
                funcBar = String.valueOf(funcBar) + "</table>\n";
            }
            if (funcBar.length() > 0 && (this.funcBarLocation.equalsIgnoreCase("top") || this.funcBarLocation.equalsIgnoreCase("both"))) {
                out.print(funcBar);
            }
            float reportScale = 1.0f;
            try {
                reportScale = Float.parseFloat(this.scale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug("\u5f00\u59cb\u751f\u6210HTML......");
            if (isInput) {
                report = new HtmlReport(parser.getCellSet(), this.name, request.getContextPath(), request, isInput);
                ((HtmlReport)report).setScale(reportScale);
                ((HtmlReport)report).setParamsId(reportParamsId);
                out.print(((HtmlReport)report).generateHtml());
            } else {
                report = new HtmlReportPage(this.name, pages, currPage, request.getContextPath(), request);
                ((HtmlReportPage)report).setScale(reportScale);
                ((HtmlReportPage)report).setPrintWriter((Writer)out);
                ((HtmlReportPage)report).generateHtml();
            }
            Logger.debug("\u751f\u6210HTML\u7ed3\u675f......");
            if (funcBar.length() > 0 && (this.funcBarLocation.equalsIgnoreCase("bottom") || this.funcBarLocation.equalsIgnoreCase("both"))) {
                out.print(funcBar);
            }
            if (isInput) {
                String form = "<div style=\"display:none\"><form id=\"" + this.name + "_submitForm\" method=post action=\"" + appRoot + ServletMappings.getMapping("com.runqian.report.input.SaveDataServlet") + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=fileName value=\"" + this.reportFileName + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=srcType value=\"" + this.srcType + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=cachedId value=\"" + cachedId + "\">\n";
                String backPage = HtmlTag.getCurrURL(request, this.name);
                if (reportParamsId != null) {
                    backPage = String.valueOf(backPage) + "&reportParamsId=" + reportParamsId;
                }
                form = String.valueOf(form) + "\t<input type=hidden name=pageUrl value=\"" + backPage + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=backAndRefresh value=\"" + this.backAndRefresh + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=data>\n";
                form = String.valueOf(form) + "\t<input type=hidden name=originData>\n";
                String args = "";
                if (reportParamsId != null) {
                    Hashtable hashParam = ParamsPool.get(reportParamsId);
                    Iterator it = hashParam.keySet().iterator();
                    while (it.hasNext()) {
                        String pName = (String)it.next();
                        String pValue = (String)hashParam.get(pName);
                        if (args.length() > 0) {
                            args = String.valueOf(args) + ";";
                        }
                        args = String.valueOf(args) + pName + "=" + pValue;
                    }
                    form = String.valueOf(form) + "\t<input type=hidden name=params value=\"" + args + "\">\n";
                }
                if (this.processor != null && this.processor.trim().length() > 0) {
                    form = String.valueOf(form) + "\t<input type=hidden name=processor value=\"" + this.processor + "\">\n";
                }
                form = String.valueOf(form) + "</form>";
                out.println(form);
                if (!inNS && this.needOfflineInput.equalsIgnoreCase("yes")) {
                    form = "<form id=\"" + this.name + "_saveToLocalForm\" method=post target=\"" + this.name + "_saveToLocalFrame\" action=\"" + appRoot + ServletMappings.getMapping("com.runqian.report.input.SaveToLocalServlet") + "\">\n";
                    form = String.valueOf(form) + "\t<input type=hidden name=fileContent>\n";
                    form = String.valueOf(form) + "\t<input type=hidden name=saveAsName>\n";
                    form = String.valueOf(form) + "</form>\n";
                    form = String.valueOf(form) + "<iframe name=\"" + this.name + "_saveToLocalFrame\" id=\"" + this.name + "_saveToLocalFrame\" style=\"display:none\"></iframe>";
                    out.println(form);
                }
                out.println("</div>");
                out.println("<script language=javascript>");
                out.println("\tfunction " + this.name + "_importExcel() {");
                String importUrl = String.valueOf(appRoot) + ServletMappings.getMapping("com.runqian.report.input.SelectExcelFileServlet") + "?fileName=" + this.reportFileName + "&srcType=" + this.srcType + "&cachedId=" + cachedId + "&backAndRefresh=" + this.backAndRefresh + "&webTableName=" + this.name;
                if (args.length() > 0) {
                    importUrl = String.valueOf(importUrl) + "&params=" + URLEncoder.encode(args);
                }
                if (this.processor != null && this.processor.trim().length() > 0) {
                    importUrl = String.valueOf(importUrl) + "&processor=" + URLEncoder.encode(this.processor);
                }
                if (this.canImport2DB != null && this.canImport2DB.length() > 0) {
                    importUrl = String.valueOf(importUrl) + "&canImport2DB=" + this.canImport2DB;
                }
                out.println("\t\tvar address = \"" + importUrl + "\";");
                out.println("\t\twindow.open( address, \"\", \"left=200, top=250, height=180, width=400, status=no, resizable=yes\" );");
                out.println("\t}");
                out.println("</script>");
                out.println("</div>");
            }
            return 6;
        }
        catch (Throwable e) {
            Logger.error("\u9519\u8bef\uff1a", e);
            throw new JspTagException(e.getMessage());
        }
    }

    public void release() {
        this.name = null;
        this.width = null;
        this.height = null;
        this.needPageMark = null;
        this.srcType = null;
        this.beanName = null;
        this.reportFileName = null;
        this.columns = null;
        this.funcBarFontFace = null;
        this.funcBarFontSize = null;
        this.funcBarFontColor = null;
        this.needSaveAsExcel = null;
        this.needSaveAsPdf = null;
        this.needPrint = null;
        this.functionBarColor = null;
        this.separator = null;
        this.canModifyBeforePrint = null;
        this.funcBarLocation = null;
        this.pageMarkLabel = null;
        this.firstPageLabel = null;
        this.prevPageLabel = null;
        this.nextPageLabel = null;
        this.lastPageLabel = null;
        this.printLabel = null;
        this.excelLabel = null;
        this.pdfLabel = null;
        this.generateParamForm = null;
        this.displayNoLinkPageMark = null;
        this.connection = null;
        this.params = null;
        this.saveAsName = null;
        this.submit = null;
        this.needOfflineInput = null;
        this.offline = null;
        this.processor = null;
        this.outerDS = null;
        this.needImportExcel = null;
        this.importExcelLabel = null;
        this.usePaperSizePrint = null;
        this.excelPageStyle = null;
        this.printedRaq = null;
        this.backAndRefresh = null;
        this.scale = null;
        this.excelUsePaperSize = null;
        this.textDataSeparator = null;
        this.needSaveAsText = null;
        this.textLabel = null;
        this.userFuncBarElements = null;
    }

    public String getName() {
        return this.name;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public String getScale() {
        return this.scale;
    }

    public String getSrcType() {
        return this.srcType;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getNeedPageMark() {
        return this.needPageMark;
    }

    public String getFuncBarLocation() {
        return this.funcBarLocation;
    }

    public String getColumns() {
        return this.columns;
    }

    public String getFuncBarFontFace() {
        return this.funcBarFontFace;
    }

    public String getFuncBarFontSize() {
        return this.funcBarFontSize;
    }

    public String getFuncBarFontColor() {
        return this.funcBarFontColor;
    }

    public String getNeedSaveAsExcel() {
        return this.needSaveAsExcel;
    }

    public String getNeedSaveAsPdf() {
        return this.needSaveAsPdf;
    }

    public String getNeedPrint() {
        return this.needPrint;
    }

    public String getFunctionBarColor() {
        return this.functionBarColor;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getCanModifyBeforePrint() {
        return this.canModifyBeforePrint;
    }

    public String getPageMarkLabel() {
        return this.pageMarkLabel;
    }

    public String getFirstPageLabel() {
        return this.firstPageLabel;
    }

    public String getPrevPageLabel() {
        return this.prevPageLabel;
    }

    public String getNextPageLabel() {
        return this.nextPageLabel;
    }

    public String getLastPageLabel() {
        return this.lastPageLabel;
    }

    public String getPrintLabel() {
        return this.printLabel;
    }

    public String getExcelLabel() {
        return this.excelLabel;
    }

    public String getPdfLabel() {
        return this.pdfLabel;
    }

    public String getGenerateParamForm() {
        return this.generateParamForm;
    }

    public String getDisplayNoLinkPageMark() {
        return this.displayNoLinkPageMark;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getParams() {
        return this.params;
    }

    public String getSaveAsName() {
        return this.saveAsName;
    }

    public String getSubmit() {
        return this.submit;
    }

    public String getNeedOfflineInput() {
        return this.needOfflineInput;
    }

    public String getOffline() {
        return this.offline;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getOuterDS() {
        return this.outerDS;
    }

    public String getNeedImportExcel() {
        return this.needImportExcel;
    }

    public String getImportExcelLabel() {
        return this.importExcelLabel;
    }

    public String getUsePaperSizePrint() {
        return this.usePaperSizePrint;
    }

    public String getExcelPageStyle() {
        return this.excelPageStyle;
    }

    public String getPrintedRaq() {
        return this.printedRaq;
    }

    public String getBackAndRefresh() {
        return this.backAndRefresh;
    }

    public String getExcelUsePaperSize() {
        return this.excelUsePaperSize;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPageMarkLabel(String pageMarkLabel) {
        this.pageMarkLabel = pageMarkLabel;
    }

    public void setFirstPageLabel(String firstPageLabel) {
        this.firstPageLabel = firstPageLabel;
    }

    public void setPrevPageLabel(String prevPageLabel) {
        this.prevPageLabel = prevPageLabel;
    }

    public void setNextPageLabel(String nextPageLabel) {
        this.nextPageLabel = nextPageLabel;
    }

    public void setLastPageLabel(String lastPageLabel) {
        this.lastPageLabel = lastPageLabel;
    }

    public void setPrintLabel(String printLabel) {
        this.printLabel = printLabel;
    }

    public void setExcelLabel(String excelLabel) {
        this.excelLabel = excelLabel;
    }

    public void setPdfLabel(String pdfLabel) {
        this.pdfLabel = pdfLabel;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setSrcType(String srcType) {
        this.srcType = srcType;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setNeedPageMark(String needPageMark) {
        this.needPageMark = needPageMark;
    }

    public void setFuncBarLocation(String funcBarLocation) {
        this.funcBarLocation = funcBarLocation;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setFuncBarFontFace(String funcBarFontFace) {
        this.funcBarFontFace = funcBarFontFace;
    }

    public void setFuncBarFontSize(String funcBarFontSize) {
        this.funcBarFontSize = funcBarFontSize;
    }

    public void setFuncBarFontColor(String funcBarFontColor) {
        this.funcBarFontColor = funcBarFontColor;
    }

    public void setNeedSaveAsExcel(String needSaveAsExcel) {
        this.needSaveAsExcel = needSaveAsExcel;
    }

    public void setNeedSaveAsPdf(String needSaveAsPdf) {
        this.needSaveAsPdf = needSaveAsPdf;
    }

    public void setNeedPrint(String needPrint) {
        this.needPrint = needPrint;
    }

    public void setFunctionBarColor(String functionBarColor) {
        this.functionBarColor = functionBarColor;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCanModifyBeforePrint(String canModifyBeforePrint) {
        this.canModifyBeforePrint = canModifyBeforePrint;
    }

    public void setGenerateParamForm(String generateParamForm) {
        this.generateParamForm = generateParamForm;
    }

    public void setDisplayNoLinkPageMark(String displayNoLinkPageMark) {
        this.displayNoLinkPageMark = displayNoLinkPageMark;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setSaveAsName(String saveAsName) {
        this.saveAsName = saveAsName;
    }

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public void setNeedOfflineInput(String needOfflineInput) {
        this.needOfflineInput = needOfflineInput;
    }

    public void setOffline(String offline) {
        this.offline = offline;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public void setOuterDS(String outerDS) {
        this.outerDS = outerDS;
    }

    public void setNeedImportExcel(String needImportExcel) {
        this.needImportExcel = needImportExcel;
    }

    public void setImportExcelLabel(String importExcelLabel) {
        this.importExcelLabel = importExcelLabel;
    }

    public void setUsePaperSizePrint(String usePaperSizePrint) {
        this.usePaperSizePrint = usePaperSizePrint;
    }

    public void setExcelPageStyle(String excelPageStyle) {
        this.excelPageStyle = excelPageStyle;
    }

    public void setPrintedRaq(String printedRaq) {
        this.printedRaq = printedRaq;
    }

    public void setBackAndRefresh(String backAndRefresh) {
        this.backAndRefresh = backAndRefresh;
    }

    public void setExcelUsePaperSize(String excelUsePaperSize) {
        this.excelUsePaperSize = excelUsePaperSize;
    }

    public String getNeedSaveAsText() {
        return this.needSaveAsText;
    }

    public void setNeedSaveAsText(String needSaveAsText) {
        this.needSaveAsText = needSaveAsText;
    }

    public String getTextLabel() {
        return this.textLabel;
    }

    public void setTextLabel(String textLabel) {
        this.textLabel = textLabel;
    }

    public String getTextDataSeparator() {
        return this.textDataSeparator;
    }

    public void setTextDataSeparator(String textDataSeparator) {
        this.textDataSeparator = textDataSeparator;
    }

    public String getUserFuncBarElements() {
        return this.userFuncBarElements;
    }

    public void setUserFuncBarElements(String userFuncBarElements) {
        this.userFuncBarElements = userFuncBarElements;
    }

    private void initParameters() {
        this.width = this.getDefaultParam(this.width, "0");
        this.height = this.getDefaultParam(this.height, "0");
        this.columns = this.getDefaultParam(this.columns, "0");
        this.srcType = this.getDefaultParam(this.srcType, "file");
        this.beanName = this.getDefaultParam(this.beanName, null);
        this.needPageMark = this.getDefaultParam(this.needPageMark, "yes");
        this.funcBarFontFace = this.getDefaultParam(this.funcBarFontFace, DefaultTagProps.funcBarFontFace);
        this.funcBarFontSize = this.getDefaultParam(this.funcBarFontSize, DefaultTagProps.funcBarFontSize);
        try {
            Integer.parseInt(this.funcBarFontSize);
            this.funcBarFontSize = String.valueOf(this.funcBarFontSize) + "px";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.funcBarFontColor = this.getDefaultParam(this.funcBarFontColor, DefaultTagProps.funcBarFontColor);
        this.needSaveAsExcel = this.getDefaultParam(this.needSaveAsExcel, "no");
        this.needSaveAsPdf = this.getDefaultParam(this.needSaveAsPdf, "no");
        this.needPrint = this.getDefaultParam(this.needPrint, "no");
        this.functionBarColor = this.getDefaultParam(this.functionBarColor, DefaultTagProps.functionBarColor);
        this.separator = this.getDefaultParam(this.separator, DefaultTagProps.separator);
        this.canModifyBeforePrint = this.getDefaultParam(this.canModifyBeforePrint, "no");
        this.funcBarLocation = this.getDefaultParam(this.funcBarLocation, "top");
        this.pageMarkLabel = this.getDefaultParam(this.pageMarkLabel, DefaultTagProps.pageMarkLabel);
        this.firstPageLabel = this.getDefaultParam(this.firstPageLabel, DefaultTagProps.firstPageLabel);
        this.prevPageLabel = this.getDefaultParam(this.prevPageLabel, DefaultTagProps.prevPageLabel);
        this.nextPageLabel = this.getDefaultParam(this.nextPageLabel, DefaultTagProps.nextPageLabel);
        this.lastPageLabel = this.getDefaultParam(this.lastPageLabel, DefaultTagProps.lastPageLabel);
        this.printLabel = this.getDefaultParam(this.printLabel, DefaultTagProps.printLabel);
        this.excelLabel = this.getDefaultParam(this.excelLabel, DefaultTagProps.excelLabel);
        this.pdfLabel = this.getDefaultParam(this.pdfLabel, DefaultTagProps.pdfLabel);
        this.generateParamForm = this.getDefaultParam(this.generateParamForm, "no");
        this.displayNoLinkPageMark = this.getDefaultParam(this.displayNoLinkPageMark, DefaultTagProps.displayNoLinkPageMark);
        this.connection = this.getDefaultParam(this.connection, null);
        this.params = this.getDefaultParam(this.params, null);
        this.saveAsName = this.getDefaultParam(this.saveAsName, null);
        this.submit = this.getDefaultParam(this.submit, DefaultTagProps.submit);
        this.needOfflineInput = this.getDefaultParam(this.needOfflineInput, "no");
        this.offline = this.getDefaultParam(this.offline, DefaultTagProps.offline);
        this.processor = this.getDefaultParam(this.processor, null);
        this.outerDS = this.getDefaultParam(this.outerDS, null);
        this.needImportExcel = this.getDefaultParam(this.needImportExcel, "no");
        this.importExcelLabel = this.getDefaultParam(this.importExcelLabel, DefaultTagProps.importExcelLabel);
        this.usePaperSizePrint = this.getDefaultParam(this.usePaperSizePrint, "yes");
        this.excelPageStyle = this.getDefaultParam(this.excelPageStyle, null);
        this.printedRaq = this.getDefaultParam(this.printedRaq, null);
        this.backAndRefresh = this.getDefaultParam(this.backAndRefresh, "yes");
        this.scale = this.getDefaultParam(this.scale, "1.0");
        this.excelUsePaperSize = this.getDefaultParam(this.excelUsePaperSize, "no");
        this.needSaveAsText = this.getDefaultParam(this.needSaveAsText, "no");
        this.textLabel = this.getDefaultParam(this.textLabel, "\u5b58\u4e3aText");
        this.textDataSeparator = this.getDefaultParam(this.textDataSeparator, "\t");
        this.canImport2DB = "1";
        int pos = this.needImportExcel.indexOf(",");
        if (pos > 0) {
            this.canImport2DB = this.needImportExcel.substring(pos + 1);
            this.canImport2DB = this.canImport2DB.trim();
            this.needImportExcel = this.needImportExcel.substring(0, pos).trim();
        }
        this.userFuncBarElements = this.getDefaultParam(this.userFuncBarElements, null);
    }

    private String getDefaultParam(String param, String def) {
        if (param == null) {
            return def;
        }
        return param;
    }

    public static String getCurrURL(HttpServletRequest request, String name) {
        String url = request.getRequestURL().toString();
        String queryString = "";
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String param = (String)em.nextElement();
            if (param.equals(String.valueOf(name) + "_currPage") || param.equals(String.valueOf(name) + "_sessionId") || param.equals(String.valueOf(name) + "_cachedId") || param.equals("reportParamsId") || param.equals("data") || param.equals("originData") || param.equals("pageUrl")) continue;
            String[] values = request.getParameterValues(param);
            int i = 0;
            while (i < values.length) {
                queryString = String.valueOf(queryString) + param + "=" + URLEncoder.encode(values[i]) + "&";
                ++i;
            }
        }
        if (queryString.length() == 0) {
            return String.valueOf(url) + "?";
        }
        return String.valueOf(url) + "?" + queryString + "&";
    }

    private String getPageParam(HttpServletRequest request, String name) {
        String pageParams = "";
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String param = (String)em.nextElement();
            if (param.equals(String.valueOf(name) + "_currPage") || param.equals(String.valueOf(name) + "_sessionId") || param.equals(String.valueOf(name) + "_cachedId") || param.equals("reportParamsId")) continue;
            String[] values = request.getParameterValues(param);
            int i = 0;
            while (i < values.length) {
                pageParams = String.valueOf(pageParams) + "<input type=hidden name=\"" + param + "\" value=\"" + values[i] + "\">\n";
                ++i;
            }
        }
        return pageParams;
    }

    public static synchronized String createSessionId() {
        if (++sessionId > 999999) {
            sessionId = 100000;
        }
        return String.valueOf(sessionId);
    }

    public static String generateParamsFormHtml(String generateParamForm, String srcType, String reportFileName, String appRoot, String pageUrl, ServletContext application) throws Exception {
        if (generateParamForm == null) {
            return "";
        }
        String paramsForm = "";
        if (generateParamForm.equalsIgnoreCase("yes")) {
            int i;
            ReportCalculator rc = new ReportCalculator(application);
            rc.setParameter("fileName", reportFileName);
            rc.setParameter("srcType", srcType);
            rc.setParameter("needCalculate", "no");
            CellSet srcCs = null;
            try {
                srcCs = rc.calc();
            }
            catch (LicenseException le) {
                throw new Exception(le.getMessage());
            }
            String s = "";
            Object tmp = srcCs.getPropertyValue(0, 0, 1105);
            if (tmp != null && tmp.toString().trim().length() > 0) {
                Arguments args = new Arguments(tmp.toString());
                int argCount = args.size();
                i = 0;
                while (i < argCount) {
                    Argument arg = args.get(i);
                    String defaultValue = arg.value;
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    s = String.valueOf(s) + "\t\t<td>&nbsp;" + arg.chName + "</td><td><input name=\"" + arg.enName + "\" value=\"" + defaultValue + "\" style=\"width:70px\"></td>\n";
                    ++i;
                }
            }
            if ((tmp = srcCs.getPropertyValue(0, 0, 1107)) != null && tmp.toString().trim().length() > 0) {
                Macros macros = new Macros(tmp.toString());
                int macroCount = macros.size();
                i = 0;
                while (i < macroCount) {
                    String defaultValue = macros.getValue(i);
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    s = String.valueOf(s) + "\t\t<td>&nbsp;" + macros.getTitle(i) + "</td><td><input name=\"" + macros.getName(i) + "\" value=\"" + defaultValue + "\" style=\"width:70px\"></td>\n";
                    ++i;
                }
            }
            if (s.length() > 0) {
                paramsForm = String.valueOf(paramsForm) + "<form method=post action=\"" + appRoot + "/setReportParams\">\n";
                paramsForm = String.valueOf(paramsForm) + "\t<table><tr style=\"font-family:\u5b8b\u4f53;font-size:13px\">\n";
                paramsForm = String.valueOf(paramsForm) + s;
                paramsForm = String.valueOf(paramsForm) + "\t\t<td><input type=submit value=\u67e5\u8be2 style=\"font-family:\u5b8b\u4f53;font-size:13px;width:40px;height:22px\"></td>\n";
                paramsForm = String.valueOf(paramsForm) + "\t</tr></table>\n";
                paramsForm = String.valueOf(paramsForm) + "\t<input type=hidden name=resultPage value=\"" + pageUrl + "\">\n";
                paramsForm = String.valueOf(paramsForm) + "</form>\n";
            }
        }
        return paramsForm;
    }
}

