/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.tag;

import com.runqian.base.util.Escape;
import com.runqian.base.util.Logger;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.view.LicenseException;
import com.runqian.report.view.ParamsPool;
import com.runqian.report.view.ReportCalculator;
import com.runqian.report.view.ServletMappings;
import com.runqian.report.view.html.ParamForm;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class ParamTag
extends TagSupport {
    private String name = null;
    private String paramFileName = null;
    private String resultPage = null;
    private String target = null;
    private String hiddenParams = null;
    private String processor = null;
    private String needSubmit = null;
    private String submitLabel = null;
    private String params = null;

    public void release() {
        this.name = null;
        this.paramFileName = null;
        this.resultPage = null;
        this.target = null;
        this.hiddenParams = null;
        this.processor = null;
        this.needSubmit = null;
        this.submitLabel = null;
        this.params = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParamFileName() {
        return this.paramFileName;
    }

    public void setParamFileName(String paramFileName) {
        this.paramFileName = paramFileName;
    }

    public String getResultPage() {
        return this.resultPage;
    }

    public void setResultPage(String resultPage) {
        this.resultPage = resultPage;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getHiddenParams() {
        return this.hiddenParams;
    }

    public void setHiddenParams(String hiddenParams) {
        this.hiddenParams = hiddenParams;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public String getNeedSubmit() {
        return this.needSubmit;
    }

    public void setNeedSubmit(String needSubmit) {
        this.needSubmit = needSubmit;
    }

    public String getSubmitLabel() {
        return this.submitLabel;
    }

    public void setSubmitLabel(String submitLabel) {
        this.submitLabel = submitLabel;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    private void initParameters() {
        this.resultPage = this.getDefaultParam(this.resultPage, null);
        this.target = this.getDefaultParam(this.target, null);
        this.hiddenParams = this.getDefaultParam(this.hiddenParams, null);
        this.processor = this.getDefaultParam(this.processor, null);
        this.needSubmit = this.getDefaultParam(this.needSubmit, "yes");
        this.submitLabel = this.getDefaultParam(this.submitLabel, "\u67e5\u8be2");
        this.params = this.getDefaultParam(this.params, null);
    }

    private String getDefaultParam(String param, String def) {
        if (param == null) {
            return def;
        }
        return param;
    }

    public int doStartTag() throws JspTagException {
        try {
            this.initParameters();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            request.setCharacterEncoding("GBK");
            HttpSession session = request.getSession(true);
            JspWriter out = this.pageContext.getOut();
            String appmap = request.getContextPath();
            this.name = this.name.trim();
            if (this.paramFileName.trim().length() == 0 || this.paramFileName.equals("null")) {
                return 6;
            }
            out.print("<form id=\"" + this.name + "\" name=\"" + this.name + "\" method=post action=\"" + appmap + ServletMappings.getMapping("com.runqian.report.view.SetReportParamsServlet") + "\"");
            if (this.target != null) {
                out.print(" target=" + this.target);
            }
            out.print(">\n");
            String reportParamsId = null;
            if (this.params != null) {
                SegmentSet segs = new SegmentSet(this.params, true, ';');
                Iterator it = segs.keySet().iterator();
                Hashtable<String, String> hash = new Hashtable<String, String>(segs.size());
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String value = segs.get(name);
                    value = Escape.removeEscAndQuote(value);
                    hash.put(name, value);
                }
                reportParamsId = ParamsPool.createParamsId();
                ParamsPool.put(reportParamsId, hash);
            }
            ReportCalculator rc = new ReportCalculator(this.pageContext.getServletContext());
            rc.setParameter("fileName", this.paramFileName);
            if (reportParamsId != null) {
                rc.setParameter("reportParamsId", reportParamsId);
            }
            CellSet cs = null;
            try {
                cs = rc.calc();
            }
            catch (LicenseException le) {
                throw new Exception(le.getMessage());
            }
            ParamForm pf = new ParamForm(cs, this.name, request);
            pf.setParamsId(reportParamsId);
            out.print(pf.generateHtml());
            if (this.processor != null) {
                out.println("\t<input type=hidden name=processor value=\"" + this.processor + "\">");
            }
            if (this.hiddenParams != null) {
                out.println("\t<input type=hidden name=hiddenParams value=\"" + this.hiddenParams + "\">");
            }
            if (this.resultPage != null) {
                out.println("\t<input type=hidden name=resultPage value=\"" + this.resultPage + "\">");
            } else {
                out.println("\t<input type=hidden name=resultPage value=\"" + this.getCurrURL(request) + "\">");
            }
            if (this.needSubmit.equalsIgnoreCase("yes")) {
                out.print("<div style=\"padding-top:7px\"><a href=\"#\" onclick=\"_submit( " + this.name + " );return false\">" + this.submitLabel + "</a></div>\n");
            }
            out.println("</form>");
            return 6;
        }
        catch (Throwable e) {
            Logger.error("\u9519\u8bef\uff1a", e);
            throw new JspTagException(e.getMessage());
        }
    }

    private String getCurrURL(HttpServletRequest request) {
        String url = request.getServletPath();
        String queryString = "";
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String param = (String)em.nextElement();
            if (param.equals("reportParamsId")) continue;
            String[] values = request.getParameterValues(param);
            int i = 0;
            while (i < values.length) {
                queryString = String.valueOf(queryString) + param + "=" + values[i] + "&";
                ++i;
            }
        }
        if (queryString.length() > 0) {
            return String.valueOf(url) + "?" + queryString.substring(0, queryString.length() - 1);
        }
        return url;
    }
}

