/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.tag;

import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.Logger;
import com.runqian.base.util.SegmentSet;
import com.runqian.base.util.Sentence;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.input.ExcelNotation;
import com.runqian.report.input.ExpTransform;
import com.runqian.report.input.InputUtils;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.tag.DefaultTagProps;
import com.runqian.report.tag.HtmlTag;
import com.runqian.report.view.CachedReportPool;
import com.runqian.report.view.LicenseException;
import com.runqian.report.view.ParamsPool;
import com.runqian.report.view.ReportCalculator;
import com.runqian.report.view.ServletMappings;
import com.runqian.report.view.html.HtmlReport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

public class SheetsTag
extends TagSupport {
    private String name = null;
    private String sheets = null;
    private String sheetsRelation = null;
    private String funcBarLocation = null;
    private String separator = null;
    private String params = null;
    private String saveAsName = null;
    private String tabBackColor = null;
    private String tabHLBackColor = null;
    private String tabFontColor = null;
    private String tabHLFontColor = null;
    private String tabFontName = null;
    private String tabFontSize = null;
    private String submit = null;
    private String needOfflineInput = null;
    private String offline = null;
    private String border = null;
    private String margin = null;
    private String processor = null;
    private String backAndRefresh = null;

    public int doStartTag() throws JspTagException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            request.setCharacterEncoding("GBK");
            JspWriter out = this.pageContext.getOut();
            String appRoot = String.valueOf(request.getScheme()) + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
            if (!DefaultTagProps.resolved) {
                DefaultTagProps.resolve(request.getContextPath());
                DefaultTagProps.resolved = true;
            }
            this.initParameters();
            this.name = this.name.trim();
            boolean inNS = request.getHeader("user-agent").toLowerCase().indexOf("msie") < 0;
            String pageUrl = HtmlTag.getCurrURL(request, this.name);
            ArgumentTokenizer at = new ArgumentTokenizer(this.sheets, ';');
            ArrayList<String> files = new ArrayList<String>();
            ArrayList<String> tableIds = new ArrayList<String>();
            ArrayList<String> tabNames = new ArrayList<String>();
            HashSet<String> set = new HashSet<String>();
            String raqs = "";
            String tables = "";
            String cachedIds = "";
            while (at.hasMoreTokens()) {
                String tmp = at.nextToken();
                if (tmp == null || (tmp = tmp.trim()).length() == 0) continue;
                ArgumentTokenizer at1 = new ArgumentTokenizer(tmp, ',');
                String fileName = at1.nextToken();
                fileName = fileName.trim();
                files.add(fileName);
                if (raqs.length() > 0) {
                    raqs = String.valueOf(raqs) + ",";
                }
                raqs = String.valueOf(raqs) + fileName;
                String id = at1.nextToken();
                if (id == null || id.trim().length() == 0) {
                    throw new Exception("sheets\u5c5e\u6027" + this.sheets + "\u914d\u7f6e\u9519\u8bef\uff01");
                }
                id = id.trim();
                tableIds.add(id);
                set.add(id);
                if (tables.length() > 0) {
                    tables = String.valueOf(tables) + ",";
                }
                tables = String.valueOf(tables) + id;
                String disp = "";
                if (at1.hasMoreTokens()) {
                    disp = at1.nextToken();
                }
                if (disp == null || disp.trim().length() == 0) {
                    int pos = fileName.lastIndexOf(".");
                    if (pos > 0) {
                        disp = fileName.substring(0, pos);
                    }
                    if ((pos = disp.lastIndexOf("/")) >= 0) {
                        disp = disp.substring(pos + 1);
                    }
                }
                tabNames.add(disp.trim());
            }
            if (files.size() < 2) {
                throw new Exception("\u62a5\u8868\u6570\u5c11\u4e8e\u4e24\u5f20\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6esheets\u5c5e\u6027\uff01");
            }
            if (tableIds.size() != set.size()) {
                throw new Exception("\u62a5\u8868ID\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5sheets\u5c5e\u6027\uff01");
            }
            if (set.contains(this.name)) {
                throw new Exception("name\u5c5e\u6027\u4e0d\u80fd\u4e0esheets\u4e2d\u7684\u62a5\u8868ID\u540c\u540d\uff0c\u8bf7\u68c0\u67e5\u4fee\u6539\uff01");
            }
            String inputJS = "input.js";
            if (inNS) {
                inputJS = "input4ns.js";
            }
            out.println("<script language=javascript src=\"" + appRoot + ServletMappings.getMapping("com.runqian.base.util.ReadJavaScriptServlet") + "?" + "file=%2Fcom%2Frunqian%2Freport%2Finput%2F" + inputJS + "\">");
            out.println("</script>");
            out.println("<div id=\"" + this.name + "\" tables=\"" + tables + "\">");
            StringBuffer sbFuncBar = new StringBuffer();
            sbFuncBar.append("<div style=\"font-family:\u5b8b\u4f53;font-size:13px;color:blue;padding-top:10px\">");
            if (inNS) {
                sbFuncBar.append("<span id=runqian_submit style=\"cursor:pointer\" onclick=\"_submitSheets( document.getElementById( '" + this.name + "' ) )\">" + this.submit + "</span>");
            } else {
                sbFuncBar.append("<span id=runqian_submit style=\"cursor:pointer\" onclick=\"_submitSheets( " + this.name + " )\">" + this.submit + "</span>");
            }
            if (!inNS && this.needOfflineInput.equalsIgnoreCase("yes")) {
                String localName = this.saveAsName;
                if (localName == null || localName.trim().length() == 0) {
                    localName = this.name;
                }
                localName = String.valueOf(localName) + ".html";
                if (inNS) {
                    sbFuncBar.append(String.valueOf(this.separator) + "<span style=\"cursor:pointer\" onclick=\"_saveSheetsToLocal( " + "document.getElementById( '" + this.name + "' ), '" + localName + "' )\">" + this.offline + "</span>");
                } else {
                    sbFuncBar.append(String.valueOf(this.separator) + "<span style=\"cursor:pointer\" onclick=\"_saveSheetsToLocal( " + this.name + ", '" + localName + "' )\">" + this.offline + "</span>");
                }
            }
            sbFuncBar.append("</div>");
            if (this.funcBarLocation.equalsIgnoreCase("top") || this.funcBarLocation.equalsIgnoreCase("both")) {
                out.println(sbFuncBar.toString());
            }
            StringBuffer sbTab = new StringBuffer();
            sbTab.append("<table id=\"tabs_" + this.name + "\" currTab=\"tab_" + (String)tableIds.get(0) + "\" bkColor=\"" + this.tabBackColor + "\" bkHLColor=\"" + this.tabHLBackColor + "\" fontColor=\"" + this.tabFontColor + "\" fontHLColor=\"" + this.tabHLFontColor + "\" cellspacing=3 cellpadding=6 border=0><tr>\n");
            int i = 0;
            while (i < files.size()) {
                String tableId = (String)tableIds.get(i);
                String c = this.tabFontColor;
                String bc = this.tabBackColor;
                if (i == 0) {
                    c = this.tabHLFontColor;
                    bc = this.tabHLBackColor;
                }
                sbTab.append("\t<td id=\"tab_" + tableId + "\" report=\"" + tableId + "\" style=\"cursor:default;color:" + c + ";background-color:" + bc + ";font-family:" + this.tabFontName + ";font-size:" + this.tabFontSize + "\"" + " onclick=\"_tabClicked( this, '" + this.name + "' )\">" + (String)tabNames.get(i) + "</td>\n");
                ++i;
            }
            sbTab.append("</tr></table>");
            out.println(sbTab.toString());
            String reportParamsId = request.getParameter("reportParamsId");
            if (reportParamsId != null) {
                pageUrl = String.valueOf(pageUrl) + "reportParamsId=" + reportParamsId + "&";
            } else if (this.params != null) {
                SegmentSet segs = new SegmentSet(this.params, true, ';');
                Iterator it = segs.keySet().iterator();
                Hashtable<String, String> hash = new Hashtable<String, String>(segs.size());
                while (it.hasNext()) {
                    String name = (String)it.next();
                    String value = segs.get(name);
                    value = Escape.removeEscAndQuote(value);
                    hash.put(name, value);
                }
                reportParamsId = ParamsPool.createParamsId();
                ParamsPool.put(reportParamsId, hash);
                pageUrl = String.valueOf(pageUrl) + "reportParamsId=" + reportParamsId + "&";
            }
            out.println("<table style=\"border:" + this.border + "\" cellspacing=0 cellpadding=" + this.margin + "><tr><td>");
            int i2 = 0;
            while (i2 < files.size()) {
                String display = "none";
                if (i2 == 0) {
                    display = "block";
                }
                String fileName = (String)files.get(i2);
                ReportCalculator rc = new ReportCalculator(this.pageContext.getServletContext());
                rc.setParameter("fileName", fileName);
                if (reportParamsId != null) {
                    rc.setParameter("reportParamsId", reportParamsId);
                }
                CellSet cellSet = null;
                try {
                    cellSet = rc.calc();
                }
                catch (LicenseException le) {
                    throw new Exception(le.getMessage());
                }
                String cachedId = CachedReportPool.put((CellSet)cellSet.clone());
                if (cachedIds.length() > 0) {
                    cachedIds = String.valueOf(cachedIds) + ",";
                }
                cachedIds = String.valueOf(cachedIds) + cachedId;
                PageBuilder pb = new PageBuilder(cellSet, 999999999, 999999999, 1);
                String tableId = (String)tableIds.get(i2);
                HtmlReport report = new HtmlReport(pb.getPage(1), tableId, request.getContextPath(), request, true);
                out.println(report.generateHtml());
                out.println("<script language=javascript>document.getElementById( \"" + tableId + "\" ).style.display = \"" + display + "\";</script>");
                ++i2;
            }
            out.println("</td></tr></table>");
            if (this.funcBarLocation.equalsIgnoreCase("bottom") || this.funcBarLocation.equalsIgnoreCase("both")) {
                out.print(sbFuncBar.toString());
            }
            if (this.sheetsRelation != null && this.sheetsRelation.trim().length() > 0) {
                out.println("<script language=javascript>");
                out.println("\tfunction " + this.name + "_sheetsValid() {");
                ArgumentTokenizer token = new ArgumentTokenizer(this.sheetsRelation.trim(), ';');
                while (token.hasMoreTokens()) {
                    String tmp = token.nextToken();
                    if (tmp == null || (tmp = this.trim(tmp)).length() == 0) continue;
                    ArgumentTokenizer at1 = new ArgumentTokenizer(tmp, '@');
                    String exp = at1.nextToken().trim();
                    exp = this.trim(exp);
                    String msg = "";
                    if (at1.hasMoreTokens()) {
                        msg = at1.nextToken();
                    }
                    if (msg == null) {
                        msg = "";
                    }
                    msg = this.trim(msg);
                    ExpTransform et = new ExpTransform(exp, null);
                    this.replaceCell(et, tableIds, inNS);
                    exp = et.toString();
                    exp = InputUtils.replaceEqual(exp, 0);
                    exp = Sentence.replace(exp, "<>", "!=", 2);
                    exp = Sentence.replace(exp, " and ", " && ", 3);
                    exp = Sentence.replace(exp, " or ", " || ", 3);
                    out.println("\t\tif( ! ( " + exp + " ) ) {");
                    out.println("\t\t\talert( \"" + msg + "\" );");
                    out.println("\t\t\treturn false;");
                    out.println("\t\t}");
                }
                out.println("\t\treturn true;");
                out.println("\t}");
                out.println("</script>");
            }
            String form = "<div style=\"display:none\"><form id=\"" + this.name + "_submitForm\" method=post action=\"" + appRoot + ServletMappings.getMapping("com.runqian.report.input.SaveSheetsServlet") + "\">\n";
            form = String.valueOf(form) + "\t<input type=hidden name=files value=\"" + raqs + "\">\n";
            form = String.valueOf(form) + "\t<input type=hidden name=tables value=\"" + tables + "\">\n";
            form = String.valueOf(form) + "\t<input type=hidden name=cachedIds value=\"" + cachedIds + "\">\n";
            form = String.valueOf(form) + "\t<input type=hidden name=pageUrl value=\"" + pageUrl + "\">\n";
            form = String.valueOf(form) + "\t<input type=hidden name=backAndRefresh value=\"" + this.backAndRefresh + "\">\n";
            int i3 = 0;
            while (i3 < files.size()) {
                String tableId = (String)tableIds.get(i3);
                form = String.valueOf(form) + "\t<input type=hidden name=" + tableId + "_data>\n";
                form = String.valueOf(form) + "\t<input type=hidden name=" + tableId + "_originData>\n";
                ++i3;
            }
            if (reportParamsId != null) {
                Hashtable hashParam = ParamsPool.get(reportParamsId);
                Iterator it = hashParam.keySet().iterator();
                String params = "";
                while (it.hasNext()) {
                    String pName = (String)it.next();
                    String pValue = (String)hashParam.get(pName);
                    if (params.length() > 0) {
                        params = String.valueOf(params) + ";";
                    }
                    params = String.valueOf(params) + pName + "=" + pValue;
                }
                form = String.valueOf(form) + "\t<input type=hidden name=params value=\"" + params + "\">\n";
            }
            if (this.processor != null && this.processor.trim().length() > 0) {
                form = String.valueOf(form) + "\t<input type=hidden name=processor value=\"" + this.processor + "\">\n";
            }
            form = String.valueOf(form) + "</form>";
            out.println(form);
            if (!inNS && this.needOfflineInput.equalsIgnoreCase("yes")) {
                form = "<form id=\"" + this.name + "_saveToLocalForm\" method=post action=\"" + appRoot + ServletMappings.getMapping("com.runqian.report.input.SaveToLocalServlet") + "\">\n";
                form = String.valueOf(form) + "\t<input type=hidden name=fileContent>\n";
                form = String.valueOf(form) + "\t<input type=hidden name=saveAsName>\n";
                form = String.valueOf(form) + "</form>";
                out.println(form);
            }
            out.println("</div>");
            out.println("</div>");
            return 6;
        }
        catch (Throwable e) {
            Logger.error("\u9519\u8bef\uff1a", e);
            throw new JspTagException(e.getMessage());
        }
    }

    public void release() {
        this.name = null;
        this.sheets = null;
        this.sheetsRelation = null;
        this.funcBarLocation = null;
        this.separator = null;
        this.params = null;
        this.saveAsName = null;
        this.tabBackColor = null;
        this.tabHLBackColor = null;
        this.tabFontColor = null;
        this.tabHLFontColor = null;
        this.tabFontName = null;
        this.tabFontSize = null;
        this.submit = null;
        this.needOfflineInput = null;
        this.offline = null;
        this.border = null;
        this.margin = null;
        this.processor = null;
        this.backAndRefresh = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSheets() {
        return this.sheets;
    }

    public void setSheets(String sheets) {
        this.sheets = sheets;
    }

    public String getSheetsRelation() {
        return this.sheetsRelation;
    }

    public void setSheetsRelation(String sheetsRelation) {
        this.sheetsRelation = sheetsRelation;
    }

    public String getFuncBarLocation() {
        return this.funcBarLocation;
    }

    public void setFuncBarLocation(String funcBarLocation) {
        this.funcBarLocation = funcBarLocation;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getSaveAsName() {
        return this.saveAsName;
    }

    public void setSaveAsName(String saveAsName) {
        this.saveAsName = saveAsName;
    }

    public String getTabBackColor() {
        return this.tabBackColor;
    }

    public void setTabBackColor(String tabBackColor) {
        this.tabBackColor = tabBackColor;
    }

    public String getTabHLBackColor() {
        return this.tabHLBackColor;
    }

    public void setTabHLBackColor(String tabHLBackColor) {
        this.tabHLBackColor = tabHLBackColor;
    }

    public String getTabFontColor() {
        return this.tabFontColor;
    }

    public void setTabFontColor(String tabFontColor) {
        this.tabFontColor = tabFontColor;
    }

    public String getTabHLFontColor() {
        return this.tabHLFontColor;
    }

    public void setTabHLFontColor(String tabHLFontColor) {
        this.tabHLFontColor = tabHLFontColor;
    }

    public String getTabFontName() {
        return this.tabFontName;
    }

    public void setTabFontName(String tabFontName) {
        this.tabFontName = tabFontName;
    }

    public String getTabFontSize() {
        return this.tabFontSize;
    }

    public void setTabFontSize(String tabFontSize) {
        this.tabFontSize = tabFontSize;
    }

    public String getSubmit() {
        return this.submit;
    }

    public void setSubmit(String submit) {
        this.submit = submit;
    }

    public String getNeedOfflineInput() {
        return this.needOfflineInput;
    }

    public void setNeedOfflineInput(String needOfflineInput) {
        this.needOfflineInput = needOfflineInput;
    }

    public String getOffline() {
        return this.offline;
    }

    public void setOffline(String offline) {
        this.offline = offline;
    }

    public String getBorder() {
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public String getMargin() {
        return this.margin;
    }

    public void setMargin(String margin) {
        this.margin = margin;
    }

    public String getProcessor() {
        return this.processor;
    }

    public void setProcessor(String processor) {
        this.processor = processor;
    }

    public String getBackAndRefresh() {
        return this.backAndRefresh;
    }

    public void setBackAndRefresh(String backAndRefresh) {
        this.backAndRefresh = backAndRefresh;
    }

    private void initParameters() {
        this.tabFontName = this.getDefaultParam(this.tabFontName, "\u5b8b\u4f53");
        this.tabFontSize = this.getDefaultParam(this.tabFontSize, "15px");
        try {
            Integer.parseInt(this.tabFontSize);
            this.tabFontSize = String.valueOf(this.tabFontSize) + "px";
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tabFontColor = this.getDefaultParam(this.tabFontColor, "white");
        this.tabHLFontColor = this.getDefaultParam(this.tabHLFontColor, "red");
        this.tabBackColor = this.getDefaultParam(this.tabBackColor, "lightskyblue");
        this.tabHLBackColor = this.getDefaultParam(this.tabHLBackColor, "peachpuff");
        this.sheetsRelation = this.getDefaultParam(this.sheetsRelation, null);
        this.separator = this.getDefaultParam(this.separator, DefaultTagProps.separator);
        this.funcBarLocation = this.getDefaultParam(this.funcBarLocation, "bottom");
        this.params = this.getDefaultParam(this.params, null);
        this.saveAsName = this.getDefaultParam(this.saveAsName, null);
        this.submit = this.getDefaultParam(this.submit, DefaultTagProps.submit);
        this.needOfflineInput = this.getDefaultParam(this.needOfflineInput, "no");
        this.offline = this.getDefaultParam(this.offline, DefaultTagProps.offline);
        this.border = this.getDefaultParam(this.border, "4px double peachpuff");
        this.margin = this.getDefaultParam(this.margin, "8");
        this.processor = this.getDefaultParam(this.processor, null);
        this.backAndRefresh = this.getDefaultParam(this.backAndRefresh, "yes");
    }

    private String getDefaultParam(String param, String def) {
        if (param == null || param.trim().length() == 0) {
            return def;
        }
        return param;
    }

    private void replaceCell(ExpTransform et, ArrayList ids, boolean inNS) {
        ArrayList parts = et.getParts();
        int i = 0;
        while (i < parts.size()) {
            String part = (String)parts.get(i);
            if ((part = this.getValidCellName(part, ids)) != null) {
                if (inNS) {
                    part = "document.getElementById( \"" + part + "\" )";
                }
                part = i < parts.size() - 1 && ".".equals((String)parts.get(i + 1)) ? String.valueOf(part) + ".value" : "_parseValue( " + part + " )";
                parts.set(i, part);
            }
            ++i;
        }
    }

    private String getValidCellName(String cellName, ArrayList ids) {
        int i = 0;
        while (i < ids.size()) {
            String tmp;
            String table = (String)ids.get(i);
            String prefix = String.valueOf(table) + "_";
            if (cellName.startsWith(prefix) && ExcelNotation.isValidExcelNotation(tmp = cellName.substring(prefix.length()))) {
                return String.valueOf(prefix) + tmp.toUpperCase();
            }
            ++i;
        }
        return null;
    }

    private String trim(String src) {
        src = src.trim();
        while (src.startsWith("\t") || src.startsWith("\n") || src.startsWith(" ")) {
            src = src.substring(1);
        }
        while (src.endsWith("\t") || src.endsWith("\n") || src.endsWith(" ")) {
            src = src.substring(0, src.length() - 1);
        }
        return src;
    }
}

