/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.usermodel;

import com.runqian.base.util.LLObject;
import com.runqian.base.util.Logger;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.CalcRpt;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.usermodel.Env;
import com.runqian.report.usermodel.Report;
import com.runqian.report.usermodel.ReportDefine;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;

public class Engine {
    private ReportDefine rDef;
    private ExtCellSet ecs;
    static int bigCount = 0;
    static int bigMax = 1;
    static Object LOCK = new Object();

    public static void setMaxConcurrentForBigReport(int max) {
        bigMax = max;
    }

    public Engine(Env env) {
        Logger.debug("\u5f00\u59cb\u8fd0\u7b97\u62a5\u8868\uff0c\u9996\u5148\u53d6\u6570......");
        this.rDef = env.getReportDefine();
        this.ecs = new ExtCellSet(env);
        this.ecs.read(this.rDef.cs);
    }

    public Object calcExp(String exp, String dsName, Env env) {
        DataSet ds = env.getDataSet(dsName);
        Expression expr = new Expression(this.ecs, ds, exp);
        return expr.calculate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Report calc() {
        LLObject llo = LLObject.get();
        if (llo == null) throw new RuntimeException("\u5728\u7c7b\u8def\u5f84\u4e2d\u672a\u627e\u5230\u6388\u6743\u6587\u4ef6xrq_license.dat\u6216\u6388\u6743\u6587\u4ef6\u5df2\u8fc7\u671f");
        if (!llo.checkExpiration()) {
            throw new RuntimeException("\u5728\u7c7b\u8def\u5f84\u4e2d\u672a\u627e\u5230\u6388\u6743\u6587\u4ef6xrq_license.dat\u6216\u6388\u6743\u6587\u4ef6\u5df2\u8fc7\u671f");
        }
        Report rpt = null;
        if (llo.check() <= 0) {
            Object object = LOCK;
            synchronized (object) {
                return this.calc1();
            }
        }
        if (!this.rDef.isBigReport()) {
            return this.calc1();
        }
        Object object = LOCK;
        synchronized (object) {
            while (true) {
                if (bigCount < bigMax) {
                    ++bigCount;
                    break;
                }
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        rpt = this.calc1();
        object = LOCK;
        synchronized (object) {
            --bigCount;
            LOCK.notify();
            return rpt;
        }
    }

    private Report calc1() {
        CalcRpt.calcRpt(this.rDef, this.ecs.getEnv().getCoverUserDataSet(), this.ecs);
        CellSet cs = this.ecs.write();
        if (cs == null) {
            return null;
        }
        Report report = new Report(cs);
        Logger.debug("\u8ba1\u7b97\u7ed3\u675f\uff1a");
        return report;
    }

    public static void main(String[] args) {
        Connection con = null;
        try {
            ReportDefine rd = new ReportDefine(new FileInputStream("F:\\report3.0\\testfile\\example\\grid.raq"));
            Env env = new Env(rd);
            Engine eg = new Engine(env);
            Driver driver = (Driver)Class.forName("com.newatlanta.jturbo.driver.Driver").newInstance();
            DriverManager.registerDriver(driver);
            con = DriverManager.getConnection("jdbc:JTurbo://yanjing/explato", "sa", "");
            if (con == null) {
                throw new Exception("\u6ca1\u6709\u83b7\u5f97\u6570\u636e\u5e93\u8fde\u63a5");
            }
            Logger.debug("\u6210\u529f\u8fde\u63a5\u6570\u636e\u5e93");
            env.setConnection(con);
            env.setDBCharset("iso-8859-1");
            env.setDBType(2);
            env.putParam("arg1", new Integer(1));
            Report report = eg.calc();
            FileOutputStream out = new FileOutputStream("F:\\temp\\tmp.pdf");
            report.exportToPDF(out);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.out);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

