/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.usermodel;

import com.runqian.base.util.Argument;
import com.runqian.base.util.ArgumentDataType;
import com.runqian.base.util.Arguments;
import com.runqian.base.util.DateFactory;
import com.runqian.base.util.NStringMap;
import com.runqian.base.util.OLAPSession;
import com.runqian.base.util.PrinterCodeManager;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.engine.Expression;
import com.runqian.report.engine.SubRptList;
import com.runqian.report.usermodel.ReportDefine;
import java.sql.Connection;
import java.util.Map;
import javax.servlet.ServletContext;

public class Env {
    private String mainDir = null;
    private Connection con;
    private String charset;
    private int dbType;
    private boolean needTransSqlcode;
    private NStringMap connMap = new NStringMap(5);
    private NStringMap charsetMap = new NStringMap(5);
    private NStringMap dbtypeMap = new NStringMap(5);
    private NStringMap needTransSqlcodeMap = new NStringMap(5);
    private NStringMap olapMap = new NStringMap(5);
    private NStringMap macroMap;
    private NStringMap paramMap;
    private NStringMap dataSetMap = new NStringMap(3);
    private SubRptList subRptList;
    private boolean autoCalcDataSet = true;
    private boolean coverUserDataSet = false;
    private ReportDefine rDefine;
    private ServletContext application = null;
    private DateFactory df = null;
    Map codeMap = null;

    public Env(ReportDefine rd, boolean autoCalcDataSet, boolean coverUserDataSet) {
        this.autoCalcDataSet = autoCalcDataSet;
        this.coverUserDataSet = coverUserDataSet;
        this.rDefine = rd;
        this.init(rd);
        this.initPrinterCode();
    }

    public Env(ReportDefine rd) {
        this.rDefine = rd;
        this.init(rd);
        this.initPrinterCode();
    }

    public Env() {
        this.macroMap = new NStringMap();
        this.paramMap = new NStringMap();
    }

    private void init(ReportDefine rd) {
        Arguments args = rd.getArguments();
        String[] argsName = args.getArgumentNames();
        this.paramMap = new NStringMap(argsName.length);
        int i = 0;
        while (i < argsName.length) {
            Argument arg = args.get(i);
            Object value = ArgumentDataType.getProperData(Integer.valueOf(arg.type), arg.value);
            this.paramMap.put(argsName[i], value);
            ++i;
        }
        this.macroMap = rd.getMacros();
        this.subRptList = rd.srl;
    }

    public ReportDefine getReportDefine() {
        return this.rDefine;
    }

    public void setReportDefine(ReportDefine rd) {
        this.rDefine = rd;
        this.init(rd);
    }

    public boolean getAutoCalcDataSet() {
        return this.autoCalcDataSet;
    }

    public void setAutoCalcDataSet(boolean autoCalcDataSet) {
        this.autoCalcDataSet = autoCalcDataSet;
    }

    public boolean getCoverUserDataSet() {
        return this.coverUserDataSet;
    }

    public void setCoverUserDataSet(boolean coverUserDataSet) {
        this.coverUserDataSet = coverUserDataSet;
    }

    public void setMainDir(String mainDir) {
        this.mainDir = mainDir;
    }

    public void setServletContext(ServletContext application) {
        this.application = application;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public String getMainDir() {
        return this.mainDir;
    }

    public void setSubRptList(SubRptList srl) {
        this.subRptList = srl;
    }

    public SubRptList getSubRptList() {
        return this.subRptList;
    }

    public void setConnection(Connection cn, String charset, int dbType, boolean needTransSQLcode) {
        this.con = cn;
        this.charset = charset;
        this.dbType = dbType;
        this.needTransSqlcode = needTransSQLcode;
    }

    public void setConnection(Connection cn, String charset, int dbType) {
        this.con = cn;
        this.charset = charset;
        this.dbType = dbType;
    }

    public void setConnection(Connection cn, String charset) {
        this.con = cn;
        this.charset = charset;
    }

    public void setConnection(Connection cn, int dbType) {
        this.con = cn;
        this.dbType = dbType;
    }

    public void setConnection(Connection cn) {
        this.con = cn;
    }

    public void setDBCharset(String charset) {
        this.charset = charset;
    }

    public void setDBType(int dbType) {
        this.dbType = dbType;
    }

    public void setNeedTransSQLcode(boolean needTransSQLcode) {
        this.needTransSqlcode = needTransSQLcode;
    }

    public Connection getConnection() {
        return this.con;
    }

    public String getDBCharset() {
        return this.charset;
    }

    public int getDBType() {
        return this.dbType;
    }

    public void setConnection(String dsn, Connection conn, String dbCharset, int dbType, boolean needTransSQLcode) {
        this.connMap.put(dsn, conn);
        this.charsetMap.put(dsn, dbCharset);
        this.dbtypeMap.put(dsn, new Integer(dbType));
        this.needTransSqlcodeMap.put(dsn, Boolean.valueOf(String.valueOf(needTransSQLcode)));
    }

    public void setConnection(String dsn, Connection conn, String dbCharset, int dbType) {
        this.connMap.put(dsn, conn);
        this.charsetMap.put(dsn, dbCharset);
        this.dbtypeMap.put(dsn, new Integer(dbType));
    }

    public void setOLAPSession(String dsn, OLAPSession session, String dbCharset) {
        this.olapMap.put(dsn, session);
        this.charsetMap.put(dsn, dbCharset);
    }

    public Connection getConnection(String dsn) {
        return (Connection)this.connMap.get(dsn);
    }

    public NStringMap getConnections() {
        return this.connMap;
    }

    public NStringMap getOLAPSessions() {
        return this.olapMap;
    }

    public OLAPSession getOLAPSession(String dsn) {
        return (OLAPSession)this.olapMap.get(dsn);
    }

    public String getDBCharset(String dsn) {
        return (String)this.charsetMap.get(dsn);
    }

    public int getDBType(String dsn) {
        Integer i = (Integer)this.dbtypeMap.get(dsn);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public boolean getNeedTransSQLcode(String dsn) {
        Boolean b = (Boolean)this.needTransSqlcodeMap.get(dsn);
        if (b != null) {
            return b;
        }
        return false;
    }

    public boolean getNeedTransSQLcode() {
        return this.needTransSqlcode;
    }

    public void putMacro(String macroName, String value) {
        this.macroMap.put(macroName, value);
    }

    public void putMacros(Map macroMap) {
        if (macroMap == null) {
            return;
        }
        this.macroMap.putAll(macroMap);
    }

    public void putMacros(ReportDefine rd) {
        this.putMacros(rd.getMacros());
    }

    public String getMacro(String macroName) {
        Object value = this.macroMap.get(macroName);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public NStringMap getMacrosMap() {
        return this.macroMap;
    }

    public void putParam(String paramName, Object paramValue) {
        if (paramName == null) {
            this.paramMap.put(paramName.toLowerCase(), (Object)null);
        } else {
            this.paramMap.put(paramName.toLowerCase(), paramValue);
        }
    }

    public Object getParam(String paramName) {
        return this.paramMap.get(paramName);
    }

    public NStringMap getParamsMap() {
        return this.paramMap;
    }

    public void putParams(Map paramsMap) {
        if (paramsMap == null) {
            return;
        }
        this.paramMap.putAll(paramsMap);
    }

    public void putDataSet(String name, DataSet dataset) {
        this.dataSetMap.put(name.toLowerCase(), dataset);
    }

    public void putDataSets(Map dsMap) {
        if (dsMap == null) {
            return;
        }
        this.dataSetMap.putAll(dsMap);
    }

    public DataSet getDataSet(String name) {
        Object o = this.dataSetMap.get(name.toLowerCase());
        if (o == null) {
            return null;
        }
        return (DataSet)o;
    }

    public NStringMap getDataSetsMap() {
        return this.dataSetMap;
    }

    public boolean isParamName(String id) {
        if (this.paramMap == null) {
            return false;
        }
        return this.paramMap.containsKey(id);
    }

    public boolean isDataSetName(String id) {
        if (this.dataSetMap == null) {
            return false;
        }
        return this.dataSetMap.containsKey(id.toLowerCase());
    }

    public DateFactory getDateFactory() {
        if (this.df == null) {
            this.df = new DateFactory();
        }
        return this.df;
    }

    public void setPrinterCodeMap(Map codeMap) {
        this.codeMap = codeMap;
    }

    public Map getPrinterCodeMap() {
        return this.codeMap;
    }

    private void initPrinterCode() {
        String printCodeName = (String)this.rDefine.getValue(0, 0, 4110);
        if (printCodeName == null || printCodeName.trim().length() == 0) {
            return;
        }
        Expression expression = new Expression(this, printCodeName);
        printCodeName = (String)expression.calculate();
        this.codeMap = PrinterCodeManager.getPrinterCodeMap(printCodeName);
    }
}

