/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.usermodel;

import com.runqian.base.util.Arguments;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.cellset.CellSetParser;
import com.runqian.report.cellset.CellSetReader;
import com.runqian.report.cellset.CellSetWriter;
import com.runqian.report.control.PrintFrame;
import com.runqian.report.engine.SubRptList;
import com.runqian.report.pager.PageBuilder;
import com.runqian.report.usermodel.ReportDataSetConfigs;
import com.runqian.report.usermodel.ReportDefine;
import com.runqian.report.view.ReportCalculator;
import com.runqian.report.view.excel.ExcelReport;
import com.runqian.report.view.html.HtmlReport;
import com.runqian.report.view.pdf.PdfReport;
import com.runqian.report.view.text.TextFile;
import com.runqian.report.view.text.TextReport;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class Report
implements Serializable {
    protected CellSet cs;
    protected transient ReportDataSetConfigs dsc;
    protected transient Arguments args;
    protected transient SubRptList srl;

    public Report(CellSet cs) {
        this.cs = cs;
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }

    public Report(String raqFileName) throws Exception {
        FileInputStream fis = new FileInputStream(raqFileName);
        this.cs = new CellSetReader(fis).read();
        fis.close();
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }

    public Report(InputStream raqStream) throws Exception {
        this.cs = new CellSetReader(raqStream).read();
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }

    public Report(File raqFile) throws Exception {
        FileInputStream fis = new FileInputStream(raqFile);
        this.cs = new CellSetReader(fis).read();
        fis.close();
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }

    public Report(int rowCount, int colCount) {
        this.cs = new CellSet(rowCount, colCount);
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }

    private ReportDataSetConfigs extractDataSetConfigs() {
        Object obj = this.cs.getPropertyValue(0, 0, 1102);
        String ds = "";
        if (obj != null) {
            ds = obj.toString();
        }
        return new ReportDataSetConfigs(ds);
    }

    private Arguments extractArguments() {
        Object obj = this.cs.getPropertyValue(0, 0, 1105);
        String arguments = "";
        if (obj != null) {
            arguments = obj.toString();
        }
        return new Arguments(arguments);
    }

    private SubRptList extractSubReportList() {
        Object obj = this.cs.getPropertyValue(0, 0, 1108);
        String sub = "";
        if (obj != null) {
            sub = obj.toString();
        }
        return new SubRptList(sub);
    }

    public CellSet getCellSet() {
        if (this.dsc != null) {
            this.cs.setPropertyValue(0, 0, 1102, this.dsc.toString());
        }
        if (this.args != null) {
            this.cs.setPropertyValue(0, 0, 1105, this.args.toString());
        }
        if (this.srl != null) {
            this.cs.setPropertyValue(0, 0, 1108, this.srl.toString());
        }
        return this.cs;
    }

    public int getRowCount() {
        return this.cs.getRow();
    }

    public int getColCount() {
        return this.cs.getColumn();
    }

    public void insertRow(int row) {
        this.cs.insertRow(row);
    }

    public void insertRows(int row, int insertRowNum) {
        int i = 0;
        while (i < insertRowNum) {
            this.insertRow(row);
            ++i;
        }
    }

    public void insertCol(int col) {
        this.cs.insertColumn(col);
    }

    public void insertCols(int col, int insertColNum) {
        int i = 0;
        while (i < insertColNum) {
            this.insertCol(col);
            ++i;
        }
    }

    public void setSplitedColumns(int columns) {
        if (columns < 1) {
            columns = 1;
        }
        this.cs.setPropertyValue(0, 0, 1106, new Integer(columns));
    }

    public int getSplitedColumns() {
        Object columns = this.cs.getPropertyValue(0, 0, 1106);
        if (columns == null) {
            return 1;
        }
        return (Integer)columns;
    }

    public void setPaperType(Integer paperType) {
        this.cs.setPropertyValue(0, 0, 1201, paperType);
    }

    public void setPaperWidth(int width) {
        Object paperType = this.cs.getPropertyValue(0, 0, 1201);
        if (paperType == null) {
            return;
        }
        if (((Integer)paperType).intValue() != CellPropertyDefine.CPS_USERDEFINED.intValue()) {
            return;
        }
        this.cs.setPropertyValue(0, 0, 1203, new Integer(width));
    }

    public int getPaperWidth() {
        PageFormat pf = new CellSetParser(this.cs).getPageFormat();
        return (int)(pf.getWidth() * 25.4 / 72.0);
    }

    public void setPaperHeight(int height) {
        Object paperType = this.cs.getPropertyValue(0, 0, 1201);
        if (paperType == null) {
            return;
        }
        if (((Integer)paperType).intValue() != CellPropertyDefine.CPS_USERDEFINED.intValue()) {
            return;
        }
        this.cs.setPropertyValue(0, 0, 1204, new Integer(height));
    }

    public int getPaperHeight() {
        PageFormat pf = new CellSetParser(this.cs).getPageFormat();
        return (int)(pf.getHeight() * 25.4 / 72.0);
    }

    public void setPaperOrientation(int paperOrientation) {
        if (paperOrientation < 1 || paperOrientation > 2) {
            paperOrientation = 2;
        }
        this.cs.setPropertyValue(0, 0, 1202, new Integer(paperOrientation));
    }

    public int getPaperOrientation() {
        Object obj = this.cs.getPropertyValue(0, 0, 1202);
        if (obj == null) {
            return 2;
        }
        return (Integer)obj;
    }

    public PageFormat getPaperFormat() {
        return new CellSetParser(this.cs).getPageFormat();
    }

    public void setPaperLeftMargin(int margin) {
        this.cs.setPropertyValue(0, 0, 1205, new Integer(margin));
    }

    public void setPaperRightMargin(int margin) {
        this.cs.setPropertyValue(0, 0, 1206, new Integer(margin));
    }

    public void setPaperTopMargin(int margin) {
        this.cs.setPropertyValue(0, 0, 1207, new Integer(margin));
    }

    public void setPaperBottomMargin(int margin) {
        this.cs.setPropertyValue(0, 0, 1208, new Integer(margin));
    }

    public int getPaperLeftMargin() {
        Object obj = this.cs.getPropertyValue(0, 0, 1205);
        if (obj == null) {
            return 25;
        }
        return (Integer)obj;
    }

    public int getPaperRightMargin() {
        Object obj = this.cs.getPropertyValue(0, 0, 1206);
        if (obj == null) {
            return 25;
        }
        return (Integer)obj;
    }

    public int getPaperTopMargin() {
        Object obj = this.cs.getPropertyValue(0, 0, 1207);
        if (obj == null) {
            return 25;
        }
        return (Integer)obj;
    }

    public int getPaperBottomMargin() {
        Object obj = this.cs.getPropertyValue(0, 0, 1208);
        if (obj == null) {
            return 25;
        }
        return (Integer)obj;
    }

    public void setColValue(int col, int propId, Object value) {
        this.cs.setPropertyValue(0, col, propId, value);
    }

    public Object getColValue(int col, int propId) {
        return this.cs.getPropertyValue(0, col, propId);
    }

    public void setValue(int row, int col, int propId, Object value) {
        this.cs.setPropertyValue(row, col, propId, value);
    }

    public void setValue(int row, int col, Object value) {
        this.cs.setPropertyValue(row, col, 4102, value);
    }

    public int[] getRowColNo(String cellJspVarName) {
        int rows = this.getRowCount();
        int cols = this.getColCount();
        int row = 1;
        while (row < rows) {
            int col = 1;
            while (col < cols) {
                String name = (String)this.getValue(row, col, 4702);
                if (name != null && name.trim().length() > 0 && name.trim().equalsIgnoreCase(cellJspVarName)) {
                    return new int[]{row, col};
                }
                ++col;
            }
            ++row;
        }
        return null;
    }

    public Object getValue(int row, int col, int propId) {
        return this.cs.getPropertyValue(row, col, propId);
    }

    public Object getValue(int row, int col) {
        return this.cs.getPropertyValue(row, col, 4102);
    }

    public void saveTo(OutputStream os) {
        this.cs.setPropertyValue(0, 0, 1102, this.dsc.toString());
        this.cs.setPropertyValue(0, 0, 1105, this.args.toString());
        this.cs.setPropertyValue(0, 0, 1108, this.srl.toString());
        new CellSetWriter(this.cs).write(new PrintWriter(os, true));
    }

    public void exportToPDF(OutputStream os) throws Exception {
        PdfReport pdf = new PdfReport(this.cs);
        pdf.out(os);
        os.flush();
    }

    public void exportToExcel(OutputStream os, boolean pageBroken, int dispRatio) throws Exception {
        ExcelReport excel = null;
        excel = pageBroken ? new ExcelReport(this.cs) : new ExcelReport(this.cs, 999999999, 999999999);
        excel.setDispRatio(dispRatio);
        excel.out(os);
        os.flush();
    }

    public void exportToExcel(OutputStream os, boolean pageBroken) throws Exception {
        this.exportToExcel(os, pageBroken, 75);
    }

    public void exportToHTML(String fileName) throws Exception {
        this.exportToHTML(fileName, 1.0f);
    }

    /*
     * Exception decompiling
     */
    public void exportToHTML(String fileName, float scale) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 103->107)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toHTMLString(String reportName, HttpServletRequest request) throws Exception {
        return this.toHTMLString(reportName, request, 1.0f);
    }

    public String toHTMLString(String reportName, HttpServletRequest request, float scale) throws Exception {
        PageBuilder pb = new PageBuilder(this.cs, 999999999, 999999999);
        HtmlReport html = new HtmlReport(pb.getPage(1), reportName, request.getContextPath(), request);
        html.setScale(scale);
        return html.generateHtml();
    }

    public String toHTMLString(String reportName, String domainAndPort, String appMap, float scale) throws Exception {
        PageBuilder pb = new PageBuilder(this.cs, 999999999, 999999999);
        HtmlReport html = new HtmlReport(pb.getPage(1), reportName, appMap, null);
        html.setAppRoot(String.valueOf(domainAndPort) + appMap);
        html.setScale(scale);
        return html.generateHtml();
    }

    public void print() throws Exception {
        this.print(false);
    }

    public void print(boolean needSelectPrinter) throws Exception {
        PrintFrame frame = new PrintFrame(this.cs, false, null);
        frame.setModal(false);
        frame.setLocation(-1000, -1000);
        frame.show();
        frame.directPrint(needSelectPrinter);
    }

    public String toText() throws Exception {
        return new TextReport(this.cs).toString();
    }

    public String toText(String separator, boolean dispValue) throws Exception {
        TextFile tf = new TextFile(this.cs, separator);
        tf.setSaveDispValue(dispValue);
        return tf.toString();
    }

    public void exportToText(OutputStream os) throws Exception {
        PrintWriter pw = new PrintWriter(os);
        pw.print(this.toText());
        pw.flush();
    }

    public void exportToText(OutputStream os, String separator, boolean dispValue) throws Exception {
        PrintWriter pw = new PrintWriter(os);
        pw.print(this.toText(separator, dispValue));
        pw.flush();
    }

    public static ReportDefine getReportDefine(String raqFileName, ServletContext application) throws Exception {
        ReportCalculator rc = new ReportCalculator(application);
        rc.setParameter("fileName", raqFileName);
        rc.setParameter("needCalculate", "no");
        return new ReportDefine(rc.calc());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        new CellSetWriter(this.cs).write(new PrintWriter(out, true));
    }

    private void readObject(ObjectInputStream in) throws Exception {
        this.cs = new CellSetReader(in).read();
        this.dsc = this.extractDataSetConfigs();
        this.args = this.extractArguments();
        this.srl = this.extractSubReportList();
    }
}

