/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.usermodel;

import com.runqian.base.module.DataSetConfig;
import com.runqian.base.module.DataSetConfigs;
import com.runqian.base.tool.Tools;
import com.runqian.base.util.ArgumentTokenizer;
import com.runqian.base.util.Escape;
import com.runqian.base.util.ReportError;
import com.runqian.base.util.SQLParser;
import com.runqian.base.util.SegmentSet;
import com.runqian.report.dataset.BuildinDataSetFactory;
import com.runqian.report.dataset.DataSet;
import com.runqian.report.dataset.DataSetFactory;
import com.runqian.report.dataset.OlapDataSetFactory;
import com.runqian.report.dataset.ProcDataSetFactory;
import com.runqian.report.dataset.SQLDataSetFactory;
import com.runqian.report.dataset.TextDataSetFactory;
import com.runqian.report.dataset.XMLDataSetFactory;
import com.runqian.report.engine.ExtCellSet;
import com.runqian.report.usermodel.Env;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ReportDataSetConfigs
extends DataSetConfigs {
    public ReportDataSetConfigs(String cfgStr) {
        super(cfgStr);
    }

    public Map calcDataSets(Env env, ExtCellSet ecs) {
        String[] dsNames = this.getDataSetNames();
        HashMap<String, DataSet> dataSetMap = new HashMap<String, DataSet>(dsNames.length);
        int i = 0;
        while (i < dsNames.length) {
            DataSet ds = this.calcDataSet(env, dsNames[i], ecs);
            if (ds != null) {
                dataSetMap.put(dsNames[i], ds);
            }
            ++i;
        }
        return dataSetMap;
    }

    public DataSet calcDataSet(Env env, String dsName, ExtCellSet ecs) {
        return ReportDataSetConfigs.calcDataSet(env, this.get(dsName), ecs);
    }

    public static DataSet calcDataSet(Env env, DataSetConfig dsc) {
        return ReportDataSetConfigs.calcDataSet(env, dsc, new ExtCellSet(env));
    }

    public static DataSet calcDataSet(Env env, DataSetConfig dsc, ExtCellSet ecs) {
        if (dsc == null) {
            return null;
        }
        int sqlType = dsc.getSQLType();
        switch (sqlType) {
            case 5: {
                String textFile = dsc.getSQL();
                Properties prop = new Properties();
                prop.put("fileName", textFile);
                TextDataSetFactory textDS = new TextDataSetFactory();
                textDS.setProperties(prop);
                try {
                    return textDS.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
            case 6: {
                String xmlFile = dsc.getSQL();
                Properties prop1 = new Properties();
                prop1.put("fileName", xmlFile);
                XMLDataSetFactory xmlDS = new XMLDataSetFactory();
                xmlDS.setProperties(prop1);
                try {
                    return xmlDS.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
            case 7: {
                DataSetFactory od;
                String define = dsc.getSQL();
                SegmentSet set = new SegmentSet(define, ';');
                String arg = set.get("args");
                arg = Escape.removeEscAndQuote(arg);
                String classes = set.get("class");
                classes = Escape.removeEscAndQuote(classes);
                try {
                    od = (DataSetFactory)Class.forName(classes).newInstance();
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
                ArgumentTokenizer at = new ArgumentTokenizer(arg, ';');
                Properties prop2 = new Properties();
                while (at.hasMoreTokens()) {
                    String s = at.nextToken();
                    int pos = s.indexOf(",");
                    if (pos <= 0) continue;
                    prop2.put(s.substring(0, pos), s.substring(pos + 1, s.length()));
                }
                od.setProperties(prop2);
                try {
                    return od.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
            case 8: {
                Properties prop4 = new Properties();
                prop4.put("dsc", dsc);
                BuildinDataSetFactory buildinDS = new BuildinDataSetFactory();
                buildinDS.setProperties(prop4);
                try {
                    return buildinDS.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
            case 3: {
                Properties prop5 = new Properties();
                prop5.put("dsc", dsc);
                prop5.put("ecs", ecs);
                ProcDataSetFactory procDS = new ProcDataSetFactory();
                procDS.setProperties(prop5);
                try {
                    return procDS.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
            case 9: {
                Properties propOlap = new Properties();
                propOlap.put("dsc", dsc);
                OlapDataSetFactory olapDS = new OlapDataSetFactory();
                olapDS.setProperties(propOlap);
                try {
                    return olapDS.getDataSet(env);
                }
                catch (Exception e) {
                    throw new ReportError(e.getMessage(), e);
                }
            }
        }
        Properties prop3 = new Properties();
        prop3.put("dsc", dsc);
        prop3.put("ecs", ecs);
        SQLDataSetFactory sqlDS = new SQLDataSetFactory();
        sqlDS.setProperties(prop3);
        try {
            return sqlDS.getDataSet(env);
        }
        catch (ReportError re) {
            throw re;
        }
        catch (Exception e) {
            throw new ReportError(e.getMessage(), e);
        }
    }

    private Vector getDataSetColumns(DataSet ds) {
        if (ds == null) {
            return new Vector();
        }
        int c = ds.getColumnCount();
        Vector<String> columns = new Vector<String>();
        int i = 1;
        while (i <= c) {
            String name = ds.getColumnName(i);
            columns.add(name);
            ++i;
        }
        return columns;
    }

    public Vector calcDataSetColumns(Env env, String dsName) {
        Vector cols = new Vector();
        try {
            DataSetConfig dsc = this.get(dsName);
            if (dsc == null) {
                return null;
            }
            int sqlType = dsc.getSQLType();
            if (sqlType == 1) {
                String sql = dsc.getSQL();
                if (!Tools.isValidString(sql)) {
                    return cols;
                }
                String ls_sql = SQLParser.modify(sql, 2, "1=0");
                dsc.clearArguments();
                dsc.setSQL(ls_sql);
            }
            ExtCellSet ecs = new ExtCellSet(env);
            cols = this.getDataSetColumns(this.calcDataSet(env, dsName, ecs));
        }
        catch (Exception e) {
            e.printStackTrace();
            cols = new Vector();
        }
        return cols;
    }
}

