/*
 * Decompiled with CFR 0.152.
 */
package com.runqian.report.usermodel;

import com.runqian.base.util.Arguments;
import com.runqian.base.util.Escape;
import com.runqian.base.util.Macros;
import com.runqian.base.util.NStringMap;
import com.runqian.report.cellset.CellPropertyDefine;
import com.runqian.report.cellset.CellSet;
import com.runqian.report.engine.SubRptList;
import com.runqian.report.graph.GraphProperty;
import com.runqian.report.usermodel.Report;
import com.runqian.report.usermodel.ReportDataSetConfigs;
import java.io.File;
import java.io.InputStream;

public class ReportDefine
extends Report {
    public ReportDefine(CellSet cs) {
        super(cs);
    }

    public ReportDefine(String raqFileName) throws Exception {
        super(raqFileName);
    }

    public ReportDefine(InputStream raqStream) throws Exception {
        super(raqStream);
    }

    public ReportDefine(File raqFile) throws Exception {
        super(raqFile);
    }

    public void setReportType(Integer reportType) {
        int type = 2;
        if (reportType != null) {
            type = reportType;
        }
        if (type < 1 || type > 3) {
            type = 2;
        }
        this.cs.setPropertyValue(0, 0, 1101, new Integer(type));
    }

    public int getReportType() {
        Object obj = this.cs.getPropertyValue(0, 0, 1101);
        if (obj == null) {
            return 2;
        }
        return (Integer)obj;
    }

    public ReportDataSetConfigs getDataSetConfigs() {
        return this.dsc;
    }

    public void setDataSetConfigs(ReportDataSetConfigs dsc) {
        this.dsc = dsc;
        this.cs.setPropertyValue(0, 0, 1102, dsc.toString());
    }

    public Arguments getArguments() {
        return this.args;
    }

    public SubRptList getSubRptList() {
        return this.srl;
    }

    public void setMacro(String macroName, String macroTitle, String macroValue) {
        Macros macros = new Macros();
        String tmp = (String)this.cs.getPropertyValue(0, 0, 1107);
        macros = tmp == null || tmp.trim().length() == 0 ? new Macros() : new Macros(tmp);
        macros.set(macroName, macroTitle, macroValue);
        this.cs.setPropertyValue(0, 0, 1107, macros.toString());
    }

    public String getMacro(String macroName) {
        String tmp = (String)this.cs.getPropertyValue(0, 0, 1107);
        if (tmp == null || tmp.trim().length() == 0) {
            return null;
        }
        Macros macros = new Macros(tmp);
        return macros.getValue(macroName);
    }

    public String[] getMacroNames() {
        String tmp = (String)this.cs.getPropertyValue(0, 0, 1107);
        if (tmp == null || tmp.trim().length() == 0) {
            return null;
        }
        Macros macros = new Macros(tmp);
        int count = macros.size();
        String[] names = new String[count];
        int i = 0;
        while (i < count) {
            names[i] = macros.getName(i);
            ++i;
        }
        return names;
    }

    public NStringMap getMacros() {
        String[] names = this.getMacroNames();
        if (names == null) {
            return null;
        }
        NStringMap macros = new NStringMap();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            macros.put(name, this.getMacro(name));
            ++i;
        }
        return macros;
    }

    public void setColExp(int col, int propId, String exp) {
        this.cs.setPropertyExpression(0, col, propId, exp);
    }

    public String getColExp(int col, int propId) {
        return this.cs.getPropertyExpression(0, col, propId);
    }

    public void setExp(int row, int col, int propId, String exp) {
        this.cs.setPropertyExpression(row, col, propId, exp);
    }

    public String getExp(int row, int col, int propId) {
        return this.cs.getPropertyExpression(row, col, propId);
    }

    public GraphProperty getGraphProperty(int row, int col) {
        Object o = this.getValue(row, col, 4101);
        try {
            int type = (Integer)o;
            if (type != CellPropertyDefine.CDT_GRAPH) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        o = this.getExp(row, col, 4102);
        if (o == null || o.toString().trim().length() == 0) {
            return null;
        }
        String exp = o.toString();
        exp = exp.substring(exp.indexOf("(") + 1, exp.length() - 1);
        exp = Escape.removeEscAndQuote(exp);
        GraphProperty props = new GraphProperty(exp);
        return props;
    }

    public boolean setGraphProperty(int row, int col, GraphProperty props) {
        Object o = this.getValue(row, col, 4101);
        try {
            int type = (Integer)o;
            if (type != CellPropertyDefine.CDT_GRAPH) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        String exp = props.toString();
        exp = Escape.addEscAndQuote(exp);
        exp = "graph(" + exp + ")";
        this.setExp(row, col, 4102, exp);
        return true;
    }

    public boolean isBigReport() {
        Object o = this.getValue(0, 0, 1218);
        return (Boolean)o;
    }
}

